/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ocf;

import com.adobe.epubcheck.ocf.IDPFFontManglingFilter;
import com.adobe.epubcheck.ocf.OCFPackage;
import com.adobe.epubcheck.ocf.UnsupportedEncryptionFilter;
import com.adobe.epubcheck.xml.XMLElement;
import com.adobe.epubcheck.xml.XMLHandler;
import com.adobe.epubcheck.xml.XMLParser;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public class EncryptionHandler
implements XMLHandler {
    OCFPackage ocf;
    XMLParser parser;

    EncryptionHandler(OCFPackage ocf, XMLParser parser) {
        this.ocf = ocf;
        this.parser = parser;
    }

    @Override
    public void startElement() {
        String comp;
        XMLElement parent;
        String algorithm;
        XMLElement e = this.parser.getCurrentElement();
        if (e.getName().equals("CipherReference")) {
            String algorithm2 = null;
            XMLElement parent2 = e.getParent();
            if (parent2 != null && (parent2 = parent2.getParent()) != null && parent2.getName().equals("EncryptedData")) {
                algorithm2 = (String)parent2.getPrivateData();
            }
            String entryName = e.getAttribute("URI");
            try {
                entryName = URLDecoder.decode(entryName, "UTF-8");
            }
            catch (UnsupportedEncodingException er) {
                throw new InternalError(e.toString());
            }
            if (algorithm2 == null) {
                algorithm2 = "unknown";
            }
            if (algorithm2.equals("http://www.idpf.org/2008/embedding")) {
                this.ocf.setEncryption(entryName, new IDPFFontManglingFilter(this.ocf));
            } else {
                this.ocf.setEncryption(entryName, new UnsupportedEncryptionFilter());
            }
        } else if (e.getName().equals("EncryptionMethod") && (algorithm = e.getAttribute("Algorithm")) != null && (parent = e.getParent()) != null && (comp = parent.getAttributeNS("http://ns.adobe.com/digitaleditions/enc", "compression")) == null) {
            parent.setPrivateData(algorithm);
        }
    }

    @Override
    public void endElement() {
    }

    @Override
    public void ignorableWhitespace(char[] chars, int arg1, int arg2) {
    }

    @Override
    public void characters(char[] chars, int arg1, int arg2) {
    }

    @Override
    public void processingInstruction(String arg0, String arg1) {
    }
}

