/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ops;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.opf.OPFChecker;
import com.adobe.epubcheck.opf.OPFChecker30;
import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.ops.OPSHandler;
import com.adobe.epubcheck.util.EpubTypeAttributes;
import com.adobe.epubcheck.util.HandlerUtil;
import com.adobe.epubcheck.util.MetaUtils;
import com.adobe.epubcheck.util.PathUtil;
import com.adobe.epubcheck.xml.XMLElement;
import com.adobe.epubcheck.xml.XMLParser;
import java.util.HashSet;

public class OPSHandler30
extends OPSHandler {
    String properties;
    HashSet<String> prefixSet;
    HashSet<String> propertiesSet;
    String mimeType;
    boolean video = false;
    boolean audio = false;
    boolean hasValidFallback = false;

    public OPSHandler30(String path, String mimeType, String properties, XRefChecker xrefChecker, XMLParser parser, Report report) {
        super(path, xrefChecker, parser, report);
        this.mimeType = mimeType;
        this.properties = properties;
        this.prefixSet = new HashSet();
        this.propertiesSet = new HashSet();
    }

    boolean checkPrefix(String prefix) {
        if (!this.prefixSet.contains(prefix = prefix.trim())) {
            this.report.error(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), "Undecleared prefix: " + prefix);
            return false;
        }
        return true;
    }

    private void checkType(String type) {
        if (type == null) {
            return;
        }
        MetaUtils.validateProperties(type, EpubTypeAttributes.EpubTypeSet, this.prefixSet, this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), this.report, false);
    }

    @Override
    public void characters(char[] chars, int arg1, int arg2) {
        super.characters(chars, arg1, arg2);
        String str = new String(chars, arg1, arg2);
        str = str.trim();
        if (!str.equals("") && (this.audio || this.video)) {
            this.hasValidFallback = true;
        }
    }

    @Override
    public void startElement() {
        super.startElement();
        XMLElement e = this.parser.getCurrentElement();
        String name = e.getName();
        if (name.equals("html")) {
            HandlerUtil.processPrefixes(e.getAttributeNS("http://www.idpf.org/2007/ops", "prefix"), this.prefixSet, this.report, this.path, this.parser.getLineNumber(), this.parser.getColumnNumber());
        } else if (name.equals("object")) {
            this.processObject(e);
        } else if (name.equals("math")) {
            this.propertiesSet.add("mathml");
        } else if (!this.mimeType.equals("image/svg+xml") && name.equals("svg")) {
            this.propertiesSet.add("svg");
        } else if (name.equals("script")) {
            this.propertiesSet.add("scripted");
        } else if (name.equals("switch")) {
            this.propertiesSet.add("switch");
        } else if (name.equals("audio")) {
            this.processAudio(e);
        } else if (name.equals("video")) {
            this.processVideo(e);
        }
        this.processSrc(e.getName(), e.getAttribute("src"));
        this.checkType(e.getAttributeNS("http://www.idpf.org/2007/ops", "type"));
    }

    private void processAudio(XMLElement e) {
        this.audio = true;
    }

    private void processVideo(XMLElement e) {
        this.video = true;
        String posterSrc = e.getAttribute("poster");
        String posterMimeType = null;
        if (this.xrefChecker != null && posterSrc != null) {
            posterMimeType = this.xrefChecker.getMimeType(PathUtil.resolveRelativeReference(this.path, posterSrc));
        }
        if (posterMimeType != null && !OPFChecker.isBlessedImageType(posterMimeType)) {
            this.report.error(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), "Video poster must have core media image type!");
        }
        if (posterSrc != null) {
            this.hasValidFallback = true;
            this.processSrc(e.getName(), posterSrc);
        }
    }

    private void processSrc(String name, String src) {
        if (src == null || this.xrefChecker == null) {
            return;
        }
        if (src.startsWith("http://")) {
            this.propertiesSet.add("remote-resources");
        } else {
            src = PathUtil.resolveRelativeReference(this.path, src);
        }
        this.xrefChecker.registerReference(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), src, 0);
        String srcMimeType = this.xrefChecker.getMimeType(src);
        if (srcMimeType == null) {
            return;
        }
        if (!this.mimeType.equals("image/svg+xml") && srcMimeType.equals("image/svg+xml")) {
            this.propertiesSet.add("svg");
        }
        if ((name.equals("source") || name.equals("audio")) && this.audio && OPFChecker30.isBlessedAudioType(srcMimeType)) {
            this.hasValidFallback = true;
        }
    }

    private void processObject(XMLElement e) {
        String type = e.getAttribute("type");
        if (!this.mimeType.equals("image/svg+xml") && type.equals("image/svg+xml")) {
            this.propertiesSet.add("svg");
        }
    }

    @Override
    public void endElement() {
        super.endElement();
        XMLElement e = this.parser.getCurrentElement();
        String name = e.getName();
        if (name.equals("html") || name.equals("svg")) {
            this.checkProperties();
        } else if (name.equals("video")) {
            this.checkFallback("Video");
        } else if (name.equals("audio")) {
            this.checkFallback("Audio");
        }
    }

    private void checkFallback(String elementType) {
        if (this.hasValidFallback) {
            this.hasValidFallback = false;
        } else {
            this.report.error(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), elementType + " element doesn't provide fallback!");
        }
    }

    private void checkProperties() {
        if (this.properties != null && this.properties.equals("singleFileValidation")) {
            return;
        }
        if (this.properties != null) {
            this.properties = this.properties.replaceAll("nav", "");
        }
        for (String prop : this.propertiesSet) {
            if (this.properties != null && this.properties.contains(prop)) {
                this.properties = this.properties.replaceAll(prop, "");
                continue;
            }
            this.report.error(this.path, 0, 0, "This file should declare in opf the property: " + prop);
        }
        if (this.properties != null) {
            this.properties = this.properties.trim();
        }
        if (this.properties != null && !this.properties.equals("")) {
            this.report.error(this.path, 0, 0, "This file should not declare in opf the properties: " + this.properties);
        }
    }
}

