/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.util;

import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.InvalidVersionException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResourceUtil {
    public static String getResourcePath(String localName) {
        String classPath = ResourceUtil.class.getName().replace('.', '/');
        String classPackage = classPath.substring(0, classPath.lastIndexOf("/"));
        String projectPackage = classPackage.substring(0, classPackage.lastIndexOf("/"));
        return projectPackage + "/" + localName;
    }

    public static InputStream getResourceStream(String resourcePath) {
        ClassLoader loader = ResourceUtil.class.getClassLoader();
        if (loader == null) {
            return ClassLoader.getSystemResourceAsStream(resourcePath);
        }
        return loader.getResourceAsStream(resourcePath);
    }

    public static URL getResourceURL(String resourcePath) {
        ClassLoader loader = ResourceUtil.class.getClassLoader();
        if (loader == null) {
            return ClassLoader.getSystemResource(resourcePath);
        }
        return loader.getResource(resourcePath);
    }

    public static EPUBVersion retrieveOpfVersion(InputStream inputStream) throws InvalidVersionException {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            int ch = inputStream.read();
            while (ch != -1) {
                stringBuffer.append((char)ch);
                ch = inputStream.read();
            }
            String regex = "<package[^>]*version\\s*=\\s*\"([\\d]+\\.[\\d]+)\"";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(stringBuffer);
            if (matcher.find()) {
                String version = matcher.group(1);
                if (version.equals("2.0")) {
                    return EPUBVersion.VERSION_2;
                }
                if (version.equals("3.0")) {
                    return EPUBVersion.VERSION_3;
                }
                throw new InvalidVersionException(InvalidVersionException.UNSUPPORTED_VERSION);
            }
            throw new InvalidVersionException(InvalidVersionException.VERSION_NOT_FOUND);
        }
        catch (IOException iOException) {
            throw new InvalidVersionException(InvalidVersionException.VERSION_NOT_FOUND);
        }
    }
}

