/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.xml;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.util.ResourceUtil;
import com.adobe.epubcheck.xml.XMLAttribute;
import com.adobe.epubcheck.xml.XMLElement;
import com.adobe.epubcheck.xml.XMLHandler;
import com.adobe.epubcheck.xml.XMLValidator;
import com.sun.org.apache.xerces.internal.impl.io.MalformedByteSequenceException;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class XMLParser
extends DefaultHandler
implements LexicalHandler,
DeclHandler {
    SAXParser parser;
    Report report;
    String resource;
    InputStream resourceIn;
    Vector<XMLHandler> contentHandlers = new Vector();
    XMLElement currentElement;
    Vector<ContentHandler> validatorContentHandlers = new Vector();
    Vector<DTDHandler> validatorDTDHandlers = new Vector();
    Locator documentLocator;
    static String zipRoot = "file:///epub-root/";
    static Hashtable<String, String> systemIdMap;
    HashSet<String> entities = new HashSet();
    String mimeType;
    static final byte[][] utf16magic;
    static final byte[][] ucs4magic;
    static final byte[] utf8magic;
    static final byte[] ebcdicmagic;

    public XMLParser(InputStream resourceIn, String entryName, String mimeType, Report report) {
        this.report = report;
        this.resource = entryName;
        this.resourceIn = resourceIn;
        this.mimeType = mimeType;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        boolean hasXML11 = false;
        this.entities.add("gt");
        this.entities.add("lt");
        this.entities.add("amp");
        this.entities.add("quot");
        try {
            hasXML11 = factory.getFeature("http://xml.org/sax/features/xml-1.1");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.parser = factory.newSAXParser();
            XMLReader reader = this.parser.getXMLReader();
            reader.setDTDHandler(this);
            reader.setContentHandler(this);
            reader.setEntityResolver(this);
            reader.setErrorHandler(this);
            try {
                reader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
                reader.setProperty("http://xml.org/sax/properties/declaration-handler", this);
            }
            catch (SAXNotRecognizedException e) {
                e.printStackTrace();
            }
            catch (SAXNotSupportedException e) {
                e.printStackTrace();
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public void addXMLHandler(XMLHandler handler) {
        if (handler != null) {
            this.contentHandlers.add(handler);
        }
    }

    public void addValidator(XMLValidator xv) {
        DTDHandler dtdHandler;
        PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder();
        propertyMapBuilder.put(ValidateProperty.ERROR_HANDLER, this);
        Validator validator = xv.schema.createValidator(propertyMapBuilder.toPropertyMap());
        ContentHandler contentHandler = validator.getContentHandler();
        if (contentHandler != null) {
            this.validatorContentHandlers.add(contentHandler);
        }
        if ((dtdHandler = validator.getDTDHandler()) != null) {
            this.validatorDTDHandlers.add(dtdHandler);
        }
    }

    static boolean matchesMagic(byte[] magic, byte[] buffer) {
        for (int i = 0; i < magic.length; ++i) {
            if (buffer[i] == magic[i]) continue;
            return false;
        }
        return true;
    }

    static String sniffEncoding(InputStream in) throws IOException {
        int c;
        int asciiLen;
        int k;
        byte[] buffer = new byte[256];
        in.mark(buffer.length);
        int len = in.read(buffer);
        in.reset();
        if (len < 4) {
            return null;
        }
        for (k = 0; k < utf16magic.length; ++k) {
            if (!XMLParser.matchesMagic(utf16magic[k], buffer)) continue;
            return "UTF-16";
        }
        for (k = 0; k < ucs4magic.length; ++k) {
            if (!XMLParser.matchesMagic(ucs4magic[k], buffer)) continue;
            return "UCS-4";
        }
        if (XMLParser.matchesMagic(utf8magic, buffer)) {
            return "UTF-8";
        }
        if (XMLParser.matchesMagic(ebcdicmagic, buffer)) {
            return "EBCDIC";
        }
        for (asciiLen = 0; asciiLen < len && (c = buffer[asciiLen] & 0xFF) != 0 && c <= 127; ++asciiLen) {
        }
        String header = new String(buffer, 0, asciiLen, "ASCII");
        int encIndex = header.indexOf("encoding=");
        if (encIndex < 0) {
            return null;
        }
        if ((encIndex += 9) >= header.length()) {
            return null;
        }
        char quote = header.charAt(encIndex);
        if (quote != '\"' && quote != '\'') {
            return null;
        }
        int encEnd = header.indexOf(quote, encIndex + 1);
        if (encEnd < 0) {
            return null;
        }
        String encoding = header.substring(encIndex + 1, encEnd);
        return encoding.toUpperCase();
    }

    public void process() {
        try {
            String encoding;
            InputStream in = this.resourceIn;
            if (!in.markSupported()) {
                in = new BufferedInputStream(in);
            }
            if ((encoding = XMLParser.sniffEncoding(in)) != null && !encoding.equals("UTF-8") && !encoding.equals("UTF-16")) {
                this.report.error(this.resource, 0, 0, "Only UTF-8 and UTF-16 encodings are allowed for XML, detected " + encoding);
            }
            InputSource ins = new InputSource(in);
            ins.setSystemId(zipRoot + this.resource);
            this.parser.parse(ins, (DefaultHandler)this);
            in.close();
        }
        catch (MalformedByteSequenceException e) {
            this.report.error(this.resource, 0, 0, "Malformed byte sequence: " + e.getMessage() + " Check encoding");
        }
        catch (IOException e) {
            this.report.error(null, 0, 0, "I/O error reading " + this.resource);
        }
        catch (IllegalArgumentException e) {
            this.report.error(null, 0, 0, "could not parse " + this.resource + ": " + e.getMessage());
        }
        catch (SAXException e) {
            this.report.error(this.resource, 0, 0, e.getMessage());
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        String resourcePath = systemIdMap.get(systemId);
        if (resourcePath != null) {
            InputStream resourceStream = ResourceUtil.getResourceStream(resourcePath);
            if (systemId.equals("xhtml-lat1.ent") || systemId.equals("xhtml-symbol.ent") || systemId.equals("xhtml-special.ent")) {
                System.err.println("A problem in XML parser detected: external XML entity URLs are not resolved");
                System.err.println("\tPlease configure your runtime environment to use a different XML parser");
                System.err.println("\t(e.g. using javax.xml.parsers.SAXParserFactory system property)");
            }
            InputSource source = new InputSource(resourceStream);
            source.setPublicId(publicId);
            source.setSystemId(systemId);
            return source;
        }
        if (systemId.startsWith(zipRoot)) {
            return null;
        }
        this.report.warning(this.resource, 0, 0, "Unresolved external XML entity '" + systemId + "'");
        InputStream urlStream = new URL(systemId).openStream();
        InputSource source = new InputSource(urlStream);
        source.setPublicId(publicId);
        source.setSystemId(systemId);
        return source;
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        int len = this.validatorDTDHandlers.size();
        for (int i = 0; i < len; ++i) {
            this.validatorDTDHandlers.elementAt(i).notationDecl(name, publicId, systemId);
        }
    }

    @Override
    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        int len = this.validatorDTDHandlers.size();
        for (int i = 0; i < len; ++i) {
            this.validatorDTDHandlers.elementAt(i).unparsedEntityDecl(name, publicId, systemId, notationName);
        }
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        this.report.error(this.resource, ex.getLineNumber(), ex.getColumnNumber(), ex.getMessage());
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        this.report.error(this.resource, ex.getLineNumber(), ex.getColumnNumber(), ex.getMessage());
    }

    @Override
    public void warning(SAXParseException ex) throws SAXException {
        this.report.warning(this.resource, ex.getLineNumber(), ex.getColumnNumber(), ex.getMessage());
    }

    @Override
    public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
        int vlen = this.validatorContentHandlers.size();
        for (int i = 0; i < vlen; ++i) {
            this.validatorContentHandlers.elementAt(i).characters(arg0, arg1, arg2);
        }
        int len = this.contentHandlers.size();
        for (int i = 0; i < len; ++i) {
            this.contentHandlers.elementAt(i).characters(arg0, arg1, arg2);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        int len = this.validatorContentHandlers.size();
        for (int i = 0; i < len; ++i) {
            this.validatorContentHandlers.elementAt(i).endDocument();
        }
    }

    @Override
    public void endElement(String arg0, String arg1, String arg2) throws SAXException {
        int vlen = this.validatorContentHandlers.size();
        for (int i = 0; i < vlen; ++i) {
            this.validatorContentHandlers.elementAt(i).endElement(arg0, arg1, arg2);
        }
        int len = this.contentHandlers.size();
        for (int i = 0; i < len; ++i) {
            this.contentHandlers.elementAt(i).endElement();
        }
        this.currentElement = this.currentElement.getParent();
    }

    @Override
    public void endPrefixMapping(String arg0) throws SAXException {
        int vlen = this.validatorContentHandlers.size();
        for (int i = 0; i < vlen; ++i) {
            this.validatorContentHandlers.elementAt(i).endPrefixMapping(arg0);
        }
    }

    @Override
    public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        int vlen = this.validatorContentHandlers.size();
        for (int i = 0; i < vlen; ++i) {
            this.validatorContentHandlers.elementAt(i).ignorableWhitespace(arg0, arg1, arg2);
        }
        int len = this.contentHandlers.size();
        for (int i = 0; i < len; ++i) {
            this.contentHandlers.elementAt(i).ignorableWhitespace(arg0, arg1, arg2);
        }
    }

    @Override
    public void processingInstruction(String arg0, String arg1) throws SAXException {
        int vlen = this.validatorContentHandlers.size();
        for (int i = 0; i < vlen; ++i) {
            this.validatorContentHandlers.elementAt(i).processingInstruction(arg0, arg1);
        }
        int len = this.contentHandlers.size();
        for (int i = 0; i < len; ++i) {
            this.contentHandlers.elementAt(i).processingInstruction(arg0, arg1);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        int vlen = this.validatorContentHandlers.size();
        for (int i = 0; i < vlen; ++i) {
            this.validatorContentHandlers.elementAt(i).setDocumentLocator(locator);
        }
        this.documentLocator = locator;
    }

    @Override
    public void skippedEntity(String arg0) throws SAXException {
        int vlen = this.validatorContentHandlers.size();
        for (int i = 0; i < vlen; ++i) {
            this.validatorContentHandlers.elementAt(i).skippedEntity(arg0);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        int vlen = this.validatorContentHandlers.size();
        for (int i = 0; i < vlen; ++i) {
            this.validatorContentHandlers.elementAt(i).startDocument();
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String name;
        String prefix;
        if (this.mimeType.equals("application/xhtml+xml")) {
            AttributesImpl correctedAttributes = new AttributesImpl(atts);
            int calen = correctedAttributes.getLength();
            for (int i = 0; i < calen; ++i) {
                if (!correctedAttributes.getLocalName(i).startsWith("data-")) continue;
                correctedAttributes.removeAttribute(i);
            }
            atts = correctedAttributes;
        }
        int vlen = this.validatorContentHandlers.size();
        for (int i = 0; i < vlen; ++i) {
            this.validatorContentHandlers.elementAt(i).startElement(namespaceURI, localName, qName, atts);
        }
        int index = qName.indexOf(58);
        if (index < 0) {
            prefix = null;
            name = qName;
        } else {
            prefix = qName.substring(0, index);
            name = qName.substring(index + 1);
        }
        int count = atts.getLength();
        XMLAttribute[] attributes = count == 0 ? null : new XMLAttribute[count];
        for (int i = 0; i < count; ++i) {
            String attPrefix;
            String attName = atts.getLocalName(i);
            String attNamespace = atts.getURI(i);
            String attQName = atts.getQName(i);
            int attIndex = attQName.indexOf(58);
            if (attIndex < 0) {
                attPrefix = null;
                attNamespace = null;
            } else {
                attPrefix = attQName.substring(0, attIndex);
            }
            String attValue = atts.getValue(i);
            attributes[i] = new XMLAttribute(attNamespace, attPrefix, attName, attValue);
        }
        this.currentElement = new XMLElement(namespaceURI, prefix, name, attributes, this.currentElement);
        int len = this.contentHandlers.size();
        for (int i = 0; i < len; ++i) {
            this.contentHandlers.elementAt(i).startElement();
        }
    }

    @Override
    public void startPrefixMapping(String arg0, String arg1) throws SAXException {
        int vlen = this.validatorContentHandlers.size();
        for (int i = 0; i < vlen; ++i) {
            this.validatorContentHandlers.elementAt(i).startPrefixMapping(arg0, arg1);
        }
    }

    @Override
    public void comment(char[] text, int arg1, int arg2) throws SAXException {
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void endEntity(String ent) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void startDTD(String arg0, String arg1, String arg2) throws SAXException {
    }

    @Override
    public void startEntity(String ent) throws SAXException {
        if (!this.entities.contains(ent) && !ent.equals("[dtd]")) {
            this.report.error(this.resource, this.getLineNumber(), this.getColumnNumber(), "Entity '" + ent + "' is undeclared");
        }
    }

    @Override
    public void attributeDecl(String name, String name2, String type, String mode, String value) throws SAXException {
    }

    @Override
    public void elementDecl(String name, String model) throws SAXException {
    }

    @Override
    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        this.entities.add(name);
    }

    @Override
    public void internalEntityDecl(String name, String value) throws SAXException {
        this.entities.add(name);
    }

    public XMLElement getCurrentElement() {
        return this.currentElement;
    }

    public Report getReport() {
        return this.report;
    }

    public int getLineNumber() {
        return this.documentLocator.getLineNumber();
    }

    public int getColumnNumber() {
        return this.documentLocator.getColumnNumber();
    }

    static {
        Hashtable<String, String> map = new Hashtable<String, String>();
        map.put("http://www.idpf.org/dtds/2007/opf.dtd", ResourceUtil.getResourcePath("schema/20/dtd/opf20.dtd"));
        map.put("http://openebook.org/dtds/oeb-1.2/oeb12.ent", ResourceUtil.getResourcePath("schema/20/dtd/oeb12.dtdinc"));
        map.put("http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd", ResourceUtil.getResourcePath("schema/20/dtd/xhtml1-transitional.dtd"));
        map.put("http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd", ResourceUtil.getResourcePath("schema/20/dtd/xhtml1-strict.dtd"));
        map.put("http://www.w3.org/TR/xhtml1/DTD/xhtml-lat1.ent", ResourceUtil.getResourcePath("schema/20/dtd/xhtml-lat1.dtdinc"));
        map.put("http://www.w3.org/TR/xhtml1/DTD/xhtml-symbol.ent", ResourceUtil.getResourcePath("schema/20/dtd/xhtml-symbol.dtdinc"));
        map.put("http://www.w3.org/TR/xhtml1/DTD/xhtml-special.ent", ResourceUtil.getResourcePath("schema/20/dtd/xhtml-special.dtdinc"));
        map.put("http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd", ResourceUtil.getResourcePath("schema/20/dtd/svg11.dtd"));
        map.put("http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd", ResourceUtil.getResourcePath("schema/20/dtd/opf20.dtd"));
        map.put("http://www.daisy.org/z3986/2005/dtbook-2005-2.dtd", ResourceUtil.getResourcePath("schema/20/dtd/dtbook-2005-2.dtd"));
        map.put("http://www.daisy.org/z3986/2005/ncx-2005-1.dtd", ResourceUtil.getResourcePath("schema/20/dtd/ncx-2005-1.dtd"));
        map.put("xhtml-lat1.ent", ResourceUtil.getResourcePath("dtd/xhtml-lat1.dtdinc"));
        map.put("xhtml-symbol.ent", ResourceUtil.getResourcePath("dtd/xhtml-symbol.dtdinc"));
        map.put("xhtml-special.ent", ResourceUtil.getResourcePath("dtd/xhtml-special.dtdinc"));
        systemIdMap = map;
        utf16magic = new byte[][]{{-2, -1}, {-1, -2}, {0, 60, 0, 63}, {60, 0, 63, 0}};
        ucs4magic = new byte[][]{{0, 0, -2, -1}, {-1, -2, 0, 0}, {0, 0, -1, -2}, {-2, -1, 0, 0}, {0, 0, 0, 60}, {0, 0, 60, 0}, {0, 60, 0, 0}, {60, 0, 0, 0}};
        utf8magic = new byte[]{-17, -69, -65};
        ebcdicmagic = new byte[]{76, 111, -89, -108};
    }
}

