/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.opf;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.bitmap.BitmapCheckerFactory;
import com.adobe.epubcheck.css.CSSCheckerFactory;
import com.adobe.epubcheck.dtbook.DTBookCheckerFactory;
import com.adobe.epubcheck.ncx.NCXCheckerFactory;
import com.adobe.epubcheck.ocf.OCFPackage;
import com.adobe.epubcheck.opf.ContentChecker;
import com.adobe.epubcheck.opf.ContentCheckerFactory;
import com.adobe.epubcheck.opf.DocumentValidator;
import com.adobe.epubcheck.opf.GenericContentCheckerFactory;
import com.adobe.epubcheck.opf.OPFHandler;
import com.adobe.epubcheck.opf.OPFItem;
import com.adobe.epubcheck.opf.OPFReference;
import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.ops.OPSCheckerFactory;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.GenericResourceProvider;
import com.adobe.epubcheck.util.PathUtil;
import com.adobe.epubcheck.xml.XMLParser;
import com.adobe.epubcheck.xml.XMLValidator;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;

public class OPFChecker
implements DocumentValidator {
    OCFPackage ocf;
    Report report;
    String path;
    HashSet<String> containerEntries;
    protected XMLValidator opfValidator = new XMLValidator("schema/20/rng/opf.rng");
    protected XMLValidator opfSchematronValidator = new XMLValidator("schema/20/sch/opf.sch");
    XRefChecker xrefChecker;
    protected Hashtable contentCheckerFactoryMap;
    OPFHandler opfHandler = null;
    protected EPUBVersion version;
    protected GenericResourceProvider resourceProvider = null;
    XMLParser opfParser = null;

    private void initContentCheckerFactoryMap() {
        Hashtable<String, ContentCheckerFactory> map = new Hashtable<String, ContentCheckerFactory>();
        map.put("application/xhtml+xml", OPSCheckerFactory.getInstance());
        map.put("text/html", OPSCheckerFactory.getInstance());
        map.put("text/x-oeb1-document", OPSCheckerFactory.getInstance());
        map.put("image/jpeg", BitmapCheckerFactory.getInstance());
        map.put("image/gif", BitmapCheckerFactory.getInstance());
        map.put("image/png", BitmapCheckerFactory.getInstance());
        map.put("image/svg+xml", OPSCheckerFactory.getInstance());
        map.put("application/x-dtbook+xml", DTBookCheckerFactory.getInstance());
        map.put("text/css", CSSCheckerFactory.getInstance());
        this.contentCheckerFactoryMap = map;
    }

    public OPFChecker(OCFPackage ocf, Report report, String path, HashSet<String> containerEntries, EPUBVersion version) {
        this.ocf = ocf;
        this.resourceProvider = ocf;
        this.report = report;
        this.path = path;
        this.containerEntries = containerEntries;
        this.xrefChecker = new XRefChecker(ocf, report, version);
        this.version = version;
        this.initContentCheckerFactoryMap();
    }

    public OPFChecker(String path, GenericResourceProvider resourceProvider, Report report) {
        this.resourceProvider = resourceProvider;
        this.report = report;
        this.path = path;
        this.version = EPUBVersion.VERSION_2;
        this.initContentCheckerFactoryMap();
    }

    public void runChecks() {
        OPFItem item;
        int i;
        if (!this.ocf.hasEntry(this.path)) {
            this.report.error(null, 0, 0, "OPF file " + this.path + " is missing");
            return;
        }
        this.validate();
        if (!this.opfHandler.checkUniqueIdentExists()) {
            this.report.error(this.path, -1, -1, "unique-identifier attribute in package element must reference an existing identifier element id");
        }
        int itemCount = this.opfHandler.getItemCount();
        for (i = 0; i < itemCount; ++i) {
            item = this.opfHandler.getItem(i);
            try {
                this.xrefChecker.registerResource(item.getPath(), item.getMimeType(), item.isInSpine(), this.checkItemFallbacks(item, this.opfHandler), this.checkImageFallbacks(item, this.opfHandler));
            }
            catch (IllegalArgumentException e) {
                this.report.error(this.path, item.getLineNumber(), item.getColumnNumber(), e.getMessage());
            }
            this.checkItem(item, this.opfHandler);
        }
        for (i = 0; i < itemCount; ++i) {
            item = this.opfHandler.getItem(i);
            if (item.path.startsWith("http://")) continue;
            this.checkItemContent(item, this.opfHandler);
        }
        try {
            for (String entry : this.ocf.getFileEntries()) {
                if (this.opfHandler.getItemByPath(entry) != null || entry.startsWith("META-INF/") || entry.startsWith("META-INF\\") || entry.equals("mimetype") || this.containerEntries.contains(entry)) continue;
                this.report.warning(null, -1, -1, "item (" + entry + ") exists in the zip file, but is not declared in the OPF file");
            }
            for (String directory : this.ocf.getDirectoryEntries()) {
                boolean hasContents = false;
                for (String file : this.ocf.getFileEntries()) {
                    if (!file.startsWith(directory)) continue;
                    hasContents = true;
                }
                if (hasContents) continue;
                this.report.warning(null, -1, -1, "zip file contains empty directory " + directory);
            }
        }
        catch (IOException e) {
            this.report.error(null, -1, -1, "Unable to read zip file entries.");
        }
        this.xrefChecker.checkReferences();
    }

    public void initHandler() {
        this.opfHandler = new OPFHandler(this.ocf, this.path, this.report, this.xrefChecker, this.opfParser, this.version);
    }

    @Override
    public boolean validate() {
        int errorsSoFar = this.report.getErrorCount();
        int warningsSoFar = this.report.getWarningCount();
        try {
            this.opfParser = new XMLParser(new BufferedInputStream(this.resourceProvider.getInputStream(this.path)), this.path, "opf", this.report);
            this.initHandler();
            this.opfParser.addXMLHandler(this.opfHandler);
            this.opfParser.addValidator(this.opfValidator);
            this.opfParser.addValidator(this.opfSchematronValidator);
            this.opfParser.process();
        }
        catch (IOException e) {
            this.report.error(this.path, 0, 0, e.getMessage());
        }
        int refCount = this.opfHandler.getReferenceCount();
        for (int i = 0; i < refCount; ++i) {
            OPFReference ref = this.opfHandler.getReference(i);
            String itemPath = PathUtil.removeAnchor(ref.getHref());
            if (this.opfHandler.getItemByPath(itemPath) != null) continue;
            this.report.error(this.path, ref.getLineNumber(), ref.getColumnNumber(), "File listed in reference element in guide was not declared in OPF manifest: " + ref.getHref());
        }
        int itemCount = this.opfHandler.getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            OPFItem item = this.opfHandler.getItem(i);
            this.checkItem(item, this.opfHandler);
        }
        int spineItemCount = this.opfHandler.getSpineItemCount();
        for (int i = 0; i < spineItemCount; ++i) {
            OPFItem item = this.opfHandler.getSpineItem(i);
            this.checkSpineItem(item, this.opfHandler);
        }
        return errorsSoFar == this.report.getErrorCount() && warningsSoFar == this.report.getWarningCount();
    }

    public static boolean isBlessedItemType(String type, EPUBVersion version) {
        if (version == EPUBVersion.VERSION_2) {
            return type.equals("application/xhtml+xml") || type.equals("application/x-dtbook+xml");
        }
        return type.equals("application/xhtml+xml") || type.equals("image/svg+xml");
    }

    public static boolean isDeprecatedBlessedItemType(String type) {
        return type.equals("text/x-oeb1-document") || type.equals("text/html");
    }

    public static boolean isBlessedStyleType(String type) {
        return type.equals("text/css");
    }

    public static boolean isDeprecatedBlessedStyleType(String type) {
        return type.equals("text/x-oeb1-css");
    }

    public static boolean isBlessedImageType(String type) {
        return type.equals("image/gif") || type.equals("image/png") || type.equals("image/jpeg") || type.equals("image/svg+xml");
    }

    protected void checkItem(OPFItem item, OPFHandler opfHandler) {
        OPFItem fallbackStyleItem;
        String fallbackStyle;
        OPFItem fallbackItem;
        String mimeType = item.getMimeType();
        String fallback = item.getFallback();
        if (mimeType != null && !mimeType.equals("") && mimeType.matches("[a-zA-Z0-9!#$&+-^_]+/[a-zA-Z0-9!#$&+-^_]+") && (OPFChecker.isDeprecatedBlessedItemType(mimeType) || OPFChecker.isDeprecatedBlessedStyleType(mimeType))) {
            if (opfHandler.getOpf20PackageFile() && mimeType.equals("text/html")) {
                this.report.warning(this.path, item.getLineNumber(), item.getColumnNumber(), "text/html is not appropriate for XHTML/OPS, use application/xhtml+xml instead");
            } else if (opfHandler.getOpf12PackageFile() && mimeType.equals("text/html")) {
                this.report.warning(this.path, item.getLineNumber(), item.getColumnNumber(), "text/html is not appropriate for OEBPS 1.2, use text/x-oeb1-document instead");
            } else if (opfHandler.getOpf20PackageFile()) {
                this.report.warning(this.path, item.getLineNumber(), item.getColumnNumber(), "deprecated media-type '" + mimeType + "'");
            }
        }
        if (opfHandler.getOpf12PackageFile() && fallback == null) {
            if (OPFChecker.isBlessedItemType(mimeType, this.version)) {
                this.report.warning(this.path, item.getLineNumber(), item.getColumnNumber(), "use of OPS media-type '" + mimeType + "' in OEBPS 1.2 context; use text/x-oeb1-document instead");
            } else if (OPFChecker.isBlessedStyleType(mimeType)) {
                this.report.warning(this.path, item.getLineNumber(), item.getColumnNumber(), "use of OPS media-type '" + mimeType + "' in OEBPS 1.2 context; use text/x-oeb1-css instead");
            }
        }
        if (fallback != null && (fallbackItem = opfHandler.getItemById(fallback)) == null) {
            this.report.error(this.path, item.getLineNumber(), item.getColumnNumber(), "fallback item could not be found");
        }
        if ((fallbackStyle = item.getFallbackStyle()) != null && (fallbackStyleItem = opfHandler.getItemById(fallbackStyle)) == null) {
            this.report.error(this.path, item.getLineNumber(), item.getColumnNumber(), "fallback-style item could not be found");
        }
    }

    protected void checkItemContent(OPFItem item, OPFHandler opfHandler) {
        String mimeType = item.getMimeType();
        String path = item.getPath();
        String properties = item.getProperties();
        if (mimeType != null) {
            ContentCheckerFactory checkerFactory = item.isNcx() ? NCXCheckerFactory.getInstance() : (ContentCheckerFactory)this.contentCheckerFactoryMap.get(mimeType);
            if (checkerFactory == null) {
                checkerFactory = GenericContentCheckerFactory.getInstance();
            }
            if (checkerFactory != null) {
                ContentChecker checker = checkerFactory.newInstance(this.ocf, this.report, path, mimeType, properties, this.xrefChecker, this.version);
                checker.runChecks();
            }
        }
    }

    protected void checkSpineItem(OPFItem item, OPFHandler opfHandler) {
        String mimeType = item.getMimeType();
        if (mimeType != null) {
            if (OPFChecker.isBlessedStyleType(mimeType) || OPFChecker.isDeprecatedBlessedStyleType(mimeType) || OPFChecker.isBlessedImageType(mimeType)) {
                this.report.error(this.path, item.getLineNumber(), item.getColumnNumber(), "'" + mimeType + "' is not a permissible spine media-type");
            } else if (!OPFChecker.isBlessedItemType(mimeType, this.version) && !OPFChecker.isDeprecatedBlessedItemType(mimeType) && item.getFallback() == null) {
                this.report.error(this.path, item.getLineNumber(), item.getColumnNumber(), "non-standard media-type '" + mimeType + "' with no fallback");
            } else if (!(OPFChecker.isBlessedItemType(mimeType, this.version) || OPFChecker.isDeprecatedBlessedItemType(mimeType) || this.checkItemFallbacks(item, opfHandler))) {
                this.report.error(this.path, item.getLineNumber(), item.getColumnNumber(), "non-standard media-type '" + mimeType + "' with fallback to non-spine-allowed media-type");
            }
        }
    }

    protected boolean checkItemFallbacks(OPFItem item, OPFHandler opfHandler) {
        String mimeType;
        OPFItem fallbackStyleItem;
        String fallbackStyle;
        String mimeType2;
        OPFItem fallbackItem;
        String fallback = item.getFallback();
        if (fallback != null && (fallbackItem = opfHandler.getItemById(fallback)) != null && (mimeType2 = fallbackItem.getMimeType()) != null) {
            if (OPFChecker.isBlessedItemType(mimeType2, this.version) || OPFChecker.isDeprecatedBlessedItemType(mimeType2)) {
                return true;
            }
            if (this.checkItemFallbacks(fallbackItem, opfHandler)) {
                return true;
            }
        }
        return (fallbackStyle = item.getFallbackStyle()) != null && (fallbackStyleItem = opfHandler.getItemById(fallbackStyle)) != null && (mimeType = fallbackStyleItem.getMimeType()) != null && (OPFChecker.isBlessedStyleType(mimeType) || OPFChecker.isDeprecatedBlessedStyleType(mimeType));
    }

    protected boolean checkImageFallbacks(OPFItem item, OPFHandler opfHandler) {
        String mimeType;
        OPFItem fallbackItem;
        String fallback = item.getFallback();
        if (fallback != null && (fallbackItem = opfHandler.getItemById(fallback)) != null && (mimeType = fallbackItem.getMimeType()) != null) {
            if (OPFChecker.isBlessedImageType(mimeType)) {
                return true;
            }
            if (this.checkImageFallbacks(fallbackItem, opfHandler)) {
                return true;
            }
        }
        return false;
    }
}

