/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.opf;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ocf.OCFPackage;
import com.adobe.epubcheck.opf.OPFChecker;
import com.adobe.epubcheck.util.EPUBVersion;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public class XRefChecker {
    public static final int RT_GENERIC = 0;
    public static final int RT_HYPERLINK = 1;
    public static final int RT_IMAGE = 2;
    public static final int RT_OBJECT = 3;
    public static final int RT_STYLESHEET = 4;
    public static final int RT_AUDIO = 5;
    public static final int RT_SVG_PAINT = 16;
    public static final int RT_SVG_CLIP_PATH = 17;
    public static final int RT_SVG_SYMBOL = 18;
    Hashtable<String, Resource> resources = new Hashtable();
    HashSet<String> undeclared = new HashSet();
    Vector<Reference> references = new Vector();
    Report report;
    OCFPackage ocf;
    EPUBVersion version;

    public XRefChecker(OCFPackage ocf, Report report, EPUBVersion version) {
        this.ocf = ocf;
        this.report = report;
        this.version = version;
    }

    public String getMimeType(String path) {
        return this.resources.get(path) != null ? this.resources.get((Object)path).mimeType : null;
    }

    public void registerResource(String resource, String mimeType, boolean inSpine, boolean hasValidItemFallback, boolean hasValidImageFallback) {
        if (this.resources.get(resource) != null) {
            throw new IllegalArgumentException("duplicate resource: " + resource);
        }
        this.resources.put(resource, new Resource(resource, mimeType, inSpine, hasValidItemFallback, hasValidImageFallback));
    }

    public void registerAnchor(String resource, int lineNumber, int columnNumber, String id, int type) {
        Resource res = this.resources.get(resource);
        if (res == null) {
            throw new IllegalArgumentException("unregistered resource: " + resource);
        }
        if (res.anchors.get(id) != null) {
            throw new IllegalArgumentException("duplicate id: " + id);
        }
        res.anchors.put(id, new Anchor(id, lineNumber, columnNumber, type));
    }

    public void registerReference(String srcResource, int srcLineNumber, int srcColumnNumber, String refResource, String refFragment, int type) {
        if (refResource.startsWith("data:")) {
            return;
        }
        this.references.add(new Reference(srcResource, srcLineNumber, srcColumnNumber, refResource, refFragment, type));
    }

    public void registerReference(String srcResource, int srcLineNumber, int srcColumnNumber, String ref, int type) {
        String refFragment;
        String refResource;
        if (ref.startsWith("data:")) {
            return;
        }
        int hash = ref.indexOf("#");
        if (hash >= 0) {
            refResource = ref.substring(0, hash);
            refFragment = ref.substring(hash + 1);
        } else {
            refResource = ref;
            refFragment = null;
        }
        this.registerReference(srcResource, srcLineNumber, srcColumnNumber, refResource, refFragment, type);
    }

    public void checkReferences() {
        Enumeration<Reference> refs = this.references.elements();
        while (refs.hasMoreElements()) {
            Reference ref = refs.nextElement();
            this.checkReference(ref);
        }
    }

    private void checkReference(Reference ref) {
        Resource res = this.resources.get(ref.refResource);
        if (res == null) {
            if (!this.ocf.hasEntry(ref.refResource)) {
                this.report.error(ref.resource, ref.lineNumber, ref.columnNumber, "'" + ref.refResource + "': referenced resource missing in the package");
            } else if (!this.undeclared.contains(ref.refResource)) {
                this.undeclared.add(ref.refResource);
                this.report.error(ref.resource, ref.lineNumber, ref.columnNumber, "'" + ref.refResource + "': referenced resource exists, but not declared in the OPF file");
            }
            return;
        }
        if (ref.fragment == null) {
            switch (ref.type) {
                case 16: 
                case 17: 
                case 18: {
                    this.report.error(ref.resource, ref.lineNumber, ref.columnNumber, "fragment identifier missing in reference to '" + ref.refResource + "'");
                    break;
                }
                case 1: {
                    if (!(res.mimeType == null || OPFChecker.isBlessedItemType(res.mimeType, this.version) || OPFChecker.isDeprecatedBlessedItemType(res.mimeType) || res.hasValidItemFallback)) {
                        this.report.error(ref.resource, ref.lineNumber, ref.columnNumber, "hyperlink to non-standard resource '" + ref.refResource + "' of type '" + res.mimeType + "'");
                    }
                    if (res.inSpine) break;
                    this.report.warning(ref.resource, ref.lineNumber, ref.columnNumber, "hyperlink to resource outside spine '" + ref.refResource + "'");
                    break;
                }
                case 2: {
                    if (res.mimeType == null || OPFChecker.isBlessedImageType(res.mimeType) || res.hasValidImageFallback) break;
                    this.report.error(ref.resource, ref.lineNumber, ref.columnNumber, "non-standard image resource '" + ref.refResource + "' of type '" + res.mimeType + "'");
                    break;
                }
            }
        } else {
            switch (ref.type) {
                case 1: {
                    if (!(res.mimeType == null || OPFChecker.isBlessedItemType(res.mimeType, this.version) || OPFChecker.isDeprecatedBlessedItemType(res.mimeType) || res.hasValidItemFallback)) {
                        this.report.error(ref.resource, ref.lineNumber, ref.columnNumber, "hyperlink to non-standard resource '" + ref.refResource + "' of type '" + res.mimeType + "'");
                    }
                    if (res.inSpine) break;
                    this.report.warning(ref.resource, ref.lineNumber, ref.columnNumber, "hyperlink to resource outside spine '" + ref.refResource + "'");
                    break;
                }
                case 2: {
                    this.report.error(ref.resource, ref.lineNumber, ref.columnNumber, "fragment identifier used for image resource '" + ref.refResource + "'");
                    break;
                }
                case 4: {
                    this.report.error(ref.resource, ref.lineNumber, ref.columnNumber, "fragment identifier used for stylesheet resource '" + ref.refResource + "'");
                }
            }
            Anchor anchor = res.anchors.get(ref.fragment);
            if (anchor == null) {
                this.report.error(ref.resource, ref.lineNumber, ref.columnNumber, "'" + ref.fragment + "': fragment identifier is not defined in '" + ref.refResource + "'");
                return;
            }
            switch (ref.type) {
                case 16: 
                case 17: {
                    if (anchor.type == ref.type) break;
                    this.report.error(ref.resource, ref.lineNumber, ref.columnNumber, "fragment identifier '" + ref.fragment + "' defines incompatible resource type in '" + ref.refResource + "'");
                    break;
                }
                case 1: 
                case 18: {
                    if (anchor.type == ref.type || anchor.type == 0) break;
                    this.report.error(ref.resource, ref.lineNumber, ref.columnNumber, "fragment identifier '" + ref.fragment + "' defines incompatible resource type in '" + ref.refResource + "'");
                }
            }
        }
    }

    private class Resource {
        String resource;
        String mimeType;
        Hashtable<String, Anchor> anchors;
        boolean inSpine;
        boolean hasValidItemFallback;
        boolean hasValidImageFallback;

        Resource(String resource, String type, boolean inSpine, boolean hasValidItemFallback, boolean hasValidImageFallback) {
            this.mimeType = type;
            this.resource = resource;
            this.inSpine = inSpine;
            this.hasValidItemFallback = hasValidItemFallback;
            this.hasValidImageFallback = hasValidImageFallback;
            this.anchors = new Hashtable();
        }
    }

    private class Anchor {
        String id;
        int lineNumber;
        int columnNumber;
        int type;

        public Anchor(String id, int lineNumber, int columnNumber, int type) {
            this.id = id;
            this.lineNumber = lineNumber;
            this.columnNumber = columnNumber;
            this.type = type;
        }
    }

    private class Reference {
        String resource;
        int lineNumber;
        int columnNumber;
        String refResource;
        String fragment;
        int type;

        public Reference(String srcResource, int srcLineNumber, int srcColumnNumber, String refResource, String fragment, int type) {
            this.fragment = fragment;
            this.lineNumber = srcLineNumber;
            this.columnNumber = srcColumnNumber;
            this.refResource = refResource;
            this.resource = srcResource;
            this.type = type;
        }
    }
}

