<?php

/*
  Plugin Name: PriPre
  Plugin URI: http://sourceforge.jp/projects/copper/
  Description: 印刷物・電子書籍の両方に対応した出版システムです。
  Version: @version@
  Author: MIYABE Tatsuhiko
  Author URI: http://copper-pdf.com/
  License: Commercial.
 */
define('PRIPRE_COPPER_URI_DEFAULT', 'ctip://localhost:8099/');
define('PRIPRE_COPPER_USER_DEFAULT', 'user');
define('PRIPRE_COPPER_PASSWORD_DEFAULT', 'kappa');

require_once 'includes/config.inc.php';
require_once 'includes/edit.inc.php';
require_once 'includes/publish.inc.php';
require_once 'includes/cover.inc.php';
require_once 'includes/filters.inc.php';

register_activation_hook(__FILE__, 'pripre_install');
register_deactivation_hook(__FILE__, 'pripre_uninstall');

// 青空文庫風タグ
add_filter('the_content', 'pripre_text_filter');

// SVGをアップロード許可
add_filter('ext2type', 'pripre_ext2type');
add_filter('upload_mimes', 'pripre_mime_type');

global $pripre_db_version;
$pripre_db_version = 1;

// データベース生成
function pripre_install() {
    global $wpdb;
    global $pripre_db_version;

    if (!empty($wpdb->charset))
        $charset_collate = "DEFAULT CHARACTER SET $wpdb->charset";
    if (!empty($wpdb->collate))
        $charset_collate .= " COLLATE $wpdb->collate";

    $pripre_book = $wpdb->prefix . "pripre_book";
    $pripre_book_param = $wpdb->prefix . "pripre_book_param";
    $pripre_book_post_param = $wpdb->prefix . "pripre_book_post_param";
    if ($wpdb->get_var("SHOW TABLES LIKE '$pripre_book'") != $pripre_book) {
        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    	// 本のマスターテーブル
        dbDelta("CREATE TABLE $pripre_book (
		id BIGINT(20) UNSIGNED,
		book_date DATETIME DEFAULT '0000-00-00 00:00:00' NOT NULL,
		PRIMARY KEY (id),
		FOREIGN KEY (id) REFERENCES {$wpdb->prefix}term_taxonomy(term_taxonomy_id)
		ON DELETE CASCADE
		) $charset_collate");

        // 本のパラメータ
        dbDelta("CREATE TABLE $pripre_book_param (
		book_id BIGINT(20) UNSIGNED NOT NULL,
		param_name VARCHAR(64) NOT NULL,
		param_value LONGTEXT,
		PRIMARY KEY (book_id, param_name),
		FOREIGN KEY (book_id) REFERENCES $pripre_book (id)
        ON DELETE CASCADE
		) $charset_collate");

        // 本の記事のパラメータ
        dbDelta("CREATE TABLE $pripre_book_post_param (
		book_id BIGINT(20) UNSIGNED NOT NULL,
		post_id INT(20) UNSIGNED NOT NULL,
		param_name VARCHAR(64) NOT NULL,
		param_value LONGTEXT,
        PRIMARY KEY (book_id, post_id, param_name),
		FOREIGN KEY (book_id) REFERENCES $pripre_book (id)
		ON DELETE CASCADE,
		FOREIGN KEY (post_id) REFERENCES {$wpdb->prefix}posts(id)
		ON DELETE CASCADE
		) $charset_collate");

        add_option("pripre_db_version", $pripre_db_version);
    }
}

// データベース削除
function pripre_uninstall() {
	global $wpdb;
	$pripre_book = $wpdb->prefix . "pripre_book";
	$pripre_book_param = $wpdb->prefix . "pripre_book_param";
	$pripre_book_post = $wpdb->prefix . "pripre_book_post";
	
	$wpdb->query("DROP TABLE $pripre_book_post");
	$wpdb->query("DROP TABLE $pripre_book_param");
	$wpdb->query("DROP TABLE $pripre_book");
}

add_action('admin_menu', 'pripre_admin_menu');
add_filter('plugin_action_links', 'pripre_add_link', 10, 2);

function pripre_admin_menu() {
    // サイドメニュー
    // 設定
	add_menu_page('PriPre 設定', 'PriPre', 'administrator', 'pripre.php', 'pripre_options_page', plugins_url('pripre/images/icon.png'), 80); 
    // 出版
	add_submenu_page('pripre.php', '出版', '出版', 'publish_pages', 'pripre_publish_tool', 'pripre_publish_tool');
	add_submenu_page('pripre.php', '表紙ツール', '表紙ツール', 'publish_pages', 'pripre_cover_tool', 'pripre_cover_tool');
	
    // 投稿画面の印刷プレビュー
    add_meta_box('pripre_post_style_box', __('PriPre', 'pripre_textdomain'), 'pripre_post_style_box', 'post', 'side');
    add_meta_box('pripre_post_style_box', __('PriPre', 'pripre_textdomain'), 'pripre_post_style_box', 'page', 'side');
}

function pripre_pdf() {
	?>
	<form target="_blank" action="<?php echo plugins_url('pripre/actions/read-pdf.php'); ?>">
	  <fieldset style="border:2pt solid Gray;padding:3px;margin:3px;">
	  <legend>PDF</legend>
	  <input type="hidden" name="p" value="<?php the_ID(); ?>"/>
	  <label>サイズ <select name="s">
	    <option value="9.7in">9.7インチ(iPad)</option>
	    <option value="6in">6インチ(キンドル)</option>
	    <option value="3.5in">3.5インチ(スマホ)</option>
	    <option value="A4">A4</option>
	  </select></label>
	  <label>文字 <select name="f">
	    <option value="-2">特小</option>
	    <option value="-1">小</option>
	    <option value="" selected="selected">中</option>
	    <option value="1">大</option>
	    <option value="2">特大</option>
	  </select></label>
	  <label>周囲余白 <select name="m">
	    <option value="e">なし</option>
	    <option value="" selected="selected">小</option>
	    <option value="2">大</option>
	  </select></label>
	  <label> <input type="checkbox" name="v" value="1" />縦書き</label>
	  <input type="submit" value="表示" style="background-color:#337fcc;color:White;border:1px solid #225588;border-radius:5px;"/>
	  </fieldset>
	</form>
	<?php
}

wp_enqueue_script('jquery-ui-draggable');
wp_enqueue_script('jquery-ui-droppable');

wp_register_style('pripre_style', plugins_url('pripre/styles/style.css'));
wp_enqueue_style('pripre_style');
?>