<?php
require_once('config.php');
require_once ('cssj/cssj_driver.php');

if (!isset($_GET['post'])) {
	exit;
}
$id = $_GET['post'];
$post = get_post($id);
if (empty($post)) {
	exit;
}

$auth = get_userdata($post->post_author);
if($auth->first_name || $auth->last_name) {
	$name = $auth->first_name." ".$auth->last_name;
} else {
	$name = $auth->user_nicename;            
}
$title = $post->post_title;
$email = $auth->user_email;
$published = date('Y年 n月 j日  H:i:s', strtotime($post->post_date));
$modified = date('Y年 n月 j日  H:i:s', strtotime($post->post_modified));
$now = date('Y年 n月 j日  H:i:s');
$html = $post->post_content;
$html = apply_filters('the_content', $html);
$siteurl = get_option("siteurl");

header("Content-Type: application/pdf");
header("Content-Disposition: inline; filename=post-$id.pdf");

$driver = cssj_create_driver_for($copper_host, $copper_port);
$session = cssj_create_session($driver, $copper_user, $copper_password);
cssj_include_resource($session, '**');
cssj_ob_start_main($session, $siteurl, 'text/html', 'UTF-8');

print <<<EOD
<html>
  <head>
<meta name="AUTHOR" content="$name" />
<meta name="GENERATOR" content="WordPress" />
<title>$title</title>
  <style type="text/css">
EOD;

readfile('style.css');

print <<<EOD
  </style>
  </head>
  <body>
<h1>$title</h1>
<div id="nombre">-<span></span>-</div>
<div class="published">
<span class="label">公開日時:</span><span class="date">$published</span><br />
<span class="label">最終更新日時:</span><span class="date">$modified</span><br />
<span class="label">PDF変換日時:</span><span class="date">$now</span><br />
(by&nbsp;$name)</div>
EOD;

print <<<EOD
<div class="body">
$html
</div>
EOD;

print <<<EOD
  </body>
</html>
EOD;

cssj_ob_end_flush_main();
cssj_close($session);
?>
