<?php
require_once ('../../../../wp-load.php');
require_once ('../includes/utils.inc.php');

$post_id = $_GET['p'];
$post = get_post( $post_id );
if (get_post_status($post_id) != 'publish') {
	$post_type = $post->post_type;
	$post_type_object = get_post_type_object( $post_type );
	if ( !current_user_can($post_type_object->cap->read_post, $post_id) ) {
		wp_die( __('You are not allowed to edit this item.') );
	}
}

global $base;

$style = $_GET['s'];
$vertical = $_GET['v'];

global $pripre_ebook_font, $pripre_ebook_margin;
$pripre_ebook_font = $_GET['f'];
$pripre_ebook_margin = $_GET['m'];

switch($style) {
	case '9.7in':
		$template = $vertical ? 'ebook/v9.7in' : 'ebook/9.7in';
		break;
	case '6in':
		$template = $vertical ? 'ebook/v6in' : 'ebook/6in';
		break;
	case '3.5in':
		$template = $vertical ? 'ebook/v3.5in' : 'ebook/3.5in';
		break;
	case 'A4':
		$template = $vertical ? 'ebook/va4' : 'ebook/a4';
		break;
	default:
		$template = get_post_meta($post_id, 'pripre_entry_style', TRUE);
}

$site = home_url();
$dir = pripre_get_base_dir();
$base = "$dir/templates/book/$template";
$copper = pripre_get_copper();

header("Content-Type: application/pdf");
//header("Content-Type: text/plain");

include ("../includes/copper-common.inc.php");
$template = pripre_get_template($template);
$copper->property("output.page-width", $template['width']."mm");
$copper->property("output.page-height", $template['height']."mm");

$copper->start_resource("style.css", array('encoding' => 'UTF-8'));
include ("$base/style.css");
$copper->end_resource();

$copper->start_main(".", array('encoding' => 'UTF-8'));
$title =  str_replace('\\"', '"', $post->post_title);
$content =  str_replace('\\"', '"', $post->post_content);
$contents_template = "$base/entry.php";
include ("$dir/templates/html.php");
$copper->end_main();
$copper->close();
?>
