CubePDF ユーザーズマニュアル
====

Copyright © 2010 CubeSoft, Inc.  
GNU Affero General Public License version 3 (AGPLv3)  
support@cube-soft.jp  
https://www.cube-soft.jp/cubepdf/

## CubePDF による変換手順

CubePDF は **仮想プリンター** としてインストールされます。そのため、Google Chrome や
Microsoft Edge などの Web ブラウザ、Microsoft Word, Excel, PowerPoint など **印刷**
ボタンのあるアプリケーションであれば何でも、次の 3 ステップで PDF へ変換する事ができます。

1. PDF 化したいものを適当なアプリケーションで表示し **印刷** を選択します。
2. 利用できるプリンターの一覧から **CubePDF** を選択し **印刷** ボタンをクリックします。
3. CubePDF のメイン画面が表示されるので、保存場所などを確認し **変換** ボタンをクリックします。

![PDF への変換手順](https://github.com/cube-soft/Cube.Pdf/blob/master/Applications/Converter/Assets/01.ja.png?raw=true)

指定した名前の PDF ファイルが既に存在する場合、既存の PDF ファイルに結合する事もできます。
既存の PDF ファイルに対する指定方法は次の 4 通りです。

* **上書き**  
  既存の PDF ファイルを新しい PDF ファイルで上書きします。
* **先頭に結合**  
  既存の PDF ファイルの先頭に、変換内容を結合します。
* **末尾に結合**  
  既存の PDF ファイルの末尾に、変換内容を結合します。
* **リネーム**   
  sample (2).pdf のように、自動的に別のファイル名で保存します。

ただし、結合先の PDF ファイルがパスワードによって保護されている時は、
セキュリティ機能で同じ管理用パスワードを設定した場合のみ結合する事ができます。

### 注意

CubePDF は「仮想プリンター」と呼ばれるソフトウェアで、他のアプリケーションの
「印刷」を介して利用します。そのため、スタートメニュー等から直接 CubePDF を
実行したり、PDF ファイル等に関連付けたりして利用する事はできません。

また、CubePDF は変換機能のみを提供し、変換後のファイルを閲覧するには別途
アプリケーションが必要です。例えば、PDF ファイルを閲覧するアプリケーションとしては
[Adobe Acrobat Reader DC](https://get.adobe.com/jp/reader/) 等が挙げられます。

## CubePDF の設定

### 一般

CubePDF は PDF 以外のファイル形式にも変換する事ができます。PDF 以外のファイル形式に
変換したい場合、**ファイルタイプ** の選択項目の中から変換したいものを選択して下さい。

尚、PNG のように複数のページを保持できないファイル形式の場合、変換するページ数だけ
ファイルが作成されます。例えば、出力ファイル名が Sample.png の場合、実際には
Sample-01.png, Sample-02.png, ... と言った名前のファイルが作成されます。

![ファイルタイプ](https://github.com/cube-soft/Cube.Pdf/blob/master/Applications/Converter/Assets/02.ja.png?raw=true)

ファイルタイプが PDF の場合、PDF のバージョンを選択することができます。
PDF のバージョンはファイルタイプの右側にある選択項目の中から必要なものを選択して下さい。

**解像度** の項目は、主にファイルサイズの圧縮（ダウンサンプリング）のために使用されます。
そのため、変換元のデータ以上の解像度を設定しても、品質やファイルサイズが変化しない
場合があります。また、ファイルタイプが PDF, PS, EPS の場合、埋め込まれている画像のみ
設定を影響を受けます。

**ページの向き** の項目は、変換後のファイルの向きを設定する事ができます。
設定可能な項目は以下の通りです。

* **縦・横**  
  全てのページを縦、または横方向に揃えます。
* **自動**  
  PDF を選択した場合のみ有効な設定で、元ファイルの各ページの向きを保持します。
  ファイルタイプが PDF 以外の場合、縦を選択した時と同様の挙動となります。

**ポストプロセス** の項目は、CubePDF による変換処理が終了した後に実行する操作を設定する事が
できます。設定可能な項目は以下の通りです。

* **開く**  
  変換後のファイルを関連付けられたアプリケーションで開きます。
* **フォルダを開く**  
  変換後のファイルを保存したフォルダを開きます。
* **何もしない**  
  変換処理終了後、何もせずに終了します。
* **その他**  
  任意のプログラムを指定できます。

尚、任意のプログラムを指定した場合、CubePDF は変換後のファイルのパスを引数にして実行します。

### 文書プロパティ

![文書プロパティ](https://github.com/cube-soft/Cube.Pdf/blob/master/Applications/Converter/Assets/03.ja.png?raw=true)

ファイルタイプで PDF を選択した場合、タイトルや作成者などの情報を登録する事ができます。
ここで登録した情報は、Adobe Acrobat Reader DC などの PDF 閲覧ソフトのプロパティ画面で
閲覧する事ができます。また、**表示オプション** の項目は、PDF 閲覧ソフトで開いた時の
表示方法を変更する事ができます。

尚、これらの情報の入力を省略した場合、CubePDF は、タイトル、作成者、サブタイトル、
キーワードの情報は空欄に、変換ソフトの情報は「CubePDF」に設定した状態で PDF ファイルを
作成します。

### セキュリティ

ファイルタイプで PDF を選択した場合、作成された PDF ファイルにパスワードを設定する事ができます。
パスワードを設定する場合は、まず **PDF ファイルをパスワードで保護する** の項目を有効にし、
**管理用パスワード** とパスワード確認の項目に同じパスワードを 2 回 入力してください。

![セキュリティ](https://github.com/cube-soft/Cube.Pdf/blob/master/Applications/Converter/Assets/04.ja.png?raw=true)

次に、**操作** の項目で、ユーザに許可・制限する操作を指定します。
設定可能な項目は以下の通りです。

* PDF ファイルを開く時にパスワードを要求する
* 印刷を許可する
* テキストや画像のコピーを許可する
* フォームへの入力を許可する
* ページの挿入、回転、削除を許可する

尚、**PDF ファイルを開く時にパスワードを要求する** の項目を有効にする際、
**管理用パスワードと共用する** の項目も有効にすると、CubePDF は、閲覧用パスワードに
管理用パスワードと同じものを設定します。

ただし、**管理用パスワードと閲覧用パスワードを共有した場合、PDF 閲覧ソフトによっては、印刷やコピー操作等の制限が正常に機能しない事があります**。
これは、PDF 閲覧ソフトが管理用パスワードで PDF ファイルを開いたと認識するためと
予想されます。そのため、CubePDF では、管理用パスワードと共用した場合、その他の操作に
関する許可設定を受け付けないように設計しています。

また、管理用パスワードで PDF ファイルを開いたと認識された場合、閲覧用パスワードの除去も
含めた全ての PDF 編集が可能になります。閲覧用パスワードを管理用パスワードと共用する場合、
これらの動作を十分に理解した上でご利用下さい。

### その他の設定

変換に関するその他の設定（オプション）は以下の通りです。

* **グレースケール**  
  フォントや図形、埋め込まれた画像などを全てグレースケールにした状態で変換します。
* **PDF ファイル中の画像を JPEG 形式で圧縮する**  
  埋め込まれている画像を JPEG 形式に圧縮した上で変換処理を実行します。
* **PDF ファイルを Web 表示用に最適化する**  
  Web 上で PDF ファイルを閲覧する場合、通常は全てのデータがダウンロードし終わるまで
  待つ必要があります。このオプションを有効にすると、ダウンロードの完了した部分を
  先に表示する事ができるような形に最適化されます。これは Linearized PDF と呼ばれる
  仕様です。ただし、このオプションは **パスワードによって保護されている PDF ファイルには適用する事ができません**。
  CubePDF は、何らかのセキュリティ設定が指定されている場合、このオプションを無視します。

**バージョン情報** では、CubePDF のバージョン情報が表示されます。
また、その下にある **起動時にアップデートを確認する** の項目を有効にすると、
CubePDF のバージョンアップ時にパソコンの右下に通知されます。アップデートの確認は、
1 日 1 回、パソコンの起動時に実行されます。
また、アップデートの確認のために送信する情報は、CubePDF, Windows, .NET Framework
それぞれのバージョン番号です。

![表示言語](https://github.com/cube-soft/Cube.Pdf/blob/master/Applications/Converter/Assets/05.ja.png?raw=true)

**表示言語** では、CubePDF メイン画面のメニュー等の表示言語を設定する事ができます。
対応言語は英語と日本語の 2 種類です。また、表示言語で自動を選択した場合、Windows の
言語設定に応じてどちらかの言語が自動的に選択されます。

### 設定の保存

CubePDF のメイン画面において何らかの項目を変更した場合、左下の **設定を保存** ボタンが
クリック可能な状態になります。この時にクリックすると、その時点の各種設定情報が保存されます。
そして、次回以降の CubePDF 起動時における各種設定の初期状態として使用されるようになります。

例えば、CubePDF は初期設定ではデスクトップに変換したファイルを保存しますが、出力ファイルで
別のフォルダを指定後に設定を保存ボタンをクリックすると、次回以降は指定されたフォルダを
保存フォルダの初期設定として利用するようになります。

ただし、セキュリティの各種項目および、出力ファイルのファイル名部分は設定を保存機能の対象外です。

## CubePDF プリンターの設定

CubePDF は、これまでに説明したアプリケーションの設定以外に、**CubePDF プリンター**
に対する設定も存在します。プリンターの設定を変更するためには、まず **コントロールパネル** の
**デバイスとプリンターの表示** で表示される画面で CubePDF を右クリックし **印刷設定** を
選択して下さい。

![印刷設定（コントロールパネル）](https://github.com/cube-soft/Cube.Pdf/blob/master/Applications/Converter/Assets/08.ja.png?raw=true)

また、Windows 8 以降は **設定** からも同様の操作を行う事ができます。設定から、
**デバイス**、**プリンターとスキャナー** で表示される画面で CubePDF を選択し、
さらに **管理**、**印刷設定** の順で選択して下さい。

![印刷設定（設定）](https://github.com/cube-soft/Cube.Pdf/blob/master/Applications/Converter/Assets/09.ja.png?raw=true)

印刷設定では、**用紙/品質** タブで白黒またはカラーで印刷する設定を変更する事ができます。
また、それ以外の設定を行う場合、右下にある **詳細設定** ボタンをクリックします。

![印刷の詳細オプション](https://github.com/cube-soft/Cube.Pdf/blob/master/Applications/Converter/Assets/10.ja.png?raw=true)

**用紙サイズ** は、変換後の各ページのサイズに反映されます。
設定可能な値は、A0-A6、B0-B6、はがき、角形 1 号-角形 4 号など実際の用紙サイズに
対応した値が中心となります。尚、**Slide** は Microsoft PowerPoint の初期値 (4:3) に
相当するサイズとなります。

**印刷品質** は、画像データの変換後の品質に影響し、値が高いほど高品質になりファイル
サイズも増大します。尚、CubePDF のアプリケーション側に存在する **解像度** の設定は、
ここで設定した値が上限となります。

**拡大縮小** は、変換元のコンテンツを拡大または縮小した状態で変換するための設定で、
等倍で変換する場合は 100 となります。尚、一部の環境で、この初期値が非常に大きな値に
設定されている事例が見られます。変換後の PDF などが異常に大きな状態となっている場合、
この設定を確認して下さい。

**PostScript オプション** 下にある **TrueType フォント ダウンロードオプション** は、
文字の変換法に関する設定で、設定可能な項目は以下の通りです。

* **Native TrueType**  
  フォント情報などを保ったまま、文字として、変換します。
  ただし、Google Chrome や Microsoft Edge などの多くの Web ブラウザを始めとして、
  アプリケーションの中には印刷処理で文字を図形として変換するアウトライン化を実施
  するものもあります。この場合、プリンターの設定に関わらず、文字としての情報は
  失われてしまうのでご注意下さい。
* **アウトライン**  
  印刷時に文字を図形として変換します。
  この場合、フォント情報など文字としての情報は失われますが、変換後の位置ずれなどの
  問題を軽減する効果があります。
* **ビットマップ**  
  印刷時に文字をビットマップ画像として変換します。
  こちらも位置ずれなどの問題を解決する事がありますが、印刷品質など他の設定内容に
  よってはギザギザ感が目立つなどの問題が発生する事もあります。
* **自動**  
  プリンターが、Native TrueType、アウトライン、ビットマップの設定のどれかを自動的に選択します。

**PostScript オプション** 下にある **左右反転印刷** は、変換元のコンテンツを左右
または上下に反転した状態で変換するための設定で、通常は **いいえ** に設定されています。
一部の環境で、この初期値が **はい** となっている事例が見られます。変換後の PDF が
上下左右反転している場合、この設定を確認して下さい。

### 注意

印刷を実行するアプリケーションによっては、独自の印刷設定画面を用意しているなどの関係で、
CubePDF プリンターの設定が反映されない事があります。印刷設定に関しては、利用する
アプリケーションの設定も注意深く確認するようお願いします。

## CubePDF のアンインストール

CubePDF をアンインストールするには、まず、コントロールパネルのプログラムのアンインストール
または、設定のアプリと機能（Windows 8 以降）を選択します。そして、表示される画面で
CubePDF のアイコンを選択してアンインストールの項目を実行して下さい。

![アンインストール（コントロールパネル）](https://github.com/cube-soft/Cube.Pdf/blob/master/Applications/Converter/Assets/06.ja.png?raw=true)
![アンインストール（設定）](https://github.com/cube-soft/Cube.Pdf/blob/master/Applications/Converter/Assets/07.ja.png?raw=true)

## CubePDF で問題が発生した場合

CubePDF は、**C:\ProgramData\CubeSoft\CubePdf\Log** フォルダに実行ログを出力しています。
問題が発生した時は、これらのログを添付して support@cube-soft.jp までご連絡お願いします。