/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.codegen.schema;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.axis2.wsdl.codegen.schema.XmlComplexType;
import org.apache.axis2.wsdl.codegen.schema.XmlElement;
import org.apache.axis2.wsdl.codegen.schema.XmlImport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlSchema {
    public static final String XMLNS_NAMESPACE_URI = "http://www.w3.org/2000/xmlns/";
    private Map namespacesPrefixMap = new HashMap();
    private Map imports = new HashMap();
    private Map elements = new HashMap();
    private Map complexTypes = new HashMap();
    private String targetNamespace;

    public XmlSchema() {
    }

    public XmlSchema(String targetNamespace) {
        this();
        this.targetNamespace = targetNamespace;
        this.namespacesPrefixMap.put(this.targetNamespace, "tns");
        this.namespacesPrefixMap.put("http://www.w3.org/2001/XMLSchema", "xsd");
    }

    public void addNamespace(String namespace, String prefix) {
        this.namespacesPrefixMap.put(namespace, prefix);
    }

    public void addImport(XmlImport xmlImport) {
        this.imports.put(xmlImport.getTargetNamespace(), xmlImport);
    }

    public boolean isExists(XmlImport xmlImport) {
        return this.imports.containsKey(xmlImport.getTargetNamespace());
    }

    public void addElement(XmlElement xmlElement) {
        this.elements.put(xmlElement.getName(), xmlElement);
    }

    public boolean isExists(XmlElement xmlElement) {
        return this.elements.containsKey(xmlElement.getName());
    }

    public boolean isElementExists(String name) {
        return this.elements.containsKey(name);
    }

    public void addComplexType(XmlComplexType xmlComplexType) {
        this.complexTypes.put(xmlComplexType.getName(), xmlComplexType);
    }

    public boolean isExists(XmlComplexType xmlComplexType) {
        return this.complexTypes.containsKey(xmlComplexType.getName());
    }

    public boolean isComplexTypeExists(String nameComplexType) {
        return this.complexTypes.containsKey(nameComplexType);
    }

    public Element getSchemaElement(Document document) {
        Element schemaElement = document.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:schema");
        schemaElement.setPrefix("xsd");
        schemaElement.setAttribute("targetNamespace", this.targetNamespace);
        Iterator iter = this.namespacesPrefixMap.keySet().iterator();
        while (iter.hasNext()) {
            String namespace = (String)iter.next();
            String prefix = (String)this.namespacesPrefixMap.get(namespace);
            schemaElement.setAttributeNS(XMLNS_NAMESPACE_URI, "xmlns:" + prefix, namespace);
        }
        Iterator iter2 = this.imports.values().iterator();
        while (iter2.hasNext()) {
            XmlImport xmlImport = (XmlImport)iter2.next();
            schemaElement.appendChild(xmlImport.getXmlSchemaElement(document));
        }
        Iterator iter3 = this.elements.values().iterator();
        while (iter3.hasNext()) {
            XmlElement xmlElement = (XmlElement)iter3.next();
            schemaElement.appendChild(xmlElement.getSchemaElement(document, this.namespacesPrefixMap));
        }
        Iterator iter4 = this.complexTypes.values().iterator();
        while (iter4.hasNext()) {
            XmlComplexType xmlComplexType = (XmlComplexType)iter4.next();
            schemaElement.appendChild(xmlComplexType.getSchemaElement(document));
        }
        return schemaElement;
    }

    public Map getNamespacesPrefixMap() {
        return this.namespacesPrefixMap;
    }

    public void setNamespacesPrefixMap(Map namespacesPrefixMap) {
        this.namespacesPrefixMap = namespacesPrefixMap;
    }

    public Map getImports() {
        return this.imports;
    }

    public void setImports(Map imports) {
        this.imports = imports;
    }

    public Map getElements() {
        return this.elements;
    }

    public void setElements(Map elements) {
        this.elements = elements;
    }

    public Map getComplexTypes() {
        return this.complexTypes;
    }

    public void setComplexTypes(Map complexTypes) {
        this.complexTypes = complexTypes;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }
}

