/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.context.commands;

import org.apache.axis2.AxisFault;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.context.commands.UpdateContextCommand;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UpdateServiceContextCommand
extends UpdateContextCommand {
    private static final Log log = LogFactory.getLog((Class)UpdateServiceContextCommand.class);
    protected String serviceGroupName;
    protected String serviceGroupContextId;
    protected String serviceName;

    public void setServiceGroupName(String serviceGroupName) {
        this.serviceGroupName = serviceGroupName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setServiceGroupContextId(String serviceGroupContextId) {
        this.serviceGroupContextId = serviceGroupContextId;
    }

    public void execute(ConfigurationContext configurationContext) throws ClusteringFault {
        AxisService axisService;
        ServiceGroupContext sgCtx;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Updating service context properties...");
        }
        if ((sgCtx = configurationContext.getServiceGroupContext(this.serviceGroupContextId)) != null) {
            try {
                AxisService axisService2 = configurationContext.getAxisConfiguration().getService(this.serviceName);
                ServiceContext serviceContext = sgCtx.getServiceContext(axisService2);
                this.propertyUpdater.updateProperties((AbstractContext)serviceContext);
            }
            catch (AxisFault e) {
                throw new ClusteringFault((Exception)((Object)e));
            }
        }
        sgCtx = configurationContext.getServiceGroupContext(this.serviceGroupContextId);
        try {
            axisService = configurationContext.getAxisConfiguration().getService(this.serviceName);
        }
        catch (AxisFault axisFault) {
            throw new ClusteringFault((Exception)((Object)axisFault));
        }
        String scope = axisService.getScope();
        if (sgCtx == null) {
            AxisServiceGroup serviceGroup = configurationContext.getAxisConfiguration().getServiceGroup(this.serviceGroupName);
            if (serviceGroup == null) {
                return;
            }
            sgCtx = new ServiceGroupContext(configurationContext, serviceGroup);
            sgCtx.setId(this.serviceGroupContextId);
            if (scope.equals("application")) {
                configurationContext.addServiceGroupContextIntoApplicationScopeTable(sgCtx);
            } else if (scope.equals("soapsession")) {
                configurationContext.addServiceGroupContextIntoSoapSessionTable(sgCtx);
            }
        }
        try {
            ServiceContext serviceContext = sgCtx.getServiceContext(axisService);
            this.propertyUpdater.updateProperties((AbstractContext)serviceContext);
        }
        catch (AxisFault axisFault) {
            throw new ClusteringFault((Exception)((Object)axisFault));
        }
    }

    public String toString() {
        return "UpdateServiceContextCommand";
    }
}

