/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.annogen.override.internal;

import java.lang.reflect.Field;
import org.codehaus.annogen.override.AnnoBean;
import org.codehaus.annogen.override.AnnoBeanMapping;
import org.codehaus.annogen.view.internal.reflect.ReflectAnnogenTigerDelegate;
import org.codehaus.jam.provider.JamLogger;

public class DefaultAnnoBeanMapping
implements AnnoBeanMapping {
    public static final String PROXY_FOR = "PROXY_FOR";
    private ReflectAnnogenTigerDelegate mDelegate = null;

    public DefaultAnnoBeanMapping(JamLogger logger) {
        this.mDelegate = ReflectAnnogenTigerDelegate.create(logger);
    }

    public Class getAnnoBeanClassForRequest(Class requestedClass) throws ClassNotFoundException {
        if (AnnoBean.class.isAssignableFrom(requestedClass)) {
            return requestedClass;
        }
        if (this.mDelegate == null) {
            throw new IllegalStateException("Delegate failed to initialize, check log for errors.");
        }
        return this.mDelegate.getAnnogenInfo_annoBeanClass(requestedClass);
    }

    public Class getDeclaredClassForAnnoBeanClass(Class beanClass) throws ClassNotFoundException {
        Field f;
        if (!AnnoBean.class.isAssignableFrom(beanClass)) {
            throw new IllegalArgumentException(beanClass.getName() + " is not a AnnoBean");
        }
        try {
            f = beanClass.getField(PROXY_FOR);
        }
        catch (NoSuchFieldException nsfe) {
            throw new IllegalArgumentException(beanClass.getName() + " is an AnnoBean but does not have a " + PROXY_FOR + " field");
        }
        try {
            String declaredTypeName = (String)f.get(null);
            return beanClass.getClass().getClassLoader().loadClass(declaredTypeName);
        }
        catch (IllegalAccessException e) {
            try {
                throw new ClassNotFoundException().initCause(e);
            }
            catch (Throwable unlikely) {
                unlikely.printStackTrace();
                throw new IllegalStateException();
            }
        }
    }
}

