/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

dojo.provide("aipo.addressbook");

dojo.require("aipo.widget.MemberNormalSelectList");
dojo.require("aipo.widget.AddressGroupNormalSelectList");

aipo.addressbook.onLoadAddressbookDialog = function(portlet_id){

    var fpicker = dijit.byId("groupnormalselect");
    if(fpicker){
        var select = dojo.byId('init_grouplist');
        var i;
        var s_o = select.options;
        if (s_o.length == 1 && s_o[0].value == "") return;
        for(i = 0 ; i < s_o.length; i ++ ) {
            fpicker.addOptionSync(s_o[i].value,s_o[i].text,true);
        }
    }     

    var obj = dojo.byId("lastname");
    if(obj){
        obj.focus();
    }
}

aipo.addressbook.onLoadAddressbookCompanyDialog = function(portlet_id){

    var obj = dojo.byId("company_name");
    if(obj){
        obj.focus();
    }
    
}

aipo.addressbook.onLoadAddressbookGroupDialog = function(portlet_id){

    var mpicker = dijit.byId("membernormalselect");
    if(mpicker){
        var select = dojo.byId('init_memberlist');
        var i;
        var s_o = select.options;
        if (s_o.length == 1 && s_o[0].value == "") return;
        for(i = 0 ; i < s_o.length; i ++ ) {
            mpicker.addOptionSync(s_o[i].value,s_o[i].text,true);
        }
    }
    
    var obj = dojo.byId("group_name");
    if(obj){
        obj.focus();
    }
}

aipo.addressbook.formSwitchCompanyInput = function(button) {
    if(button.form.is_new_company.value == 'TRUE' || button.form.is_new_company.value == 'true') {
        button.value = '新しく入力する';
        aipo.addressbook.formCompanyInputOff(button.form);
    } else {
        button.value = '一覧から選択する';
        aipo.addressbook.formCompanyInputOn(button.form);
    }
}

aipo.addressbook.formCompanyInputOn = function(form) {
    dojo.byId('AddressBookCompanySelectField').style.display = "none";
    dojo.byId('AddressBookCompanyInputField').style.display = "";

    form.is_new_company.value = 'TRUE';
}

aipo.addressbook.formCompanyInputOff = function(form) {
    dojo.byId('AddressBookCompanyInputField').style.display = "none";
    dojo.byId('AddressBookCompanySelectField').style.display = "";
    
    form.is_new_company.value = 'FALSE';
    
    
}

/**
 * キーワード検索処理
 *
 * @param form 検索フォーム
 * @param url 検索URL
 * @param p_id ポートレットID
 * @param tab 表示対象タブ
 */
aipo.addressbook.onSubmitSerchButton = function(form,url,p_id,tab){

     var exec_url = url;

     if(tab==""){
        if(form.tab != undefined ){
	       if(form.tab[0].checked){
	           tab = form.tab[0].value;
	       }else{
	           tab = form.tab[1].value;
	       }
        }
     }
     
     //change start
     //var search_params = [["sword",form.sword.value],["tab",tab],["mode",form.mode.value]];
     var search_params
     if( form.sword.value != "" ) {
       search_params = [["sword",form.sword.value],["tab",tab],["mode",form.mode.value]];
     } else {
       search_params = [["sword",form.sword.value],["tab",tab]];
     }
     //change end
     aipo.viewPage(exec_url, p_id, search_params);
     
}

aipo.addressbook.onReceiveMessage = function(msg){
    if(!msg) {
        var arrDialog = dijit.byId("modalDialog");
        if(arrDialog){
            arrDialog.hide();
        }
        aipo.portletReload('addressbook');
    }
    if (dojo.byId('messageDiv')) {
      dojo.byId('messageDiv').innerHTML = msg;
    }
}

aipo.addressbook.onListReceiveMessage = function(msg){
   if(!msg) {
        var arrDialog = dijit.byId("modalDialog");
        if(arrDialog){
           arrDialog.hide();
        }
        aipo.portletReload('addressbook');
    }
    if (dojo.byId('listmessageDiv')) {
        dojo.byId('listmessageDiv').innerHTML = msg;
    }
}

//add by motegi start
/**
 * 個人アドレスの登録・更新・削除時のレスポンスハンドら
 *
 * @param msg サーバーからのレスポンス
 */
aipo.addressbook.onReceiveMessageForWindow = function(msg){
    if(!msg) {   
        //change start
        //window.opener.aipo.portletReload('addressbook');
        for(var index in window.opener.ptConfig) {
          if(window.opener.ptConfig[index].group == 'addressbook') {
            var url = window.opener.ptConfig[index].reloadUrl;
            if( window.opener.dojo.byId('SearchModeFlag') ) {
              url = url + "&mode=ajaxsearch&reload=1";
              window.opener.ptConfig[index].reloadUrl = url;
              
            }
            //window.opener.aipo.viewPage(url, index);
            window.opener.aipo.portletReload('addressbook');
          }
        }
        //change end
        window.close();
    }
    if (dojo.byId('messageDiv')) {
      dojo.byId('messageDiv').innerHTML = msg;
    }
}

/**
 * 社内アドレス検索（プルダウン選択時処理）
 *
 * @param exec_url 検索URL
 * @param p_id ポートレットID
 * @param change_post1 部署１プルダウン選択時か？
 */
aipo.addressbook.onSearchCorpAddressSubmit = function(exec_url, p_id, change_post1){

  var parent_group_name =dojo.byId('parent_group_name').value;
  var post2_group_name =dojo.byId('post2_group_name').value;
  //var position_id =dojo.byId('position_id').value;
  //var role_id =dojo.byId('role_id').value;
  var position_id = "";
  var role_id = "";
  
  var search_params = [
                   ["ajax_search_corp","1"],    
                   ["parent_group_name",parent_group_name],
                   ["post2_group_name",post2_group_name],
                   ["position_id",position_id],
                   ["role_id",role_id],
                   ["change_post1",change_post1]
                  ];
  
  aipo.viewPage(exec_url, p_id, search_params);
}
