/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.fileupload.beans;

import com.aimluck.commons.field.ALStringField;

/**
 * アップロードファイルの詳細な情報を含むBeanです。 <br />
 * 
 */
public class FileuploadBean extends FileuploadLiteBean {

  /** フォルダパス */
  private ALStringField folderPath = null;

  /** ファイルの種別 */
  private ALStringField contentType = null;

  /** 画像かどうか */
  private boolean isImage = false;

  // add start 要件No.11 メール作成／詳細（ファイル添付）
  /** アップロード成功か否か */
  private boolean isUploadSuccess = false;

  /** 結果メッセージ */
  private String resultMessage = "";

  // add end

  /**
   * コンストラクタ
   */
  public FileuploadBean() {
    initField();

    folderPath = new ALStringField();
    folderPath.setFieldName("フォルダパス");
    folderPath.setTrim(true);

    contentType = new ALStringField();
    contentType.setFieldName("コンテントタイプ");
    contentType.setTrim(true);
  }

  public ALStringField getFolderPath() {
    return folderPath;
  }

  public void setFolderPath(String path) {
    folderPath.setValue(path);
  }

  public ALStringField getContentType() {
    return contentType;
  }

  public void setContentType(String type) {
    contentType.setValue(type);
  }

  public void setIsImage(boolean bool) {
    isImage = bool;
  }

  public boolean isImage() {
    return isImage;
  }

  // add start 要件No.11 メール作成／詳細（ファイル添付）
  /**
   * アップロードが成功したか否かを返します。
   * 
   * @return 成功時ture、そうでない場合false
   */
  public boolean isUploadSuccess() {
    return isUploadSuccess;
  }

  /**
   * アップロードの結果を設定します。
   * 
   * @param bool
   *          成功時ture、そうでない場合false
   */
  public void setUploadResult(boolean bool) {
    isUploadSuccess = bool;
  }

  /**
   * 結果メッセージを返します。
   * 
   * @return 結果メッセージ
   */
  public String getResultMessage() {
    return resultMessage;
  }

  /**
   * 結果メッセージを設定します。
   * 
   * @param resultMessage
   *          結果メッセージ
   */
  public void setResultMessage(String resultMessage) {
    this.resultMessage = resultMessage;
  }
  // add end

}
