/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.actions.webmail;

import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.modules.actions.common.ALBaseAction;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.webmail.WebMailAccountSelectData;
import com.aimluck.eip.webmail.WebMailFilterSelectData;
import com.aimluck.eip.webmail.WebMailFolderSelectData;
import com.aimluck.eip.webmail.WebMailSelectData;
import com.aimluck.eip.webmail.WebMailSendSelectData;
import com.aimluck.eip.webmail.util.WebMailUtils;

/**
 * Webメールの取り扱いに関するアクションクラスです。 <br />
 */
public class WebMailAction extends ALBaseAction {

  private static final JetspeedLogger logger =
    JetspeedLogFactoryService.getLogger(WebMailAction.class.getName());

  /**
   * 
   * @param portlet
   * @param context
   * @param rundata
   * @throws Exception
   */
  @Override
  protected void buildNormalContext(VelocityPortlet portlet, Context context,
      RunData rundata) throws Exception {

    // add start 20111110
    // 検索条件をクリア
    clearConditionSession(rundata, context);
    // add end

    // add start
    // 全アカウントに対してメール受信処理を行う
    // WebMailUtils.receiveAllAccountMailsThread(rundata, context);

    if (getMode() == null) {
      // 全アカウントに対してメール受信処理を行う
      WebMailUtils.receiveAllAccountMailsThread(rundata, context);
      // add end

      // セッション情報をクリアする
      clearWebMailSession(rundata, context);

      ALEipUtils.setTemp(rundata, context, ALEipConstants.ENTITY_ID, ALEipUtils
        .getPortlet(rundata, context)
        .getPortletConfig()
        .getInitParameter("p3a-accounts")
        .trim());

      WebMailSelectData listData = new WebMailSelectData();
      listData.initField();
      listData.loadMailAccountList(rundata, context);
      // add start
      // フォルダ容量情報設定
      listData.loadMailBoxVolume(rundata, context);
      // add end
      listData.setRowsNum(Integer.parseInt(portlet
        .getPortletConfig()
        .getInitParameter("p1a-rows")));
      listData.setStrLength(Integer.parseInt(portlet
        .getPortletConfig()
        .getInitParameter("p4a-strlen")));
      listData.doViewList(this, rundata, context);
      setTemplate(rundata, "webmail");

    }
  }

  /**
   * 
   * @param portlet
   * @param context
   * @param rundata
   */
  @Override
  protected void buildMaximizedContext(VelocityPortlet portlet,
      Context context, RunData rundata) {
    // MODEを取得
    String mode = rundata.getParameters().getString(ALEipConstants.MODE);

    try {
      if (ALEipConstants.MODE_LIST.equals(mode)) {
        doWebmail_list(rundata, context);
      }

      if (getMode() == null) {
        doWebmail_list(rundata, context);
      }
    } catch (Exception e) {
      logger.error("Exception", e);
    }
  }

  /**
   * 受信フォルダもしくは送信フォルダに保存されているメールの一覧を表示する．
   * 
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doWebmail_list(RunData rundata, Context context) throws Exception {
    VelocityPortlet portlet = ALEipUtils.getPortlet(rundata, context);

    // change start by motegi 受入試験課題・障害一覧 No.5
    // WebMailSelectData listData = new WebMailSelectData();
    // listData.initField();
    // listData.loadMailAccountList(rundata, context);
    // listData.setRowsNum(Integer.parseInt(portlet
    // .getPortletConfig()
    // .getInitParameter("p1b-rows")));
    // listData.setStrLength(Integer.parseInt(portlet
    // .getPortletConfig()
    // .getInitParameter("p4a-strlen")));
    // listData.doViewList(this, rundata, context);
    // setTemplate(rundata, "webmail-list");

    // add start
    String tab = rundata.getParameters().getString("tab");
    if (null == tab || tab.equals("")) {
      tab = ALEipUtils.getTemp(rundata, context, "tab");
    }
    if (WebMailUtils.TAB_RECEIVE.equals(tab)) {
      // add end

      WebMailSelectData listData = new WebMailSelectData();
      listData.initField();
      listData.loadMailAccountList(rundata, context);
      // フォルダ容量情報設定
      listData.loadMailBoxVolume(rundata, context);
      listData.setRowsNum(Integer.parseInt(portlet
        .getPortletConfig()
        .getInitParameter("p1b-rows")));
      listData.setStrLength(Integer.parseInt(portlet
        .getPortletConfig()
        .getInitParameter("p4a-strlen")));
      listData.doViewList(this, rundata, context);
      // setTemplate(rundata, "webmail-list");

      // add start
    } else {

      WebMailSendSelectData listData = new WebMailSendSelectData();
      listData.initField();
      listData.loadMailAccountList(rundata, context);
      // フォルダ容量情報設定
      listData.loadMailBoxVolume(rundata, context);
      listData.setRowsNum(Integer.parseInt(portlet
        .getPortletConfig()
        .getInitParameter("p1b-rows")));
      listData.setStrLength(Integer.parseInt(portlet
        .getPortletConfig()
        .getInitParameter("p4a-strlen")));
      listData.doViewList(this, rundata, context);
    }
    // add end

    // add start
    // 標準または最大化画面によってTemplateを呼び分ける
    JetspeedRunData jdata = (JetspeedRunData) rundata;
    if (jdata.getMode() == JetspeedRunData.MAXIMIZE) {
      setTemplate(rundata, "webmail-list");
    } else {
      setTemplate(rundata, "webmail");
    }
    // add end
    // change end
  }

  /**
   * POP3 サーバからメールを受信し，受信トレイを表示する．
   * 
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doWebmail_receive_mails(RunData rundata, Context context)
      throws Exception {
    // メールを受信する．
    // WebMailUtils.receiveMailsThread(rundata, context);

    // 受信トレイにフォーカスを移す．
    // remove start
    // ALEipUtils.setTemp(rundata, context, "tab", WebMailUtils.TAB_RECEIVE);
    // remove end
    doWebmail_list(rundata, context);
  }

  /**
   * アカウントの一覧を表示する．
   * 
   * @param context
   * @param rundata
   * @param isMaximized
   * @param rowCount
   * @throws Exception
   */
  public void doWebmail_account_list(RunData rundata, Context context)
      throws Exception {
    VelocityPortlet portlet = ALEipUtils.getPortlet(rundata, context);

    WebMailAccountSelectData listData = new WebMailAccountSelectData();
    listData.initField();
    listData.setRowsNum(Integer.parseInt(portlet
      .getPortletConfig()
      .getInitParameter("p1c-rows")));
    listData.setStrLength(Integer.parseInt(portlet
      .getPortletConfig()
      .getInitParameter("p4a-strlen")));
    listData.doViewList(this, rundata, context);
    setTemplate(rundata, "webmail-account-list");
  }

  /**
   * フィルタ一覧を表示する．
   * 
   * @param context
   * @param rundata
   * @param isMaximized
   * @param rowCount
   * @throws Exception
   */
  public void doWebmail_filter_list(RunData rundata, Context context)
      throws Exception {
    VelocityPortlet portlet = ALEipUtils.getPortlet(rundata, context);

    WebMailFilterSelectData listData = new WebMailFilterSelectData();
    listData.initField();
    listData.loadMailAccountList(rundata, context);
    listData.setRowsNum(Integer.parseInt(portlet
      .getPortletConfig()
      .getInitParameter("p1d-rows")));
    listData.setStrLength(Integer.parseInt(portlet
      .getPortletConfig()
      .getInitParameter("p4a-strlen")));
    listData.doViewList(this, rundata, context);

    // add start
    // 標準または最大化画面によってTemplateを呼び分ける
    JetspeedRunData jdata = (JetspeedRunData) rundata;
    if (jdata.getMode() == JetspeedRunData.MAXIMIZE) {
      setTemplate(rundata, "webmail-filter-list");
    } else {
      setTemplate(rundata, "webmail-filter");
    }
    // add end
  }

  // add start
  /**
   * フォルダ一覧を表示する．
   * 
   * @param context
   * @param rundata
   * @throws Exception
   */
  public void doWebmail_folder_list(RunData rundata, Context context)
      throws Exception {

    WebMailFolderSelectData listData = new WebMailFolderSelectData();
    listData.initField();
    listData.loadMailAccountList(rundata, context);
    // 最大20件表示
    listData.setRowsNum(20);
    listData.doViewList(this, rundata, context);

    // 標準または最大化画面によってTemplateを呼び分ける
    JetspeedRunData jdata = (JetspeedRunData) rundata;
    if (jdata.getMode() == JetspeedRunData.MAXIMIZE) {
      setTemplate(rundata, "webmail-folder-list");
    } else {
      setTemplate(rundata, "webmail-folder");
    }
  }

  // add end

  private void clearWebMailSession(RunData rundata, Context context) {
    JetspeedRunData jdata = (JetspeedRunData) rundata;
    VelocityPortlet portlet = ((VelocityPortlet) context.get("portlet"));

    jdata.getUser().removeTemp(WebMailUtils.ACCOUNT_ID);
    jdata.getUser().removeTemp(WebMailUtils.FOLDER_ID);

    jdata.getUser().removeTemp("tr_pop3mail_recieve");
    jdata.getUser().removeTemp(
      new StringBuffer().append(portlet.getID()).append(
        "com.aimluck.eip.webmail.WebMailAccountSelectDatasort").toString());
  }

  // add by motegi start
  private void clearConditionSession(RunData rundata, Context context) {

    ALEipUtils.removeTemp(rundata, context, "WebMailWord");
    ALEipUtils.removeTemp(rundata, context, "WebMailSubjectWord");
    ALEipUtils.removeTemp(rundata, context, "WebMailAddressWord");
    ALEipUtils.removeTemp(rundata, context, "WebMailIncludeSubFolder");
  }
}
