/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package aipo.batch.kicker;

import org.apache.axis2.AxisFault;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

import aipo.webservice.soap.axis2.MaintenanceServiceStub;

/**
 * <HR>
 * メールアカウント移行バッチ起動クラス
 * <p>
 * 
 * メールアカウント移行バッチ処理を起動します。
 * <P>
 * <HR>
 * <P>
 * 
 */
public class ChangeMailServerKicker {

  /** ロガー */
  private static final JetspeedLogger logger =
    JetspeedLogFactoryService.getLogger(ChangeMailServerKicker.class.getName());

  /**
   * メールアカウント移行バッチの実行クラス
   * 
   * @param args
   *            [0]-> エンドポイントのサービスのアドレス
   * @exception Exception
   */
  public static void main(String[] args) {
    MaintenanceServiceStub stub = null;
    try {

      // 接続先ＵＲＬを指定しスタブを生成するMaintenanceServiceStub
      stub =
        new MaintenanceServiceStub(
          "http://localhost:80/aipo/services/MaintenanceService");

      // レスポンスを取得
      stub._getServiceClient().getOptions().setTimeOutInMilliSeconds(
        60 * 60 * 1000);
      MaintenanceServiceStub.ChangeMailServerResponse res =
        stub.changeMailServer();
      System.out.println("return -> " + res.get_return());
    } catch (Exception e) {
    } finally {
      if (stub != null) {
        try {
          // リソース解放
          stub._getServiceClient().cleanup();
          stub.cleanup();
        } catch (AxisFault e) {
          logger.error(e.toString());
        }
      }
    }
  }
}
