/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 *
 * Copyright(C) 2011 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.addressbook;

import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;

import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.user.beans.UserGroupLiteBean;
import com.aimluck.eip.user.util.UserUtils;

/**
 * アドレス帳(携帯・スマートフォン)ポートレット所属部署2情報取得用のクラスです。
 */
public class AddressBookPost2SelectData extends
    ALAbstractSelectData<UserGroupLiteBean, UserGroupLiteBean> {

  /** 遷移元画面で選択された部署1名 */
  public String current_parent_group_name;

  /**
   * 共通メソッドを呼び出して部署2リストを生成します。
   * 
   * @param action
   *          アクションクラス
   * @param rundata
   *          JetSpeedランデータ
   * @param context
   *          JetSpeedコンテキスト
   * @throws ALPageNotFoundException
   * @throws ALDBErrorException
   */
  @Override
  public void init(ALAction action, RunData rundata, Context context)
      throws ALPageNotFoundException, ALDBErrorException {
    // 選択された部署1名情報取得
    current_parent_group_name =
      rundata.getRequest().getParameter("parent_group_name");
    super.init(action, rundata, context);
  }

  /**
   * 遷移元画面で選択された部署1名に紐づく 部署2リストを取得するメソッドです。
   * 
   * @return 部署2データ
   */
  public List<UserGroupLiteBean> getChildGroupList() {
    if (current_parent_group_name != null
      && current_parent_group_name.length() > 0) {
      return UserUtils.getPost2LiteBeans(current_parent_group_name);
    }
    return new ArrayList<UserGroupLiteBean>(0);
  }

  /**
   * 遷移元画面で選択された部署1名を取得するメソッドです。
   * 
   * @return "選択中"部署1名
   */
  public String getCurrentParentGroupName() {
    return current_parent_group_name;
  }

  /**
   * ※未使用
   */
  @Override
  protected Attributes getColumnMap() {
    return null;
  }

  /**
   * ※未使用
   */
  @Override
  protected ResultList<UserGroupLiteBean> selectList(RunData rundata,
      Context context) throws ALPageNotFoundException, ALDBErrorException {
    return null;
  }

  /**
   * ※未使用
   */
  @Override
  protected Object getResultData(UserGroupLiteBean obj)
      throws ALPageNotFoundException, ALDBErrorException {
    return null;
  }

  /**
   * ※未使用
   */
  @Override
  protected Object getResultDataDetail(UserGroupLiteBean obj)
      throws ALPageNotFoundException, ALDBErrorException {
    return null;
  }

  /**
   * ※未使用
   */
  @Override
  protected UserGroupLiteBean selectDetail(RunData rundata, Context context)
      throws ALPageNotFoundException, ALDBErrorException {
    return null;
  }

}
