/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.screens;

import javax.servlet.http.HttpServletResponse;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.schedule.ScheduleConst;
import com.aimluck.eip.schedule.ScheduleSelectData;

/**
 * スケジュールの詳細画面を処理するクラスです。 <br />
 * 
 */
public class ScheduleDetailScreen extends ALVelocityScreen {

  /** logger */
  private static final JetspeedLogger logger =
    JetspeedLogFactoryService.getLogger(ScheduleDetailScreen.class.getName());

  /**
   * 
   * @param rundata
   * @param context
   * @throws Exception
   */
  @Override
  protected void doOutput(RunData rundata, Context context) throws Exception {
    // add start
    // 画面テンプレートパス
    String layout_template = "";
    // add end

    try {
      ScheduleSelectData detailData = new ScheduleSelectData();
      detailData.initField();
      // change start
      // detailData.doViewDetail(this, rundata, context);
      if (detailData.doViewDetail(this, rundata, context)) {
        // テンプレートを正常系画面に決定
        layout_template = "portlets/html/ja/ajax-schedule-detail.vm";
      } else {
        // add start
        // 運用課題No.34
        if (ScheduleConst.ERR_STATUS_NO_DATA.equals(detailData.getErrStatus())) {
          // エラー状態がデータなしの場合、テンプレートをデータなし画面に決定
          layout_template = "portlets/html/ja/no-schedule-detail-err.vm";
        } else {
          // add end
          // テンプレートを異常系画面に決定
          layout_template = "portlets/html/ja/DBErrorForWindow.vm";
          // add start
        }
        // add end
      }

      // remove start
      // 無意味なコードのため削除
      // String entityid =
      // ALEipUtils.getTemp(rundata, context, ALEipConstants.ENTITY_ID);
      // context.put(ALEipConstants.ENTITY_ID, entityid);
      // remove end

      // remove start
      // String layout_template = "portlets/html/ja/ajax-schedule-detail.vm";

      // setTemplate(rundata, context, layout_template);
      // remove end

    } catch (Exception ex) {
      logger.error("[ScheduleDetailScreen] Exception.", ex);
      // change start
      // ALEipUtils.redirectDBError(rundata);
      // テンプレートを異常系画面に決定
      layout_template = "portlets/html/ja/DBErrorForWindow.vm";
      // change end
    }
    // add start
    // 別ウインドウ化対応
    HttpServletResponse response = rundata.getResponse();
    response
      .setContentType("text/html; " + ALEipConstants.DEF_CONTENT_ENCODING);

    setTemplate(rundata, context, layout_template);
    // add end
  }

}
