/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 *
 * Copyright(C) 2012 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.screens;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URLEncoder;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.turbine.util.RunData;

import com.aimluck.eip.cayenne.om.portlet.AvzTScheduleFile;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import com.aimluck.eip.services.storage.ALStorageService;
import com.aimluck.eip.util.ALEipUtils;

/**
 * スケジュール添付ファイルのダウンロードを処理するクラスです。<br />
 */
public class ScheduleFileDownloadScreen extends FileuploadRawScreen {

  /** <code>loginUserName</code> ログインユーザー名 */
  private String loginUserName;

  /** 添付ファイル名の保存場所：一時保存領域 */
  public static final String TEMP_AREA = "0";

  /** 添付ファイル名の保存場所：通常保存領域 */
  public static final String SAVE_AREA = "1";

  /** 添付ファイル一時ファイル保存ディレクトリ */
  public static final String FOLDER_TMP_FOR_ATTACHMENT_FILES = JetspeedResources.getString("aipo.tmp.fileupload.attachment.directory", "");

  /** デフォルトエンコーディングを表わすシステムプロパティのキー */
  public static final String FILE_ENCODING = JetspeedResources.getString("content.defaultencoding", "UTF-8");

  /** 添付ファイル名を保存するファイルの拡張子 */
  public static final String EXT_FILENAME = ".txt";

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(ScheduleFileDownloadScreen.class.getName());

  /**
   * スケジュール作成（編集）画面 添付ファイルリンククリック処理
   * 
   * @param rundata
   * @throws Exception
   */
  @Override
  protected void doOutput(RunData rundata) throws Exception {
    try {
      // ログイン名取得
      ALEipUser loginuser = ALEipUtils.getALEipUser(rundata);
      loginUserName = loginuser.getName().getValue();

      // 処理モード
      String mode = rundata.getParameters().getString("download_mode");

      if (mode.equals(TEMP_AREA)) {
        // 一時保存領域からダウンロード

        // ユーザID
        int uid = ALEipUtils.getUserId(rundata);
        // ルートパス
        if (FOLDER_TMP_FOR_ATTACHMENT_FILES == null || "".equals(FOLDER_TMP_FOR_ATTACHMENT_FILES)) {
          logger.error("添付ファイル一時ファイル保存ディレクトリの取得が失敗しました。");
          throw new Exception();
        }
        // データベース名
        String orgId = Database.getDomainName();
        // 保存フォルダ名
        String folderName = rundata.getParameters().getString("folder_name");
        // ファイル名
        String fileId = rundata.getParameters().getString("attachmentIndex");
        // ファイルのフルパス
        String fileFullPath = FOLDER_TMP_FOR_ATTACHMENT_FILES + "/" + orgId + "/" + uid + "/" + folderName + "/" + fileId;

        BufferedReader reader = null;
        try {
          reader = new BufferedReader(new InputStreamReader(ALStorageService.getFile(fileFullPath + EXT_FILENAME), FILE_ENCODING));
          String line = reader.readLine();
          // ファイル名はURLエンコードする。（エンコードすると半角スペースが+に置き変わってしまうため、%20に置換する）
          line = URLEncoder.encode(line, "UTF-8").replaceAll("\\+", "%20");
          super.setFileName(line);
        } catch (Exception e) {
          logger.error("Exception", e);
        } finally {
          try {
            reader.close();
          } catch (Exception e) {
            logger.error("Exception", e);
          }
        }

        super.setFilePath(fileFullPath);

        // ダウンロード実行
        super.doOutput(rundata);

      } else {
        // DBから取得した保存先でダウンロード
        AvzTScheduleFile file = ScheduleUtils.getAvzTScheduleFile(rundata);

        super.setFilePath(ScheduleUtils.getSaveDirPath(Database.getDomainName(), file.getOwnerId().intValue()) + file.getFilePath());
        // ファイル名はURLエンコードする。（エンコードすると半角スペースが+に置き変わってしまうため、%20に置換する）
        String fileName = URLEncoder.encode(file.getFileName(), "UTF-8").replaceAll("\\+", "%20");
        super.setFileName(fileName);
        super.doOutput(rundata);
      }
    } catch (Exception e) {
      logger.error("添付ファイルのダウンロードに失敗しました。ログインユーザー:" + loginUserName, e);
    }
  }
}
