/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.screens;

import java.util.List;

import javax.servlet.http.HttpServletResponse;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.schedule.ScheduleFormData;
import com.aimluck.eip.user.beans.UserGroupPositionLiteBean;
import com.aimluck.eip.user.util.UserUtils;
import com.aimluck.eip.util.ALEipUtils;

/**
 * スケジュールフォームデータを管理するためのクラスです。 <br />
 * 
 */
public class ScheduleFormScreen extends ALVelocityScreen {

  /** logger */
  private static final JetspeedLogger logger =
    JetspeedLogFactoryService.getLogger(ScheduleFormScreen.class.getName());

  /**
   * 
   * @param rundata
   * @param context
   * @throws Exception
   */
  @Override
  protected void doOutput(RunData rundata, Context context) throws Exception {

    try {

      doSchedule_form(rundata, context);

    } catch (Exception ex) {
      logger.error("[ScheduleFormScreen] Exception.", ex);
      ALEipUtils.redirectDBError(rundata);
    }
  }

  protected void doSchedule_form(RunData rundata, Context context) {
    // add start
    // 画面テンプレートパス
    String layout_template = "";
    // add end

    ScheduleFormData formData = new ScheduleFormData();
    formData.loadParameters(rundata, context);
    formData.initField();
    // change start
    // formData.doViewForm(this, rundata, context);
    // 別ウインドウ化対応
    if (formData.doViewForm(this, rundata, context)) {

      // 現在のユーザー名を取得する
      ALEipUser loginuser = ALEipUtils.getALEipUser(rundata);
      String current = loginuser.getAliasName().toString();
      context.put("current_user", current);
      context.put("current_user_ln", loginuser.getName());
      context.put("current_user_id", loginuser.getUserId());

      // ログインユーザーの所属部署1,部署2を取得する
      List<UserGroupPositionLiteBean> list =
        UserUtils.getPostPositionBeanList((int) loginuser
          .getUserId()
          .getValue());
      if (list != null && list.size() > 0) {
        UserGroupPositionLiteBean b = list.get(0);
        String current_parent_group_name = b.getPost1GroupName();
        String current_group_name = b.getPost2GroupName();
        context.put("current_group_name", current_group_name);
        context.put("current_parent_group_name", current_parent_group_name);
      }

      // テンプレートを正常系画面に決定
      layout_template = "portlets/html/ja/ajax-schedule-form.vm";
    } else {
      // テンプレートを異常系画面に決定
      layout_template = "portlets/html/ja/DBErrorForWindow.vm";
    }
    // change end

    // add start
    // 別ウインドウ化対応
    HttpServletResponse response = rundata.getResponse();
    response
      .setContentType("text/html; " + ALEipConstants.DEF_CONTENT_ENCODING);
    // add end

    // remove start
    // String layout_template = "portlets/html/ja/ajax-schedule-form.vm";
    // remove end
    setTemplate(rundata, context, layout_template);
  }
}
