/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 *
 * Copyright(C) 2011 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.screens;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.webmail.WebMailPackageProcessFormData;

/**
 * 一括処理選択画面を処理するクラスです。
 * 
 */
public class WebMailPackageProcessFormScreen extends ALVelocityScreen {

  /** logger */
  private static final JetspeedLogger logger =
    JetspeedLogFactoryService.getLogger(WebMailPackageProcessFormScreen.class
      .getName());

  @Override
  protected void doOutput(RunData rundata, Context context) throws Exception {
    try {
      WebMailPackageProcessFormData formData =
        new WebMailPackageProcessFormData();
      formData.initField();
      formData.doViewForm(this, rundata, context);
      // remove start
      // 内部レビュー反映No.3
      // HttpServletResponse response = rundata.getResponse();
      // response.setContentType("text/html; "
      // + ALEipConstants.DEF_CONTENT_ENCODING);
      // remove end
      setTemplate(
        rundata,
        context,
        "portlets/html/ja/ajax-webmail-package-process-form.vm");
    } catch (Exception ex) {
      logger.error("[WebMailAccountFormScreen] Exception.", ex);
      ALEipUtils.redirectDBError(rundata);
    }
  }

}
