/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.webmail.beans;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.eip.common.ALData;

/**
 * Webメールのフォルダ容量合計情報のBeanです。 <br />
 */
public class WebMailFolderVolumeSummaryBean implements ALData, Cloneable {

  /** フォルダ容量合計 */
  private ALNumberField folderVolumeSummary;

  /** メールボックス使用率 */
  private ALNumberField mailBoxVolumePct;

  /** メールボックス未使用率 */
  private ALNumberField mailBoxVolumeEmptyPct;

  /**
   * 
   * 
   */
  public void initField() {
    folderVolumeSummary = new ALNumberField();
    mailBoxVolumePct = new ALNumberField();
    mailBoxVolumeEmptyPct = new ALNumberField();
  }

  /**
   * フォルダ容量合計取得<BR>
   * 
   * @return
   */
  public ALNumberField getFolderVolumeSummary() {
    return folderVolumeSummary;
  }

  /**
   * フォルダ容量合計設定<BR>
   * 
   * @param folderVolumeSummary
   */
  public void setFolderVolumeSummary(long folderVolumeSummary) {
    this.folderVolumeSummary.setValue(folderVolumeSummary);
  }

  /**
   * メールボックス使用率取得<BR>
   * 
   * @return mailBoxVolumePct
   */
  public ALNumberField getMailBoxVolumePct() {
    return mailBoxVolumePct;
  }

  /**
   * メールボックス使用率設定<BR>
   * 
   * @param mailBoxVolumePct
   */
  public void setMailBoxVolumePct(long mailBoxVolumePct) {
    this.mailBoxVolumePct.setValue(mailBoxVolumePct);
  }

  /**
   * メールボックス未使用率取得<BR>
   * 
   * @return mailBoxVolumeEmptyPct
   */
  public ALNumberField getMailBoxVolumeEmptyPct() {
    return mailBoxVolumeEmptyPct;
  }

  /**
   * メールボックス未使用率設定<BR>
   * 
   * @param mailBoxVolumeEmptyPct
   */
  public void setMailBoxVolumeEmptyPct(long mailBoxVolumeEmptyPct) {
    this.mailBoxVolumeEmptyPct.setValue(mailBoxVolumeEmptyPct);
  }

  @Override
  protected Object clone() throws CloneNotSupportedException {
    return super.clone();
  }

}
