/*!
* @file ItemBase.h
* @brief Q[̃ACex[X̃vg^Cv
* @date 2014/02/01
* @author Deskull
* 2014 Sikabane Works.
*/

#pragma once

#include "stdafx.h"
#include "Dice.h"
#include "ItemTemplate.h"
#include "GameElement.h"
#include "SavingTable.h"
#include "HaveSymbol.h"


namespace Deeangband
{

	/*!
	* @class ItemBase
	* @brief ACex[X̃NX
	* @details
	* <H1>Tv</H1>
	* ItemBaseNX́AACe̊{ʂ`
	* <H2>Xe[^Xvf</H2>
	* x[XACe͈ȉ̃Xe[^XvfĂB
	* <ul>
	* <li>_[W_CX/DamageDice</li>
	* <li>d/Weight</li>
	* <li>{Z[rOC/BaseSaving</li>
	* <li>ǉZ[rOC/PlusSaving</li>
	* </ul>
	*/
	class ItemBase : public ItemTemplate
	{
	private:
		Dice baseDamage; //!< x[X_[W̃_CX
		WEIGHT weight; //!< ACȅd
		SavingTable baseSaving; //!< {Z[rOC
		SavingTable plusSaving; //!< ǉZ[rOC

		template<class Archive> void serialize(Archive &archive, const unsigned int) 
		{
		}

	public:

		/*! 
		* @brief ItemBaseNXRXgN^
		*/
		ItemBase::ItemBase(void);

		/*! 
		* @brief ItemBasefXgN^
		*/
		ItemBase::~ItemBase(void);

		/*! 
		* @brief ACȅdʂԂ
		* @return ACȅd
		*/
		WEIGHT ItemBase::GetWeight(void);

		/*! 
		* @brief ACẽ_[W_CXԂ
		* @return ACẽ_[W_CX
		*/
		Dice ItemBase::GetDamageDice(void);

		/*! 
		* @brief _~[f[^ɂ鏉
		* @return Ȃ
		*/
		void ItemBase::WipeData(void);

		/*!
		* @brief XMLVACYɂQ[f[^ۑ
		* @return Ȃ
		*/
		void ItemBase::XMLSave(std::string filename);

	};

}