/*!
* @file HaveGameTime.cpp
* @brief Q[^CێۃNX`
* @date 2014/06/11
* @author Deskull
* 2014 Sikabane Works.
*/

#include "stdafx.h"
#include "HaveGameTime.h"

namespace Deeangband
{
	HaveGameTime::HaveGameTime(void)
	{
		WipeData();
		return;
	}

	HaveGameTime::~HaveGameTime(void)
	{
		WipeData();
		return;
	}

	void HaveGameTime::WipeData(void)
	{
		this->time = 0;
		this->turn = 0;
	}

	GAME_TIME HaveGameTime::GetGameTime(void)
	{
		return this->time;
	}

	TURN HaveGameTime::GetTurn(void)
	{
		return this->turn;
	}

	TURN HaveGameTime::GetWait(void)
	{
		return this->wait;
	}

	void HaveGameTime::PlusWait(ACTION_WAIT plusWait, bool normalRand)
	{
		double wait = normalRand ? Dice::CastNormalRand(plusWait, 5) : plusWait;
		if(plusWait <= 0) plusWait = 1;
		this->wait += plusWait;
		std::normal_distribution<> distWait(wait, GameConstants::ActionWaitDeviation);
		this->wait += (ACTION_WAIT)distWait(Dice::mt);
	}

	bool operator<(HaveGameTime left, HaveGameTime right)
	{
		return left.GetWait() < right.GetWait();
	}

	bool operator>(HaveGameTime left, HaveGameTime right)
	{
		return left.GetWait() > right.GetWait();
	}

}
