﻿using System;
using System.Runtime.Serialization;

namespace Sasa.QualityTools.DrFx.Tests.Violation.CSharp.Microsoft.Design
{
    // このクラスは CA1032:MissingConstructor に違反しています。
    [Serializable]
    public class Rule1032A : Exception
    {
        public Rule1032A(int count)
        {
            switch (count)
            {
                case 0:
                    throw new Rule1032B();
                case 1:
                    throw new Rule1032B("abc");
                case 2:
                    throw new Rule1032B("xyz", new InvalidOperationException());
                default:
                    throw new Rule1032B(new SerializationInfo(null, null), new StreamingContext());
            }
        }
    }

    [Serializable]
    public class Rule1032B : Exception
    {
        // このコンストラクタは CA1032:Accessibility に違反しています。
        internal Rule1032B()
        {
        }

        // このコンストラクタは CA1032:Accessibility に違反しています。
        internal Rule1032B(string message)
            : base(message)
        {
        }

        // このコンストラクタは CA1032:Accessibility に違反しています。
        internal Rule1032B(string message, Exception innerException)
            : base(message, innerException)
        {
        }

        // このコンストラクタは CA1032:Accessibility に違反しています。
        internal Rule1032B(SerializationInfo info, StreamingContext context)
            : base(info, context)
        {
        }
    }
}
