﻿using System;
using System.Diagnostics.CodeAnalysis;
using System.Runtime.InteropServices;
using System.Text;

namespace Sasa.QualityTools.DrFx.Tests.Violation.CSharp.Microsoft.Usage
{
    internal static class Rule2205
    {
        // このメソッドは CA2205:PlatformInvokeDeclaration に違反しています。
        [DllImport("kernel32.dll", CharSet = CharSet.Unicode, SetLastError = true)]
        [SuppressMessage("Microsoft.Design", "CA1060:MovePInvokesToNativeMethodsClass")]
        internal static extern int ExpandEnvironmentStrings(string lpSrc, StringBuilder lpDst, int nSize);
    }

    public static class Rule2205A
    {
        public static string ExpandEnvironmentVariable(string variableName)
        {
            StringBuilder expandedVariable = new StringBuilder(256);
            if (Rule2205.ExpandEnvironmentStrings(variableName, expandedVariable, expandedVariable.Capacity) != 0)
            {
                throw new InvalidOperationException("Failed to expand enviroment variable.");
            }
            return expandedVariable.ToString();
        }
    }
}
