﻿using System;
using System.Configuration;
using System.Data;
using System.Data.Common;

namespace DrFx.St.Target5
{
    public static class Program
    {
        public static void Main()
        {
            ConnectionStringSettings setting = ConfigurationManager.ConnectionStrings["mydatasource"];

            DbProviderFactory factory = DbProviderFactories.GetFactory(setting.ProviderName);
            using (IDbConnection connection = factory.CreateConnection())
            {
                connection.ConnectionString= setting.ConnectionString;
                connection.Open();
                using (IDbCommand command = connection.CreateCommand())
                {
                    command.CommandText = "SELECT * FROM [Customers]";
                    using (IDataReader reader = command.ExecuteReader())
                    {
                        while (reader.Read())
                        {
                            Console.WriteLine(reader["Customer Id"]);
                        }
                    }
                }
            }
        }
    }
}
