﻿using System;
using System.Collections;
using System.IO;

namespace Sasa.QualityTools.DrFx.Tests.Violation.CSharp.Microsoft.Design
{
    public class Rule1065 : IEqualityComparer
    {
        private int orderId = 1;

        // このプロパティは CA1065:PropertyGetter に違反しています。
        public int OrderId
        {
            get
            {
                if (this.orderId < 0)
                {
                    throw new FileNotFoundException();
                }
                return this.orderId;
            }
        }

        public override string ToString()
        {
            throw new FileLoadException();
        }

        // このプロパティは CA1065:HasAllowedExceptions に違反しています。
        public int GetHashCode(object obj)
        {
            if (this.orderId == (int)obj)
            {
                throw new DirectoryNotFoundException();
            }
            return this.orderId;
        }

        bool IEqualityComparer.Equals(object x, object y)
        {
            return x == y;
        }
    }
}
