﻿/*
 * DrFx - FxCop Report Translator and Visualizer.
 * Copyright (C) 2010 Sasa Yuan
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */



using System;
using System.Collections.Generic;
using System.IO;

namespace Sasa.QualityTools.DrFx.Core
{
    /// <summary>
    /// FxCopCmd.exe プロセス生成のための構成値を表します。
    /// </summary>
    public class FxCopProcessConfiguration
    {
        /// <summary>
        /// FxCop インストールディレクトリ。
        /// デフォルト値は '%PROGRAMFILES%\Microsoft FxCop 1.36' です。
        /// </summary>
        public string FxCopInstallDirectory { get; set; }

        /// <summary>
        /// FxCop レポートの出力先。
        /// デフォルト値は 'codeanalysisreport.xml' です。
        /// </summary>
        public string OutputFile { get; set; }

        /// <summary>
        /// コード分析対象アセンブリのパスのコレクション。
        /// </summary>
        public ICollection<string> TargetFiles { get; private set; }

        /// <summary>
        /// ルール定義アセンブリのパスのコレクション。
        /// </summary>
        public ICollection<string> RuleFiles { get; private set; }

        /// <summary>
        /// コード分析対象アセンブリの依存アセンブリ検索ディレクトリのコレクション。
        /// </summary>
        public ICollection<string> DependencyDirectories { get; private set; }

        /// <summary>
        /// カスタムディクショナリファイル。
        /// デフォルト値は空文字列です。
        /// </summary>
        public string DictionaryFile { get; set; }

        /// <summary>
        /// 分析対象アセンブリが依存しているアセンブリの検索先に GAC を含めるかどうか。
        /// デフォルト値は false です。
        /// </summary>
        public bool EnableSearchGac { get; set; }



        /// <summary>
        /// 新しいインスタンスを初期化します。
        /// </summary>
        public FxCopProcessConfiguration()
        {
            FxCopInstallDirectory = Path.Combine(Environment.GetEnvironmentVariable("PROGRAMFILES"), "Microsoft FxCop 1.36");
            OutputFile = "codeanalysisreport.xml";
            TargetFiles = new List<string>();
            RuleFiles = new List<string>();
            DependencyDirectories = new List<string>();
            DictionaryFile = String.Empty;
        }
    }
}
