﻿/*
 * DrFx - FxCop Report Translator and Visualizer.
 * Copyright (C) 2010 Sasa Yuan
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */



using Sasa.QualityTools.DrFx.Explorer.Report;
using System;
using System.Windows;
using System.Windows.Controls;

namespace Sasa.QualityTools.DrFx.Explorer
{
    public class WarningDataTemplateSelector : DataTemplateSelector
    {
        public override DataTemplate SelectTemplate(object item, DependencyObject container)
        {
            FxCopIssueRelationship relationship = item as FxCopIssueRelationship;
            if (relationship == null)
            {
                return new DataTemplate(typeof(FxCopIssueRelationship));
            }

            switch (relationship.Target)
            {
                case WarningTarget.Assembly:
                    return (DataTemplate)Application.Current.FindResource("AssemblyTemplate");
                case WarningTarget.Namespace:
                    return (DataTemplate)Application.Current.FindResource("NamespaceTemplate");
                case WarningTarget.Type:
                    return (DataTemplate)Application.Current.FindResource("TypeTemplate");
                case WarningTarget.Member:
                    return (DataTemplate)Application.Current.FindResource("MemberTemplate");
                default:
                    return new DataTemplate(typeof(FxCopIssueRelationship));
            }
        }
    }
}
