﻿/*
 * DrFx - FxCop Report Translator and Visualizer.
 * Copyright (C) 2010 Sasa Yuan
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */



using NUnit.Framework;
using Sasa.QualityTools.DrFx.Explorer.Rule;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Xml;

namespace Sasa.QualityTools.DrFx.Explorer.Tests.Integration.Rule
{
    [TestFixture]
    public class FxCopRuleLoaderTest
    {
        [Test]
        public void TestLoadRulesFromAssembliesWithoutAssembly()
        {
            FxCopRuleLoader loader = new FxCopRuleLoader();
            Collection<FxCopRule> rules = loader.Load();

            Assert.That(rules, Is.Empty);
        }

        [Test]
        public void TestLoadRulesFromAssemblies()
        {
            FxCopRuleLoader loader = new FxCopRuleLoader();
            loader.AssemblyPaths.Add(@"TestData\Rule\FxCopRuleLoaderTest\Sasa.QualityTools.DrFx.Tests.Data.TestRules.dll");
            Collection<FxCopRule> rules = loader.Load();

            Assert.That(rules, Has.Count.EqualTo(3));

            Assert.That(rules[0].Name, Is.EqualTo("テストルール 1"));
            Assert.That(rules[0].CheckId, Is.EqualTo("DR1001"));
            Assert.That(rules[0].Category, Is.EqualTo("DrFx.Tests"));
            Assert.That(rules[0].TypeName, Is.EqualTo("Test1Rule"));
            Assert.That(rules[0].AssemblyName, Is.EqualTo("Sasa.QualityTools.DrFx.Tests.Data.TestRules"));

            Assert.That(rules[1].Name, Is.EqualTo("テストルール 2"));
            Assert.That(rules[1].CheckId, Is.EqualTo("DR1002"));
            Assert.That(rules[1].Category, Is.EqualTo("DrFx.Tests"));
            Assert.That(rules[1].TypeName, Is.EqualTo("Test2Rule"));
            Assert.That(rules[1].AssemblyName, Is.EqualTo("Sasa.QualityTools.DrFx.Tests.Data.TestRules"));

            Assert.That(rules[2].Name, Is.EqualTo("テストルール 3"));
            Assert.That(rules[2].CheckId, Is.EqualTo("DR1003"));
            Assert.That(rules[2].Category, Is.EqualTo("DrFx.Tests"));
            Assert.That(rules[2].TypeName, Is.EqualTo("Test3Rule"));
            Assert.That(rules[2].AssemblyName, Is.EqualTo("Sasa.QualityTools.DrFx.Tests.Data.TestRules"));
        }
    }
}
