﻿using System;
using System.IO;
using System.Security.Permissions;

namespace Sasa.QualityTools.DrFx.Tests.Violation.CSharp.Microsoft.Security
{
    public static class Rule2106
    {
        public static string ReadFile(string directory, string fileName)
        {
            return ReadFile(Path.Combine(directory, fileName));
        }

        // このクラスは CA2106:Stack に違反しています。
        public static string ReadFile(string path)
        {
            FileIOPermission permission = new FileIOPermission(PermissionState.Unrestricted);
            permission.Assert();
            return File.ReadAllText(path);
        }

        // このクラスは CA2106:Default に違反しています。
        [FileIOPermission(SecurityAction.Assert, Unrestricted = true)]
        public static string[] GetFiles(string directory)
        {
            return Directory.GetFiles(directory);
        }
    }
}
