﻿using System;
using System.IO;
using System.Security.Permissions;

namespace Sasa.QualityTools.DrFx.Tests.Violation.CSharp.Microsoft.Security
{
    public class Rule2103
    {
        private string role;

        public string UserName { get; set; }

        public Rule2103(string role)
        {
            this.role = role;
        }

        public string ReadFile(string file)
        {
            PrincipalPermission permission = new PrincipalPermission(UserName, "Users");
            permission.Demand();
            return File.ReadAllText(file);
        }

        public string ReadFile(string file, string userName)
        {
            PrincipalPermission permission = new PrincipalPermission(userName, this.role);
            permission.Demand();
            return File.ReadAllText(file);
        }
    }
}
