;**********************************************************************
;                                                                     *
;    Filename:      DV877A.asm                                        *
;    Remark         DV adapter using UT-118 + LCD(20x4) + PIC Prog.   *
;    Date:          09/03/2007                                        *
;    Last Modified  11/19/2007                                        *
;    File Version:  V 00.57                                           *
;                                                                     *
;    Author:        Satoshi Yasuda 7m3tjz/ad6gz                       *
;                   7m3tjz@jarl.com                                   *
;                                                                     *
;    If you want to redistribute this file,                           *
;      do not modify all files without permission.                    *
;                                                                     *
;**********************************************************************

#include	DV877A.inc				; Initial valuse set in this header

#if Language == 1
#include	language_E.inc			; English version
#endif
#if	Language == 2					; German varsion (not yet)
#include	language_G.inc
#endif
#if Language == 0
#include	language_J.inc			; Japanese version
#endif
;=====================================================================*
;                                                                     *
;    Notes:                                                           *
;   08/28/2007 Release v00.01                                         *
;   09/05/2007 Bug Fix v00.04                                         *
;   09/09/2007 added Message interval routine v00.05                  *
;   09/11/2007 V00.06                                                 *
;   09/11/2007 Added DCD v00.07                                       *
;   09/12/2007 Change buffer empty check v00.08                       * 
;   09/12/2007 bug fix v00.09                                         *
;   09/12/2007 Added M1 M2 M3 v00.10                                  *
;   09/12/2007 RRW,RCW buf fixed v00.11                               *
;   09/13/2007 Bug Fix v00.12                                         *
;   09/14/2007 added Reset routine v00.13                             *
;   09/15/2007 M1,M2,M3 return logic change  v00.14                   *
;   09/15/2007 M1,M2,M3 message change v00.15                         *
;   09/16/2007 Added debug mode v00.16                                *
;   09/17/2007 Added GPS Display routeine v00.17                      *
;   09/17/2007 Added GPS Display SW v00.18                            *
;   09/18/2007 Added AdDefault2 v00.19                                *
;   09/18/2007 Added GPS V message skip v00.20                        *
;   09/20/2007 Changed auto tx set v00.21                             *
;   09/21/2007 Bug fix for  auto duplex v00.22                        *
;   09/21/2007 Bug fix for debug mode@v00.23                          *
;   09/23/2007 Bug fix for debug mode v00.24                          *
;   09/23/2007 Add clear LCD v00.25                                   *
;   09/24/2007 Bug fix for second rs232c v00.26                       *
;   09/24/2007 Added PTT Lock v00.27                                  *
;   09/25/2007 Bug Fix PTT Lock v00.28                                *
;   09/25/2007 clern up v00.29                                        *
;   09/25/2007 clern up v00.30                                        *
;   09/26/2007 Added Beep v00.31                                      *
;   09/26/2007 Bug Fix for Beep v00.32                                *
;   09/27/2007 Clean Up v00.33                                        *
;   09/27/2007 Added clear line 4 in 0x00 command v00.34              *
;   09/27/2007 Bug Fix for yourcall , RPT1 and RPT2 set v00.35        *
;   09/27/2007 Change the check logic for UT118 data stream v00.36    *
;   09/28/2007 Bug fix for display positioning info. v00.37           *
;   09/29/2007 Bug fix for display positioning info. v00.38           *
;   09/29/2007 Bug fix for positioning time info. v00.39              *
;   09/30/2007 Change the check routine for length of GPS Msg. v00.40 *
;              Bug Fix for check 0xfe in datastream                   *
;   10/01/2007 GPS Message set v00.41                                 *
;   10/01/2007 Bug fix for GPS Message set v00.42 and v00.43          *
;   10/04/2007 Added menu mode cancel on PTT V00.44                   * 
;   10/06/2007 Added serial eeprom write route V00.45                 * 
;   10/08/2007 Added cancel botton for serial eeprom write V00.46     * 
;   10/08/2007 Bug fix for your callsign and callsign2 V00.47         *
;                  DOesn't work "/" for Yourcall area. (Fixed)        *
;   10/13/2007 Bug fix for GPS Message set V00.48                     *
;   10/27/2007 Added DCD V00.49                                       *
;   10/29/2007 Bug Fix for DCD and clean up for source V00.50         *
;   10/30/2007 Clean Up V00.51                                        *
;   10/31/2007 Added English message  V00.52                          *
;   11/03/2007 Clean up V00.53                                        *
;   11/04/2007 Bug Fix for DCD V00.54                                 *
;	11/06/2007 Language selection and setting the Initial values      *
;              move to two headers. V00.55                            *
;              One is message on Language.                            *
;                  Japanese: language_J.inc                           *
;                  English:  language_E.inc                           *
;                  German:   language_G.inc (not yet)                 *
;              Another one is initial values (DV877A.inc).            *
;   11/07/2007 Added DSQL/CSQL & DCD to serial eeprom area V00.56     *
;   11/19/2007 Chaged bit3 of PORTB from output to input              *
;                                 for PIC Programer support           *              
;                                                                     *
;**********************************************************************


		list p=16f877a
		#include <p16f877a.inc>
		errorlevel -302
		errorlevel -306
		errorlevel -202

		__CONFIG _CP_OFF & _WDT_OFF & _BODEN_OFF & _PWRTE_ON & _HS_OSC &  _LVP_OFF & _DEBUG_OFF & _CPD_OFF

;==============================================================

SPBRG_VAL	EQU	.31		;set baud rate 9600 for 19.6608Mhz or 20.00MHz clock
TX_BUF_LEN	EQU	.80		;length of transmit circular buffer
RX_BUF_LEN	EQU	TX_BUF_LEN	;length of receive circular buffer

;----------------------------------------------------------------------------
;Bit Definitions for Flags

TxBufFull	EQU	0		;bit indicates Tx buffer is full
TxBufEmpty	EQU	1		;bit indicates Tx buffer is empty
RxBufFull	EQU	2		;bit indicates Rx buffer is full
RxBufEmpty	EQU	3		;bit indicates Rx buffer is empty
FirstDisp	EQU	4
AllSpaces	EQU	5
DebugDisp	EQU	6
MaintMode	EQU 7

;----------------------------------------------------------------------------
;Bit Definitions for Flags2
GpsSentence	EQU		0
GLL			EQU 	1
BEEP_Bit	EQU 	2
Beep_Sw		EQU		3
Called_Sw	EQU		4
GPSDisp_Sw	EQU 	5
GpsMsgSet	EQU		6
MenuCancel	EQU 	7

;----------------------------------------------------------------------------
;Bit Definitions for Flags3
YourCallFlag	EQU		0
AutoReply		EQU		1
P_Beep_Sw		EQU 	2
Pocket_BEEP_Sw	EQU		3
SendDsql_Sw		EQU		4
Beep2			EQU 	5
DsqlSet_Sw		EQU		6
Display_Sw		EQU 	7
;
;----------------------------------------------------------------------------
; AdDefault
Duplex_OnOff	EQU		0
RRW_OnOff		EQU		1
RCW_OnOff		EQU		2
DRS_OnOff		EQU		3
MSGSend_OnOff	EQU		4
GPSDisplay		EQU		5
AutoDuplex		EQU		6
PTTLock			EQU		7
;---------------------------------
; AdDefault2
Debug			EQU		0
BeepOnOff		EQU		1
SlowData96		EQU		2

;
;----------------------------------------------------------------------------
; UT-118  (PORTA)
To_UT118_PTT	EQU		0
From_UT118_PTT	EQU		1
To_LED			EQU		2
From_Mic_PTT	EQU 	3
To_Rig_PTT		EQU		4
Beep			EQU		5
;
;----------------------------------------------------------------------------
; LCD 20 x 4 SC2004C (PORTB)
LCD_E			equ		0		; LCD Enable/Disable
LCD_RW			equ		1		; LCD R/W
LCD_RS			equ		2		; LCD RS
LCD_BUSY_F		equ		7		; LCD Busy

;
;----------------------------------------------------------------------------
; PORTD assign table
menu			equ		0
back			equ		1
enter			equ		2
up				equ		3
down			equ		4
PortdMask		equ		0x1f

;--------
MaxMenu			equ		.25

;-
;------------
;  PORTE assign table
M1				EQU		0
M2				EQU		1
M3				EQU		2
PorteMask		EQU		0x07


;----------------------------------------------------------
WRITE_ADDR  	equ     b'10100000' ; Control byte for write operations
READ_ADDR   	equ     b'10100001' ; Control byte for read operations
;----------------------------------------------------------------------------

#DEFINE		TXBUSY		RESULT,0	;sending
#DEFINE		RXBUSY		RESULT,1	;receiving
#DEFINE		RECV		RESULT,2	;receive end
#DEFINE		ERROR		RESULT,3	;error bit
#DEFINE		START_BIT	RESULT,4	
#DEFINE		RXNEXT_BIT	RESULT,5
#DEFINE		STOP_BIT	RESULT,6
;
MsgTimeOut		EQU		.50			; 25mSec * 50 = 1 Sec.
;
;--------------------------------------------------------------
;Variables

		CBLOCK	0x70
		WREG_TEMP		;storage for WREG during interrupt
		STATUS_TEMP		;storage for STATUS during interrupt
		PCLATH_TEMP		;storage for PCLATH during interrupt
		FSR_TEMP		;storage for FSR during interrupt
		AdDefault		;Adapter default value
		AdDefault2
		DPDT			;
		DPDT_W
		COUNT			;
		COUNT1			;
		COUNT2
		POINT			;
		sw				;
		temp
		temp2
		ReTryCnt
		ENDC

		CBLOCK	0x20
		Flags
		Flags2
		Flags3
		TempData
		BufferData
		TxStartPtr
		TxEndPtr
		RxStartPtr
		RxEndPtr
		msec_cnt
		sec_cnt
		sec_sw
		msg_no
		msg_timeout
		PTT_mode
		command
		resp
		C005PNT
		temp_c0		
		MenuPointer
		AlphaPNT
		AlphaPNT2
		LCDPNT
		Hex2DecTemp
		NumericTemp
		datai
		datao
		pollcnt
		I2CPNTlow
		I2CPNThigh
		I2CaddrHigh
		I2CaddrLow
		BITCNT_TX
		BITCNT_RX
		TX_TEMP
		RX_TEMP
		EXTRA
		temp3
		RESULT
		GpsSW
		GpsLcdPnt
		GpsTimePnt
		portd_s
		porte_s
		RF_Flag0
		RF_Flag1
		JumpPoint
		dsql_sw
		TempCallSign:8
		TempDummy:12
		BeepCNT
		PocketBeepCNT
		EEPROM_ADDR
		EEPROM_DATA
		ENDC

		CBLOCK	0xA0
		TxBuffer:TX_BUF_LEN
		ENDC

		CBLOCK	0x120
		RxBuffer:RX_BUF_LEN
		ENDC

		CBLOCK	0x1A0
		RPT2CallSign:8
		RPT1CallSign:8
		CallerCallSign:8
;
		CurrentRPT2CallSign:8
		CurrentRPT1CallSign:8
		CurrentCallerCallSign:8
;
		MemRPT2CallSign:8
		MemRPT1CallSign:8
		MemCallerCallSign:8
		MemDSQL
		MemDCD
;
		ENDC


;-----------------------------------------------------------------------------
;Macros to select the register bank
; Many bank changes can be optimized when only one STATUS bit changes

Bank0		MACRO			;macro to select data RAM bank 0
		bcf		STATUS,RP0
		bcf		STATUS,RP1
		ENDM

Bank1		MACRO			;macro to select data RAM bank 1
		bsf		STATUS,RP0
		bcf		STATUS,RP1
		ENDM

Bank2		MACRO			;macro to select data RAM bank 2
		bcf		STATUS,RP0
		bsf		STATUS,RP1
		ENDM

Bank3		MACRO			;macro to select data RAM bank 3
		bsf		STATUS,RP0
		bsf		STATUS,RP1
		ENDM

Bank01		MACRO			;macro to select data RAM bank 1
		bsf		STATUS,RP0
		ENDM

Bank10		MACRO			;macro to select data RAM bank 1
		bcf		STATUS,RP0
		ENDM

Bank02		MACRO
		bsf		STATUS,RP1
		ENDM

Bank20		MACRO
		bcf		STATUS,RP1
		ENDM


Bank23		MACRO			;macro to select data RAM bank 3
		bsf		STATUS,RP0
		ENDM

Bank32		MACRO			;macro to select data RAM bank 3
		bcf		STATUS,RP0
		ENDM


;---------------------------------------------

Page0		MACRO
		bcf		PCLATH,4
		bcf		PCLATH,3
		ENDM

Page1		MACRO
		bcf		PCLATH,4
		bsf		PCLATH,3
		ENDM

Page2		MACRO
		bsf		PCLATH,4
		bcf		PCLATH,3
		ENDM

Page3		MACRO
		bsf		PCLATH,4
		bsf		PCLATH,3
		ENDM

Page01		MACRO
		bsf		PCLATH,3
		ENDM

Page10		MACRO
		bcf		PCLATH,3
		ENDM

Page02		MACRO
		bsf		PCLATH,4
		ENDM

Page20		MACRO
		bcf		PCLATH,4
		ENDM

Page23		MACRO
		bsf		PCLATH,3
		ENDM

Page32		MACRO
		bcf		PCLATH,3
		ENDM

Page13		MACRO
		bsf		PCLATH,4
		ENDM

Page31		MACRO
		bcf		PCLATH,4
		ENDM

;----------------------------------------------------------------------------
;This code executes when a reset occurs.

		ORG     0x0000		; reset vector

ResetCode
 		clrf    PCLATH		;select program memory page 0
  		goto    Main		;go to beginning of program

;----------------------------------------------------------------------------
;This code executes when an interrupt occurs.

		ORG	0x0004

InterruptCode:
   		movwf	WREG_TEMP	;save WREGDupOn
		movf	STATUS,W	;store STATUS in WREG
		clrf	STATUS		;select file register bank0
		movwf	STATUS_TEMP	;save STATUS value
		movf	PCLATH,W	;store PCLATH in WREG
		movwf	PCLATH_TEMP	;save PCLATH value
		clrf	PCLATH		;select program memory page0
		movf	FSR,W		;store FSR in WREG
		movwf	FSR_TEMP	;save FSR value

;
;-----------------------------------------------------------------
;  receive from second rs232c
		bcf			STATUS,RP0		; Bank0
		btfsc		PIR1,TMR1IF
		goto		STARTBIT

;
;-----------------------------------------------------------------
; output to second rs232c
		bcf			STATUS,RP0		; Bank0
		btfsc		PIR1,TMR2IF
		bsf			STATUS,RP0		; Bank1
		btfsc		PIE1,TMR2IE
		goto		PutChar
;-----------------------------------------
		bcf			STATUS,RP0		; Bank0
		btfsc		INTCON,TMR0IF	;test TMR0 interrupt
		goto		TMR0Set

		bcf			STATUS,RP0	; Bank0
		btfsc		PIR1,RCIF	;test RCIF receive interrupt
		bsf			STATUS,RP0	;change to bank1 if RCIF set
		btfsc		PIE1,RCIE	;test if interrupt enabled if RCIF set
		goto		GetData		;if RCIF and RCIE set, do receive

		bcf			STATUS,RP0	; Bank0
		btfsc		PIR1,TXIF	;test for TXIF transmit interrupt
		bsf			STATUS,RP0	;change to bank1 if TXIF set
		btfsc		PIE1,TXIE	;test if interrupt enabled if TXIF set
		goto		PutData		;if TXIF and TCIE set, do transmit

		goto		EndInt

;------------------------------------
;Get received data and write into receive buffer.

GetData:
;		Bank0
		bcf			STATUS,RP0
		btfsc		RCSTA,OERR	;test overrun error flag
		goto		ErrOERR		;handle it if error
		btfsc		RCSTA,FERR	;test framing error flag
		goto		ErrFERR		;handle it if error

		btfsc		Flags,RxBufFull	;check if buffer full
		goto		ErrRxOver	;handle it if full

		movf		RCREG,W		;get received data
		btfss		Flags,MaintMode
		call		PutRxBuffer	;and put in buffer
		goto		EndInt

ErrOERR:	
		bcf		RCSTA,CREN	;reset the receiver logic
		bsf		RCSTA,CREN	;enable reception again
		goto	EndInt

ErrFERR:
		movf	RCREG,W		;discard received data that has error
		goto	EndInt

ErrRxOver:
		movf	RCREG,W		;discard received data
		goto	EndInt

;------------------------------------
;Read data from the transmit buffer and transmit the data.

PutData:
;		Bank0			;select bank 0
		bcf		STATUS,RP0
		btfss	Flags,TxBufEmpty ;check if transmit buffer empty
		goto	PutDat1		;if not then go get data and transmit
		bsf		STATUS,RP0	; Bank1
		bcf		PIE1,TXIE	;disable TX interrupt because all done
		goto	EndInt

PutDat1:
		call	GetTxBuffer	;get data to transmit
		movwf	TXREG		;and transmit
		goto	EndInt

;
;---------------------------------------------------------------------------
; PutChar
PutChar:
;		Bank0
		bcf			STATUS,RP0
		bcf			PIR1,TMR2IF
		MOVF		BITCNT_TX,F	;end test
		BTFSC		STATUS,Z	
		GOTO		STOPBIT		;send stop bit
NEXTTXBIT
		DECF		BITCNT_TX,F	;BITCNT-1
		BSF			STATUS,C	;C on
		RRF			TX_TEMP,1	;shift send data
		BTFSS		STATUS,C	;bit test
		BCF			PORTC,1		;0 out
		BTFSC		STATUS,C
		BSF			PORTC,1		;1 out
		GOTO		EndInt		;return			
;****  Send Stop bit  ****
STOPBIT
		MOVF		EXTRA,W
		BTFSC		STATUS,Z	;end test
		GOTO		DONE		;goto end
		DECF		EXTRA,F		;end of stop
		BSF			PORTC,1		;send 1 for stop bit
		GOTO		EndInt		;return
;***  all end of send ****
DONE
		bsf			STATUS,RP0		; Bank1
		bcf			PIE1,TMR2IE
		bcf			STATUS,RP0		; Bank0
		bcf			T2CON,TMR2ON
		bcf			TXBUSY		;reset busy bit
		GOTO		EndInt		;return

;---------------------------------------------------------------------
;****  Start bit process for second rs232c  ****
STARTBIT
		bcf			STATUS,RP0		; Bank0
		bcf			PIR1,TMR1IF
		btfsc		RXNEXT_BIT
		goto		RXNEXT
		btfss		STOP_BIT
		goto		STARTBIT_2
		btfsc		START_BIT
		goto		STARTBIT_0
		btfsc		PORTC,0
		goto		STARTBIT_1
		bsf			START_BIT
		movlw		0xff
		movwf		TMR1H
		movlw		0x90
		movwf		TMR1L
		goto		EndInt
STARTBIT_0
		bsf			RXNEXT_BIT
		movlw		0xfe			; fe
		movwf		TMR1H
		movlw		0x20
		movwf		TMR1L
		clrf		RX_TEMP
		movlw		0x09
		movwf		BITCNT_RX
		goto		EndInt
STARTBIT_1
		movlw		0xff
		movwf		TMR1H
		movlw		0xc0
		movwf		TMR1L
		goto		EndInt		;return
STARTBIT_2
		movlw		0xff
		movwf		TMR1H
		movlw		0xc0
		movwf		TMR1L
		btfss		PORTC,0
		goto		EndInt
		bsf			STOP_BIT
		goto		EndInt

RXNEXT
		movlw		0xfe		; fe
		movwf		TMR1H
		movlw		0x20
		movwf		TMR1L

		decfsz		BITCNT_RX,F	;counter-1
		GOTO		NEXTRXBIT
;*** stop bit process  ***
		BTFSS		PORTC,0		;stop bit check
		BSF			ERROR		;not stop
		bsf			STATUS,RP0	; Bank1
		bcf			PIE1,TMR1IE	;inhibit interrupt
		bcf			STATUS,RP0	; Bank0
		bcf			PIR1,TMR1IF
		BCF			RXBUSY		;reset busy flag
		movf		RX_TEMP,0
		btfsc		Flags,MaintMode
		goto		RXNEXT_00
		call		PutTxBuffer
		goto		RXNEXT_02
RXNEXT_00
		call		PutRxBuffer
RXNEXT_02
		bcf			PIR1,TMR1IF
		bcf			START_BIT
		bcf			RXNEXT_BIT
		bcf			STOP_BIT
		movlw		0xff
		movwf		TMR1H
		movlw		0xc0
		movfw		TMR1L
		bsf			STATUS,RP0	; Bank1
		bsf			PIE1,TMR1IE
		GOTO		EndInt

;**** next bit process  ***
NEXTRXBIT
		BCF			STATUS,C	;prepare bit for shift
		BTFSC		PORTC,0		;data=0 or 1?
		BSF			STATUS,C	;1 case
		RRF			RX_TEMP,F		;set data to RXREG
		bcf			PIR1,TMR1IF
		GOTO		EndInt


;-----------------------------------
; TMR0
TMR0Set
		bcf		INTCON,TMR0IF		; interrupt flag clear
		movlw	0x3f			; load timer 
		movwf	TMR0			; set to TMR0 
;								beep
		btfss	Flags2,Beep_Sw
		goto	BEEP_02
		decfsz	BeepCNT,f
		goto	BEEP_00
		bcf		Flags2,Beep_Sw
		btfss	Flags3,P_Beep_Sw
		goto	BEEP_06
		decfsz	PocketBeepCNT,f
		goto	BEEP_03
		bcf		Flags2,Beep_Sw
		bcf		Flags3,P_Beep_Sw
		goto	BEEP_02
BEEP_03
		bsf		Flags2,Beep_Sw
		movlw	0xa0
		movwf	BeepCNT
BEEP_00
		btfss	PocketBeepCNT,1
		goto	BEEP_06
		btfss	Flags3,Beep2
		goto	BEEP_05
		bcf		Flags3,Beep2
		goto	BEEP_02
BEEP_05
		bsf		Flags3,Beep2
BEEP_06
		btfss	Flags2,BEEP_Bit
		goto	BEEP_01
		bcf		Flags2,BEEP_Bit
		bcf		PORTA,Beep
		goto	BEEP_02
BEEP_01
		bsf		Flags2,BEEP_Bit
		bsf		PORTA,Beep
BEEP_02
		decfsz	msec_cnt,f		; 10msec counter-1
		goto	EndInt
		movlw	0x50			; 0.3125mSec * 80(0x50) = 25mSec
		movwf	msec_cnt
;		
		movfw	msg_timeout
		btfss	STATUS,Z
		decf	msg_timeout,f
		decfsz	sec_cnt,f
		goto	EndInt
		movlw	0x28			; 25mSec 40(0x28) = 1Sec
		movwf	sec_cnt
		incf	sec_sw,f

;------------------------------------
;End of interrupt routine restores context

EndInt:
;		Bank0			;select bank 0
		bcf		STATUS,RP0
		movf	FSR_TEMP,W	;get saved FSR value
		movwf	FSR		;restore FSR
		movf	PCLATH_TEMP,W	;get saved PCLATH value
		movwf	PCLATH		;restore PCLATH
		movf	STATUS_TEMP,W	;get saved STATUS value
		movwf	STATUS		;restore STATUS
		swapf	WREG_TEMP,F	;prepare WREG to be restored
		swapf	WREG_TEMP,W	;restore WREG without affecting STATUS
		retfie			;return from interrupt

;
;--------------------------
SendPostAmble
;				0xfd
		movlw	0xfd
		call	PutTxBuffer
		return

SendPreAmble
;				0xfe,0xfe,0x01,0x7f,0x1d
		movlw	0xfe		
		call	PutTxBuffer
		movlw	0xfe
		call	PutTxBuffer
		movlw	0x01
		call	PutTxBuffer
		movlw	0x7f
		call	PutTxBuffer
		movlw	0x1d
		call	PutTxBuffer
		return
;----------------------------------------------------------------------------
; putchar

putchar
;		Bank0
		bcf			STATUS,RP0
		movwf		TX_TEMP
		BSF			TXBUSY		;set busy bit
		MOVLW		8		;bit count
		MOVWF		BITCNT_TX		;reset bit counter
		MOVLW		1
		MOVWF		EXTRA		;set stopbit flag
		movlw		0x05		; timer:on  pre scal:4
		movwf		T2CON
;		Bank1
		bsf			STATUS,RP0
		bsf			PIE1,TMR2IE
;		Bank0
		bcf			STATUS,RP0
		bcf			PORTC,1		; start bit send
		return

;----------------------------------------------------------------------------
; Main
Main
;
		Bank0
		clrf		PORTA
		clrf		PORTB
		clrf		PORTC
		clrf		PORTD
		clrf		PORTE
		bsf			STATUS,RP0				; Bank1
		movlw		0x06
		movwf		ADCON1
;								PORTA
		movlw		1 << From_UT118_PTT | 1 << From_Mic_PTT
		movwf		TRISA
;								PORTB
		movlw		0x08
		movwf		TRISB		; bit3: input   others: output
;                               PORTC
		movlw		0xf9		;set tris bits for TX and RX
		movwf		TRISC
;								PORTD
		movlw		0xff
		movwf		TRISD		; ALL input for PORTD
;								PORTE
		movlw		0x07
		movwf		TRISE
		bcf			STATUS,RP0	; Bank0
		clrf		PTT_mode
		movlw		1 << To_UT118_PTT | 1 << To_Rig_PTT	; RX: 1 TX:0 
		movwf		PORTA
		movlw		0xff
		movwf		portd_s
		movwf		porte_s

;		
;   Initialize for I2C
		Page3
		call		I2CInit
;		Options read from EEPROM to RAM
		call		ReadOptions
		call		ReadOptions2
;		YourCall move from EEPROM to RAM (move to Current)
		call		EEpromYourCall
;		read		DSQL
		call		ReadDSQL
;
		call		ReadNoRetry

;		set up serial port and buffers
		call		SetupSerial
;
		Page0

;		initialize each variables
		clrf		sw
		clrf		MenuPointer
		clrf		msg_no
		clrf		msg_timeout
		clrf		PocketBeepCNT

		movlw		0x20		; " "
		movwf		AlphaPNT
		movwf		AlphaPNT2
		clrf		Flags
		clrf		Flags2
		clrf		Flags3
		movlw		0x80
		movwf		GpsLcdPnt

;	interrupt timere set for 10mSec.
;
		bsf			STATUS,RP0
		movlw		0x82			; 87
		movwf		OPTION_REG
		bcf			STATUS,RP0
		movlw		0x3f			; counter set 0x3f  (19.6608MHz)
		movwf		TMR0
		bsf			INTCON,TMR0IE
		movlw		0x50			; 0x0a
		movwf		msec_cnt
		clrf		sec_sw
		movlw		0x28			; 0x0a
		movwf		sec_cnt

;-------------  Initialize TIMER2 & second rs232c
;
		bsf			STATUS,RP0		; bank1
		movlw		0x80
		movwf		PR2
		bcf			STATUS,RP0	; bank0
		bsf			PORTC,1		;set for stop bit
		bcf			TXBUSY		;reset busy bit

		movlw		0x00
		call		putchar
		btfsc		TXBUSY
		goto		$-1
		movlw		0x0a
		call		putchar

		movlw		0xff
		movwf		TMR1H
		movlw		0xc0			; 0xc0
		movwf		TMR1L
		bcf			PIR1,TMR1IF
		bsf			STATUS,RP0			; Bank1
		bsf			PIE1,TMR1IE
		bcf			STATUS,RP0			; Bank0
		bcf			START_BIT
		bcf			RXNEXT_BIT
		bsf			STOP_BIT
		btfss		PORTC,0	
		bcf			STOP_BIT
		movlw		0x01
		movwf		T1CON		

;
;----------- INIT LCD
		Page3
		call		LCD_INI
		Page0
		btfss		PORTD,menu
		goto		Maint_00
		Page3		
		call		LCD_FirstDisplay
		Page0
		
;
;----------------------------------------------------------------------------
; default setting part1
		clrf	resp
		clrf	command
		call	my_callsign_set
		incf	resp,f
		
Part1_00
		movf	resp,w
		btfss	STATUS,Z
		goto	Part1_99
		incf	command,f

Part1_000
		clrf	resp
		pageselw	Part1Table
		movlw	low Part1Table
		addwf	command,w
		btfsc	STATUS,C
		incf	PCLATH,f
		movwf	PCL
Part1Table
		goto	Part1_01
		goto	Part1_02
		goto	Part1_03
		goto	Part1_04
		goto	Part1_05
		goto	Part1_06
		goto	Part1_07
		goto	Part1_08
		goto	Part1_09

Part1_01					; my callsign
		call	my_callsign_set
		incf	resp,f
		goto	Part1_99
Part1_02					; my callsign2
		call	my_callsign2_set
		incf	resp,f
		goto	Part1_99
Part1_03					; Txcallsing
		call	TxCallsign_set
		incf	resp,f
		goto	Part1_99
Part1_04					; TxMessage
		call	GpsMessageSet
		incf	resp,f
		goto	Part1_99
Part1_05					; Slow data baud rate
		call	SlowDataInitSet
		incf	resp,f
		goto	Part1_99
Part1_06					; Gps 
		call	GPSset
		incf	resp,f
		goto	Part1_99
Part1_07					; DCD 
		call	DCDset
		incf	resp,f
		goto	Part1_99
Part1_08					; DSQL 
		call	DSQLset
		incf	resp,f
		goto	Part1_99
Part1_09					;
		movfw	resp
		btfsc	STATUS,Z
		goto	Part2

Part1_99
		movfw	resp
		xorlw	0xff
		btfsc	STATUS,Z
		goto	Part1_000
		Page01	
		call	CheckReceivedData
		Page10                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        		Page0
		goto	Part1_00


;------------------------------------
;  default setting part2
Part2
		clrf	resp
		call	DuplexOn
		incf	resp,f
		clrf	sw
Part2_00
		movfw	resp
		btfsc	STATUS,Z
		goto	MainLoop
		xorlw	0xff		; NG ?
		btfss	STATUS,Z
		goto	Part2_99
Part2_01
		clrf	resp		
		call	DuplexOn
		incf	resp,f
Part2_99
		Page01
		call	CheckReceivedData
		Page10
		goto	Part2_00

Maint_00
		Page01
		goto	Maint_01

;----------------------------------------
;  Main loop
;----------------------------------------
MainLoop
;	Tact Switch Check
;------------------------------------
TactSwitchCheck
		Page3
		call	TactSW
		call	PorteSW
		Page0

		btfsc	portd_s,back
		goto	dsql_skip
		Page01
		call	dsql_set
		Page10
dsql_skip
		movlw	b'10010011'
		Page3	
		call	LCD_CMD_4
		Page0
		movfw	dsql_sw
		btfss	STATUS,Z
		goto	dsql_00
		movlw	" "
		goto	dsql_99
dsql_00
		movwf	temp
		decfsz	temp,f
		goto	dsql_01
		movlw	"d"
		goto	dsql_99
dsql_01
		decfsz	temp,f
		goto	dsql_02
		movlw	"D"
		goto	dsql_99
dsql_02			
		decfsz	temp,f
		goto	dsql_03
		movlw	"c"
		goto	dsql_99
dsql_03			
		movlw	"C"
dsql_99
		Page3
		call	LCD_DATA_4
		Page0


;-----------------
		btfss	Flags3,Display_Sw
		goto	Menu_Skip_Check	
		movfw	command
		btfss	STATUS,Z
		goto	MainLoop0
		movfw	resp
		btfss	STATUS,Z
		goto	MainLoop0
		bcf		Flags3,Display_Sw
		goto	Menu_Go
Menu_Skip_Check
		btfsc	portd_s,menu		; menu mode
		goto	Menu_Skip
Menu_Go
		Page2
		call	MenuDisp
		Page0
		btfsc	Flags3,Display_Sw
		goto	MainLoop0
Menu_Skip

;--------------
;		TX callsign Quick Set
		btfss	portd_s,enter
		call	QuickSet
;--------------
#if	Release == 0
;debug
		btfss	AdDefault2,Debug
		goto	debug_skip
		btfss	portd_s,down
		call	TxCallRead
		btfss	portd_s,up
		call	TxMsgRead
debug_skip
#endif
;------
; One Tuch Memory
		btfsc	porte_s,M1
		goto	M_02
		call	M1Read
		addlw	0
		btfsc	STATUS,Z
		goto	M_00
		Page02
		call	MenuDisp_M
		Page20
M_02
		btfsc	porte_s,M2
		goto	M_03
		call	M2Read
		addlw	0
		btfsc	STATUS,Z
		goto	M_00
		Page02
		call	MenuDisp_M
		Page20
M_03
		btfsc	porte_s,M3
		goto	M_00
		call	M3Read
		addlw	0
		btfsc	STATUS,Z
		goto	M_00
		Page02
		call	MenuDisp_M
		Page20
M_00

;--------------
#if		Release == 0				; Running indicator
		Page3
		movlw	B'10100111'
		call	LCD_CMD_4
		movlw	" "
		btfss	sec_sw,0
		movlw	"*"
		call	LCD_DATA_4
		Page0
#endif
;-------------------------------------
		movfw	msg_no
		btfsc	STATUS,Z
		goto	msg_no_skip
		movfw	msg_timeout
		btfsc	STATUS,Z
		clrf	msg_no
msg_no_skip
;-------------------------------------
		btfss	AdDefault,MSGSend_OnOff
		goto	MainLoop0
; ------------------------------------			timer check
		btfsc		Flags3,Display_Sw
		goto		MainLoop0
		Page3
		call		ReadMsgSndInterval
		Page0
		xorwf		sec_sw,w
		btfss		STATUS,Z
		goto		MainLoop0
		clrf		sec_sw
		movlw		0x40
		movwf		resp
		movlw		0x01
		movwf		command

MainLoop0
		Bank0
		btfsc	Flags,RxBufEmpty
		goto	MainLoop0_00
		Page01
		call	CheckReceivedData
		Page10
MainLoop0_00
		pageselw	CommandTable
		movlw		low CommandTable
		addwf		command,w
		btfsc		STATUS,C
		incf		PCLATH,f
		movwf		PCL
CommandTable
		goto		MainLoop00
		goto		Next00			; Message 1/4
		goto		Next01			; Message 2/4
		goto		Next02			; Message 3/4
		goto		Next03			; Message 4/4
		goto		GPSSnd			; command: 05  GPS
		goto		MyCallSnd		; command: 06  MyCall
		goto		TxCallSnd		; command: 07  TxCall
		goto		MyCall2Snd		; command: 08  MyCall2
		goto		GpsMsgSnd		; command: 09  GpsMsgSnd
		goto		DupOnOffSnd			; command: 0a  DupSnd
		goto		TxcurrentCallSnd	; command: 0b  Tx send + DupOn
		goto		MemTxSnd		; command: 0c  Txsnd + DupOnOff
		goto		SlowSpdSnd		; command: 0d  slow data baud rate set
		goto		DCDSnd			; command: 0e	DCD set
		goto		DupOnSnd		; command: 0f	Duplex On
		goto		DupOffSnd		; command: 10   Duplex Off
		goto		DSQLSnd			; command: 11   DSQL set

Next00
		call		MSG_Send_40
		movfw		resp
		btfss		STATUS,Z
		goto		MainLoop00
		incf		command,f
		movlw		0x40
		movwf		resp
		goto		MainLoop00

Next01
		call		MSG_Send_41
		movfw		resp
		btfss		STATUS,Z
		goto		MainLoop00
		incf		command,f
		movlw		0x40
		movwf		resp
		goto		MainLoop00	

Next02
		call		MSG_Send_42
		movfw		resp
		btfss		STATUS,Z
		goto		MainLoop00
		incf		command,f
		movlw		0x40
		movwf		resp
		goto		MainLoop00

Next03
		call		MSG_Send_43
		movfw		resp
		btfsc		STATUS,Z
		clrf		command
		goto		MainLoop00


GPSSnd
		movfw		resp
		xorlw		0x40
		btfss		STATUS,Z
		goto		GPSSnd_00
		call		GPSset
		clrf		resp
		incf		resp,f
GPSSnd_00
		movfw		resp
		btfsc		STATUS,Z
		goto		GPSSnd_01
		xorlw		0xff		; NG ?
		btfss		STATUS,Z
		goto		MainLoop00
		clrf		resp		
		call		GPSset
		incf		resp,f
		goto		MainLoop00
GPSSnd_01
		clrf		command
		goto		MainLoop00


MyCallSnd
		movfw		resp
		xorlw		0x40
		btfss		STATUS,Z
		goto		MyCallSnd_00
		call		my_callsign_set
		clrf		resp
		incf		resp,f
MyCallSnd_00	
		movfw		resp
		btfsc		STATUS,Z
		goto		MyCallSnd_01
		xorlw		0xff		; NG ?
		btfss		STATUS,Z
		goto		MainLoop00
		clrf		resp		
		call		my_callsign_set
		incf		resp,f
		goto		MainLoop00
MyCallSnd_01
		movlw		0x40
		movwf		resp
		movlw		0x09
		movwf		command
		goto		MainLoop00



MyCall2Snd
		movfw		resp
		xorlw		0x40
		btfss		STATUS,Z
		goto		MyCall2Snd_00
		call		my_callsign2_set
		clrf		resp
		incf		resp,f
MyCall2Snd_00
		movfw		resp
		btfsc		STATUS,Z
		goto		MyCall2Snd_01
		xorlw		0xff		; NG ?
		btfss		STATUS,Z
		goto		MainLoop00
		clrf		resp		
		call		my_callsign2_set
		incf		resp,f
		goto		MainLoop00
MyCall2Snd_01
		clrf		command
		goto		MainLoop00



TxCallSnd
		movfw		resp
		xorlw		0x40
		btfss		STATUS,Z
		goto		TxCallSnd_00
		call		TxCallsign_set
		clrf		resp
		incf		resp,f
TxCallSnd_00
		movfw		resp
		btfsc		STATUS,Z
		goto		TxCallSnd_01
		xorlw		0xff		; NG ?
		btfss		STATUS,Z
		goto		MainLoop00
		clrf		resp		
		call		TxCallsign_set
		incf		resp,f
		goto		MainLoop00
TxCallSnd_01
		btfsc		AdDefault,Duplex_OnOff
		goto		TxCallSnd_02
		clrf		command
		goto		MainLoop00
TxCallSnd_02
		movlw		0x0a
		movwf		command
		movlw		0x40
		movwf		resp
		goto		MainLoop00


GpsMsgSnd
		movfw		resp
		xorlw		0x40
		btfss		STATUS,Z
		goto		GpsMsgSnd_00
		call		GpsMessageSet
		clrf		resp
		incf		resp,f
GpsMsgSnd_00
		movfw		resp
		btfsc		STATUS,Z
		goto		GpsMsgSnd_01
		xorlw		0xff		; NG ?
		btfss		STATUS,Z
		goto		MainLoop00
		clrf		resp		
		call		GpsMessageSet
		incf		resp,f
		goto		MainLoop00
GpsMsgSnd_01
		clrf		command
		goto		MainLoop00


DupOnOffSnd	
		movfw	resp
		xorlw	0x40
		btfss	STATUS,Z
		goto	DupOnOffSnd_00
		call	DuplexOn
		clrf	resp
		incf	resp,f
DupOnOffSnd_00
		movfw	resp
		btfsc	STATUS,Z
		goto	DupOnOffSnd_01
		xorlw	0xff		; NG ?
		btfss	STATUS,Z
		goto	MainLoop00
		clrf	resp		
		call	DuplexOn
		incf	resp,f
		goto	MainLoop00
DupOnOffSnd_01
		clrf		command
		btfss		Flags3,DsqlSet_Sw
		goto		MainLoop00
		movlw		0x40
		movwf		resp
		movlw		0x0e
		movwf		command
		goto		MainLoop00


DupOnSnd	
		movfw	resp
		xorlw	0x40
		btfss	STATUS,Z
		goto	DupOnSnd_00
		call	DupOn
		clrf	resp
		incf	resp,f
DupOnSnd_00
		movfw	resp
		btfsc	STATUS,Z
		goto	DupOnOffSnd_01
		xorlw	0xff		; NG ?
		btfss	STATUS,Z
		goto	MainLoop00
		clrf	resp		
		call	DupOn
		incf	resp,f
		goto	MainLoop00



DupOffSnd	
		movfw	resp
		xorlw	0x40
		btfss	STATUS,Z
		goto	DupOffSnd_00
		call	DupOff
		clrf	resp
		incf	resp,f
DupOffSnd_00
		movfw	resp
		btfsc	STATUS,Z
		goto	DupOnOffSnd_01
		xorlw	0xff		; NG ?
		btfss	STATUS,Z
		goto	MainLoop00
		clrf	resp		
		call	DupOff
		incf	resp,f
		goto	MainLoop00


TxcurrentCallSnd
		movfw	resp
		xorlw	0x40
		btfss	STATUS,Z
		goto	TxcurrentCallSnd_00
		call	CurrentTxCallsign_set
		clrf	resp
		incf	resp,f
TxcurrentCallSnd_00
		movfw	resp
		btfsc	STATUS,Z
		goto	TxcurrentCallSnd_01
		xorlw	0xff		; NG ?
		btfss	STATUS,Z
		goto	MainLoop00
		clrf	resp		
		call	CurrentTxCallsign_set
		incf	resp,f
		goto	MainLoop00

TxcurrentCallSnd_01
;		check all space in RPT2 and PRT1
		movlw	0x10
		movwf	COUNT1
		movlw	CurrentRPT2CallSign
		movwf	temp
TxcurrentCallSnd_10
		BANKISEL	CurrentRPT2CallSign		;(PRT2 and PRT1)
		movfw	temp
		movwf	FSR			;and place into FSR
		movfw	INDF		;read from PRT2 in Bank3
		xorlw	" "
		btfss	STATUS,Z
		goto	TxcurrentCallSnd_20
		incf	temp,F
		decfsz	COUNT1,F
		goto	TxcurrentCallSnd_10
		movlw	0x10			; dup off
		btfss	AdDefault,AutoDuplex
		movlw	0x0a
		movwf	command
		movlw	0x40
		movwf	resp
		goto	MainLoop00
TxcurrentCallSnd_20
		movlw	0x40
		movwf	resp
		movlw	0x0f			; dup on
		btfss	AdDefault,AutoDuplex
		movlw	0x0a
		movwf	command
		goto	MainLoop00

;MemTxSnd_20
;		movlw	0x40
;		movwf	resp
;		movlw	0x0f
;		btfss	AdDefault,AutoDuplex
;		movlw	0x0a			; dup on
;		movwf	command
;		goto	MainLoop00



MemTxSnd
		movfw	resp
		xorlw	0x40
		btfss	STATUS,Z
		goto	MemTxSnd_00
		call	MemTx_set
		clrf	resp
		incf	resp,f
MemTxSnd_00
		movfw	resp
		btfsc	STATUS,Z
		goto	MemTxSnd_01
		xorlw	0xff		; NG ?
		btfss	STATUS,Z
		goto	MainLoop00
		clrf	resp		
		call	MemTx_set
		incf	resp,f
		goto	MainLoop00
MemTxSnd_01
;		check all space in RPT2 and PRT1
		bcf		Flags,AllSpaces		; check for RPT1 and RPT2 
		movlw	0x10
		movwf	COUNT1
		movlw	MemRPT2CallSign
		movwf	temp
MemTxSnd_10
		BANKISEL	MemRPT2CallSign		;(PRT2 and PRT1)
		movfw	temp
		movwf	FSR			;and place into FSR
		movfw	INDF		;read from PRT2 in Bank3
		xorlw	" "
		btfss	STATUS,Z
		goto	TxcurrentCallSnd_20
		incf	temp,F
		decfsz	COUNT1,F
		goto	MemTxSnd_10
		btfsc	AdDefault,AutoDuplex
		goto	MemTxSnd_15
		movlw	0x10
		movwf	command
		movlw	0x40
		movwf	resp
		goto	MainLoop00
MemTxSnd_15
		clrf	command
		btfss	Flags3,DsqlSet_Sw
		goto	MainLoop00
		movlw	0x40
		movwf	resp
		movlw	0x0e
		movwf	command
		goto	MainLoop00

MemTx_set
		call		SendPreAmble
		movlw		0x05
		call		PutTxBuffer
		movlw		0x08	
		movwf		COUNT1
		movlw		MemRPT2CallSign
		movwf		temp
MemTx_10
		BANKISEL	MemRPT2CallSign
		movfw		temp
		movwf		FSR			;and place into FSR
		movfw		INDF		;read from PRT2 (RX RPT1)
		call		PutTxBuffer
		incf		temp,F
		decfsz		COUNT1,F
		goto		MemTx_10

		movlw		0x08
		movwf		COUNT1
		BANKISEL	MemRPT2CallSign
		movlw		MemRPT1CallSign
		movwf		temp
MemTx_20
		BANKISEL	MemRPT1CallSign		;(PRT2, PRT1 and Your)
		movfw		temp
		movwf		FSR		;and place into FSR
		movfw		INDF		;read from PRT1 (RX RPT2)
		call		PutTxBuffer
		incf		temp,F
		decfsz		COUNT1,F
		goto		MemTx_20

		movlw		0x08
		movwf		COUNT1
		movlw		MemCallerCallSign
		movwf		temp
MemTx_30
		BANKISEL	MemCallerCallSign		;(PRT2, PRT1 and Your)
		movfw		temp
		movwf		FSR		;and place into FSR
		movfw		INDF		;read caller callsign
		call		PutTxBuffer
		incf		temp,F
		decfsz		COUNT1,F
		goto		MemTx_30
		call		SendPostAmble
		return

;----------------------------------------------
SlowSpdSnd	
		movfw		resp
		xorlw		0x40
		btfss		STATUS,Z
		goto		SlowSpdSnd_00
		call		SlowDataInitSet
		clrf		resp
		incf		resp,f
SlowSpdSnd_00
		movfw		resp
		btfsc		STATUS,Z
		goto		SlowSpdSnd_01
		xorlw		0xff		; NG ?
		btfss		STATUS,Z
		goto		MainLoop00
		clrf		resp		
		call		SlowDataInitSet
		incf		resp,f
		goto		MainLoop00
SlowSpdSnd_01
		clrf		command
		goto		MainLoop00

;-------------------------------------
DCDSnd
		movfw		resp
		xorlw		0x40
		btfss		STATUS,Z
		goto		DCDSnd_00
		call		DCDset
		clrf		resp
		incf		resp,f
DCDSnd_00
		movfw		resp
		btfsc		STATUS,Z
		goto		DCDSnd_01
		xorlw		0xff		; NG ?
		btfss		STATUS,Z
		goto		MainLoop00
		clrf		resp		
		call		DCDset
		incf		resp,f
		goto		MainLoop00
DCDSnd_01
		clrf		command
		btfss		Flags3,DsqlSet_Sw
		goto		MainLoop00
		movlw		0x40
		movwf		resp
		movlw		0x11
		movwf		command
		goto		MainLoop00


;-------------------------------------
DSQLSnd
		Page01
		goto		DSQLSnd_1

;---------------------------------
#if		Release == 0
TxCallRead			; debug
		Page3
		call		ClearLCD
		Page0
		call		SendPreAmble
		movlw		0x03				; read my call
		call		PutTxBuffer
		call		SendPostAmble
		call		SendPreAmble
		movlw		0x05				; read tx call
		call		PutTxBuffer
		call		SendPostAmble
;		call		SendPreAmble
;		movlw		0xdb				; read tx call2
;		call		PutTxBuffer
;		call		SendPostAmble
		bsf			Flags,DebugDisp
		call		SendPreAmble
		movlw		0xcf				; read duplex
		call		PutTxBuffer
		call		SendPostAmble
		call		SendPreAmble
		movlw		0xdc				; read my call2
		call		PutTxBuffer
		call		SendPostAmble
		return

;----------------------------------------------
TxMsgRead
		Page3
		call		ClearLCD
		Page0
		call		SendPreAmble
		movlw		0xd2				; read tx message
		call		PutTxBuffer
		call		SendPostAmble
		call		SendPreAmble
		movlw		0xc9				; read baud rate of slow data
		call		PutTxBuffer
		call		SendPostAmble
		call		SendPreAmble
		movlw		0xd1				; read GPS Filter
		call		PutTxBuffer
		call		SendPostAmble
		bsf			Flags,DebugDisp
		call		SendPreAmble
		movlw		0x01				; read DSQL 
		call		PutTxBuffer
		call		SendPostAmble
		call		SendPreAmble
		movlw		0x17				; read DCD
		call		PutTxBuffer
		call		SendPostAmble
		return
#endif
;----------------------------------------
MainLoop00
;		Bank0
;		btfsc	Flags,RxBufEmpty
;		goto	MainLoop00_00
;		Page01
;		call	CheckReceivedData
;		Page10
;MainLoop00_00
		btfsc	AdDefault,PTTLock
		goto	DispPTTLock
		pageselw PTT_MODE_TABLE
		movlw 	low PTT_MODE_TABLE
		addwf 	PTT_mode,w
		btfsc 	STATUS,C
		incf 	PCLATH,f
		movwf	PCL

PTT_MODE_TABLE
		goto	ptt_mode_00
		goto	Mic_ptt_on_check
		goto	ptt_on
		goto	clear_PTT_1

ptt_mode_00
;	check From Mic PTT
		btfsc	PORTA,From_Mic_PTT	; 0= on 1=off
		goto	MainLoop				; off
		bcf		Flags3,P_Beep_Sw
		btfss	Flags2,MenuCancel
		goto	ptt_mode_01
		bcf		Flags2,MenuCancel
		Page3
		call	TIME60M
		call	TIME60M
		Page0
		btfsc	PORTA,From_Mic_PTT	; 0= on 1=off
		goto	MainLoop				; off
ptt_mode_01
		movlw	0x01					; on
		movwf	PTT_mode
		movlw	1 << To_LED | 1 << To_UT118_PTT ; Rig_PTT: on   LED: on
		movwf	PORTA				;@LED and RIG_PTT on
		call	delay_ptt
		goto	MainLoop

Mic_ptt_on_check
		btfsc	PORTA,From_Mic_PTT	; 1=off  0=on 
		goto	clear_PTT			; off
		goto	still_Mic_ptt_on	; on
still_Mic_ptt_on
		movlw	1 << To_LED			; LED:on UT118_PTT:on RIG_PTT:on
		movwf	PORTA
		btfss	AdDefault,MSGSend_OnOff
		goto	ptt_on
		Page3
		call	ReadMsgSndInterval
		Page0
		movwf		sec_sw
ptt_on
		btfsc	PORTA,From_Mic_PTT
		goto	clear_PTT
		movlw	0x02
		movwf	PTT_mode
		goto	MainLoop
;
clear_PTT
		movfw	msg_no
		btfss	STATUS,Z
		goto	MainLoop
		movlw	1 << To_LED | 1 << To_UT118_PTT
		movwf	PORTA
clear_PTT_1
		btfsc	PORTA,From_UT118_PTT	;  0 = on  1 = off
		goto	reset_PTT				; off
		movlw	0x03					; on
		movwf	PTT_mode
		goto	MainLoop
reset_PTT
		movlw	1 << To_UT118_PTT | 1 << To_Rig_PTT
		movwf	PORTA
		clrf	PTT_mode
		goto	MainLoop	;repeat main loop to check for data

;--------------------------
DispPTTLock
		btfsc	PORTA,From_Mic_PTT	; 0= on 1=off
		goto	MainLoop
		Page3
		movlw	b'11001010'		; Line1 
		call	LCD_CMD_4
		Page0
		movlw	.10
		movwf	COUNT
		movlw	.1
		movwf	POINT
DispPTTLock_00
		pageselw	PTTLockMsg
		movlw	low	PTTLockMsg
		movwf	TempData
		movfw	POINT
		addwf	TempData,f
		movlw	high PTTLockMsg
		btfsc	STATUS,C
		incf	PCLATH,F
		movfw	TempData
		call	PTTLockMsg
		incf	POINT,F
		Page3
		CALL	LCD_DATA_4
		Page0
		decfsz	COUNT,f
		goto	DispPTTLock_00
		btfss	PORTA,From_Mic_PTT	; 0= on 1=off
		goto	$-1
		Page3
		movlw	b'11001010'
		call	LCD_CMD_4
		call	DispSpace5
		call	DispSpace5
		Page0
		goto	MainLoop
PTTLockMsg
		movwf	PCL
		DT		"*PTT Lock*"

;--------------------------

delay_ptt
		movlw		low TxDelay
		Page3
		call		EEPROM_Read
		Page0
		movwf		temp
delay_ptt_00		
		Page3
		call		TIME10M
		Page0
		decfsz		temp,f
		goto		delay_ptt_00
		return

;------------------------------
;  Message Send
MSG_Send_40
		movfw	msg_no
		xorlw	0x03
		btfsc	STATUS,Z
		return
		movfw	resp
		xorlw	0x40
		btfss	STATUS,Z
		goto	MSG_Send_40_00
		call	MSGSend_40
		incf	msg_no,f
		goto	MSG_Send_99
MSG_Send_40_00
		movfw	resp
		btfsc	STATUS,Z
		return
		xorlw	0xff		; NG ?
		btfss	STATUS,Z
		return
MSG_Send_40__01
		call	MSGSend_40
MSG_Send_99
		clrf	resp		
		incf	resp,f
		movlw	MsgTimeOut
		movwf	msg_timeout
		return


MSG_Send_41
		movfw	msg_no
		xorlw	0x03
		btfsc	STATUS,Z
		return
		movfw	resp
		xorlw	0x40
		btfss	STATUS,Z
		goto	MSG_Send_41_00
		call	MSGSend_41
		incf	msg_no,f
		goto	MSG_Send_99
MSG_Send_41_00
		movfw	resp
		btfsc	STATUS,Z
		return
		xorlw	0xff		; NG ?
		btfss	STATUS,Z
		return
MSG_Send_41__01
		call	MSGSend_41
		goto	MSG_Send_99


MSG_Send_42
		movfw	msg_no
		xorlw	0x03
		btfsc	STATUS,Z
		return
		movfw	resp
		xorlw	0x40
		btfss	STATUS,Z
		goto	MSG_Send_42_00
		call	MSGSend_42
		incf	msg_no,f
		goto	MSG_Send_99
MSG_Send_42_00
		movfw	resp
		btfsc	STATUS,Z
		return
		xorlw	0xff		; NG ?
		btfss	STATUS,Z
		return
MSG_Send_42__01
		call	MSGSend_42
		goto	MSG_Send_99


MSG_Send_43
		movfw	msg_no
		xorlw	0x03
		btfsc	STATUS,Z
		return
		movfw	resp
		xorlw	0x40
		btfss	STATUS,Z
		goto	MSG_Send_43_00
		call	MSGSend_43
		incf	msg_no,f
		goto	MSG_Send_99
MSG_Send_43_00
		movfw	resp
		btfsc	STATUS,Z
		return
		xorlw	0xff		; NG ?
		btfss	STATUS,Z
		return
MSG_Send_43__01
		call	MSGSend_43
		goto	MSG_Send_99
		

;----------------------------------------------------------------------------
;Initialize transmit buffer

InitTxBuffer:
		Bank0
		movlw	LOW TxBuffer	;take address of transmit buffer
		movwf	TxStartPtr	;and place in transmit start pointer
		movwf	TxEndPtr	;and place in transmit end pointer
		bcf		Flags,TxBufFull	;indicate Tx buffer is not full
		bsf		Flags,TxBufEmpty ;indicate Tx buffer is empty
		return

;----------------------------------------------
;Initialize receive buffer

InitRxBuffer:
		Bank0
		movlw	RxBuffer	;take address of receive buffer
		movwf	RxStartPtr	;and place in receive start pointer
		movwf	RxEndPtr	;and place in receive end pointer
		bcf		Flags,RxBufFull	;indicate Rx buffer is not full
		bsf		Flags,RxBufEmpty ;indicate Rx buffer is empty
		return

;----------------------------------------------
;Add a byte (from WREG) to the end of the transmit buffer

PutTxBuffer:
		Bank1			;select bank 1
		bcf	PIE1,TXIE	;disable transmit interrupt
		Bank0			;select bank 0
		btfsc	Flags,TxBufFull	;check if buffer full
		goto	ErrTxBufFull	;and go handle error if full

		BANKISEL TxBuffer	;bank bit for indirect addressing
		movwf	BufferData	;save WREG data into BufferData
		movf	TxEndPtr,W	;get EndPointer
		movwf	FSR		;and place into FSR
		movf	BufferData,W	;get BufferData
		movwf	INDF		;and store in buffer

;test if buffer pointer needs to wrap around to beginning of buffer memory

		movlw	LOW TxBuffer+TX_BUF_LEN-1 ;get last address of buffer
		xorwf	TxEndPtr,W	;and compare with end pointer
		movlw	LOW TxBuffer	;load first address of buffer
		btfss	STATUS,Z	;check if pointer is at last address
		incf	TxEndPtr,W	;if not then increment pointer
		movwf	TxEndPtr	;store new end pointer value

;test if buffer is full

		subwf	TxStartPtr,W	;compare with start pointer
		btfsc	STATUS,Z	;check if the same
		bsf		Flags,TxBufFull	;if so then indicate buffer full
		bcf		Flags,TxBufEmpty ;buffer cannot be empty
		Bank1			;select bank 1
		bsf		PIE1,TXIE	;enable transmit interrupt
		Bank0			;select bank 0
		return

;error because attempting to store new data and the buffer is full
;can do special error handling here - this code simply ignores the byte

ErrTxBufFull:
		Bank1			;select bank 1
		bsf		PIE1,TXIE	;enable transmit interrupt
		Bank0			;select bank 0
		return 			;no save of data because buffer full

;----------------------------------------------
;Add a byte (from WREG) to the end of the receive buffer

PutRxBuffer:
		Bank0			;select bank 0
		btfsc	Flags,RxBufFull	;check if buffer full
		goto	ErrRxBufFull	;and go handle error if full

		BANKISEL RxBuffer	;bank bit for indirect addressing
		movwf	BufferData	;save WREG into BufferData
		movf	RxEndPtr,W	;get EndPointer
		movwf	FSR		;and place into FSR
		movf	BufferData,W	;get BufferData
		movwf	INDF		;store in buffer

;test if buffer pointer needs to wrap around to beginning of buffer memory

		movlw	LOW RxBuffer+RX_BUF_LEN-1 ;get last address of buffer
		xorwf	RxEndPtr,W	;and compare with end pointer
		movlw	LOW RxBuffer	;load first address of buffer
		btfss	STATUS,Z	;check if pointer is at last address
		incf	RxEndPtr,W	;if not then increment pointer
		movwf	RxEndPtr	;store new end pointer value

;test if buffer is full

		subwf	RxStartPtr,W	;compare with start pointer
		btfsc	STATUS,Z	;check if the same
		bsf		Flags,RxBufFull	;if so then indicate buffer full
		bcf		Flags,RxBufEmpty ;buffer cannot be empty
		return

;error because attempting to store new data and the buffer is full
;can do special error handling here - this code simply ignores the byte

ErrRxBufFull:	return 			;no save of data because buffer full

;----------------------------------------------
;Remove and return (in WREG) the byte at the start of the transmit buffer

GetTxBuffer
		Bank0			;select bank 0
		btfsc	Flags,TxBufEmpty ;check if transmit buffer empty
		goto	ErrTxBufEmpty	;and go handle error if empty

		BANKISEL TxBuffer	;bank bit for indirect addressing
		movf	TxStartPtr,W	;get StartPointer
		movwf	FSR		;and place into FSR

;test if buffer pointer needs to wrap around to beginning of buffer memory

		movlw	LOW TxBuffer+TX_BUF_LEN-1 ;get last address of buffer
		xorwf	TxStartPtr,W	;and compare with start pointer
		movlw	LOW TxBuffer	;load first address of buffer
		btfss	STATUS,Z	;check if pointer is at last address
		incf	TxStartPtr,W	;if not then increment pointer
		movwf	TxStartPtr	;store new pointer value
		bcf		Flags,TxBufFull	;buffer cannot be full

;test if buffer is now empty

		xorwf	TxEndPtr,W	;compare start to end	
		btfsc	STATUS,Z	;check if the same
		bsf		Flags,TxBufEmpty ;if same then buffer will be empty
		movf	INDF,W		;get data from buffer

		return

;error because attempting to read data from an empty buffer
;can do special error handling here - this code simply returns zero

ErrTxBufEmpty:	
		retlw	0		;tried to read empty buffer

;----------------------------------------------
;Remove and return (in WREG) the byte at the start of the receive buffer

GetRxBuffer:
		Bank0			;select bank 0
		btfsc	Flags,RxBufEmpty ;check if receive buffer empty
		goto	ErrRxBufEmpty	;and go handle error if empty

		Bank1			;select bank 
		bcf		PIE1,RCIE	;disable receive interrupt
		Bank0			;select bank 0

		BANKISEL RxBuffer	;bank bit for indirect addressing
		movf	RxStartPtr,W	;get StartPointer
		movwf	FSR		;and place into FSR

;test if buffer pointer needs to wrap around to beginning of buffer memory

		movlw	LOW RxBuffer+RX_BUF_LEN-1 ;get last address of buffer
		xorwf	RxStartPtr,W	; and compare with start pointer
		movlw	LOW RxBuffer	;load first address of buffer
		btfss	STATUS,Z	;check if pointer is at last address
		incf	RxStartPtr,W	;if not then increment pointer
		movwf	RxStartPtr	;store new pointer value
		bcf		Flags,RxBufFull	;buffer cannot be full

;test if buffer is now empty

		xorwf	RxEndPtr,W	;compare start to end	
		btfsc	STATUS,Z	;check if the same
		bsf		Flags,RxBufEmpty ;if same then buffer will be empty
		movf	INDF,W		;get data from buffer
		Bank1			;select bank 1
		bsf		PIE1,RCIE	;enable receive interrupt
		Bank0			;select bank 0
		btfsc	Flags,MaintMode
		return
		movwf	temp3
		btfsc	TXBUSY
		goto	$-1
		call	putchar
		movfw	temp3
		return

;error because attempting to read data from an empty buffer
;can do special error handling here - this code simply returns zero

ErrRxBufEmpty:
		Bank1			;select bank 1
		bsf			PIE1,RCIE	;enable receive interrupt
		Bank0			;select bank 0
		retlw		0		;tried to read empty buffer


;----------------------------------------------------------------------------
;
my_callsign_set
		call		SendPreAmble
		movlw		0x03				; sub command
		call		PutTxBuffer
		movlw		low myCallSign
		movwf		temp
		movlw		.10
		movwf		COUNT
my_callsign_set_00
		movf		temp,w
		incf		temp,f
		Page3
		call		EEPROM_Read
		Page0
		call		PutTxBuffer			;put data in transmit buffer
		decfsz		COUNT,F
		goto		my_callsign_set_00
		call		SendPostAmble
		return


my_callsign2_set
		call		SendPreAmble
		movlw		0xdc
		call		PutTxBuffer
		movlw		low myCallSign2
		movwf		temp
		movlw		0x04
		movwf		COUNT
my_callsign2_set_00
		movf		temp,w
		incf		temp,f
		Page3
		call		EEPROM_Read
		Page0
		call		PutTxBuffer			;put data in transmit buffer
		decfsz		COUNT,F
		goto		my_callsign2_set_00
		call		SendPostAmble
		return


;------------------ Quick Set (TX CallSign)
QuickSet
		call		SendPreAmble
		movlw		0x05
		call		PutTxBuffer
		movlw		0x08	
		movwf		COUNT1
		movlw		RPT2CallSign
		movwf		temp
QuickSet_10
		BANKISEL	RPT2CallSign
		movfw		temp
		movwf		FSR		;and place into FSR
		movfw		INDF		;read from PRT2 (RX RPT1)
		call		PutTxBuffer
		incf		temp,F
		decfsz		COUNT1,F
		goto		QuickSet_10

		movlw		0x08
		movwf		COUNT1
		movlw		RPT1CallSign
		movwf		temp
QuickSet_20
		BANKISEL	RPT1CallSign
		movfw		temp
		movwf		FSR		;and place into FSR
		movfw		INDF		;read from PRT1 (RX RPT2)
		call		PutTxBuffer
		incf		temp,F
		decfsz		COUNT1,F
		goto		QuickSet_20

		movlw		0x08
		movwf		COUNT1
		movlw		CallerCallSign
		movwf		temp
QuickSet_30
		BANKISEL	CallerCallSign		;(PRT2, PRT1 and Your)
		movfw		temp
		movwf		FSR		;and place into FSR
		movfw		INDF		;read caller callsign
		call		PutTxBuffer
		incf		temp,F
		decfsz		COUNT1,F
		goto		QuickSet_30
		call		SendPostAmble


;		check all space in RPT2 and PRT1
		btfss	AdDefault,AutoDuplex
		return
		movlw	.16
		movwf	COUNT1
		movlw	RPT2CallSign
		movwf	temp
QuickSet_50
		BANKISEL	RPT2CallSign		;(PRT2 and PRT1)
		movfw	temp
		movwf	FSR			;and place into FSR
		movfw	INDF		;read from PRT2 in Bank3
		xorlw	" "
		btfss	STATUS,Z
		goto	DuplexOnSend
		incf	temp,F
		decfsz	COUNT1,F
		goto	QuickSet_50
		call	DupOff
		return

DuplexOnSend
		call	DupOn
		return

;----------------- TX CallSign Set
TxCallsign_set
		call		SendPreAmble
		movlw		0x05
		call		PutTxBuffer
		movlw		low TxCallSign
		movwf		temp
		movlw		.24
		movwf		COUNT
TxCallsign_set_00
		movf		temp,w
		incf		temp,f
		Page3
		call		EEPROM_Read
		Page0
		call		PutTxBuffer			;put data in transmit buffer
		decfsz		COUNT,f
		goto		TxCallsign_set_00
		call		SendPostAmble
		return

;----------------- Current TX CallSign Set
CurrentTxCallsign_set
		call		SendPreAmble
		movlw		0x05
		call		PutTxBuffer
		movlw		CurrentRPT2CallSign
		movwf		temp
		movlw		.24
		movwf		COUNT
CurrentTxCallsign_set_00
		BANKISEL	CurrentRPT2CallSign
		movfw		temp	;get EndPointer
		movwf		FSR		;and place into FSR
		movfw		INDF
		call		PutTxBuffer			;put data in transmit buffer
		incf		temp,f
		decfsz		COUNT,f
		goto		CurrentTxCallsign_set_00
		call		SendPostAmble
		return


SlowDataInitSet
		call		SendPreAmble
		movlw		0xc9
		call		PutTxBuffer
		movlw		0x00				; 9600 bps
		btfss		AdDefault2,SlowData96
		movlw		0x01				; 4800 bps
		call		PutTxBuffer
		call		SendPostAmble
		return

DuplexOn
		call		SendPreAmble
		movlw		0xcf
		call		PutTxBuffer
		movlw		0x01
		btfss		AdDefault,Duplex_OnOff	
		movlw		0x00
		call		PutTxBuffer
		call		SendPostAmble
		return

DupOn
		call		SendPreAmble
		movlw		0xcf
		call		PutTxBuffer
		movlw		0x01
		call		PutTxBuffer
		call		SendPostAmble
		return


DupOff
		call		SendPreAmble
		movlw		0xcf
		call		PutTxBuffer
		movlw		0x00
		call		PutTxBuffer
		call		SendPostAmble
		return



GpsMessageSet
		clrf		temp3				; for sumcheck
		call		SendPreAmble
		movlw		0xd2				; sub command
		call		PutTxBuffer
		movlw		low GpsMessage
		movwf		temp
		movlw		.17
		movwf		COUNT
GpsMessageSet_00
		Bank0
		movf		temp,w
		incf		temp,f
		Page3
		call		EEPROM_Read
		Page0
		xorwf		temp3,f
		call		PutTxBuffer			;put data in transmit buffer
		decfsz		COUNT,f
		goto		GpsMessageSet_00
		
		movlw		low myCallSign
		movwf		temp
		movlw		0x08
		movwf		COUNT
GpsMessageSet_01
		movf		temp,w
		incf		temp,f
		Page3
		call		EEPROM_Read
		Page0
		xorwf		temp3,f
		decfsz		COUNT,F
		goto		GpsMessageSet_01
		movlw		","
		xorwf		temp3,f

		movlw		"*"
		call		PutTxBuffer

		movfw		temp3
		movwf		temp
		andlw		0xf0
		movwf		temp3
		swapf		temp3,f
		movfw		temp3
		sublw		0x09
		btfsc		STATUS,C
		goto		GpsMessageSet_02
		movfw		temp3
		addlw		0x037
		goto		GpsMessageSet_03
GpsMessageSet_02
		movfw		temp3
		addlw		0x30
GpsMessageSet_03
		call		PutTxBuffer

		movfw		temp
		andlw		0x0f
		movwf		temp
		sublw		0x09
		btfsc		STATUS,C
		goto		GpsMessageSet_04
		movfw		temp
		addlw		0x037
		goto		GpsMessageSet_05
GpsMessageSet_04
		movfw		temp
		addlw		0x30
GpsMessageSet_05
		call		PutTxBuffer


		call		SendPostAmble
		return


GPSset
;		Bank0
		call		SendPreAmble
		movlw		0xd1
		call		PutTxBuffer
		movlw		low GPS_Filter
		Page3
		call		EEPROM_Read
		Page0
		call		PutTxBuffer
		call		SendPostAmble
		return

DCDset
;		Bank0
		call		SendPreAmble
		movlw		0x17
		call		PutTxBuffer
		movlw		low DCDNumber
		Page3
		call		EEPROM_Read
		Page0
		movwf		temp3
		clrf		Hex2DecTemp
DCDset_00
		movlw		0x0a
		subwf		temp3,f
		btfss		STATUS,C
		goto		DCDset_01
		incf		Hex2DecTemp,f
		goto		DCDset_00
DCDset_01
		movlw		0x0a
		addwf		temp3,f
		swapf		Hex2DecTemp,w
		iorwf		temp3,w
		call		PutTxBuffer
		call		SendPostAmble
		return

DSQLset
;		Bank0
		call		SendPreAmble
		movlw		0x01
		call		PutTxBuffer
		movfw		dsql_sw
		call		PutTxBuffer
		call		SendPostAmble
		bsf			Flags3,SendDsql_Sw
		return


;--------------------------------------
;  Message send
MSGSend_40
		movlw		low TxMessage
		movwf		temp

		call		SendPreAmble
		movlw		0xc1				; sub command
		call		PutTxBuffer
		movlw		0x40				; sub command
		call		PutTxBuffer
		movlw		0x05
		movwf		COUNT1
MSGSend_00
		Bank0
		movf		temp,w
		incf		temp,f
		Page3
		call		EEPROM_Read
		Page0
		call		PutTxBuffer			;put data in transmit buffer
		decfsz		COUNT1,F
		goto		MSGSend_00
		call		SendPostAmble
		return

MSGSend_41
		movlw		low TxMessage
		addlw		0x05
		movwf		temp
		call		SendPreAmble
		movlw		0xc1				; sub command
		call		PutTxBuffer
		movlw		0x41				; sub command
		call		PutTxBuffer
		movlw		0x05
		movwf		COUNT1
MSGSend_01
		Bank0
		movf		temp,w
		incf		temp,f
		Page3
		call		EEPROM_Read
		Page0
		call		PutTxBuffer
		decfsz		COUNT1,F
		goto		MSGSend_01
		call		SendPostAmble
		return

MSGSend_42
		movlw		low TxMessage
		addlw		0x0a
		movwf		temp
		call		SendPreAmble
		movlw		0xc1				; sub command
		call		PutTxBuffer
		movlw		0x42				; sub command
		call		PutTxBuffer
		movlw		0x05
		movwf		COUNT1
MSGSend_02
		Bank0
		movf		temp,w
		incf		temp,f
		Page3
		call		EEPROM_Read
		Page0
		call		PutTxBuffer
		decfsz		COUNT1,F
		goto		MSGSend_02
		call		SendPostAmble
		return


MSGSend_43
		movlw		low TxMessage
		addlw		0x0f
		movwf		temp
		call		SendPreAmble
		movlw		0xc1				; sub command
		call		PutTxBuffer
		movlw		0x43				; sub command
		call		PutTxBuffer
		movlw		0x05
		movwf		COUNT1
MSGSend_03
		Bank0
		movf		temp,w
		incf		temp,f
		Page3
		call		EEPROM_Read
		Page0
		call		PutTxBuffer			;put data in transmit buffer
		decfsz		COUNT1,F
		goto		MSGSend_03
		call		SendPostAmble
		return

;-------------------- M1
M1Read
		movlw		low M1L
		Page3
		call		EEPROM_Read
		Page0
		movwf		I2CaddrLow
		movwf		I2CPNTlow
		movlw		low M1H
		Page3
		call		EEPROM_Read
		Page0
		movwf		I2CaddrHigh
		movwf		I2CPNThigh
		call		MRead
		btfss		portd_s,back
		goto		MRead_99
		btfss		portd_s,menu
		goto		MRead_88
		btfss		porte_s,M1
		goto		MRead_98
		btfss		porte_s,M2
		goto		M2Read
		goto		M3Read

;-------------------- M2
M2Read
		movlw		low M2L
		Page3
		call		EEPROM_Read
		Page0
		movwf		I2CaddrLow
		movwf		I2CPNTlow
		movlw		low M2H
		Page3
		call		EEPROM_Read
		Page0
		movwf		I2CaddrHigh
		movwf		I2CPNThigh
		call		MRead
		btfss		portd_s,back
		goto		MRead_99
		btfss		portd_s,menu
		goto		MRead_88
		btfss		porte_s,M2
		goto		MRead_98
		btfss		porte_s,M1
		goto		M1Read
		goto		M3Read

;-------------------- M3
M3Read
		movlw		low M3L
		Page3
		call		EEPROM_Read
		Page0
		movwf		I2CaddrLow
		movwf		I2CPNTlow
		movlw		low M3H
		Page3
		call		EEPROM_Read
		Page0
		movwf		I2CaddrHigh
		movwf		I2CPNThigh
		call		MRead
		btfss		portd_s,back
		goto		MRead_99
		btfss		portd_s,menu
		goto		MRead_88
		btfss		porte_s,M3
		goto		MRead_98
		btfss		porte_s,M1
		goto		M1Read
		goto		M2Read


;---
MRead
		Page3
		call		ClearLCD
		movlw		b'10000000'
		call		LCD_CMD_4
		Page0
		movlw		0x08
		movwf		COUNT
MRead_00						; name
		Page3
		call		ByteRead		
		movfw		datai
		call		LCD_DATA_4
		Page0
		incf		I2CaddrLow,f
		btfsc		STATUS,Z
		incf		I2CaddrHigh,f
		decfsz		COUNT,F
		goto		MRead_00

		Page3
		movlw		b'11000000'
		call		LCD_CMD_4
		Page0
		movlw		0x08
		movwf		COUNT
		movlw		MemCallerCallSign
		movwf		temp2
MRead_01					; your call
		Page3
		call		ByteRead		
		movfw		datai
		call		LCD_DATA_4
		Page0
		BANKISEL	MemCallerCallSign
		movfw		temp2
		movwf		FSR
		movfw		datai
		movwf		INDF
		incf		temp2,f
		incf		I2CaddrLow,f
		btfsc		STATUS,Z
		incf		I2CaddrHigh,f
		decfsz		COUNT,F
		goto		MRead_01

		Page3
		movlw		b'10010100'
		call		LCD_CMD_4
		Page0
		movlw		0x08
		movwf		COUNT
		movlw		MemRPT1CallSign
		movwf		temp2
MRead_02					; RPT1
		Page3
		call		ByteRead		
		movfw		datai
		call		LCD_DATA_4
		Page0
		BANKISEL	MemRPT1CallSign
		movfw		temp2
		movwf		FSR
		movfw		datai
		movwf		INDF
		incf		temp2,f
		incf		I2CaddrLow,f
		btfsc		STATUS,Z
		incf		I2CaddrHigh,f
		decfsz		COUNT,F
		goto		MRead_02

		Page3
		movlw		b'10011110'
		call		LCD_CMD_4
		Page0
		movlw		0x08
		movwf		COUNT
		movlw		MemRPT2CallSign
		movwf		temp2
MRead_03				; RPT2
		Page3
		call		ByteRead		
		movfw		datai
		call		LCD_DATA_4
		Page0
		BANKISEL	MemRPT2CallSign
		movfw		temp2
		movwf		FSR
		movfw		datai
		movwf		INDF
		incf		temp2,f
		incf		I2CaddrLow,f
		btfsc		STATUS,Z
		incf		I2CaddrHigh,f
		decfsz		COUNT,F
		goto		MRead_03

;----------------  read DSQL/CSQL
		Page3
		call		ByteRead
		Page0
		BANKISEL	MemDSQL
		movlw		MemDSQL
		movwf		FSR
		movfw		datai
		movwf		INDF
		Page3
		call		DSQL_disp
		Page0
		incf		I2CaddrLow,f
		btfsc		STATUS,Z
		incf		I2CaddrHigh,f
;---------------  read DCD
		Page3
		call		ByteRead
		Page0
		BANKISEL	MemDCD
		movlw		MemDCD
		movwf		FSR
		movfw		datai
		movwf		INDF
		Page3
		call		DCD_disp
		Page0
		incf		I2CaddrLow,f
		btfsc		STATUS,Z
		incf		I2CaddrHigh,f
;-------------------------------


		Page3
		movlw		b'10001010'
		call		LCD_CMD_4
		Page0
		movlw		0x08
		movwf		COUNT

MRead_04					; freq
		Page3
		call		ByteRead		
		movfw		datai
		call		LCD_DATA_4
		Page0
		incf		I2CaddrLow,f
		btfsc		STATUS,Z
		incf		I2CaddrHigh,f
		decfsz		COUNT,F
		goto		MRead_04

		MOVLW		B'11010100'
		Page3
		CALL		LCD_CMD_4
		Page0
		clrf		POINT
		incf		POINT,F
MRead_05
		movfw		POINT
		movwf		COUNT
		pageselw	ChangeMsg
		movlw		low ChangeMsg
		addwf		COUNT,w
		btfsc		STATUS,C
		incf		PCLATH,f
		call		ChangeMsg
		addlw		0
		BTFSC		STATUS,Z
		GOTO		MRead_06
		Page3
		CALL		LCD_DATA_4
		Page0
		INCF		POINT,F
		goto		MRead_05

MRead_06
		Page3
		call		TactSW
		call		PorteSW
		Page0
		btfss	portd_s,back
		return
		btfss	portd_s,menu
		return
		movfw	porte_s
		xorlw	0x07
		btfsc	STATUS,Z
		goto	MRead_06
		return

MRead_88
		Page3
		call	ClearLCD
		Page0
		retlw	0x01

MRead_98
		bcf			Flags3,Display_Sw
		Page3
		call	Set0eSet
		Page0
;		movlw	0x40
;		movwf	resp
;		movlw	0x0c
;		movwf	command
;		bsf		Flags3,DsqlSet_Sw
MRead_99
		Page3
		call	ClearLCD
		Page0
		retlw	0x00


ChangeMsg
		movwf	PCL
		dt		ChangeMSG,0

;===================================  PAGE 1 ==============================
		org		0x0800		;	Page 1
;----------------------------------------------------------------------------
; Check UT-118 data stream

CheckReceivedData
		Bank0
		btfsc	Flags,RxBufEmpty ;check if Rx buffer is empty
		return			;if so then return
		Page10
		call	GetRxBuffer	;get data from receive buffer
		Page01
		movwf	TempData
		xorlw	0xfe
		btfss	STATUS,Z
		goto	Check_Table_00
		movfw	sw
		sublw	0x02
		btfss	STATUS,C
		goto	Check_99
Check_Table_00
		pageselw Check_Table
		movlw 	low Check_Table
		addwf 	sw,w
		btfsc 	STATUS,C
		incf 	PCLATH,f
		movwf	PCL
Check_Table
		goto	Check_00
		goto	Check_01
		goto	Check_02
		goto	Check_03
		goto	Check_04
		goto	Check_05
		goto	Check_99		; Dummy reserve
		goto	Check_99		; Dummy reseerve

Check_00					; check First 0xFE
		movfw	TempData
		xorlw	0xfe
		btfss	STATUS,Z
		goto	Check_99
		incf	sw,F
		return

Check_01					; check Second 0xFE
		movfw	TempData
		xorlw	0xfe
		btfss	STATUS,Z
		goto	Check_99
		incf	sw,F
		return
		

Check_02					; check 0x7F or 0xFE
		movfw	TempData
		xorlw	0xfe
		btfsc	STATUS,Z
		return
		movfw	TempData
		xorlw	0x7f
		btfss	STATUS,Z
		goto	Check_99
		incf	sw,f
		return

Check_03					; Check 0x01
		movfw	TempData
		xorlw	0x01
		btfss	STATUS,Z
		goto	Check_99
		incf	sw,f
		return

Check_04					; Check 0x1D, 0XFA or 0xFB
		movfw	TempData
		xorlw	0x1d
		btfss	STATUS,Z
		goto	Check_04_01
		incf	sw,f
		return
Check_04_01
		movfw	TempData
		xorlw	0xfa			; NG response
		btfss	STATUS,Z
		goto	Check_04_02
		goto	set_fa
Check_04_02
		movfw	TempData
		xorlw	0xfb			; ACK response
		btfss	STATUS,Z
		goto	Check_99
		goto	set_fb

Check_05							; Check subcommand
		swapf	TempData,w
		andlw	0x0f
		movwf	JumpPoint
		pageselw Table_xx
		movlw 	low Table_xx
		addwf 	JumpPoint,w
		btfsc 	STATUS,C
		incf 	PCLATH,f
		movwf	PCL
Table_xx
		goto	Check_0x00
		goto	Check_0x10
		goto	Check_99		; Check_0x20
		goto	Check_99		; Check_0x30
		goto	Check_99		; Check_0x40
		goto	Check_99		; Check_0x50
		goto	Check_99		; Check_0x60
		goto	Check_99		; Check_0x70
		goto	Check_99		; Check_0x80
		goto	Check_99		; Check_0x90
		goto	Check_99		; Check_0xa0
		goto	Check_99		; Check_0xb0
		goto	Check_0xc0
		goto	Check_0xd0
		goto	Check_99		; Check_0xe0
		goto	Check_99		; Check_0xf0


Check_0x00
		movfw	TempData
		andlw	0x0f
		movwf	JumpPoint
		pageselw Table_0x00
		movlw 	low Table_0x00
		addwf 	JumpPoint,w
		btfsc 	STATUS,C
		incf 	PCLATH,f
		movwf	PCL
Table_0x00
		goto	set_00			; sub command check 0x00 (Flag read)
		goto	set_01			; sub command check 0x01 (Flag read)
		goto	Check_99
		goto	set_03			; sub command check 0x03 (READ My callsign)
		goto	set_04			; sub command check 0x04 (READ RX callsign)
		goto	set_05			; sub command check 0x05 (READ TX callsign)
		goto	Check_99
		goto	Check_99
		goto	Check_99
		goto	Check_99
		goto	Check_99
		goto	Check_99
		goto	Check_99
		goto	Check_99
		goto	Check_99
		goto	Check_99

Check_0x10
		movfw	TempData
		xorlw	0x17			; sub command check 0x05 (READ DCD)
		btfsc	STATUS,Z
		goto	set_17
		goto	Check_99

Check_0xc0
		movfw	TempData
		andlw	0x0f
		movwf	JumpPoint
		pageselw Table_0xc0
		movlw 	low Table_0xc0
		addwf 	JumpPoint,w
		btfsc 	STATUS,C
		incf 	PCLATH,f
		movwf	PCL
Table_0xc0
		goto	set_c0			; sub command check 0xc0 (All Message READ)
		goto	set_c1			; sub command check 0xc1 (ACK of send message)
		goto	set_c2			; sub command check 0xc2 (??????????)
		goto	Check_99
		goto	Check_99
		goto	Check_99
		goto	Check_99
		goto	Check_99
		goto	Check_99
		goto	set_c9			; sub command check 0xc9 (baud rate of slow data)
		goto	Check_99
		goto	Check_99
		goto	Check_99
		goto	Check_99
		goto	Check_99
		goto	set_cf			; sub command duplex on/off

Check_0xd0
		movfw	TempData
		andlw	0x0f
		movwf	JumpPoint
		pageselw Table_0xd0
		movlw 	low Table_0xd0
		addwf 	JumpPoint,w
		btfsc 	STATUS,C
		incf 	PCLATH,f
		movwf	PCL
Table_0xd0
		goto	Check_99
		goto	set_d1			; sub command check db (GPS filter read)
		goto	set_d2			; sub command check db (TX Message read)
		goto	set_d3			; read GLL of sending GPS message
		goto	set_d4			; read GGA of sending GPS message
		goto	set_d5			; read RMC of sending GPS message
		goto	set_d6			; read GSA of sending GPS message
		goto	set_d7			; read VTG of sending GPS message
		goto	Check_99
		goto	set_d9			; read 0xd9 (??????????)
		goto	set_da			; read 0xda (??????????)
		goto	set_db			; sub command check db (RX "/" read)
		goto	set_dc			; sub command check db (TX "/" read)
		goto	Check_99
		goto	Check_99
		goto	Check_99

;
;		return
;

Check_99
		clrf	sw
		return

CheckRxBuffer
		btfss	Flags,RxBufEmpty
		retlw	0x00
		Page13
		call	TIME10M
		Page31
		btfss	Flags,RxBufEmpty
		retlw	0x00
		Page13
		call	TIME10M
		Page31
		btfss	Flags,RxBufEmpty
		retlw	0x00
		retlw	0x01


;----------------------------------------------------------------------------
; 0x00
set_00
		call	CheckRxBuffer	
		addlw	0
		btfss	STATUS,Z
		goto	set_99
		Page10
		call	GetRxBuffer		; 1 byte skip
		Page3
		btfss	Flags,FirstDisp	
		call	ClearLCD
		movlw	b'10001111'		; Line1 
		call	LCD_CMD_4
		Page31
		call	CheckRxBuffer	
		addlw	0
		btfss	STATUS,Z
		goto	set_99
		Page10
		call	GetRxBuffer		; 5 bits of flag1
		Page01
		movwf	RF_Flag0
;		movlw	"V"
;		btfsc	RF_Flag0,4		; Data or Voice
;		movlw	"D"
;		Page13
;		call	LCD_DATA_4	
;		Page31
		movlw	"D"
		btfsc	RF_Flag0,3		; Direct or Repeater
		movlw	"R"
		Page13
		call	LCD_DATA_4	
		Page31
		movlw	"N"
		btfsc	RF_Flag0,2		; Breadk
		movlw	"B"
		Page13
		call	LCD_DATA_4	
		Page31
		movlw	"D"
		btfsc	RF_Flag0,1		; Data or Control
		movlw	"C"
		Page13
		call	LCD_DATA_4	
		Page31
		movlw	"N"
		btfsc	RF_Flag0,0		; Nornal or emrgency
		movlw	"E"
		Page13
		call	LCD_DATA_4	
		movlw	b'11001010'		; Line2
		call	LCD_CMD_4
		Page31
		call	CheckRxBuffer	
		addlw	0
		btfss	STATUS,Z
		goto	set_99
		Page10
		call	GetRxBuffer		; 3 bits of flag1
		Page01
		movwf	RF_Flag1
		movwf	TempData
		addlw	0
		btfsc	STATUS,Z
		goto	set_00_42
		movlw	0x00
set_00_41
		addlw	.10
		decfsz	TempData,f
		goto	set_00_41
set_00_42
		movwf	POINT
		movlw	.10
		movwf	COUNT
set_00_44
		Page1
		pageselw	msg_00
		movlw	low	msg_00
		movwf	TempData
		movfw	POINT
		addwf	TempData,f
		movlw	high msg_00
		btfsc	STATUS,C
		incf	PCLATH,F
		movfw	TempData
		call	flag_table
		incf	POINT,F
		Page13
		CALL	LCD_DATA_4
		Page31
		decfsz	COUNT,f
		goto	set_00_44
		movfw	RF_Flag1
		btfss	STATUS,Z
		goto	set_99
		Page13
		call	Disp4Clear
		Page31	
		bcf		Flags,DebugDisp
		goto	set_99
;
;-------------------
;
flag_table
		movwf	PCL
msg_00	DT		msg_00_MSG		; NULL
msg_01	DT		msg_01_MSG		; Relay unavailable
msg_02	DT		msg_02_MSG		; No Relay
msg_03	DT		msg_03_MSG		; ACK
msg_04	DT		msg_04_MSG		; Resend
msg_05	DT		msg_05_MSG
msg_06	DT		msg_06_MSG		; Auto Reply
msg_07	DT		msg_00_MSG		; Repeater

;
;----------------
;------  0x01
set_01
		btfss	Flags3,SendDsql_Sw
		goto	set_01_00
		bcf		Flags3,SendDsql_Sw
		goto	set_99
set_01_00		
		bcf		Flags3,Pocket_BEEP_Sw
		call	CheckRxBuffer
		addlw	0
		btfss	STATUS,Z
		goto	set_99
		Page10
		call	GetRxBuffer		; read DSQL code
		Page01
		movwf	temp
		btfss	Flags,DebugDisp
		goto	set_01_01
		movwf	datai
		Page3
		movlw	b'11011111'
		call	DSQL_disp_0
		Page1
		goto	set_98
set_01_01
		btfsc	temp,0
		bsf		Flags3,Pocket_BEEP_Sw
		call	CheckRxBuffer
		addlw	0
		btfss	STATUS,Z
		goto	set_99
		Page10
		call	GetRxBuffer
		Page01
		addlw	0
		btfss	STATUS,Z
		goto	Pocket_beep
		goto	BeepOn
Pocket_beep
		btfss	Flags3,Pocket_BEEP_Sw
		goto	set_99
		bsf		Flags3,P_Beep_Sw
		movlw	.60
		movwf	PocketBeepCNT
BeepOn
		btfss	AdDefault2,BeepOnOff
		return
		bsf		Flags2,Beep_Sw
		movlw	0xa0		
		movwf	BeepCNT
		goto	set_99


;----------------------------------------------------------------------------
; 0x03
set_03
		Page13
		movlw	b'10000000'	; Line1 0 My Call
		CALL	LCD_CMD_4
		Page31
		movlw	0x08
		movwf	COUNT2
set_03_01			; MyCall
		call	CheckRxBuffer	
		addlw	0
		btfss	STATUS,Z
		goto	set_99
		Page10
		call	GetRxBuffer
		Page3
		call	LCD_DATA_4
		Page31
		decfsz	COUNT2,F
		goto	set_03_01

set_03_00
		Page13
		movlw	B'10001101'
		call	LCD_CMD_4
		Page31
		clrf	POINT
		incf	POINT,F
		movlw	.6
		movwf	COUNT2
set_03_02
		movfw	POINT
		movwf	COUNT
		pageselw	DebugMSG
		movlw	low DebugMSG
		addwf	COUNT,w
		btfsc	STATUS,C
		incf	PCLATH,f
		call	DebugMSG
		Page13
		call	LCD_DATA_4
		Page31
		INCF	POINT,F
		decfsz	COUNT2,f
		goto	set_03_02
		bcf		Flags,FirstDisp
		goto	set_99

DebugMSG
		movwf	PCL
		dt		"*DEBUG"

;------ RX ----------------------------------------------------------------------
; 0x04
set_04
;----------- RPT2
set_04_0
		btfss	Flags2,GPSDisp_Sw
		goto	set_04_0_0
		bcf		Flags2,GPSDisp_Sw
		Page13
		call	Disp3Clear
set_04_0_0
		Page13
		movlw	b'10011110'	; Line3 RPT2
		CALL	LCD_CMD_4
		Page31
set_04_00
		movlw	0x08
		movwf	COUNT2
		movlw	RPT1CallSign
		btfsc	RF_Flag0,3		; Direct or Repeater
		movlw	RPT2CallSign
		movwf	temp
set_04_01			; RPT2
		call	CheckRxBuffer	
		addlw	0
		btfss	STATUS,Z
		goto	set_99
		Page10
		call	GetRxBuffer
		Page01
		movwf	TempData
		BANKISEL	RPT1CallSign
		btfsc	RF_Flag0,3		; Direct or Repeater
		BANKISEL	RPT2CallSign
		movf	temp,W
		movwf	FSR
		movf	TempData,W
		movwf	INDF
		Page13
		call	LCD_DATA_4
		Page31
		incf	temp,F
		decfsz	COUNT2,F
		goto	set_04_01

;---------------- RPT1
		Page13
		movlw	B'10010100'	; Line 3  RPT1
		call	LCD_CMD_4
		Page31
		movlw	0x08
		movwf	COUNT2
		movlw	RPT2CallSign
		btfsc	RF_Flag0,3
		movlw	RPT1CallSign
		movwf	temp
set_04_02	
		call	CheckRxBuffer	
		addlw	0
		btfss	STATUS,Z
		goto	set_99
		Page10
		call	GetRxBuffer
		Page01
		movwf	TempData
		BANKISEL	RPT2CallSign
		btfsc	RF_Flag0,3
		BANKISEL	RPT1CallSign
		movf	temp,W
		movwf	FSR
		movf	TempData,W
		movwf	INDF
		Page13
		call	LCD_DATA_4
		Page31
		incf	temp,F
		decfsz	COUNT2,F
		goto	set_04_02


;----------------- Called
;
		Page13
		movlw	b'11000000'		; Line2 Called
		call	LCD_CMD_4
		Page31
		movlw	0x08
		movwf	COUNT2
		movlw		low myCallSign
		movwf		temp
		bsf		Flags2,Called_Sw
set_04_03	
		call	CheckRxBuffer	
		addlw	0
		btfss	STATUS,Z
		goto	set_99
		movf		temp,w
		incf		temp,f
		Page3
		call		EEPROM_Read
		Page1
		movwf		TempData
		Page10
		call	GetRxBuffer	;get data from receive buffer
		Page01
		xorwf	TempData,f
		btfss	STATUS,Z
		bcf		Flags2,Called_Sw
		Page13
		call	LCD_DATA_4
		Page31
		decfsz	COUNT2,F
		goto	set_04_03



;----------------- Caller
		bsf		Flags,AllSpaces
		Page13
		movlw	b'10000000'		; Line1 Caller
		call	LCD_CMD_4
		Page31
		movlw	0x08
		movwf	COUNT2
		movlw	CallerCallSign
		movwf	temp
set_04_04	
		call	CheckRxBuffer	
		addlw	0
		btfss	STATUS,Z
		goto	set_99
		Page10
		call	GetRxBuffer
		Page01
		movwf	TempData
		BANKISEL	CallerCallSign
		movf	temp,W
		movwf	FSR
		movf	TempData,W
		movwf	INDF
		Page13
		call	LCD_DATA_4
		Page31
		btfss	Flags,AllSpaces
		goto	set_04_05
		movfw	TempData
		xorlw	" "
		btfss	STATUS,Z
		bcf		Flags,AllSpaces
set_04_05
		incf	temp,F
		decfsz	COUNT2,F
		goto	set_04_04

;-------------   
		movfw	RF_Flag1
		btfsc	STATUS,Z
		goto	set_04_06
		btfss	AdDefault,DRS_OnOff
		goto	set_99
		xorlw	0x01
		btfss	STATUS,Z
		goto	set_99
		btfss	Flags2,Called_Sw
		goto	set_99
		call	Rpt1CallSet
		goto	TxSend
		goto	set_99
set_04_06
		Page13
		call		EEpromYourCall
		Page31
		Bank0
		btfsc	AdDefault,RCW_OnOff
		call	YuCallSet
		btfsc	AdDefault,RRW_OnOff
		call	RptCallSet
		btfsc	AdDefault,RCW_OnOff
		goto	TxSend
		btfsc	AdDefault,RRW_OnOff
		goto	TxSend
		goto	set_99
TxSend
		btfsc	Flags,AllSpaces
		goto	set_99
		movlw	0x40
		movwf	resp
		movlw	0x0b
		movwf	command
		goto	set_99

YuCallSet
		Bank0
		movlw	CallerCallSign
		movwf	temp
		movlw	CurrentCallerCallSign
		movwf	temp2
		movlw	0x08
		movwf	COUNT
YuCallSet_00
		BANKISEL	CallerCallSign
		movfw	temp
		movwf	FSR
		movfw	INDF
		movwf	TempData
		BANKISEL	CurrentCallerCallSign
		movfw	temp2
		movwf	FSR
		movfw	TempData
		movwf	INDF
		incf	temp,f
		incf	temp2,f
		decfsz	COUNT,F
		goto	YuCallSet_00
		return

RptCallSet
		Bank0
		movlw	RPT2CallSign
		movwf	temp
		movlw	CurrentRPT2CallSign
		movwf	temp2
		movlw	0x10
		movwf	COUNT
RptCallSet_00
		BANKISEL	RPT2CallSign
		movfw	temp
		movwf	FSR
		movfw	INDF
		movwf	TempData
		BANKISEL	CurrentRPT2CallSign
		movfw	temp2
		movwf	FSR
		movfw	TempData
		movwf	INDF
		incf	temp,f
		incf	temp2,f
		decfsz	COUNT,F
		goto	RptCallSet_00
		return

Rpt1CallSet
		Bank0
		movlw	RPT1CallSign
		movwf	temp
		movlw	CurrentRPT1CallSign
		movwf	temp2
		movlw	0x08
		movwf	COUNT
Rpt1CallSet_00
		BANKISEL	RPT1CallSign
		movfw	temp
		movwf	FSR
		movfw	INDF
		movwf	TempData
		BANKISEL	CurrentRPT1CallSign
		movfw	temp2
		movwf	FSR
		movfw	TempData
		movwf	INDF
		incf	temp,f
		incf	temp2,f
		decfsz	COUNT,F
		goto	Rpt1CallSet_00
		return

;------ TX ----------------------------------------------------------------------
; 0x05

set_05
;----------- RPT2
set_05_0
		Page13
		movlw	b'10011110'	; Line3 0 RPT2
		CALL	LCD_CMD_4
		Page31
set_05_00
		movlw	0x08
		movwf	COUNT2
set_05_01			; RPT2
		call	CheckRxBuffer	
		addlw	0
		btfss	STATUS,Z
		goto	set_99
		Page10
		call	GetRxBuffer
		Page3
		call	LCD_DATA_4
		Page31
		decfsz	COUNT2,F
		goto	set_05_01

;---------------- RPT1
		Page13
		movlw	B'10010100'	; Line 3 10 RPT1
		call	LCD_CMD_4
		Page31
		movlw	0x08
		movwf	COUNT2
set_05_02	
		call	CheckRxBuffer	
		addlw	0
		btfss	STATUS,Z
		goto	set_99
		Page10
		call	GetRxBuffer	;get data from receive buffer
		Page3
		call	LCD_DATA_4
		Page31
		decfsz	COUNT2,F
		goto	set_05_02


;----------------- Called
;
		Page13
		movlw	b'11000000'		; Line2 0 Called
		call	LCD_CMD_4
		Page31
		movlw	0x08
		movwf	COUNT2
set_05_03	
		call	CheckRxBuffer	
		addlw	0
		btfss	STATUS,Z
		goto	set_99
		Page10
		call	GetRxBuffer	;get data from receive buffer
		Page3
		call	LCD_DATA_4
		Page31
		decfsz	COUNT2,F
		goto	set_05_03
		goto	set_99

;---------------
; 0x17			read DCD
set_17
		Page13
		movlw	b'11100110'
		call	LCD_CMD_4
		Page31

		call	CheckRxBuffer	
		addlw	0
		btfss	STATUS,Z
		goto	set_99
		Page10
		call	GetRxBuffer
		Page3
		movwf	temp
		swapf	temp,w
		andlw	0x0f
		iorlw	0x30
		Page13
		call	LCD_DATA_4
		Page31
		movfw	temp
		andlw	0x0f
		iorlw	0x30
		Page13
		call	LCD_DATA_4
		Page31
		goto	set_99


;-----------------
; 0xc0		All message Read
; Messages 0x3x,0x40,0x41,0x42,0x43,0x5x 
set_c0
		call	CheckRxBuffer	
		addlw	0
		btfss	STATUS,Z
		goto	set_99
		Page10
		call	GetRxBuffer
		Page01
		movwf	TempData
		btfss	AdDefault,GPSDisplay
		goto	set_gps_skip
		andlw	0xf0
		xorlw	0x30			; GPS sentence + message
		btfsc	STATUS,Z
		goto	set_c0_gps
set_gps_skip
		movfw	TempData
		xorlw	0x40
		btfss	STATUS,Z
		goto	set_c0_01
		Page13
		MOVLW	B'11010100'	; Line 4
		CALL	LCD_CMD_4
		Page31
		movlw	0x05
		movwf	COUNT2
set_c0_00
		call	CheckRxBuffer	
		addlw	0
		btfss	STATUS,Z
		goto	set_99
		Page10
		call	GetRxBuffer
		Page3
		call	LCD_DATA_4
		Page31
		decfsz	COUNT2,F
		goto	set_c0_00
		goto	set_99

set_c0_01
		movfw	TempData
		xorlw	0x41
		btfss	STATUS,Z
		goto	set_c0_03
		Page13
		MOVLW	B'11011001'	; Line 4
		CALL	LCD_CMD_4
		Page31
		movlw	0x05
		movwf	COUNT2
set_c0_02
		call	CheckRxBuffer	
		addlw	0
		btfss	STATUS,Z
		goto	set_99
		Page10
		call	GetRxBuffer
		Page3
		call	LCD_DATA_4
		Page31
		decfsz	COUNT2,F
		goto	set_c0_02
		goto	set_99

set_c0_03
		movfw	TempData
		xorlw	0x42
		btfss	STATUS,Z
		goto	set_c0_05
		Page13
		MOVLW	B'11011110'	; Line 4
		CALL	LCD_CMD_4
		Page31
		movlw	0x05
		movwf	COUNT2
set_c0_04
		call	CheckRxBuffer	
		addlw	0
		btfss	STATUS,Z
		goto	set_99
		Page10
		call	GetRxBuffer
		Page3
		call	LCD_DATA_4
		Page31
		decfsz	COUNT2,F
		goto	set_c0_04
		goto	set_99

set_c0_05
		movfw	TempData
		xorlw	0x43
		btfss	STATUS,Z
		goto	set_99
		Page13
		MOVLW	B'11100011'	; Line 4
		CALL	LCD_CMD_4
		Page31
		movlw	0x05
		movwf	COUNT2
set_c0_06
		call	CheckRxBuffer	
		addlw	0
		btfss	STATUS,Z
		goto	set_99
		Page10
		call	GetRxBuffer
		Page3
		call	LCD_DATA_4
		Page31
		decfsz	COUNT2,F
		goto	set_c0_06
		goto	set_99


set_c0_gps
		movfw	TempData
		andlw	0x0f
		btfsc	STATUS,Z
		goto	set_99
		sublw	0x05
		btfss	STATUS,C
		goto	set_99
		movfw	TempData
		andlw	0x0f
		movwf	COUNT2
		Page13
		movfw	GpsLcdPnt
		call	LCD_CMD_4
		Page31
		bsf		Flags2,GPSDisp_Sw
set_gps_10
		call	CheckRxBuffer	
		addlw	0
		btfss	STATUS,Z
		goto	set_99
		Page10
		call	GetRxBuffer
		Page01
		movwf	TempData

		xorlw	"$"					; check $GPxxx
		btfss	STATUS,Z
		goto	set_gps_11
		clrf	GpsSW
		incf	GpsSW,f
		goto	set_gps_90

set_gps_11
		pageselw GPS_SW_Table
		movlw 	low GPS_SW_Table
		addwf 	GpsSW,w
		btfsc 	STATUS,C
		incf 	PCLATH,f
		movwf	PCL
GPS_SW_Table
		goto	set_gps_90
		goto	set_gps_20
		goto	set_gps_22
		goto	set_gps_23
		goto	set_gps_24
		goto	set_gps_25
		goto	set_gps_27
		goto	set_gps_29
		goto	set_gps_31
		goto	set_gps_41
		goto	set_gps_51

set_gps_20
		movfw	TempData
		xorlw	"G"
		btfss	STATUS,Z
		goto	set_gps_80
		incf	GpsSW,f
		goto	set_gps_90

set_gps_22
		movfw	TempData
		xorlw	"P"
		btfss	STATUS,Z
		goto	set_gps_80
		incf	GpsSW,f
		goto	set_gps_90

set_gps_23
		movfw	TempData
		xorlw	"G"
		btfss	STATUS,Z
		goto	set_gps_23_1
		incf	GpsSW,f
		goto	set_gps_90
set_gps_23_1
		movfw	TempData
		xorlw	"R"
		btfss	STATUS,Z
		goto	set_gps_80
		incf	GpsSW,f
		goto	set_gps_90

set_gps_24
		incf	GpsSW,f
		bsf		Flags2,GLL
		movfw	TempData
		xorlw	"L"
		btfss	STATUS,Z
		bcf		Flags2,GLL
		goto	set_gps_90

set_gps_25
		btfsc	Flags2,GLL
		goto	set_gps_25_1
		movfw	TempData
		xorlw	","
		btfss	STATUS,Z
		goto	set_gps_90
		incf	GpsSW,f
		Page13
		movlw	b'11011111'
		movwf	GpsLcdPnt
		call	LCD_CMD_4
		movlw	" "
		call	LCD_DATA_4
		incf	GpsLcdPnt,f
		Page31
		clrf	GpsTimePnt
		goto	set_gps_90

set_gps_27							; time
		btfsc	Flags2,GLL
		goto	set_gps_27_1
		movfw	TempData
		xorlw	","
		btfss	STATUS,Z
		goto	set_gps_28
		incf	GpsSW,f
		Page13
		movlw	b'10010100'
		movwf	GpsLcdPnt
		call	LCD_CMD_4
		movlw	" "
		call	LCD_DATA_4
		incf	GpsLcdPnt,f
		Page31
		goto	set_gps_90

set_gps_28
		movfw	GpsTimePnt
		xorlw	0x06
		btfsc	STATUS,Z
		goto	set_gps_90
		movfw	TempData
		Page13
		movfw	TempData
		call	LCD_DATA_4
		incf	GpsLcdPnt,f
		Page31
		incf	GpsTimePnt,f
		movfw	GpsTimePnt
		xorlw	0x02
		btfsc	STATUS,Z
		goto	set_gps_28_7
		movfw	GpsTimePnt
		xorlw	0x04
		btfss	STATUS,Z
		goto	set_gps_90
set_gps_28_7
		Page13
		movlw	":"
		call	LCD_DATA_4
		incf	GpsLcdPnt,f
		Page31
		goto	set_gps_90


set_gps_29							; long
		btfsc	Flags2,GLL
		goto	set_gps_29_1
		movfw	TempData
		xorlw	","
		btfss	STATUS,Z
		goto	set_gps_30
		incf	GpsSW,f
		goto	set_gps_90
set_gps_30
		movfw	TempData
		xorlw	"V"
		btfsc	STATUS,Z
		goto	set_gps_80
		movfw	TempData
		xorlw	"A"
		btfss	STATUS,Z
		goto	set_gps_32
		decf	GpsSW,f
		goto	set_gps_90

set_gps_31
		btfsc	Flags2,GLL
		goto	set_gps_31_1
		movfw	TempData
		xorlw	","
		btfss	STATUS,Z
		goto	set_gps_32
		incf	GpsSW,f
		Page13
		movlw	b'11010100'
		movwf	GpsLcdPnt
		call	LCD_CMD_4
		Page31
		goto	set_gps_90

set_gps_41						; lat
		btfsc	Flags2,GLL
		goto	set_gps_41_1
		movfw	TempData
		xorlw	","
		btfss	STATUS,Z
		goto	set_gps_32
		incf	GpsSW,f
		goto	set_gps_90


set_gps_51						; lat
		btfsc	Flags2,GLL
		goto	set_gps_51_1
		movfw	TempData
		xorlw	","
		btfss	STATUS,Z
		goto	set_gps_32
		goto	set_gps_75


;-------------- $GPGLL
set_gps_25_1
		movfw	TempData
		xorlw	","
		btfss	STATUS,Z
		goto	set_gps_90
		incf	GpsSW,f
		Page13
		movlw	b'10010100'
		movwf	GpsLcdPnt
		call	LCD_CMD_4
		movlw	" "
		call	LCD_DATA_4
		incf	GpsLcdPnt,f
		Page31
		goto	set_gps_90


set_gps_27_1							; long
		movfw	TempData
		xorlw	","
		btfss	STATUS,Z
		goto	set_gps_32
		incf	GpsSW,f
		goto	set_gps_90

set_gps_29_1							; long
		movfw	TempData
		xorlw	","
		btfss	STATUS,Z
		goto	set_gps_32
		incf	GpsSW,f
		movlw	b'11010100'
		movwf	GpsLcdPnt
		Page13
		call	LCD_CMD_4
		Page31
		goto	set_gps_90

set_gps_31_1
		movfw	TempData
		xorlw	","
		btfss	STATUS,Z
		goto	set_gps_32
		incf	GpsSW,f
		goto	set_gps_90

set_gps_41_1						; time
		movfw	TempData
		xorlw	","
		btfss	STATUS,Z
		goto	set_gps_32
		incf	GpsSW,f
		Page13
		movlw	b'11011111'
		movwf	GpsLcdPnt
		call	LCD_CMD_4
		movlw	" "
		call	LCD_DATA_4
		incf	GpsLcdPnt,f
		Page31
		clrf	GpsTimePnt
		goto	set_gps_90


set_gps_51_1						; time
		movfw	TempData
		xorlw	","
		btfsc	STATUS,Z
		goto	set_gps_80
		goto	set_gps_28


;--------------
set_gps_32
		Page13
		movfw	TempData
		call	LCD_DATA_4
		incf	GpsLcdPnt,f
		Page31
		goto	set_gps_90


set_gps_75
		Page13
		movlw	b'10011111'
		movwf	GpsLcdPnt
		call	LCD_CMD_4
		Page31
		movlw	0x09
		movwf	POINT
set_gps_75_0
		movlw	" "
		Page13
		call	LCD_DATA_4
		Page31
		incf	GpsLcdPnt,f
		decfsz	POINT,f
		goto	set_gps_75_0

set_gps_80
		clrf	GpsSW
set_gps_90
		decfsz	COUNT2,F
		goto	set_gps_10
		goto	set_99

;-----------------------------
set_call
		movfw	TempData
		andlw	0x0f
		movwf	COUNT2
set_call_80
		call	CheckRxBuffer	
		addlw	0
		btfss	STATUS,Z
		goto	set_99
set_call_81
		Page10
		call	GetRxBuffer
		Page01
		movwf	TempData
						; flag 0
		movfw	C005PNT				
		btfss	STATUS,Z
		goto	set_call_01
		incf	C005PNT,f
		goto	set_call_95
set_call_01				; flag 1
		movfw	C005PNT
		xorlw	0x01
		btfss	STATUS,Z
		goto	set_call_02
		incf	C005PNT,f
		goto	set_call_95
set_call_02				; flag 2
		movfw	C005PNT
		xorlw	0x02
		btfss	STATUS,Z
		goto	set_call_10
		incf	C005PNT,f
		movlw	0x08
		movwf	POINT
		Page13
		movlw	b'10010100'
		CALL	LCD_CMD_4
		Page31
		movlw	RPT2CallSign
		movwf	temp_c0
		goto	set_call_95
set_call_10
		movfw	C005PNT
		xorlw	0x03
		btfss	STATUS,Z
		goto	set_call_20
							; RPT2
		BANKISEL	RPT2CallSign
		movf	temp_c0,W
		movwf	FSR
		movf	TempData,W
		movwf	INDF
		Page13
		call	LCD_DATA_4
		Page31
		incf	temp_c0,f
		decfsz	POINT,f
		goto	set_call_95
		incf	C005PNT,f
		movlw	0x08
		movwf	POINT
		Page13
		movlw	B'10011110'
		call	LCD_CMD_4
		Page31
		movlw	RPT1CallSign
		movwf	temp_c0
		goto	set_call_95
set_call_20
		movfw	C005PNT
		xorlw	0x04
		btfss	STATUS,Z
		goto	set_call_30
					; RPT1
		BANKISEL	RPT1CallSign
		movf	temp_c0,W
		movwf	FSR
		movf	TempData,W
		movwf	INDF
		Page13
		call	LCD_DATA_4
		Page31
		incf	temp_c0,f
		decfsz	POINT,f
		goto	set_call_95
		incf	C005PNT,f
		movlw	0x08
		movwf	POINT
		Page13		
		movlw	b'11000000'		; Line2 Called
		call	LCD_CMD_4
		Page31
		goto	set_call_95
set_call_30
		movfw	C005PNT
		xorlw	0x05
		btfss	STATUS,Z
		goto	set_call_40
					; called
		movfw	TempData
		Page13
		call	LCD_DATA_4
		Page31
		decfsz	POINT,f
		goto	set_call_95
		incf	C005PNT,f
		movlw	0x08
		movwf	POINT		
		Page13
		movlw	b'10000000'		; Line1 Caller
		call	LCD_CMD_4
		Page31
		movlw	CallerCallSign
		movwf	temp_c0
		goto	set_call_95
set_call_40
		movfw	C005PNT
		xorlw	0x06
		btfss	STATUS,Z
		goto	set_call_50
					; caller
		BANKISEL	CallerCallSign
		movf	temp_c0,W
		movwf	FSR
		movf	TempData,W
		movwf	INDF
		Page13
		call	LCD_DATA_4
		Page31
		btfss	Flags,AllSpaces
		goto	set_call_41
		movfw	TempData
		xorlw	" "
		btfss	STATUS,Z
		bcf		Flags,AllSpaces
set_call_41
		incf	temp_c0,F
		decfsz	POINT,f
		goto	set_call_95
		incf	C005PNT,f
		movlw	B'10001000'	; Line 1 and Charecter 8
		Page13
		call	LCD_CMD_4
		movlw	" "
		call	LCD_DATA_4
		Page31
		bsf		Flags,AllSpaces
		movlw	0x04
		movwf	POINT
		goto	set_call_95
;
set_call_50
		movfw	C005PNT
		xorlw	0x07
		btfss	STATUS,Z
		goto	set_call_60
					; called
		movfw	TempData
		Page13
		call	LCD_DATA_4
		Page31
		movfw	TempData
		xorlw	" "
		btfss	STATUS,Z
		bcf		Flags,AllSpaces
		decfsz	POINT,F
		goto	set_call_95
		incf	C005PNT,f
		btfsc	Flags,AllSpaces
		goto	set_call_95
		movlw	B'10001000'	; Line 1 and Charecter 8
		Page13
		call	LCD_CMD_4
		movlw	"/"
		call	LCD_DATA_4
		Page31
		goto	set_call_95
set_call_60
		incf	C005PNT,f
		movfw	C005PNT
		xorlw	0x0a
		btfss	STATUS,Z
		goto	set_call_95
		clrf	C005PNT
		goto	set_99
;
set_call_95
		decfsz	COUNT2,F
		goto	set_call_80
		goto	set_99
		
;------------------------------------
; 0xc1   ACK for  message send
set_c1
		call	CheckRxBuffer	
		addlw	0
		btfss	STATUS,Z
		goto	set_99
		Page10
		call	GetRxBuffer
		Page01
		addlw	0
		btfsc	STATUS,Z
		decf	msg_no,f
set_c1_99
		goto	set_99
		

;-----------------
; 0xc2   ??????????
set_c2
		goto	set_99
		

;---------------
; 0xc9			read baud rate of slow data
set_c9
		Page13
		movlw	b'11010100'
		call	LCD_CMD_4
		Page31

		call	CheckRxBuffer	
		addlw	0
		btfss	STATUS,Z
		goto	set_99
		Page10
		call	GetRxBuffer
		Page01
		xorlw	0x01
		btfsc	STATUS,Z
		goto	set_c9_00
		Page13
		call	Disp9600
		Page31
		goto	set_c9_01
set_c9_00	
		Page13
		call	Disp4800
		Page31
set_c9_01
		goto	set_99


;---------------
; 0xd1			read GPS filter
set_d1
		Page13
		movlw	b'11011001'
		call	LCD_CMD_4
		Page31

		call	CheckRxBuffer	
		addlw	0
		btfss	STATUS,Z
		goto	set_99
		Page10
		call	GetRxBuffer
		Page3
		call	DispHex2Dec
		Page31
		goto	set_99


;---------------------------------------
; 0xd2	 GPS Message read
set_d2
		Page13
		call	ClearLCD
		movlw	B'11000000'	; Line 2 0 Message
		CALL	LCD_CMD_4
		Page31
		movlw	.20
		movwf	COUNT2
set_d2_00
		call	CheckRxBuffer	
		addlw	0
		btfss	STATUS,Z
		goto	set_99
		Page10
		call	GetRxBuffer
		Page3
		call	LCD_DATA_4
		Page31
		decfsz	COUNT2,F
		goto	set_d2_00


		movlw		low TxMessage
		movwf		temp
		movlw		.20
		movwf		COUNT2
		Page13
		movlw		b'10010100'		; Line3 0
		call		LCD_CMD_4
		Page31
set_d2_01
		movf		temp,w
		incf		temp,f
		Page3
		call		EEPROM_Read
		call		LCD_DATA_4
		Page31
		decfsz		COUNT2,F
		goto		set_d2_01
		goto		set_03_00

;---------------------------
; 0xd3
set_d3
		goto	set_99

;---------------------------
; 0xd4
set_d4
		goto	set_99

;---------------------------
; 0xd5
set_d5
		goto	set_99

;---------------------------
; 0xd6
set_d6
		goto	set_99

;---------------------------
; 0xd7
set_d7
		goto	set_99

;---------------------------
; 0xd7
set_d9
		clrf	C005PNT
		goto	set_99

;---------------------------
; 0xd7
set_da
		clrf	C005PNT
		goto	set_99


;--------------------------
; 0xdb		RX callsign "/" set
set_db
		movlw	B'10001000'	; Line 1 and Charecter 8
		btfsc	Flags,DebugDisp
		movlw	B'11001000'
		Page13
		call	LCD_CMD_4
		movlw	" "
		call	LCD_DATA_4
		Page31
		bsf		Flags,AllSpaces
		movlw	0x04
		movwf	COUNT2
set_db_00
		call	CheckRxBuffer	
		addlw	0
		btfss	STATUS,Z
		goto	set_98
		Page10
		call	GetRxBuffer	;get data from receive buffer
		movwf	TempData
		Page3
		call	LCD_DATA_4
		Page31
		movfw	TempData
		xorlw	" "
		btfss	STATUS,Z
		bcf		Flags,AllSpaces
		decfsz	COUNT2,F
		goto	set_db_00
		btfsc	Flags,AllSpaces
		goto	set_98
		movlw	B'10001000'	; Line 1 and Charecter 8
		btfsc	Flags,DebugDisp
		movlw	B'11001000'
set_db_02
		Page13
		call	LCD_CMD_4
		movlw	"/"
		call	LCD_DATA_4
		Page31
		goto	set_98


;---------------------------------------
; 0xdc		TX callsign "/" set
set_dc
		Page13
		movlw	B'10001000'	; Line 1 and Charecter 8
		call	LCD_CMD_4
		movlw	" "
		call	LCD_DATA_4
		Page31
		bsf		Flags,AllSpaces
		movlw	0x04
		movwf	COUNT2
set_dc_00
		call	CheckRxBuffer	
		addlw	0
		btfss	STATUS,Z
		goto	set_99
		Page10
		call	GetRxBuffer	;get data from receive buffer
		movwf	TempData
		Page3
		call	LCD_DATA_4
		Page31
		movfw	TempData
		xorlw	" "
		btfss	STATUS,Z
		bcf		Flags,AllSpaces
		decfsz	COUNT2,F
		goto	set_dc_00
		btfsc	Flags,AllSpaces
		goto	set_99
		Page13
		movlw	B'10001000'	; Line 1 and Charecter 8
		call	LCD_CMD_4
		movlw	"/"
		call	LCD_DATA_4
		Page31
		goto	set_99

set_98
		bcf		Flags,DebugDisp
set_99
		clrf	sw
		return

;----------------------------------------------------------------------------
; 0xcf
set_cf
		Page13
		movlw	b'11010100'	; Line4 0  Duplex
		CALL	LCD_CMD_4
		Page31
						; Duplex
		call	CheckRxBuffer	
		addlw	0
		btfss	STATUS,Z
		goto	set_99
		Page10
		call	GetRxBuffer
		Page01
		xorlw	0x01
		btfss	STATUS,Z
		goto	set_cf_01
		Page13
		call	DispOn
		Page31
		goto	set_99
set_cf_01
		Page13
		call	DispOff
		Page31
		goto	set_99


;------------------------------
;  NG
set_fa
		movlw	0xff
		movwf	resp
		decfsz	ReTryCnt,f
		goto	set_99
		clrf	resp
		clrf	command
		Page13
		call	ReadNoRetry
		Page31
		goto	set_99
;------------------------------
;  ACK
set_fb
		decf	resp,f
		Page13
		call	ReadNoRetry
		Page31
		goto	set_99

;- - - - - - 
;
;--------------------------
;
MenuSet0f
		Page13
		call		MenuDisp4
		call		ReadTxDelayTime
		movwf		NumericTemp
		call		NumericSet
		Page31
		addlw		0
		btfsc		STATUS,Z
		goto		MenuSet0f_20			; back
		sublw		0x01
		btfss		STATUS,Z
		goto		MenuSet0f_10			; cancel(PTT)
		movfw		NumericTemp				; Nornmal

		movwf		temp
		Page3
		call		Confirm
		Page1
		addlw		0
		btfsc		STATUS,Z
		goto		MenuSet0f_00
		sublw		1
		btfss		STATUS,Z
		goto		MenuSet0f_10
		movfw		temp
		movwf		EEPROM_DATA
		movlw		low TxDelay
		movwf		EEPROM_ADDR
		Page13
		call		EEPROM_Write
		Page31
MenuSet0f_20
		Page2
		goto		MenuDispFirst

MenuSet0f_00
		Page13
		call		ClearLCD
		Page31
		return

MenuSet0f_10								; normal
		Page2
		goto		MenuBack_00
		
;-
;--------------------------
;
MenuSet10
		Page13
		call		MenuDisp4
		call		ReadDCD
		movwf		NumericTemp
		call		DCD_Set
		Page31
		addlw		0
		btfsc		STATUS,Z
		goto		MenuSet10_00
		sublw		0x01
		btfss		STATUS,Z
		goto		MenuSet10_10
		movfw		NumericTemp
		Page13
		call		WriteDCD
		Page31
		addlw		0
		btfsc		STATUS,Z
		return
		sublw		0x01
		btfss		STATUS,Z
		goto		MenuSet10_10
		return
MenuSet10_00
		Page2
		goto	MenuDispFirst
MenuSet10_10
		Page2
		goto	MenuBack_00


;-----------------------------------
Maint_01
		bsf		Flags,MaintMode
		MOVLW	B'10000000'
		Page13
		CALL	LCD_CMD_4
		Page31
		clrf	POINT
		incf	POINT,F
		movlw	.19
		movwf	COUNT1

Maint_05
		movfw	POINT
		movwf	COUNT
		pageselw	EEPROMWriteMsg
		movlw	low EEPROMWriteMsg
		addwf	COUNT,w
		btfsc	STATUS,C
		incf	PCLATH,f
		call	EEPROMWriteMsg
		Page13
		CALL	LCD_DATA_4
		Page31
		INCF	POINT,F
		decfsz	COUNT1,f
		goto	Maint_05
		
Maint_10
		call	Maint_GetRxBuffer
		xorlw	":"
		btfss	STATUS,Z
		goto	Maint_10
		clrf	temp		; clear sum check area
;		length chack
		call	Maint_Hex2Dec
		movwf	COUNT2
;		address check
		call	Maint_Hex2Dec
		movwf	I2CaddrHigh
		call	Maint_Hex2Dec
		movwf	I2CaddrLow
;		data chack
		call	Maint_Hex2Dec
		addlw	0
		btfsc	STATUS,Z
		goto	Maint_15
		sublw	0x01			; check end
		btfss	STATUS,Z
		goto	Maint_ACK
		goto	Maint_end
Maint_15
		movfw	COUNT2

		btfsc	STATUS,Z
		goto	Maint_10
		Page3
		movlw	b'10010100'
		call	LCD_CMD_4
		Page1
		movfw	I2CaddrHigh
		call	Disp_HEX
		movfw	I2CaddrLow
		call	Disp_HEX
Maint_20						; data store
		call	Maint_Hex2Dec
		movwf	TempData
		Page3
		call	ByteWrite
		Page1
		incf	I2CaddrLow,f
		btfsc	STATUS,Z
		incf	I2CaddrHigh,f
		decfsz	COUNT2,f
		goto	Maint_20

;       SumCheck 
		movfw	temp
		call	Maint_Hex2Dec
		movfw	temp
		btfss	STATUS,Z
		goto	Maint_ReSendReq
Maint_ACK
		movlw	"A"
		call	Maint_putchar
		movlw	"C"
		call	Maint_putchar
		movlw	"K"
		call	Maint_putchar
		movlw	0x0a
		call	Maint_putchar
		goto	Maint_10

Maint_GetRxBuffer
		btfss	PORTD,back
		goto	Maint_end
		btfsc	Flags,RxBufEmpty ;check if Rx buffer is empty
		goto	Maint_GetRxBuffer
		Page10
		call	GetRxBuffer
		Page01
		return


Maint_putchar
		btfsc		TXBUSY
		goto		$-1
		Page0
		call	putchar
		Page1
		return

Maint_ReSendReq
		movlw	"N"
		call	Maint_putchar
		movlw	"A"
		call	Maint_putchar
		movlw	"K"
		call	Maint_putchar
		movlw	0x0a
		call	Maint_putchar
		goto	Maint_10

Maint_end
		movlw	"A"
		call	Maint_putchar
		movlw	"C"
		call	Maint_putchar
		movlw	"K"
		call	Maint_putchar
		movlw	0x0a
		call	Maint_putchar
		Page0
		clrf	PCLATH
		clrf	PCL


Maint_Hex2Dec
		call	Maint_GetRxBuffer
		movwf	TempData
		andlw	0xf0
		xorlw	0x30
		btfss	STATUS,Z
		goto	Maint_alpha
		movfw	TempData
		andlw	0x0f
		movwf	temp2
		goto	Maint_Hex2Dec_00
Maint_alpha
		movfw	TempData
		andlw	0x0f
		movwf	temp2
		movlw	0x09		
		addwf	temp2,f
Maint_Hex2Dec_00
		swapf	temp2,f		
		call	Maint_GetRxBuffer
		movwf	TempData
		andlw	0xf0
		xorlw	0x30
		btfss	STATUS,Z
		goto	Maint_alpha_1
		movfw	TempData
		andlw	0x0f
		iorwf	temp2,f
		goto	Maint_Hex2Dec_01
Maint_alpha_1
		movfw	TempData
		andlw	0x0f
		iorwf	temp2,f
		movlw	0x09		
		addwf	temp2,f
Maint_Hex2Dec_01
		movfw	temp2
		addwf	temp,f
		return		
		
Disp_HEX
		movwf	TempData
		swapf	TempData,w
		andlw	0x0f
		iorlw	0x30
		movwf	temp2
		sublw	0x39
		btfsc	STATUS,C
		goto	Disp_HEX_00
		movlw	0x07
		addwf	temp2,f
Disp_HEX_00
		movfw	temp2
		Page3
		call	LCD_DATA_4
		Page1
		movfw	TempData
		andlw	0x0f
		iorlw	0x30
		movwf	temp2
		sublw	0x39
		btfsc	STATUS,C
		goto	Disp_HEX_05
		movlw	0x07
		addwf	temp2,f
Disp_HEX_05
		movfw	temp2
		Page3
		call	LCD_DATA_4
		Page1
		return


EEPROMWriteMsg
		movwf	PCL
		dt		EEPROMWriteMSG

dsql_set
		incf	dsql_sw,f
		movf	dsql_sw,w
		xorlw	0x05
		btfsc	STATUS,Z
		clrf	dsql_sw
		Page3
		call	WriteDSQL
		Page0						
		call	DSQLset
		Page1
		incf	resp,f
		return

;-----------------------------------
DSQLSnd_1
		movfw		resp
		xorlw		0x40
		btfss		STATUS,Z
		goto		DSQLSnd_00
		Page10
		call		DSQLset
		Page01
		clrf		resp
		incf		resp,f
DSQLSnd_00
		movfw		resp
		btfsc		STATUS,Z
		goto		DSQLSnd_01
		xorlw		0xff		; NG ?
		btfss		STATUS,Z
		goto		DSQLSnd_99
		clrf		resp
		Page10		
		call		DSQLset
		Page01
		incf		resp,f
		goto		DSQLSnd_99
DSQLSnd_01
		bcf			Flags3,DsqlSet_Sw
		clrf		command
DSQLSnd_99
		Page0
		goto		MainLoop00


;=================================  PAGE 2 ============================
		org		0x1000				;	page 2
;----------------------------------------------------------------------------
; Menu Display
MenuDisp
;		Bank0
		Page23
		call	ClearLCD
		Page32
MenuDisp_00
		Page23
		call	TactSW
		Page32
		btfss	portd_s,back
		goto	MenuBack
		btfss	portd_s,enter
		goto	MenuEnter
		btfss	portd_s,up
		call	MenuPntUp
		btfss	portd_s,down
		call	MenuPntDown
		btfss	PORTA,From_Mic_PTT	; if PTT on, back to main loop
		goto	MenuBack_00	
		goto	MenuDispFirst


MenuDisp_M
		clrf	POINT
		incf	POINT,F
		movlw	.20
		movwf	COUNT2
MenuDisp_M_00
		movfw	POINT
		movwf	COUNT
		pageselw	MenuFirst
		movlw	low MenuFirst
		addwf	COUNT,w
		btfsc	STATUS,C
		incf	PCLATH,f
		call	MenuFirst
		Page23
		call	LCD_DATA_4
		Page32
		INCF	POINT,F
		decfsz	COUNT2,f
		goto	MenuDisp_M_00
		Page23
		MOVLW	B'11000000'
		CALL	LCD_CMD_4
		Page32
		clrf	POINT
		incf	POINT,F
		movlw	.20
		movwf	COUNT2
MenuDisp_M_02
		movfw	POINT
		movwf	COUNT
		pageselw	Menu0e
		movlw	low Menu0e
		addwf	COUNT,w
		btfsc	STATUS,C
		incf	PCLATH,f
		call	Menu0e
		Page23
		CALL	LCD_DATA_4
		Page32
		INCF	POINT,F
		decfsz	COUNT2,F
		goto	MenuDisp_M_02
MenuDisp_M_03
		movlw	0x0e	
		movwf	MenuPointer
		goto	MenuEnter	

MenuBack_00
		bsf		Flags2,MenuCancel
MenuBack
		Page23
		call	ClearLCD
		return

MenuDispFirst
		Page23
		MOVLW	B'10000000'
		CALL	LCD_CMD_4
		movlw	b'00001100'
		call	LCD_CMD_4
		Page32
		clrf	POINT
		incf	POINT,F
		movlw	.20
		movwf	COUNT2
MenuDispFirst_00
		movfw	POINT
		movwf	COUNT
		pageselw	MenuFirst
		movlw	low MenuFirst
		addwf	COUNT,w
		btfsc	STATUS,C
		incf	PCLATH,f
		call	MenuFirst
		Page23
		call	LCD_DATA_4
		Page32
		INCF	POINT,F
		decfsz	COUNT2,f
		goto	MenuDispFirst_00
		Page23
		MOVLW	B'11000000'
		CALL	LCD_CMD_4
		Page32
		movlw	.20
		movwf	COUNT2
		clrf	POINT
		incf	POINT,F
		movfw	MenuPointer
		pageselw JumpTable
		movlw 	low JumpTable
		addwf 	MenuPointer,w
		btfsc 	STATUS,C
		incf 	PCLATH,f
		movwf	PCL
JumpTable
		goto	MenuDisp00				
		goto	MenuDisp01
		goto	MenuDisp02
		goto	MenuDisp03
		goto	MenuDisp04
		goto	MenuDisp05
		goto	MenuDisp06
		goto	MenuDisp07
		goto	MenuDisp08
		goto	MenuDisp09
		goto	MenuDisp0a
		goto	MenuDisp0b
		goto	MenuDisp0c
		goto	MenuDisp0d
		goto	MenuDisp0e
		goto	MenuDisp0f
		goto	MenuDisp10
		goto	MenuDisp11
		goto	MenuDisp12
		goto	MenuDisp13
		goto	MenuDisp14
		goto	MenuDisp15
		goto	MenuDisp16
		goto	MenuDisp17
		goto	MenuDisp18
;----------------------------------
MenuDisp00						; My callsign
		movfw		POINT
		movwf		COUNT
		pageselw	Menu_MyCall
		movlw	low Menu_MyCall
		addwf		COUNT,w
		btfsc		STATUS,C
		incf		PCLATH,f
		call		Menu_MyCall
		Page23
		CALL		LCD_DATA_4
		Page32
		INCF		POINT,F
		decfsz		COUNT2,f
		goto		MenuDisp00
		call		MenuPntSet8
		movlw		low myCallSign
		movwf		temp
MenuDisp00_02_0
		movlw	TempCallSign
		movwf	temp2
MenuDisp00_02
;		Bank0
		movf		temp,w
		incf		temp,f
		Page3
		call		EEPROM_Read
		Page2
		movwf		TempData
		BANKISEL	TempCallSign
		movfw		temp2
		movwf		FSR
		movfw		TempData
		movwf		INDF
		incf		temp2,f
		Page23
		call		LCD_DATA_4
		Page32
		decfsz		COUNT,F
		goto		MenuDisp00_02
		btfss		Flags2,GpsMsgSet
		goto		MenuDisp_00
		Page23
		call		DispSpace3
		Page32
		goto		MenuDisp_00
		

;-----------------------------
MenuDisp01					; your callsign
		movfw	POINT
		movwf	COUNT
		pageselw Menu_YourCall
		movlw	low Menu_YourCall
		addwf	COUNT,w
		btfsc	STATUS,C
		incf	PCLATH,f
		call	Menu_YourCall
		Page23
		CALL	LCD_DATA_4
		Page32
		INCF	POINT,F
		decfsz	COUNT2,F
		goto	MenuDisp01
		call		MenuPntSet8
		movlw		yourCallSign
		movwf		temp
		goto		MenuDisp00_02_0

;
;------------------------------------------
MenuDisp02				; RCW
		movfw	POINT
		movwf	COUNT
		pageselw	Menu02
		movlw	low Menu02
		addwf	COUNT,w
		btfsc	STATUS,C
		incf	PCLATH,f
		call	Menu02
		Page23
		CALL	LCD_DATA_4
		Page32
		INCF	POINT,F
		decfsz	COUNT2,f
		goto	MenuDisp02
MenuDisp02_01
		Page23
		call	Disp4Clear
		call	MenuDisp3
		Page32
		btfss	AdDefault,RCW_OnOff
		goto	MenuDispOff
MenuDispOn
		Page23
		call	DispOn
		Page32
		goto	MenuDisp_00
MenuDispOff
		Page23
		call	DispOff
		Page32
		goto	MenuDisp_00


;----------------------------------------
MenuDisp03					; RRW
		movfw	POINT
		movwf	COUNT
		pageselw	Menu03
		movlw	low Menu03
		addwf	COUNT,w
		btfsc	STATUS,C
		incf	PCLATH,f
		call	Menu03
		Page23
		CALL	LCD_DATA_4
		Page32
		INCF	POINT,F
		decfsz	COUNT2,F
		goto	MenuDisp03
		Page23
		call	Disp4Clear
		call	MenuDisp3
		Page32
		btfss	AdDefault,RRW_OnOff
		goto	MenuDispOff
		goto	MenuDispOn


;------------------------------------
MenuDisp04
		movfw	POINT
		movwf	COUNT
		pageselw	Menu04
		movlw	low Menu04
		addwf	COUNT,w
		btfsc	STATUS,C
		incf	PCLATH,f
		call	Menu04
		Page23
		CALL	LCD_DATA_4
		Page32
		INCF	POINT,F
		decfsz	COUNT2,f
		goto	MenuDisp04
		Page23
		call	Disp4Clear
		call	MenuDisp3
		Page32
		btfss	AdDefault,Duplex_OnOff
		goto	MenuDispOff
		goto	MenuDispOn


;---------------------------------
MenuDisp05					; RPT1
		movfw	POINT
		movwf	COUNT
		pageselw	Menu05
		movlw	low Menu05
		addwf	COUNT,w
		btfsc	STATUS,C
		incf	PCLATH,f
		call	Menu05
		Page23
		CALL	LCD_DATA_4
		Page32
		INCF	POINT,F
		decfsz	COUNT2,f
		goto	MenuDisp05
		call		MenuPntSet8
		movlw		low RPT1
		movwf		temp
		goto		MenuDisp00_02_0
;
;-------------------------------------

MenuDisp06					; RPT2
		movfw	POINT
		movwf	COUNT
		pageselw	Menu06
		movlw	low Menu06
		addwf	COUNT,w
		btfsc	STATUS,C
		incf	PCLATH,f
		call	Menu05
		Page23
		CALL	LCD_DATA_4
		Page32
		INCF	POINT,F
		decfsz	COUNT2,f
		goto	MenuDisp06
		call		MenuPntSet8
		movlw		low RPT2
		movwf		temp
		goto		MenuDisp00_02_0
;
;---------------------------------

MenuDisp07					; GPS filter
		movfw	POINT
		movwf	COUNT
		pageselw	Menu07
		movlw	low Menu07
		addwf	COUNT,w
		btfsc	STATUS,C
		incf	PCLATH,f
		call	Menu07
		Page23
		CALL	LCD_DATA_4
		Page32
		INCF	POINT,F
		decfsz	COUNT2,f
		goto	MenuDisp07
		Page23
		call	Disp4Clear
		call	MenuDisp3
		call	ReadGPS
		call	DispHex2Dec
		call	DispSpace5
		Page32
		goto	MenuDisp_00

;----------------------------------

MenuDisp08					; / callsign 2
		movfw	POINT
		movwf	COUNT
		pageselw	Menu08
		movlw	low Menu08
		addwf	COUNT,w
		btfsc	STATUS,C
		incf	PCLATH,f
		call	Menu08
		Page23
		CALL	LCD_DATA_4
		Page32
		INCF	POINT,F
		decfsz	COUNT2,f
		goto	MenuDisp08
		call	MenuPntSet4
		movlw		myCallSign2
		movwf		temp
		goto	MenuDisp00_02_0


;----------------------------

MenuDisp09					; Message
		bcf		Flags2,GpsMsgSet
		movfw	POINT
		movwf	COUNT
		pageselw	Menu09
		movlw	low Menu09
		addwf	COUNT,w
		btfsc	STATUS,C
		incf	PCLATH,f
		call	Menu09
		Page23
		CALL	LCD_DATA_4
		Page32
		INCF	POINT,F
		decfsz	COUNT2,f
		goto	MenuDisp09
		call	MenuPntSet20
		movlw		low TxMessage
		movwf		temp
		goto		MenuDisp00_02_0
;
;-----------------------------

MenuDisp0a
		movfw	POINT
		movwf	COUNT
		pageselw	Menu0a
		movlw	low Menu0a
		addwf	COUNT,w
		btfsc	STATUS,C
		incf	PCLATH,f
		call	Menu0a
		Page23
		CALL	LCD_DATA_4
		Page32
		INCF	POINT,F
		decfsz	COUNT2,f
		goto	MenuDisp0a
		Page23
		call	Disp4Clear
		call	MenuDisp3
		Page32
		btfss	AdDefault,MSGSend_OnOff
		goto	MenuDispOff
		goto	MenuDispOn

;------------------------------

MenuDisp0b
		movfw	POINT
		movwf	COUNT
		pageselw	Menu0b
		movlw	low Menu0b
		addwf	COUNT,w
		btfsc	STATUS,C
		incf	PCLATH,f
		call	Menu0b
		Page23
		CALL	LCD_DATA_4
		Page32
		INCF	POINT,F
		decfsz	COUNT2,f
		goto	MenuDisp0b
		Page23
		call	Disp4Clear
		call	MenuDisp3
		call	ReadMsgSndInterval
		call	DispHex2Dec
		call	Disp_Sec
		Page32
		goto	MenuDisp_00

;--------------------------------

MenuDisp0c
		movfw	POINT
		movwf	COUNT
		pageselw	Menu0c
		movlw	low Menu0c
		addwf	COUNT,w
		btfsc	STATUS,C
		incf	PCLATH,f
		call	Menu0c
		Page23
		CALL	LCD_DATA_4
		Page32
		INCF	POINT,F
		decfsz	COUNT2,f
		goto	MenuDisp0c
MenuDisp0c_01
		Page23
		call	Disp4Clear
		call	MenuDisp3
		call	ReadNoRetry
		call	DispHex2Dec
		call	DispSpace5	
		Page32
		goto	MenuDisp_00


;--------------------------------

MenuDisp0d
		movfw	POINT
		movwf	COUNT
		pageselw	Menu0d
		movlw	low Menu0d
		addwf	COUNT,w
		btfsc	STATUS,C
		incf	PCLATH,f
		call	Menu0d
		Page23
		CALL	LCD_DATA_4
		Page32
		INCF	POINT,F
		decfsz	COUNT2,f
		goto	MenuDisp0d
		Page23
		call	Disp4Clear
		call	MenuDisp3
		Page32
		btfss	AdDefault2,SlowData96
		goto	MenuDisp0d_02
		Page23
		call	Disp9600
		Page32
		goto	MenuDisp_00
MenuDisp0d_02
		Page23
		call	Disp4800
		Page32
		goto	MenuDisp_00


;------------------------------
MenuDisp0e
		movfw	POINT
		movwf	COUNT
		pageselw	Menu0e
		movlw	low Menu0e
		addwf	COUNT,w
		btfsc	STATUS,C
		incf	PCLATH,f
		call	Menu0e
		Page23
		CALL	LCD_DATA_4
		Page32
		INCF	POINT,F
		decfsz	COUNT2,f
		goto	MenuDisp0e
		Page23
		call	Disp3Clear
		Page32
		goto	MenuDisp_00

;---------------------------------
MenuDisp0f					; Tx Delay Time
		movfw	POINT
		movwf	COUNT
		pageselw	Menu0f
		movlw	low Menu0f
		addwf	COUNT,w
		btfsc	STATUS,C
		incf	PCLATH,f
		call	Menu0f
		Page23
		CALL	LCD_DATA_4
		Page32
		INCF	POINT,F
		decfsz	COUNT2,f
		goto	MenuDisp0f
		Page23
		call	Disp4Clear
		call	MenuDisp3
		call	ReadTxDelayTime
		call	DispHex2Dec
		call	Disp_mSec
		Page32
		goto	MenuDisp_00

;
;---------------------------------

MenuDisp10					; DCD set
		movfw	POINT
		movwf	COUNT
		pageselw	Menu10
		movlw	low Menu10
		addwf	COUNT,w
		btfsc	STATUS,C
		incf	PCLATH,f
		call	Menu10
		Page23
		CALL	LCD_DATA_4
		Page32
		INCF	POINT,F
		decfsz	COUNT2,f
		goto	MenuDisp10
		Page23
		call	Disp4Clear
		call	MenuDisp3
		call	ReadDCD
		call	DispHex2Dec
		call	DispSpace5
		Page32
		goto	MenuDisp_00

;
;---------------------------------

MenuDisp11					; Reset
		movfw	POINT
		movwf	COUNT
		pageselw	Menu11
		movlw	low Menu11
		addwf	COUNT,w
		btfsc	STATUS,C
		incf	PCLATH,f
		call	Menu11
		Page23
		CALL	LCD_DATA_4
		Page32
		INCF	POINT,F
		decfsz	COUNT2,f
		goto	MenuDisp11
		Page23
		call	Disp3Clear
		call	Disp4Clear
		Page32
		goto	MenuDisp_00

;
;--------------------------------------
MenuDisp12
		movfw	POINT
		movwf	COUNT
		pageselw	Menu12
		movlw	low Menu12
		addwf	COUNT,w
		btfsc	STATUS,C
		incf	PCLATH,f
		call	Menu12
		Page23
		CALL	LCD_DATA_4
		Page32
		INCF	POINT,F
		decfsz	COUNT2,f
		goto	MenuDisp12
		Page23
		call	Disp4Clear
		call	MenuDisp3
		Page32
		btfss	AdDefault2,Debug
		goto	MenuDispOff
		goto	MenuDispOn

;--------------------------------------
;
MenuDisp13
		movfw	POINT
		movwf	COUNT
		pageselw	Menu13
		movlw	low Menu13
		addwf	COUNT,w
		btfsc	STATUS,C
		incf	PCLATH,f
		call	Menu13
		Page23
		CALL	LCD_DATA_4
		Page32
		INCF	POINT,F
		decfsz	COUNT2,f
		goto	MenuDisp13
		Page23
		call	Disp4Clear
		call	MenuDisp3
		Page32
		btfss	AdDefault,GPSDisplay
		goto	MenuDispOff
		goto	MenuDispOn


;--------------------------------------
;
MenuDisp14
		movfw	POINT
		movwf	COUNT
		pageselw	Menu14
		movlw	low Menu14
		addwf	COUNT,w
		btfsc	STATUS,C
		incf	PCLATH,f
		call	Menu14
		Page23
		CALL	LCD_DATA_4
		Page32
		INCF	POINT,F
		decfsz	COUNT2,F
		goto	MenuDisp14
		Page23
		call	Disp4Clear
		call	MenuDisp3
		Page32
		btfss	AdDefault,AutoDuplex
		goto	MenuDispOff
		goto	MenuDispOn


;------------------
MenuDisp15
		movfw	POINT
		movwf	COUNT
		pageselw	Menu15
		movlw	low Menu15
		addwf	COUNT,w
		btfsc	STATUS,C
		incf	PCLATH,f
		call	Menu15
		Page23
		CALL	LCD_DATA_4
		Page32
		INCF	POINT,F
		decfsz	COUNT2,F
		goto	MenuDisp15
		Page23
		call	Disp4Clear
		call	MenuDisp3
		Page32
		btfss	AdDefault,PTTLock
		goto	MenuDispOff
		goto	MenuDispOn


;------------------   Beep
MenuDisp16
		movfw	POINT
		movwf	COUNT
		pageselw	Menu16
		movlw	low Menu16
		addwf	COUNT,w
		btfsc	STATUS,C
		incf	PCLATH,f
		call	Menu16
		Page23
		CALL	LCD_DATA_4
		Page32
		INCF	POINT,F
		decfsz	COUNT2,F
		goto	MenuDisp16
		Page23
		call	Disp4Clear
		call	MenuDisp3
		Page32
		btfss	AdDefault2,BeepOnOff
		goto	MenuDispOff
		goto	MenuDispOn

;------------------
MenuDisp17
		movfw	POINT
		movwf	COUNT
		pageselw	Menu_DRS
		movlw	low Menu_DRS
		addwf	COUNT,w
		btfsc	STATUS,C
		incf	PCLATH,f
		call	Menu_DRS
		Page23
		CALL	LCD_DATA_4
		Page32
		INCF	POINT,F
		decfsz	COUNT2,F
		goto	MenuDisp17
		Page23
		call	Disp4Clear
		call	MenuDisp3
		Page32
		btfss	AdDefault,DRS_OnOff
		goto	MenuDispOff
		goto	MenuDispOn


;----------------------------

MenuDisp18					; GPS Message
		bsf		Flags2,GpsMsgSet
		movfw	POINT
		movwf	COUNT
		pageselw	Menu_GPS_Msg
		movlw	low Menu_GPS_Msg
		addwf	COUNT,w
		btfsc	STATUS,C
		incf	PCLATH,f
		call	Menu_GPS_Msg
		Page23
		CALL	LCD_DATA_4
		Page32
		INCF	POINT,F
		decfsz	COUNT2,f
		goto	MenuDisp18
		call	MenuPntSet20
		movlw	.17
		movwf	COUNT

		movlw		low GpsMessage
		movwf		temp
		goto		MenuDisp00_02_0



MenuPntSet4
		Page23
		call	Disp4Clear
		call	Disp3Clear
		call	MenuDisp3
		Page32
		movlw	.4
		movwf	COUNT
		return

MenuPntSet8
		Page23
		call	Disp4Clear
		call	Disp3Clear
		call	MenuDisp3
		Page32
		movlw	.8
		movwf	COUNT
		return

MenuPntSet20
		Page23
		call	Disp4Clear
		movlw	B'10010100'
		call	LCD_CMD_4
		movlw	b'00001110'
		call	LCD_CMD_4
		Page32
		movlw	.20
		movwf	COUNT
		return


;--------------------------------------

MenuPntUp
		incf	MenuPointer,F
		movfw	MenuPointer
		xorlw	MaxMenu
		btfss	STATUS,Z
		return
		clrf	MenuPointer
		return

MenuPntDown
		movfw	MenuPointer
		btfsc	STATUS,Z
		goto	MenuPntDown_10
		decf	MenuPointer,F
		return
MenuPntDown_10
		movlw	MaxMenu - 1
		movwf	MenuPointer
		return
;
;-----------------------------------------------------------
; Menu
MenuFirst
		movwf	PCL
		dt		MenuFirst_MSG		;  menu
Menu_MyCall
		movwf	PCL
		dt		Menu_MyCall_MSG		; MYC
Menu_YourCall
		movwf	PCL
		dt		Menu_YourCall_MSG	; YUC (Station call)
Menu02
		movwf	PCL
		dt		Menu02_MSG			; RCW
Menu03
		movwf	PCL
		dt		Menu03_MSG			; RRW
Menu04
		movwf	PCL
		dt		Menu04_MSG			; Duplex
Menu05
		movwf	PCL
		dt		Menu05_MSG			; RPT1
Menu06
		movwf	PCL
		dt		Menu06_MSG			; RPT2
Menu07
		movwf	PCL
		dt		Menu07_MSG			; gps
Menu08
		movwf	PCL
		dt		Menu08_MSG			; callsign2
Menu09
		movwf	PCL
		dt		Menu09_MSG			; message
Menu0a
		movwf	PCL
		dt		Menu0a_MSG			; message on/off
Menu0b
		movwf	PCL
		dt		Menu0b_MSG			; interval of sending message
Menu0c
		movwf	PCL
		dt		Menu0c_MSG			; retry
Menu0d
		movwf	PCL
		dt		Menu0d_MSG			; slow data speed(baud rate)
Menu0e
		movwf	PCL
		dt		Menu0e_MSG			; memory read
Menu0f
		movwf	PCL
		dt		Menu0f_MSG			; tx delay  x 10m sec.
Menu10
		movwf	PCL
		dt		Menu10_MSG			; DCD

Menu11
		movwf	PCL
		dt		Menu11_MSG			; reset

Menu12
		movwf	PCL
		dt		Menu12_MSG			; debug

Menu13
		movwf	PCL
		dt		Menu13_MSG			; GPS Display

Menu14
		movwf	PCL
		dt		Menu14_MSG			; Auto duplex set

Menu15
		movwf	PCL
		dt		Menu15_MSG			; PTT Lock

Menu16
		movwf	PCL
		dt		Menu16_MSG			; Beep On/Off

Menu_DRS
		movwf	PCL
		dt		Menu_DRS_MSG			; DRS On/Off

Menu_GPS_Msg
		movwf	PCL
		dt		Menu_GPS_MSG			; GPS Message

;
;------------------------------------------
;
MenuEnter
		movfw	MenuPointer
		pageselw SetTable
		movlw 	low SetTable
		addwf 	MenuPointer,w
		btfsc 	STATUS,C
		incf 	PCLATH,f
		movwf	PCL
SetTable
		goto	MenuSet00				
		goto	MenuSet01
		goto	MenuSet02
		goto	MenuSet03
		goto	MenuSet04
		goto	MenuSet05
		goto	MenuSet06
		goto	MenuSet07
		goto	MenuSet08
		goto	MenuSet09_3
		goto	MenuSet0a_3
		goto	MenuSet0b_3
		goto	MenuSet0c_3
		goto	MenuSet0d_3
		goto	MenuSet0e
		goto	MenuSet0f_1
		goto	MenuSet10_1
		goto	MenuSet11_3
		goto	MenuSet12_3
		goto	MenuSet13_3
		goto	MenuSet14_3
		goto	MenuSet15_3
		goto	MenuSet16_3
		goto	MenuSet17_3
		goto	MenuSet18_3

;-------------------------------------
; Mycallsign
MenuSet00
		Page23
		call		MenuDisp4
		movlw		b'00001110'
		call		LCD_CMD_4
		call		AlphaSet
		Page32
		addlw		0
		btfsc		STATUS,Z
		goto		MenuDispFirst
		sublw		1
		btfss		STATUS,Z
		goto		MenuBack_00
MyCallSet
		Page23
		call		Confirm
		Page32
		addlw		0
		btfsc		STATUS,Z
		goto		MenuDispFirst
		sublw		1
		btfss		STATUS,Z
		goto		MenuBack_00
		clrf		POINT
		movlw		0x08
		movwf		COUNT1
MyCallSet_00
		BANKISEL	TempCallSign
		movlw		TempCallSign
		movwf		temp
		movfw		POINT
		addwf		temp,w
		movwf		FSR
		movfw		INDF
		movwf		EEPROM_DATA
		movlw		low myCallSign
		addwf		POINT,w
		movwf		EEPROM_ADDR
		Page23
		call		EEPROM_Write
		Page32
		incf		POINT,f
		decfsz		COUNT1,F
		goto		MyCallSet_00
		Bank0
		bsf			Flags3,Display_Sw
		movlw		0x06
		movwf		command
		movlw		0x40
		movwf		resp
		return

;--------------------------------
; your callsign
MenuSet01
		bsf			Flags3,YourCallFlag
		Page23
		call		MenuDisp4
		movlw		b'00001110'
		call		LCD_CMD_4
		call		AlphaSet
		Page32
		bcf			Flags3,YourCallFlag
		addlw		0
		btfsc		STATUS,Z
		goto		MenuDispFirst
		sublw		1
		btfss		STATUS,Z
		goto		MenuBack_00
YourCallSet
		Page23
		call		Confirm
		Page32
		addlw		0
		btfsc		STATUS,Z
		goto		MenuDispFirst
		sublw		1
		btfss		STATUS,Z
		goto		MenuBack_00
		clrf		POINT
		movlw		0x08
		movwf		COUNT1
YourCallSet_00
		BANKISEL	TempCallSign
		movlw		TempCallSign
		movwf		temp
		movfw		POINT
		addwf		temp,w
		movwf		FSR
		movfw		INDF
		movwf		EEPROM_DATA
		movlw		low yourCallSign
		addwf		POINT,w
		movwf		EEPROM_ADDR
		Page23
		call		EEPROM_Write
		Page32
		incf		POINT,f
		decfsz		COUNT1,F
		goto		YourCallSet_00
		bsf			Flags3,Display_Sw
		Page23
		call		EEpromYourCall
		Page32
		movlw		0x07
		movwf		command
		movlw		0x40
		movwf		resp
		return


;-----------------------------------
; RCW
MenuSet02
		Page23
		call	MenuDisp4
		movlw	B'11100000'
		call	LCD_CMD_4
		Page32
		btfss	AdDefault,RCW_OnOff
		goto	MenuSet02_02
		Page23
		call	DispOn
		Page32
		goto	MenuSet02_03
MenuSet02_02
		Page23
		call	DispOff
		Page32
MenuSet02_03
		Page23
		call	TactSW
		Page32
		btfsc	portd_s,up				; On
		goto	MenuSet02_04
		bsf		AdDefault,RCW_OnOff
		goto	MenuSet02
MenuSet02_04
		btfsc	portd_s,down				; Off
		goto	MenuSet02_05
		bcf		AdDefault,RCW_OnOff
		goto	MenuSet02
MenuSet02_05
		btfsc	portd_s,back
		goto	MenuSet02_06
ReadOptions_000
		Page23
		call	ReadOptions
		Page32
		goto	MenuDispFirst
MenuSet02_06
		btfsc	portd_s,enter
		goto	MenuSet02_07
WriteOptions_000
		Page23
		call	WriteOptions
		Page32
		goto	MenuDispFirst
MenuSet02_07
		btfss	PORTA,From_Mic_PTT
		goto	MenuBack_00
		goto	MenuSet02

;------------------------
; RRW
MenuSet03
		Page23
		call	MenuDisp4
		Page32
MenuSet03_00
		btfss	AdDefault,RRW_OnOff
		goto	MenuSet03_02
		Page23
		call	DispOn
		Page32
		goto	MenuSet03_03
MenuSet03_02
		Page23
		call	DispOff
		Page32
MenuSet03_03
		Page23
		call	TactSW
		Page32
		btfsc	portd_s,up				; On
		goto	MenuSet03_04
		bsf		AdDefault,RRW_OnOff
		goto	MenuSet03
MenuSet03_04
		btfsc	portd_s,down				; Off
		goto	MenuSet03_05
		bcf		AdDefault,RRW_OnOff
		goto	MenuSet03
MenuSet03_05
		btfsc	portd_s,back
		goto	MenuSet03_06
		goto	ReadOptions_000
MenuSet03_06
		btfsc	portd_s,enter
		goto	MenuSet03_07
		goto	WriteOptions_000
MenuSet03_07
		btfss	PORTA,From_Mic_PTT
		goto	MenuBack_00
		goto	MenuSet03


;----------------------------------
; Duplex
MenuSet04
		Page23
		call	MenuDisp4
		Page32
MenuSet04_00
		btfss	AdDefault,Duplex_OnOff
		goto	MenuSet04_02
		Page23
		call	DispOn
		Page32
		goto	MenuSet04_03
MenuSet04_02
		Page23
		call	DispOff
		Page32
MenuSet04_03
		Page23
		call	TactSW
		Page32
		btfsc	portd_s,up				; On
		goto	MenuSet04_04
		bsf		AdDefault,Duplex_OnOff
		goto	MenuSet04
MenuSet04_04
		btfsc	portd_s,down				; Off
		goto	MenuSet04_05
		bcf		AdDefault,Duplex_OnOff
		goto	MenuSet04
MenuSet04_05
		btfsc	portd_s,back
		goto	MenuSet04_06
		Page23
		call	ReadOptions
		Page32
		goto	MenuDispFirst
MenuSet04_06
		btfsc	portd_s,enter
		goto	MenuSet04_07
		Page23
		call	WriteOptions
		Page32
		bsf		Flags3,Display_Sw
		movlw		0x40
		movwf		resp
		movlw		0x0a
		movwf		command
		return
MenuSet04_07
		btfsc	PORTA,From_Mic_PTT
		goto	MenuSet04
		goto	MenuBack_00
;-----------------------------------------
; RPT1
MenuSet05
		Page23
		call		MenuDisp4
		movlw		b'00001110'
		call		LCD_CMD_4
		call		AlphaSet
		Page32
		addlw		0
		btfsc		STATUS,Z
		goto		MenuDispFirst
		sublw		1
		btfss		STATUS,Z
		goto		MenuBack_00
RPT1CallSet
		Page23
		call	Confirm
		Page32
		addlw	0
		btfsc	STATUS,Z
		goto	MenuDispFirst
		sublw		1
		btfss		STATUS,Z
		goto		MenuBack_00
		clrf	POINT
		movlw	0x08
		movwf	COUNT1
RPT1CallSet_00
		BANKISEL	TempCallSign
		movlw		TempCallSign
		movwf		temp
		movfw		POINT
		addwf		temp,w
		movwf		FSR
		movfw		INDF
		movwf		EEPROM_DATA
		movlw		low RPT1
		addwf		POINT,w
		movwf		EEPROM_ADDR
		Page23
		call		EEPROM_Write
		Page32
		incf		POINT,f
		decfsz		COUNT1,F
		goto		RPT1CallSet_00
		bsf			Flags3,Display_Sw
		Page23
		call		EEpromYourCall
		Page32
		movlw		0x07
		movwf		command
		movlw		0x40
		movwf		resp
		return

;-------------------------------
; RPT2
MenuSet06
		Page23
		call		MenuDisp4
		movlw		b'00001110'
		call		LCD_CMD_4
		call		AlphaSet
		Page32
		addlw		0
		btfsc		STATUS,Z
		goto		MenuDispFirst
		sublw		1
		btfss		STATUS,Z
		goto		MenuBack_00
RPT2CallSet
		Page23
		call	Confirm
		Page32
		addlw	0
		btfsc	STATUS,Z
		goto	MenuDispFirst
		sublw		1
		btfss		STATUS,Z
		goto		MenuBack_00
		clrf	POINT
		movlw	0x08
		movwf	COUNT1
RPT2CallSet_00
		BANKISEL	TempCallSign
		movlw		TempCallSign
		movwf		temp
		movfw		POINT
		addwf		temp,w
		movwf		FSR
		movfw		INDF
		movwf		EEPROM_DATA
		movlw		low RPT2
		addwf		POINT,w
		movwf		EEPROM_ADDR
		Page23
		call		EEPROM_Write
		Page32
		incf		POINT,f
		decfsz		COUNT1,F
		goto		RPT2CallSet_00
		bsf			Flags3,Display_Sw
		Page23
		call		EEpromYourCall
		Page32
		movlw		0x07
		movwf		command
		movlw		0x40
		movwf		resp
		return


;-------------------------------

MenuSet07
		Page23
		call		MenuDisp4
		movlw		low GPS_Filter
		call		EEPROM_Read
		movwf		NumericTemp
		call		GPS_FilterSet
		Page32
		addlw		0
		btfsc		STATUS,Z
		goto		MenuSet07_99
		movfw		NumericTemp
		Page23
		call		WriteGPS
		Page32
		addlw		0
		btfsc		STATUS,Z
		return
MenuSet07_99
		sublw		0x01
		btfss		STATUS,Z
		goto		MenuBack_00
		goto		MenuDispFirst

;------------------------------------

MenuSet08
		Page23
		call		MenuDisp4
		movlw		b'00001110'
		call		LCD_CMD_4
		call		Alpha2Set
		Page32
		addlw		0
		btfss		STATUS,Z
		call		Call2Set
		return

Call2Set
		Page23
		call	Confirm
		Page32
		addlw	0
		btfsc	STATUS,Z
		goto	MenuDispFirst
		sublw		1
		btfss		STATUS,Z
		goto		MenuBack_00
		clrf	POINT
		movlw	0x04
		movwf	COUNT1
Call2Set_00
		BANKISEL	TempCallSign
		movlw		TempCallSign
		movwf		temp
		movfw		POINT
		addwf		temp,w
		movwf		FSR
		movfw		INDF
		movwf		EEPROM_DATA
		movlw		low myCallSign2
		addwf		POINT,w
		movwf		EEPROM_ADDR
		Page23
		call		EEPROM_Write
		Page32
		incf		POINT,f
		decfsz		COUNT1,F
		goto		Call2Set_00
		bsf			Flags3,Display_Sw
		movlw		0x08
		movwf		command
		movlw		0x40
		movwf		resp
		return

;-----------------------------

MenuSet09_3
		Page23
		goto	MenuSet09

;-------------------------

MenuSet0a_3
		Page23
		goto	MenuSet0a



MenuSet0b_3
		Page23
		goto	MenuSet0b

	
MenuSet0c_3
		Page23
		goto	MenuSet0c


;-------------------------
MenuSet0d_3
		Page23
		goto	MenuSet0d

;-------------------------
MenuSet0e
		call	MenuSet0e_0
		btfss	PORTA,From_Mic_PTT
		goto	MenuBack_00
		Page23
		call	TactSW
		Page32
		btfss	portd_s,up
		call	Set0eUp
		btfss	portd_s,down
		call	Set0eDown
;--
		Page23
		call	PorteSW
		Page32
		btfss	porte_s,M1
		call	M1Set
		btfss	porte_s,M2
		call	M2Set
		btfss	porte_s,M3
		call	M3Set
;--
		btfsc	portd_s,enter
		goto	MenuSet0e_60
		Page23
		call	Set0eEnter
		Page32
		addlw	0
		btfsc	STATUS,Z
		return
		goto	MenuSet0e
MenuSet0e_60
		btfsc	portd_s,back
		goto	MenuSet0e
		Page23
		call	Disp4Clear
		Page32
		goto	MenuDispFirst

Set0eUp
		movlw	.42
		addwf	I2CPNTlow,f
		btfsc	STATUS,C
		incf	I2CPNThigh,f

		movfw	I2CPNTlow
		movwf	I2CaddrLow
		movfw	I2CPNThigh
		movwf	I2CaddrHigh
		Page23
		call		ByteRead		
		Page32
		movfw		datai
		btfss		STATUS,Z
		goto		Set0eUp_00
		clrf		I2CPNThigh
		clrf		I2CPNTlow
Set0eUp_00
		Page23
		movlw		b'11100110'
		call		LCD_CMD_4
		movlw		" "
		call		LCD_DATA_4
		movlw		" "
		call		LCD_DATA_4
		Page32
		return


Set0eDown
		movfw	I2CPNTlow
		addlw	0
		btfss	STATUS,Z
		goto	Set0eDown_00
		movfw	I2CPNThigh
		addlw	0
		btfss	STATUS,Z
		goto	Set0eDown_00
		movlw	0xff
		movwf	I2CaddrHigh
		movlw	0xfe
		movwf	I2CaddrLow
		Page23
		call		ByteRead		
		movfw		datai
		movwf	I2CPNThigh
		movlw	0xff
		movwf	I2CaddrLow
		call		ByteRead
		Page32		
		movfw		datai
		movwf	I2CPNTlow
Set0eDown_00
		movlw	.42
		subwf	I2CPNTlow,f
		btfss	STATUS,C
		decf	I2CPNThigh,f
		Page23
		movlw		b'11100110'
		call		LCD_CMD_4
		movlw		" "
		call		LCD_DATA_4
		movlw		" "
		call		LCD_DATA_4
		Page32
		return


MenuSet0e_0
		movfw		I2CPNTlow
		movwf		I2CaddrLow
		movfw		I2CPNThigh
		movwf		I2CaddrHigh
		Page23
		movlw		b'10001100'
		call		LCD_CMD_4
		Page32
		movlw		0x08
		movwf		COUNT
MenuSet0e_00						; name
		Page23
		call		ByteRead		
		movfw		datai
		call		LCD_DATA_4
		Page32
		incf		I2CaddrLow,f
		btfsc		STATUS,Z
		incf		I2CaddrHigh,f
		decfsz		COUNT,F
		goto		MenuSet0e_00

		Page23
		movlw		b'10010100'
		call		LCD_CMD_4
		Page32

		movlw		MemCallerCallSign
		call		SMemCallRead


		Page23
		movlw		b'11010100'
		call		LCD_CMD_4
		Page32

		movlw		MemRPT1CallSign
		call		SMemCallRead		; RPT1

		Page23
		movlw		b'11011110'
		call		LCD_CMD_4
		Page32

		movlw		MemRPT2CallSign
		call		SMemCallRead		; RPT2


;----------------  read DSQL/CSQL
		Page23
		call		ByteRead
		Page32
		BANKISEL	MemDSQL
		movlw		MemDSQL
		movwf		FSR
		movfw		datai
		movwf		INDF
		Page23
		call		DSQL_disp
		Page32
		incf		I2CaddrLow,f
		btfsc		STATUS,Z
		incf		I2CaddrHigh,f
;---------------  read DCD
		Page23
		call		ByteRead
		Page32
		BANKISEL	MemDCD
		movlw		MemDCD
		movwf		FSR
		movfw		datai
		movwf		INDF
		Page23
		call		DCD_disp
		Page32
		incf		I2CaddrLow,f
		btfsc		STATUS,Z
		incf		I2CaddrHigh,f
;-------------------------------

		Page23
		movlw		b'10011110'
		call		LCD_CMD_4
		Page32
		movlw		0x08
		movwf		COUNT
MenuSet0e_04
		Page23
		call		ByteRead		
		movfw		datai
		call		LCD_DATA_4
		Page32
		incf		I2CaddrLow,f
		btfsc		STATUS,Z
		incf		I2CaddrHigh,f
		decfsz		COUNT,F
		goto		MenuSet0e_04
		return

SMemCallRead
		movwf		temp2
		movlw		0x08
		movwf		COUNT
MenuSet0e_01					; your call, RPT1 RPT2
		Page23
		call		ByteRead		
		movfw		datai
		call		LCD_DATA_4
		Page32
		BANKISEL	MemRPT2CallSign
		movfw		temp2
		movwf		FSR
		movfw		datai
		movwf		INDF
		incf		temp2,f
		incf		I2CaddrLow,f
		btfsc		STATUS,Z
		incf		I2CaddrHigh,f
		decfsz		COUNT,F
		goto		MenuSet0e_01
		return
		

MenuSet0f_1
		Page1
		goto		MenuSet0f

;-------------------------------

MenuSet10_1
		Page1
		goto		MenuSet10

;-------------------------------

MenuSet11_3
		Page23
		goto		MenuSet11

;------------------------------------
MenuSet12_3
		Page23
		goto		MenuSet12

;------------------------------------
MenuSet13_3
		Page23
		goto		MenuSet13

;------------------------------------
MenuSet14_3
		Page23
		goto		MenuSet14


;------------------------------------
MenuSet15_3
		Page23
		goto		MenuSet15


;------------------------------------
MenuSet16_3
		Page23
		goto		MenuSet16

;------------------------------------
MenuSet17_3
		Page23
		goto		MenuSet17

;------------------------------------
MenuSet18_3
		Page23
		goto		MenuSet18

;------------------------------------

M1Set
		Page23
		call	M1Set_3
		Page32
		return

M2Set
		Page23
		call	M2Set_3
		Page32
		return


M3Set
		Page23
		call	M3Set_3
		Page32
		return


;====================================  PAGE 3 ===================

			org		0x1800

;***********************************************************
; LCD initilize routine
;***********************************************************
LCD_INI
		CALL	TIME10M
		CALL	TIME10M
		MOVLW	B'00110000'
		CALL	LCD_CMD
		
		CALL	TIME10M
		MOVLW	B'00110000'
		CALL	LCD_CMD

		CALL	TIME100
		MOVLW	B'00110000'
		CALL	LCD_CMD

		CALL	TIME100
		MOVLW	B'00100000'
		CALL	LCD_CMD

		call	TIME10M
		CALL	LCD_BUSY_4
		MOVLW	B'00101000'
		CALL	LCD_CMD_4

		MOVLW	B'00001100'
		CALL	LCD_CMD_4

		MOVLW	B'00000001'
		CALL	LCD_CMD_4

		MOVLW	B'00000110'
		CALL	LCD_CMD_4

		RETURN


;----------------------------------------------------------------------------
;
LCD_FirstDisplay
		MOVLW	B'00001100'	; display:on cursor:off
		CALL	LCD_CMD_4

		
TEXT_OUT1					; Line 1
		MOVLW	B'10000000'
		CALL	LCD_CMD_4
		CLRF	POINT
		INCF	POINT,F
ROW_1
		movfw	POINT
		movwf	COUNT
		pageselw TABLE
		movlw	low TABLE
		addwf	COUNT,w
		btfsc	STATUS,C
		incf	PCLATH,f
		call	TABLE
		addlw	0
		btfsc	STATUS,Z
		GOTO	TEXT_OUT3
		CALL	LCD_DATA_4
		INCF	POINT,F
		GOTO	ROW_1

TEXT_OUT3					; Line 3
		INCF	POINT,F
		MOVLW	B'10010100'
		CALL	LCD_CMD_4
ROW_3						; Line 3
		movfw	POINT
		movwf	COUNT
		pageselw	TABLE
		movlw	low TABLE
		addwf	COUNT,w
		btfsc	STATUS,C
		incf	PCLATH,f
		call	TABLE
		addlw	0
		BTFSC	STATUS,Z
		GOTO	TEXT_OUT4
		CALL	LCD_DATA_4
		INCF	POINT,F
		GOTO	ROW_3



TEXT_OUT4					; line 4
		INCF	POINT,F
		MOVLW	B'11010100'	; Line 4
		CALL	LCD_CMD_4
ROW_4						; Line 4
		movfw	POINT
		movwf	COUNT
		pageselw TABLE
		movlw	low TABLE
		addwf	COUNT,w
		btfsc	STATUS,C
		incf	PCLATH,f
		call	TABLE
		addlw	0
		BTFSC	STATUS,Z
		return
		CALL	LCD_DATA_4
		INCF	POINT,F
		GOTO	ROW_4

;***********************************************************
; LCD DISPLAY
;***********************************************************
LCD_DATA_4			; 4bit mode
		btfsc	Flags3,Display_Sw
		return
		movwf	DPDT_W
		call	LCD_BUSY_4
		movfw	DPDT_W
		ANDLW	0xf0
		CALL	LCD_DATA
		SWAPF	DPDT_W,W
		ANDLW	0xf0
		CALL	LCD_DATA
		RETURN

LCD_DATA
		MOVWF	PORTB
		BCF		PORTB,LCD_RW
		BSF		PORTB,LCD_RS
		BSF		PORTB,LCD_E
		NOP
		BCF		PORTB,LCD_E
		RETURN


;***********************************************************
; LCD COMMAND
;***********************************************************
LCD_CMD_4			; 4 bit mode
		btfsc	Flags3,Display_Sw
		return
		movwf	DPDT_W
		call	LCD_BUSY_4
		movfw	DPDT_W
		ANDLW	0xf0
		CALL	LCD_CMD
		SWAPF	DPDT_W,W
		ANDLW	0xf0
		CALL	LCD_CMD
		RETURN

LCD_CMD				;
		MOVWF	PORTB
		BCF	PORTB,LCD_RW
		BCF	PORTB,LCD_RS
		BSF	PORTB,LCD_E
		NOP
		BCF	PORTB,LCD_E
		RETURN

;***********************************************************
; BUSY Check
;***********************************************************
LCD_BUSY_4
		btfsc	Flags3,Display_Sw
		return
		clrf	PORTB
		BSF		STATUS,RP0			; bank1
		MOVLW	0xf8
		MOVWF	TRISB
		BCF		STATUS,RP0			; bank0
		BCF		PORTB,LCD_RS
		nop
		BSF		PORTB,LCD_RW
		nop
		BSF		PORTB,LCD_E
		MOVF	PORTB,W
		BCF		PORTB,LCD_E
		MOVWF	DPDT

		BSF		PORTB,LCD_E
 		MOVF	PORTB,W
		BCF		PORTB,LCD_E
   		BTFSC	DPDT,LCD_BUSY_F
		GOTO	LCD_BUSY_4
		BCF		PORTB,LCD_RW
		BSF		STATUS,RP0
		movlw	0x08
		movwf	TRISB
		BCF		STATUS,RP0
		RETURN

;		YourCall move from EEPROM to RAM (move to Current)
EEpromYourCall
		movlw	CurrentRPT2CallSign
		movwf	POINT
		movlw	low TxCallSign
		movwf	temp 
		movlw	.24
		movwf	COUNT
yourCall_00
;		Bank0
		movf		temp,w
		call		EEPROM_Read
		movwf		TempData
		BANKISEL	CurrentRPT2CallSign
		movf	POINT,W	;get EndPointer
		movwf	FSR		;and place into FSR
		movf	TempData,W	;get BufferData
		movwf	INDF		;store in PRT1 in Bank3
		incf	POINT,f
		incf	temp,f
		decfsz	COUNT,F
		goto		yourCall_00
		return

ReadOptions
;		Flag move from EEPROM to RAM
		movlw		low EEPAdDefault
		call		EEPROM_Read
		movwf		AdDefault
		return

ReadOptions2
;		Flag move from EEPROM to RAM
		movlw		low EEPAdDefault2
		call		EEPROM_Read
		movwf		AdDefault2
		return




WriteOptions
;		Flag move from RAM to EEPROM
		call		Confirm
		addlw		0
		btfss		STATUS,Z
		goto		WriteOptions_00
		call		ReadOptions
		return
WriteOptions_00
;		Bank0
		sublw		1
		btfss		STATUS,Z
		goto		MenuBack_00_00
		movfw		AdDefault
		movwf		EEPROM_DATA
		movlw		low EEPAdDefault
		movwf		EEPROM_ADDR
		call		EEPROM_Write
		return


WriteOptions2
;		Flag move from RAM to EEPROM
		call		Confirm
		addlw		0
		btfss		STATUS,Z
		goto		WriteOptions2_00
		call		ReadOptions2
		return
WriteOptions2_00
;		Bank0
		sublw		1
		btfss		STATUS,Z
		goto		MenuBack_00_00
		movfw		AdDefault2
		movwf		EEPROM_DATA
		movlw		low EEPAdDefault2
		movwf		EEPROM_ADDR
		call		EEPROM_Write
		return



ReadNoRetry
;		Flag move from EEPROM to RAM
		movlw		low NoRetry
		call		EEPROM_Read
		movwf		ReTryCnt
		return


WriteNoRetry
;		Flag move from RAM to EEPROM
		movwf	temp
		call	Confirm
		addlw	0
		btfss	STATUS,Z
		goto	WriteNoRetry_00
		call	ReadNoRetry
		return
WriteNoRetry_00
		sublw		1
		btfss		STATUS,Z
		goto		MenuBack_00_00
		movfw		temp
		movwf		EEPROM_DATA
		movlw		low NoRetry
		movwf		EEPROM_ADDR
		call		EEPROM_Write
		return

;***********************************************************
; delay routine
;***********************************************************

;100micro sec. delay i19.6608MHzj

TIME100
		MOVLW	0xa2
		MOVWF	COUNT
		NOP
		NOP
LOOP
		DECFSZ	COUNT,F
		GOTO	LOOP
		RETURN


TIME60M
		call	TIME10M
		call	TIME10M
		call	TIME10M
		call	TIME10M
		call	TIME10M
		call	TIME10M
		return

; 10 m sec. delay (19.6608MHz)
TIME10M
		MOVLW	0x64
		MOVWF	COUNT1
		NOP
		NOP
LOOP1
		CALL	TIME100
		DECFSZ	COUNT1,F
		GOTO	LOOP1
		RETURN



;*******************Initialization subroutine*********************
;           This routine initializes the MSSP module
;           for I2C Master mode, with a 100 kHz clock.
;*****************************************************************
I2CInit
;		Bank1
    	bsf     STATUS,RP0          ; Select Bank 1
;  		movlw   b'11111001'
;    	movwf   TRISC               ; Set PORTC to all inputs
    	clrf    SSPSTAT             ; Disable SMBus inputs
    	bsf     SSPSTAT,SMP         ; Disable slew rate control
    	movlw   0x31                ; Load 0x31 into WREG
    	movwf   SSPADD              ; Setup 100 kHz I2C clock
    	clrf    SSPCON2             ; Clear control bits
    	bcf     STATUS,RP0          ; Select Bank 00
    	movlw   b'00101000'
    	movwf   SSPCON              ; Enable SSP, select I2C Master mode
    	bcf     PIR1,SSPIF          ; Clear SSP interrupt flag
    	bcf     PIR2,BCLIF          ; Clear Bit Collision flag


		clrf	I2CaddrHigh
		clrf	I2CaddrLow
		clrf	I2CPNTlow
		clrf	I2CPNThigh

		return

;----------------------------------------------------------------------------
;Set up serial port and buffers.

SetupSerial:
		Bank1			;select bank 1
;		movlw	0xc9		;set tris bits for TX and RX
;		movwf	TRISC
		movlw	SPBRG_VAL	;set baud rate
		movwf	SPBRG
		movlw	0x20		;enable transmission and high baud rate
		movwf	TXSTA
		Bank10			;select bank0
		movlw	0x90		;enable serial port and reception
		movwf	RCSTA
		clrf	Flags		;clear all flag bits
		Page0
		call	InitTxBuffer	;initialize transmit buffer
		call	InitRxBuffer	;initialize receive buffer
		Page3
		movlw	0xc0		;enable global and peripheral ints
		movwf	INTCON
		Bank01			;select bank1
		movlw	0x30		;enable TX and RX interrupts
		movwf	PIE1
		Bank10
		return

ClearLCD
		bsf		Flags,FirstDisp
		MOVLW	B'00000001'
		CALL	LCD_CMD_4
		MOVLW	B'00000110'
		CALL	LCD_CMD_4
		MOVLW	B'00001100'
		CALL	LCD_CMD_4

		RETURN


;
;----------------------------------------------------------
;
TABLE
		movwf	PCL
		DT	"DVadapter "
		DT	VersionInfo
#if Language == 1		; English
		DT	"E",0
#endif
#if	Language == 2		; German
		DT	"G",0
#endif
#if Language == 0		; Japanese
		DT	"J",0
#endif
#if	Release == 0
		DT	" (C) Satoshi Yasuda",0
#else
		DT	"  (C) Satoshi Yasuda",0
#endif
		DT	"        7M3TJZ/AD6GZ",0

;---------------------


ReadTxDelayTime
		movlw		low TxDelay
		call		EEPROM_Read
		return

;-------------------------------
ReadMsgSndInterval
		movlw		low MsgSndInterval
		call		EEPROM_Read
		return

;-------------------------------
WriteMsgSndInterval
		movwf	temp
		call	Confirm
		addlw	0
		btfss	STATUS,Z
		goto	WriteMsgSndInterval_0
MenuDispFirst_3
		Page2
		goto	MenuDispFirst
WriteMsgSndInterval_0
		sublw		1
		btfss		STATUS,Z
		goto		MenuBack_00_00
		movfw		temp
		movwf		EEPROM_DATA
		movlw		low MsgSndInterval
		movwf		EEPROM_ADDR
		call		EEPROM_Write
		return

;-----------  GPS --------------
ReadGPS
		movlw		low GPS_Filter
		call		EEPROM_Read
		return

WriteGPS
		movwf	temp
		Page3
		call	Confirm
		addlw	0
		btfsc	STATUS,Z
		retlw	0x01
		sublw		1
		btfss		STATUS,Z
		retlw		0x02
		movfw		temp
		movwf		EEPROM_DATA
		movlw		low GPS_Filter
		movwf		EEPROM_ADDR
		call		EEPROM_Write
		bsf			Flags3,Display_Sw
		movlw		0x05
		movwf		command
		movlw		0x40
		movwf		resp
		retlw	0x00

GPS_FilterSet
		call	TactSW
		btfss	portd_s,up
		call	GPS_FilterPntUp
		btfss	portd_s,down
		call	GPS_FilterPntDown
		btfss	portd_s,enter
		retlw	0x01
		btfss	portd_s,back
		retlw	0x00
		btfss	PORTA,From_Mic_PTT
		retlw	0x02
;
		movlw	B'11100000'
		call	LCD_CMD_4
		movfw	NumericTemp
		call	DispHex2Dec
		goto	GPS_FilterSet
;


GPS_FilterPntUp
		incf	NumericTemp,F
		movfw	NumericTemp
		xorlw	.25 + 1
		btfss	STATUS,Z
		return
		clrf	NumericTemp
		return

GPS_FilterPntDown
		decf	NumericTemp,f
		movfw	NumericTemp
		xorlw	0xff
		btfss	STATUS,Z
		return
		movlw	.25
		movwf	NumericTemp
		return



;------------------------
DCD_Set
		call	TactSW
		btfss	portd_s,up
		call	DCD_PntUp
		btfss	portd_s,down
		call	DCD_PntDown
		btfss	portd_s,enter
		retlw	0x01
		btfss	portd_s,back
		retlw	0x00
		btfss	PORTA,From_Mic_PTT
		retlw	0x02

		movlw	B'11100000'
		call	LCD_CMD_4
		movfw	NumericTemp
		call	DispHex2Dec
		goto	DCD_Set


DCD_PntUp
		incf	NumericTemp,F
		movfw	NumericTemp
		xorlw	.99 + 1
		btfss	STATUS,Z
		return
		clrf	NumericTemp
		return


DCD_PntDown
		decf	NumericTemp,f
		movfw	NumericTemp
		xorlw	0xff
		btfss	STATUS,Z
		return
		movlw	.99
		movwf	NumericTemp
		return

;-----------  DCD --------------
ReadDCD
		movlw		low DCDNumber
		call		EEPROM_Read
		return

WriteDCD
		movwf		temp
		Page3
		call		Confirm
		addlw		0
		btfsc		STATUS,Z
		retlw		0x01			; back
		sublw		1
		btfss		STATUS,Z
		retlw		0x02		; ptt back
		movfw		temp
		movwf		EEPROM_DATA
		movlw		low	DCDNumber
		movwf		EEPROM_ADDR
		call		EEPROM_Write
		bsf			Flags3,Display_Sw
		movlw		0x0e
		movwf		command
		movlw		0x40
		movwf		resp
		retlw		0x00


;---------------- DSQL --------------
ReadDSQL
		movlw		low DSQLNumber
		call		EEPROM_Read
		movwf		dsql_sw
		return		

WriteDSQL
		movfw		dsql_sw
		movwf		EEPROM_DATA
		movlw		low	DSQLNumber
		movwf		EEPROM_ADDR
		call		EEPROM_Write
		return


;---------------  EEPROM_Read --------------
EEPROM_Read
		Bank3
		btfsc		EECON1,WR			; check former write process
		goto		$-1
		Bank2
		movwf		EEADR
		Bank23
		bcf			EECON1,EEPGD
		bsf			EECON1,RD
		Bank32
		movf		EEDATA,W
		Bank20
		return


;------------  EEPROM Write ---------------
EEPROM_Write
		Bank3
		btfsc		EECON1,WR
		goto		$-1
		Bank0
		movfw		EEPROM_DATA
		Bank2
		movwf		EEDATA
		Bank0
		movfw		EEPROM_ADDR
		Bank2
		movwf		EEADR
		Bank23
		bcf			EECON1,EEPGD
		bsf			EECON1,WREN
		bcf			INTCON,GIE
		movlw		0x55
		movwf		EECON2
		movlw		0xaa
		movwf		EECON2
		bsf			EECON1,WR
		bsf			INTCON,GIE
		bcf			EECON1,WREN
		Bank0
		return

;------------------------

MenuDisp4
		MOVLW	B'11010100'
		CALL	LCD_CMD_4
MenuDisp99
		clrf	POINT
		incf	POINT,F
MenuDisp99_00
		movfw	POINT
		movwf	COUNT
		pageselw	NewValueMsg
		movlw	low NewValueMsg
		addwf	COUNT,w
		btfsc	STATUS,C
		incf	PCLATH,f
		call	NewValueMsg
		addlw	0
		BTFSC	STATUS,Z
		GOTO	MenuDisp99_01
		CALL	LCD_DATA_4
		INCF	POINT,F
		goto	MenuDisp99_00
MenuDisp99_01
		return

NewValueMsg
		movwf	PCL
		dt		NewValueMSG,0

;----------  Confirm -------

Confirm
		MOVLW	B'11010100'
		CALL	LCD_CMD_4
		clrf	POINT
		incf	POINT,F
		movlw	.20
		movwf	COUNT1

Confirm_00
		movfw	POINT
		movwf	COUNT
		pageselw	ConfirmMsg
		movlw	low ConfirmMsg
		addwf	COUNT,w
		btfsc	STATUS,C
		incf	PCLATH,f
		call	ConfirmMsg
		CALL	LCD_DATA_4
		INCF	POINT,F
		decfsz	COUNT1,f
		goto	Confirm_00

Confirm_01
		call	TactSW
		btfss	portd_s,back
		retlw	0x00
		btfss	portd_s,enter
		retlw	0x01
		btfss	PORTA,From_Mic_PTT
		retlw	0x02
		goto	Confirm_01


ConfirmMsg
		movwf	PCL
		dt		ConfirmMSG

;*******************Start bit subroutine**************************
;           This routine generates a Start condition
;           (high-to-low transition of SDA while SCL
;           is still high.
;*****************************************************************
BSTART
    bcf     STATUS,RP1
    bcf     STATUS,RP0          ; Select Bank 00
    bcf     PIR1,SSPIF          ; Clear SSP interrupt flag
    bsf     STATUS,RP0          ; Select Bank 01
    bsf     SSPCON2,SEN         ; Generate Start condition
    bcf     STATUS,RP0          ; Select Bank 00
bstart_wait
    btfss   PIR1,SSPIF          ; Check if operation completed
    goto    bstart_wait         ; If not, keep checking

    retlw   0


;*******************Restart bit subroutine**************************
;           This routine generates a Repeated Start
;           condition (high-to-low transition of SDA
;           while SCL is still high.
;*****************************************************************
BRESTART
    bcf     STATUS,RP1
    bcf     STATUS,RP0          ; Select Bank 00
    bcf     PIR1,SSPIF          ; Clear SSP interrupt flag
    bsf     STATUS,RP0          ; Select Bank 01
    bsf     SSPCON2,RSEN        ; Generate Restart condition
    bcf     STATUS,RP0          ; Select Bank 00
brestart_wait
    btfss   PIR1,SSPIF          ; Check if operation completed
    goto    brestart_wait       ; If not, keep checking

    retlw   0


;*******************Stop bit subroutine***************************
;           This routine generates a Stop condition
;           (low-to-high transition of SDA while SCL
;           is still high.
;*****************************************************************
BSTOP
    bcf     STATUS,RP1
    bcf     STATUS,RP0          ; Select Bank 00
    bcf     PIR1,SSPIF          ; Clear SSP interrupt flag
    bsf     STATUS,RP0          ; Select Bank 01
    bsf     SSPCON2,PEN         ; Generate Stop condition
    bcf     STATUS,RP0          ; Select Bank 00
bstop_wait
    btfss   PIR1,SSPIF          ; Check if operation completed
    goto    bstop_wait          ; If not, keep checking

    retlw   0


;*******************Data transmit subroutine**********************
;           This routine transmits the byte of data
;           stored in 'datao' to the serial EEPROM
;           device. Instructions are also in place
;           to check for an ACK bit, if desired.
;           Just replace the 'goto' instruction,
;           or create an 'ackfailed' label, to provide
;           the functionality.
;*****************************************************************
TXI2C
    bcf     STATUS,RP1
    bcf     STATUS,RP0          ; Select Bank 00
    bcf     PIR1,SSPIF          ; Clear SSP interrupt flag
    movf    datao,W             ; Copy datao to WREG
    movwf   SSPBUF              ; Write byte out to device
txi2c_wait
    btfss   PIR1,SSPIF          ; Check if operation completed
    goto    txi2c_wait             ; If not, keep checking
;   bsf     STATUS,RP0          ; Select Bank 01
;   btfsc   SSPCON2,ACKSTAT     ; Check if ACK bit was received
;   goto    ackfailed           ; This executes if no ACK received    

    retlw   0


;*******************Data receive subroutine***********************
;           This routine reads in one byte of data from
;           the serial EEPROM device, and stores it in
;           'datai'.  It then responds with either an
;           ACK or a NO ACK bit, depending on the value
;           of 'ACKDT' in 'SSPCON2'.
;*****************************************************************
RXI2C
		bcf		STATUS,RP0			; Bank0
    	bcf     PIR1,SSPIF          ; Clear SSP interrupt flag
		bsf		STATUS,RP0			; Bank1
    	bsf     SSPCON2,RCEN        ; Initiate reception of byte
		bcf		STATUS,RP0			; Bnk0
rxi2c_wait
    	btfss   PIR1,SSPIF          ; Check if operation completed
    	goto    rxi2c_wait             ; If not, keep checking
    	movf    SSPBUF,W            ; Copy byte to WREG
    	movwf   datai               ; Copy WREG to datai
    	bcf     PIR1,SSPIF          ; Clear SSP interrupt flag
		bsf		STATUS,RP0			; Bank1
    	bsf     SSPCON2,ACKEN       ; Generate ACK/NO ACK bit    
		bcf		STATUS,RP0			; Bank0
rxi2c_wait2
   	 	btfss   PIR1,SSPIF          ; Check if operation completed
    	goto    rxi2c_wait2            ; If not, keep checking

    	retlw   0

;*******************Byte read test subroutine*********************
;           This routine tests the byte read feature
;           of the serial EEPROM device. 
;*****************************************************************
ByteRead
    call    BSTART              ; Generate Start condition

                                ; Send control byte
    bcf     STATUS,RP0          ; Select Bank 00
    movlw   WRITE_ADDR          ; Load control byte for write
    movwf   datao               ; Copy to datao for output
    call    TXI2C                  ; Send control byte to device

                                ; Send word address high byte
    bcf     STATUS,RP0          ; Select Bank 00
	movfw	I2CaddrHigh
    movwf   datao               ; Copy to datao for output
    call    TXI2C                  ; Send high byte to device

                                ; Send word address low byte
    bcf     STATUS,RP0          ; Select Bank 00
	movfw	I2CaddrLow
    movwf   datao               ; Copy to datao for output
    call    TXI2C                  ; Send word address to device

    call    BRESTART            ; Generate Restart condition

                                ; Send control byte
    bcf     STATUS,RP0          ; Select Bank 00
    movlw   READ_ADDR           ; Load control byte for read
    movwf   datao               ; Copy to datao for output
    call    TXI2C                  ; Send control byte to device

                                ; Read data byte
    bsf     STATUS,RP0          ; Select Bank 01
    bsf     SSPCON2,ACKDT       ; Select to send NO ACK bit
    call    RXI2C                  ; Read data byte from device

    call    BSTOP               ; Generate Stop condition

    retlw   0

;*******************Byte write test subroutine********************
;           This routine tests the byte write feature
;           of the serial EEPROM device.
;*****************************************************************
ByteWrite
    call    BSTART              ; Generate Start condition
                                ; Send control byte
    bcf     STATUS,RP0          ; Select Bank 00
    movlw   WRITE_ADDR          ; Load control byte for write
    movwf   datao               ; Copy to datao for output
    call    TXI2C                  ; Send control byte to device

                                ; Send word address high byte
    bcf     STATUS,RP0          ; Select Bank 00
    movfw	I2CaddrHigh         ; Load 0x5A for word address
    movwf   datao               ; Copy to datao for output
    call    TXI2C

                                ; Send word address low byte
    bcf     STATUS,RP0          ; Select Bank 00
    movfw   I2CaddrLow
    movwf   datao               ; Copy to datao for output
    call    TXI2C                  ; Send word address to device

                                ; Send data byte
    bcf     STATUS,RP0          ; Select Bank 00
    movfw	TempData
    movwf   datao               ; Copy to datao for output
    call    TXI2C                  ; Send data byte to device

    call    BSTOP               ; Generate Stop condition

    call    PollI2C                ; Poll for write completion

    retlw   0

;*******************Acknowledge Polling subroutine****************
;           This subroutine polls the EEPROM device
;           for an ACK bit, which indicates that the
;           internal write cycle has completed. Code
;           is in place for a timeout routine, just
;           uncomment the 'goto TimedOut' line, and
;           provide a 'TimedOut' label.
;*****************************************************************
PollI2C
    bcf     STATUS,RP0          ; Select Bank 00
    movlw   .40
    movwf   pollcnt             ; Set max polling times to 40
polling
    call    BRESTART            ; Generate start bit
    bcf     STATUS,RP0          ; Select Bank 00
    movlw   WRITE_ADDR          ; Now send the control byte
    movwf   datao               ; Copy control byte to buffer
    call    TXI2C                  ; Output control byte to device
    bsf     STATUS,RP0          ; Select Bank 01
    btfss   SSPCON2,ACKSTAT     ; Was the ACK bit low?
    goto    exitpoll            ; If yes, stop polling
                                ; If no, check if polled 40 times
    bcf     STATUS,RP0          ; Select Bank 00
    decfsz  pollcnt,F           ; Is poll counter down to zero?
    goto    polling             ; If no, poll again
;   goto    TimedOut            ; If yes, part didn't respond
                                ; in time, so take action
exitpoll
    call    BSTOP               ; Generate stop bit
    retlw   0

;-------------------------------------------------
Disp3Clear
		movlw	b'10010100'
		goto	DispClear
Disp4Clear
		MOVLW	B'11010100'
DispClear
		CALL	LCD_CMD_4
		movlw	.20
		movwf	COUNT
Disp4Clear_00
		movlw	" "
		call	LCD_DATA_4
		decfsz	COUNT,F
		goto	Disp4Clear_00
		return


DispOn
		movlw	"O"
		call	LCD_DATA_4
		movlw	"n"
		call	LCD_DATA_4
		movlw	" "
		call	LCD_DATA_4
		goto	lcd_onoff


DispOff
		movlw	"O"
		call	LCD_DATA_4
		movlw	"f"
		call	LCD_DATA_4
		movlw	"f"
		call	LCD_DATA_4
lcd_onoff
		movlw	0x05
		movwf	COUNT
DispOff_00
		movlw	" "
		call	LCD_DATA_4
		decfsz	COUNT,F
		goto	DispOff_00
		return

Disp_mSec
		movlw	"0"
		call	LCD_DATA_4
		movlw	"m"
		call	LCD_DATA_4
		movlw	"S"
		call	LCD_DATA_4
		movlw	"e"
		call	LCD_DATA_4
		movlw	"c"
		call	LCD_DATA_4
		return

Disp_Sec
		movlw	" "
		call	LCD_DATA_4
		movlw	"S"
		call	LCD_DATA_4
		movlw	"e"
		call	LCD_DATA_4
		movlw	"c"
		call	LCD_DATA_4
		movlw	"."
		call	LCD_DATA_4
		return

Disp9600
		movlw	"9"
		call	LCD_DATA_4
		movlw	"6"
		call	LCD_DATA_4
		goto	lcd_4800_00


Disp4800
		movlw	"4"
		call	LCD_DATA_4
		movlw	"8"
		call	LCD_DATA_4
lcd_4800_00
		movlw	"0"
		call	LCD_DATA_4
		movlw	"0"
		call	LCD_DATA_4
		call	DispSpace4
		return



DispSpace5
		movlw	" "
		call	LCD_DATA_4
DispSpace4
		movlw	" "
		call	LCD_DATA_4
DispSpace3
		movlw	" "
		call	LCD_DATA_4
		movlw	" "
		call	LCD_DATA_4
		movlw	" "
		call	LCD_DATA_4
		return

DispHex2Dec
		bcf		Flags,AllSpaces
		movwf	TempData
		movlw	0x30
		movwf	Hex2DecTemp
		movlw	0x64
		subwf	TempData,f			; w - 100 
		btfss	STATUS,C
		goto	Hex2Dec_00
		incf	Hex2DecTemp,f
		movlw	0x64
		subwf	TempData,f
		btfss	STATUS,C
		goto	Hex2Dec_01
		incf	Hex2DecTemp,f
		goto	Hex2Dec_02
Hex2Dec_01
		movlw	0x64
		addwf	TempData,f
Hex2Dec_02
		movfw	Hex2DecTemp
		call	LCD_DATA_4
		goto	Hex2Dec_10
Hex2Dec_00
		movlw	0x64
		addwf	TempData,f
		movlw	" "
		call	LCD_DATA_4
		bsf		Flags,AllSpaces
		goto	Hex2Dec_10
Hex2Dec_10
		movlw	0x30
		movwf	Hex2DecTemp
Hex2Dec_11
		movlw	0x0a
		subwf	TempData,f
		btfss	STATUS,C
		goto	Hex2Dec_20
		incf	Hex2DecTemp,f
		goto	Hex2Dec_11
Hex2Dec_20
		movfw	Hex2DecTemp
		btfss	Flags,AllSpaces
		goto	Hex2Dec_21
		xorlw	0x30
		btfsc	STATUS,Z
		goto	Hex2Dec_22
		movfw	Hex2DecTemp
		goto	Hex2Dec_21
Hex2Dec_22
		movlw	0x20
Hex2Dec_21
		call	LCD_DATA_4
		movlw	0x0a
		addwf	TempData,f
		movfw	TempData
		addlw	0x30
		call	LCD_DATA_4
		return

;=============================================
AlphaSet
		call		DispTempCall8
		MOVLW	B'11100000'
		movwf	LCDPNT

AlphaSet_00
		BANKISEL	TempCallSign
		movlw	TempCallSign
		movwf	temp
		movfw	LCDPNT
		andlw	0x0f
		addwf	temp,w
		movwf	FSR
		movfw	INDF
		movwf	AlphaPNT
		movfw	LCDPNT
		CALL	LCD_CMD_4
		call	TactSW
		btfss	portd_s,up
		call	AlphaPntUp
		btfss	portd_s,down
		call	AlphaPntDown
		btfss	portd_s,enter
		goto	AlphaEnter
		btfss	portd_s,back
		goto	AlphaBack
		btfss	PORTA,From_Mic_PTT
		retlw	0x02
;
		movfw	AlphaPNT
		call	LCD_DATA_4

		BANKISEL	TempCallSign
		movlw	TempCallSign
		movwf	temp
		movfw	LCDPNT
		andlw	0x0f
		addwf	temp,w
		movwf	FSR
		movfw	AlphaPNT
		movwf	INDF
		goto	AlphaSet_00
;
;

AlphaEnter
		incf	LCDPNT,f
		movfw	LCDPNT
		xorlw	b'11101000'
		btfsc	STATUS,Z
		retlw	0x01
		goto	AlphaSet_00

AlphaBack
		decf	LCDPNT,f
		movfw	LCDPNT
		xorlw	B'11011111'
		btfsc	STATUS,Z
		retlw	0x00
		goto	AlphaSet_00


AlphaPntUp
		incf	AlphaPNT,F
		movfw	AlphaPNT
		xorlw	0x21
		btfss	STATUS,Z
		goto	AlphaPntUp_00
		movlw	0x2f
		btfss	Flags3,YourCallFlag
		movlw	0x30
		movwf	AlphaPNT
		return
AlphaPntUp_00
		movfw	AlphaPNT
		xorlw	0x3a
		btfss	STATUS,Z
		goto	AlphaPntUp_01
		movlw	0x41
		movwf	AlphaPNT
		return
AlphaPntUp_01
		movfw	AlphaPNT
		xorlw	0x5b
		btfss	STATUS,Z
		return
		movlw	0x20
		movwf	AlphaPNT
		return

AlphaPntDown
		decf	AlphaPNT,f
		movfw	AlphaPNT
		xorlw	0x1f
		btfss	STATUS,Z
		goto	AlphaPntDown_00
		movlw	0x5a
		movwf	AlphaPNT
		return
AlphaPntDown_00
		movlw	0x2e
		btfss	Flags3,YourCallFlag
		movlw	0x2f
		xorwf	AlphaPNT,w
		btfss	STATUS,Z
		goto	AlphaPntDown_01
		movlw	0x20
		movwf	AlphaPNT
		return
AlphaPntDown_01
		movfw	AlphaPNT
		xorlw	0x40
		btfss	STATUS,Z
		return
		movlw	0x39
		movwf	AlphaPNT
		return


Alpha2Set
		call	DispTempCall4
		MOVLW	B'11100000'
		movwf	LCDPNT

Alpha2Set_00
		BANKISEL	TempCallSign
		movlw	TempCallSign
		movwf	temp
		movfw	LCDPNT
		andlw	0x0f
		addwf	temp,w
		movwf	FSR
		movfw	INDF
		movwf	AlphaPNT
		movfw	LCDPNT
		CALL	LCD_CMD_4
		call	TactSW
		btfss	portd_s,up
		call	Alpha2PntUp
		btfss	portd_s,down
		call	Alpha2PntDown
		btfss	portd_s,enter
		goto	Alpha2Enter
		btfss	portd_s,back
		goto	AlphaBack
		btfss	PORTA,From_Mic_PTT
		retlw	0x02
;

		movfw	AlphaPNT
		call	LCD_DATA_4

		BANKISEL	TempCallSign
		movlw	TempCallSign
		movwf	temp
		movfw	LCDPNT
		andlw	0x0f
		addwf	temp,w
		movwf	FSR
		movfw	AlphaPNT
		movwf	INDF
		goto	Alpha2Set_00
;
;

Alpha2Enter
		incf	LCDPNT,f
		movfw	LCDPNT
		xorlw	b'11100100'
		btfsc	STATUS,Z
		retlw	0x01
		goto	Alpha2Set_00

Alpha2Back
		decf	LCDPNT,f
		movfw	LCDPNT
		xorlw	B'11011111'
		movfw	AlphaPNT
		call	LCD_DATA_4
		btfsc	STATUS,Z
		retlw	0x00
		goto	Alpha2Set_00


Alpha2PntUp
		incf	AlphaPNT,F
		movfw	AlphaPNT
		xorlw	0x21
		btfss	STATUS,Z
		goto	Alpha2PntUp_00
		movlw	0x2f
		movwf	AlphaPNT
		return
Alpha2PntUp_00
		movfw	AlphaPNT
		xorlw	0x3a
		btfss	STATUS,Z
		goto	Alpha2PntUp_01
		movlw	0x41
		movwf	AlphaPNT
		return
Alpha2PntUp_01
		movfw	AlphaPNT
		xorlw	0x5b
		btfss	STATUS,Z
		return
		movlw	0x20
		movwf	AlphaPNT
		return

Alpha2PntDown
		decf	AlphaPNT,f
		movfw	AlphaPNT
		xorlw	0x1f
		btfss	STATUS,Z
		goto	Alpha2PntDown_00
		movlw	0x5a
		movwf	AlphaPNT
		return
Alpha2PntDown_00
		movfw	AlphaPNT
		xorlw	0x2e
		btfss	STATUS,Z
		goto	Alpha2PntDown_01
		movlw	0x20
		movwf	AlphaPNT
		return
Alpha2PntDown_01	
		movfw	AlphaPNT
		xorlw	0x40
		btfss	STATUS,Z
		return
		movlw	0x39
		movwf	AlphaPNT
		return


Alpha3Set
		call	DispTempCall20
		MOVLW	B'11010100'
		movwf	LCDPNT
		clrf	POINT

Alpha3Set_00
		BANKISEL	TempCallSign
		movlw	    TempCallSign
		movwf	temp
		movfw	POINT
		addwf	temp,w
		movwf	FSR
		movfw	INDF
		movwf	AlphaPNT2

		movfw	LCDPNT
		CALL	LCD_CMD_4
		call	TactSW
		btfss	portd_s,up
		call	Alpha3PntUp
		btfss	portd_s,down
		call	Alpha3PntDown
		btfss	portd_s,enter
		goto	Alpha3Enter
		btfss	portd_s,back
		goto	Alpha3Back
		btfss	PORTA,From_Mic_PTT
		retlw	0x02
;

		movfw	AlphaPNT2
		call	LCD_DATA_4

		BANKISEL	TempCallSign
		movlw	TempCallSign
		movwf	temp
		movfw	POINT
		addwf	temp,w
		movwf	FSR
		movfw	AlphaPNT2
		movwf	INDF
		goto	Alpha3Set_00
;
;

Alpha3Enter
		incf	POINT,f
		incf	LCDPNT,f
		movlw	b'11100101'
		btfss	Flags2,GpsMsgSet
		movlw	b'11101000'
		xorwf	LCDPNT,W
		btfsc	STATUS,Z
		retlw	0x01
		goto	Alpha3Set_00

Alpha3Back
		decf	POINT,f
		decf	LCDPNT,f
		movfw	LCDPNT
		xorlw	B'11010011'
		btfsc	STATUS,Z
		retlw	0x00
		goto	Alpha3Set_00


Alpha3PntUp
		incf	AlphaPNT2,F
		movfw	AlphaPNT2
		xorlw	0x7f
		btfss	STATUS,Z
		goto	Alpha3PntUp_00
		movlw	0x20
		movwf	AlphaPNT2
		return
Alpha3PntUp_00
		return

Alpha3PntDown
		decf	AlphaPNT2,f
		movfw	AlphaPNT2
		xorlw	0x1f
		btfss	STATUS,Z
		goto	AlphaPntDown_00
		movlw	0x7e
		movwf	AlphaPNT2
		return
Alpha3PntDown_00
		return

NumericSet
		call	TactSW
		btfss	portd_s,up
		call	NumericPntUp
		btfss	portd_s,down
		call	NumericPntDown
		btfss	portd_s,enter
		retlw	0x01
		btfss	portd_s,back
		retlw	0x00
		btfss	PORTA,From_Mic_PTT
		retlw	0x02
;
		movlw	B'11100000'
		call	LCD_CMD_4
		movfw	NumericTemp
		call	DispHex2Dec
		call	Disp_mSec
		goto	NumericSet
;


NumericPntUp
		incf	NumericTemp,F
		return

NumericPntDown
		decf	NumericTemp,f
		return

;-----------------------------
;
NumericSet0b
		call	TactSW
		btfss	portd_s,up
		call	NumericPntUp
		btfss	portd_s,down
		call	NumericPntDown
		btfss	portd_s,enter
		retlw	0x01
		btfss	portd_s,back
		retlw	0x00
		btfss	PORTA,From_Mic_PTT
		retlw	0x02
;
		movlw	B'11100000'
		call	LCD_CMD_4
		movfw	NumericTemp
		call	DispHex2Dec
		call	Disp_Sec
		goto	NumericSet0b


;-----------------------------
;
NumericSet0c
		call	TactSW
		btfss	portd_s,up
		call	NumericPntUp
		btfss	portd_s,down
		call	NumericPntDown
		btfss	portd_s,enter
		retlw	0x01
		btfss	portd_s,back
		retlw	0x00
		btfss	PORTA,From_Mic_PTT
		retlw	0x02
;
		movlw	B'11100000'
		call	LCD_CMD_4
		movfw	NumericTemp
		call	DispHex2Dec
		call	DispSpace5	
		goto	NumericSet0c


;-----------------------

MenuDisp3
		MOVLW	B'10010100'
		CALL	LCD_CMD_4
MenuDisp98
		clrf	POINT
		incf	POINT,F
		movlw	.12
		movwf	COUNT1
MenuDisp98_00
		movfw	POINT
		movwf	COUNT
		pageselw	CurrentSet
		movlw	low CurrentSet
		addwf	COUNT,w
		btfsc	STATUS,C
		incf	PCLATH,f
		call	CurrentSet
		call	LCD_DATA_4
		INCF	POINT,F
		decfsz	COUNT1,f
		goto	MenuDisp98_00
		return

CurrentSet
		movwf	PCL
		dt		CurrentSetMSG

;--------------------------------------
TxMsgSet
		Bank0
		call		Confirm
		addlw		0
		btfsc		STATUS,Z
		goto		MenuDispFirst_3
		sublw		1
		btfss		STATUS,Z
		goto		MenuBack_00_00
		movlw		0x14
		btfsc		Flags2,GpsMsgSet
		movlw		0x11
		movwf		COUNT1
		movlw		low TxMessage
		btfsc		Flags2,GpsMsgSet
		movlw		low	GpsMessage
		movwf		POINT
		movlw		TempCallSign
		movwf		temp
TxMsgSet_00
		BANKISEL	TempCallSign
		movfw		temp
		movwf		FSR
		movfw		INDF
		movwf		EEPROM_DATA
		movfw		POINT
		movwf		EEPROM_ADDR
		call		EEPROM_Write
		incf		POINT,f
		incf		temp,f
		decfsz		COUNT1,F
		goto		TxMsgSet_00
		clrf		command
		clrf		resp
		btfss		Flags2,GpsMsgSet
		return
		movlw		0x09
		movwf		command
		movlw		0x40
		movwf		resp
		return

;--------------------------------

Set0eEnter
		call		Confirm
		addlw		0
		btfsc		STATUS,Z
		retlw		0x01
		sublw		1
		btfss		STATUS,Z
		retlw		0x02

		bsf			Flags3,Display_Sw
Set0eSet
		movlw		0x40
		movwf		resp
		movlw		0x0c
		movwf		command
		bsf			Flags3,DsqlSet_Sw
		BANKISEL	MemDCD
		movlw		MemDCD
		movwf		FSR
		movfw		INDF
		movwf		EEPROM_DATA
		movlw		low	DCDNumber
		movwf		EEPROM_ADDR
		call		EEPROM_Write
		BANKISEL	MemDSQL
		movlw		MemDSQL
		movwf		FSR
		movfw		INDF
		movwf		dsql_sw
		movwf		EEPROM_DATA
		movlw		low	DSQLNumber
		movwf		EEPROM_ADDR
		call		EEPROM_Write
		retlw		0x00

;-------------------------
MenuSet09
		bcf			Flags2,GpsMsgSet
		movlw		B'11010100'
		call		LCD_CMD_4
		call		Alpha3Set
		addlw		0
		btfsc		STATUS,Z
		goto		MenuSet09_00
		call		TxMsgSet
		bsf			Flags3,Display_Sw
		return
MenuSet09_00
		Page32
		goto		MenuDispFirst

;
;-------------------------
MenuSet0a
		call	MenuDisp4
		movlw	B'11100000'
		call	LCD_CMD_4
		btfss	AdDefault,MSGSend_OnOff
		goto	MenuSet0a_02
		call	DispOn
		goto	MenuSet0a_03
MenuSet0a_02
		call	DispOff
MenuSet0a_03
		call	TactSW
		btfsc	portd_s,up				; On
		goto	MenuSet0a_04
		bsf		AdDefault,MSGSend_OnOff
		goto	MenuSet0a
MenuSet0a_04
		btfsc	portd_s,down			; Off
		goto	MenuSet0a_05
		bcf		AdDefault,MSGSend_OnOff
		goto	MenuSet0a
MenuSet0a_05
		btfsc	portd_s,back
		goto	MenuSet0a_06
ReadOptions_0000
		call	ReadOptions
		Page32
		goto	MenuDispFirst
MenuSet0a_06
		btfsc	portd_s,enter
		goto	MenuSet0a_07
WriteOptions_0000
		call	WriteOptions
		Page32
		goto	MenuDispFirst
MenuSet0a_07
		btfsc	PORTA,From_Mic_PTT
		goto	MenuSet0a
MenuBack_00_00
		call	ReadOptions
MenuBack_00_10
		Page32
		goto	MenuBack_00


;
;--------------------------
;
MenuSet0b
		call		MenuDisp4
		call		ReadMsgSndInterval
		movwf		NumericTemp
		call		NumericSet0b
		addlw		0
		btfsc		STATUS,Z
		goto		MenuSet0b_00
		movfw		NumericTemp
		call		WriteMsgSndInterval
		Page32
		goto		MenuDispFirst
MenuSet0b_00
		call		ClearLCD
		return

;
;--------------------------
;
MenuSet0c
		call		MenuDisp4
		call		ReadNoRetry
		movwf		NumericTemp
		call		NumericSet0c
		addlw		0
		btfsc		STATUS,Z
		goto		MenuSet0b_00
		movfw		NumericTemp
		call		WriteNoRetry
		Page32
		goto		MenuDispFirst
MenuSet0c_00
		call		ClearLCD

		return

;------------------------------  Set 0d
; baud rate set
MenuSet0d
		call	MenuDisp4
		movlw	B'11100000'
		call	LCD_CMD_4
		btfss	AdDefault2,SlowData96
		goto	MenuSet0d_02
		call	Disp9600
		goto	MenuSet0d_03
MenuSet0d_02
		call	Disp4800
MenuSet0d_03
		call	TactSW
		btfsc	portd_s,up				; 9600
		goto	MenuSet0d_04
		bsf		AdDefault2,SlowData96
		goto	MenuSet0d

MenuSet0d_04
		btfsc	portd_s,down			; 4800
		goto	MenuSet0d_05
		bcf		AdDefault2,SlowData96
		goto	MenuSet0d

MenuSet0d_05
		btfsc	portd_s,back
		goto	MenuSet0d_06
		call	ReadOptions2
		Page32
		goto	MenuDispFirst

MenuSet0d_06
		btfsc	portd_s,enter
		goto		MenuSet0d_07
		call		WriteOptions2
		bsf			Flags3,Display_Sw
		movlw		0x0d
		movwf		command
		movlw		0x40
		movwf		resp
		return

MenuSet0d_07
		btfsc	PORTA,From_Mic_PTT
		goto	MenuSet0d
		goto	MenuBack_00_02


;
;--------------------------
; Reset
MenuSet11
		MOVLW	B'10010100'
		CALL	LCD_CMD_4
		clrf	POINT
		incf	POINT,F
MenuSet11_00
		movfw	POINT
		movwf	COUNT
		pageselw	ReSetMsg
		movlw	low ReSetMsg
		addwf	COUNT,w
		btfsc	STATUS,C
		incf	PCLATH,f
		call	ReSetMsg
		addlw	0
		BTFSC	STATUS,Z
		GOTO	MenuSet11_01
		CALL	LCD_DATA_4
		INCF	POINT,F
		goto	MenuSet11_00
MenuSet11_01
		call	TactSW
		btfsc	portd_s,back
		goto	MenuSet11_02
		Page32
		goto		MenuDispFirst
MenuSet11_02
		btfsc	portd_s,enter
		goto	MenuSet11_03
		Page0
		clrf	PCLATH
		clrf	PCL
MenuSet11_03
		btfsc	PORTA,From_Mic_PTT
		goto	MenuSet11_01
		goto	MenuBack_00_10

ReSetMsg
		movwf	PCL
		dt		ReSetMSG,0

;----------------------------
; Debug
MenuSet12
		call	MenuDisp4
		movlw	B'11100000'
		call	LCD_CMD_4
		btfss	AdDefault2,Debug
		goto	MenuSet12_02
		call	DispOn
		goto	MenuSet12_03
MenuSet12_02
		call	DispOff
MenuSet12_03
		call	TactSW
		btfsc	portd_s,up				; On
		goto	MenuSet12_04
		bsf		AdDefault2,Debug
		goto	MenuSet12
MenuSet12_04
		btfsc	portd_s,down			; Off
		goto	MenuSet12_05
		bcf		AdDefault2,Debug
		goto	MenuSet12
MenuSet12_05
		btfsc	portd_s,back
		goto	MenuSet12_06
ReadOptions2_0000
		call	ReadOptions2
		Page32
		goto	MenuDispFirst
MenuSet12_06
		btfsc	portd_s,enter
		goto	MenuSet12_07
WriteOptions2_0000
		call	WriteOptions2
		Page32
		goto	MenuDispFirst
MenuSet12_07
		btfsc	PORTA,From_Mic_PTT
		goto	MenuSet12
		goto	MenuBack_00_02

;----------------------------
; GPS
MenuSet13
		call	MenuDisp4
		movlw	B'11100000'
		call	LCD_CMD_4
		btfss	AdDefault,GPSDisplay
		goto	MenuSet13_02
		call	DispOn
		goto	MenuSet13_03
MenuSet13_02
		call	DispOff
MenuSet13_03
		call	TactSW
		btfsc	portd_s,up				; On
		goto	MenuSet13_04
		bsf		AdDefault,GPSDisplay
		goto	MenuSet13
MenuSet13_04
		btfsc	portd_s,down			; Off
		goto	MenuSet13_05
		bcf		AdDefault,GPSDisplay
		goto	MenuSet13
MenuSet13_05
		btfsc	portd_s,back
		goto	MenuSet13_06
		goto	ReadOptions_0000
MenuSet13_06
		btfsc	portd_s,enter
		goto	MenuSet13_07
		goto	WriteOptions_0000
MenuSet13_07
		btfsc	PORTA,From_Mic_PTT
		goto	MenuSet13
		goto	MenuBack_00_00


;----------------------------
; Auto Duplex
MenuSet14
		call	MenuDisp4
		movlw	B'11100000'
		call	LCD_CMD_4
		btfss	AdDefault,AutoDuplex
		goto	MenuSet14_02
		call	DispOn
		goto	MenuSet14_03
MenuSet14_02
		call	DispOff
MenuSet14_03
		call	TactSW
		btfsc	portd_s,up				; On
		goto	MenuSet14_04
		bsf		AdDefault,AutoDuplex
		goto	MenuSet14
MenuSet14_04
		btfsc	portd_s,down			; Off
		goto	MenuSet14_05
		bcf		AdDefault,AutoDuplex
		goto	MenuSet14
MenuSet14_05
		btfsc	portd_s,back
		goto	MenuSet14_06
		goto	ReadOptions_0000
MenuSet14_06
		btfsc	portd_s,enter
		goto	MenuSet14_07
		goto	WriteOptions_0000
MenuSet14_07
		btfsc	PORTA,From_Mic_PTT
		goto	MenuSet14
		goto	MenuBack_00_00
		

;----------------------------
; PTT Lock
MenuSet15
		call	MenuDisp4
		movlw	B'11100000'
		call	LCD_CMD_4
		btfss	AdDefault,PTTLock
		goto	MenuSet15_02
		call	DispOn
		goto	MenuSet15_03
MenuSet15_02
		call	DispOff
MenuSet15_03
		call	TactSW
		btfsc	portd_s,up				; On
		goto	MenuSet15_04
		bsf		AdDefault,PTTLock
		goto	MenuSet15
MenuSet15_04
		btfsc	portd_s,down			; Off
		goto	MenuSet15_05
		bcf		AdDefault,PTTLock
		goto	MenuSet15
MenuSet15_05
		btfsc	portd_s,back
		goto	MenuSet15_06
		goto	ReadOptions_0000
MenuSet15_06
		btfsc	portd_s,enter
		goto	MenuSet15_07
		goto	WriteOptions_0000
MenuSet15_07
		btfsc	PORTA,From_Mic_PTT
		goto	MenuSet15
		goto	MenuBack_00_00


;----------------------------
; Beep On/Off
MenuSet16
		call	MenuDisp4
		movlw	B'11100000'
		call	LCD_CMD_4
		btfss	AdDefault2,BeepOnOff
		goto	MenuSet16_02
		call	DispOn
		goto	MenuSet16_03
MenuSet16_02
		call	DispOff
MenuSet16_03
		call	TactSW
		btfsc	portd_s,up				; On
		goto	MenuSet16_04
		bsf		AdDefault2,BeepOnOff
		goto	MenuSet16
MenuSet16_04
		btfsc	portd_s,down				; Off
		goto	MenuSet16_05
		bcf		AdDefault2,BeepOnOff
		goto	MenuSet16
MenuSet16_05
		btfsc	portd_s,back
		goto	MenuSet16_06
		goto	ReadOptions2_0000
MenuSet16_06
		btfsc	portd_s,enter
		goto	MenuSet16_07
		goto	WriteOptions2_0000
MenuSet16_07
		btfsc	PORTA,From_Mic_PTT
		goto	MenuSet16
MenuBack_00_02
		call	ReadOptions2
		Page32
		goto	MenuBack_00

;----------------------------
; DRS On/Off
MenuSet17
		call	MenuDisp4
		movlw	B'11100000'
		call	LCD_CMD_4
		btfss	AdDefault,DRS_OnOff
		goto	MenuSet17_02
		call	DispOn
		goto	MenuSet17_03
MenuSet17_02
		call	DispOff
MenuSet17_03
		call	TactSW
		btfsc	portd_s,up				; On
		goto	MenuSet17_04
		bsf		AdDefault,DRS_OnOff
		goto	MenuSet17
MenuSet17_04
		btfsc	portd_s,down				; Off
		goto	MenuSet17_05
		bcf		AdDefault,DRS_OnOff
		goto	MenuSet17
MenuSet17_05
		btfsc	portd_s,back
		goto	MenuSet17_06
		goto	ReadOptions_0000
MenuSet17_06
		btfsc	portd_s,enter
		goto	MenuSet17_07
		goto	WriteOptions_0000
MenuSet17_07
		btfsc	PORTA,From_Mic_PTT
		goto	MenuSet17
		goto	MenuBack_00_00

;-------------------------
MenuSet18
		bsf			Flags2,GpsMsgSet
		movlw		B'11010100'
		call		LCD_CMD_4
		call		Alpha3Set
		addlw		0
		btfsc		STATUS,Z
		goto		MenuSet18_00
		call		TxMsgSet
		bsf			Flags3,Display_Sw
		return
MenuSet18_00
		Page32
		goto		MenuDispFirst


;---------------------------
M1Set_3
		movfw		I2CPNTlow
		movwf		EEPROM_DATA
		movlw		low M1L
		movwf		EEPROM_ADDR
		call		EEPROM_Write
		movfw		I2CPNThigh
		movwf		EEPROM_DATA
		movlw		low M1H
		movwf		EEPROM_ADDR
		call		EEPROM_Write
		movlw		b'11100110'
		call		LCD_CMD_4
		movlw		"*"
		call		LCD_DATA_4
		movlw		"1"
		call		LCD_DATA_4
		return
;------
M2Set_3
		movfw		I2CPNTlow
		movwf		EEPROM_DATA
		movlw		low M2L
		movwf		EEPROM_ADDR
		call		EEPROM_Write
		movfw		I2CPNThigh
		movwf		EEPROM_DATA
		movlw		low M2H
		movwf		EEPROM_ADDR
		call		EEPROM_Write
		movlw		b'11100110'
		call		LCD_CMD_4
		movlw		"*"
		call		LCD_DATA_4
		movlw		"2"
		call		LCD_DATA_4
		return

;----------
M3Set_3
		movfw		I2CPNTlow
		movwf		EEPROM_DATA
		movlw		low M3L
		movwf		EEPROM_ADDR
		call		EEPROM_Write
		movfw		I2CPNThigh
		movwf		EEPROM_DATA
		movlw		low M3H
		movwf		EEPROM_ADDR
		call		EEPROM_Write
		movlw		b'11100110'
		call		LCD_CMD_4
		movlw		"*"
		call		LCD_DATA_4
		movlw		"3"
		call		LCD_DATA_4
		return

DispTempCall4
		movlw		0x04
		goto		DispTempCall8_00
DispTempCall8
		movlw		0x08
DispTempCall8_00
		movwf	COUNT1
		BANKISEL	TempCallSign
		movlw		TempCallSign
		movwf		FSR
DispTempCall8_01
		movfw		INDF
		incf		FSR,F
		call		LCD_DATA_4
		decfsz		COUNT1,f
		goto		DispTempCall8_01
		movlw		B'11100000'
		call		LCD_CMD_4		
		return

DispTempCall20
		movlw	0x11
		btfss	Flags2,GpsMsgSet
		movlw	0x14
		movwf	COUNT1
		BANKISEL	TempCallSign
		movlw		TempCallSign
		movwf		FSR
DispTempCall20_00
		movfw		INDF
		incf		FSR,F
		call		LCD_DATA_4
		decfsz		COUNT1,f
		goto		DispTempCall20_00
		btfsc		Flags2,GpsMsgSet
		call		DispSpace3
		movlw		B'11010100'
		call		LCD_CMD_4		
		return


;--------
TactSW
		movlw		PortdMask
		movwf		portd_s
		movfw		PORTD
		andlw		PortdMask
		xorwf		portd_s,w
		btfsc		STATUS,Z
		return
		xorlw		PortdMask
		movwf		portd_s
		call		TIME10M
		movfw		PORTD
		andlw		PortdMask
		xorwf		portd_s,w
		btfss		STATUS,Z
		goto		TactSW
		call		TIME60M
		movfw		PORTD
		xorwf		portd_s,w
		btfss		STATUS,Z
		goto		TactSW
		return
		

;--------
PorteSW
		movlw		PorteMask
		movwf		porte_s
		movfw		PORTE
		andlw		PorteMask
		xorwf		porte_s,w
		btfsc		STATUS,Z
		return
		xorlw		PorteMask
		movwf		porte_s
		call		TIME10M
		movfw		PORTE
		andlw		PorteMask
		xorwf		porte_s,w
		btfss		STATUS,Z
		goto		PorteSW
		call		TIME60M
		movfw		PORTE
		xorwf		porte_s,w
		btfss		STATUS,Z
		goto		PorteSW
		return

;------------------
DSQL_disp
		movlw		b'11001100'
DSQL_disp_0
		call		LCD_CMD_4
		clrf		POINT
		movfw		datai
		btfsc		STATUS,Z
		goto		DSQL_disp_10
		movlw		.5
DSQL_disp_20
		addwf		POINT,f
		decfsz		datai,f
		goto		DSQL_disp_20
DSQL_disp_10
		movlw		.5
		movwf		COUNT

DSQL_disp_50
		pageselw	DSQL_MSG
		movlw		low DSQL_MSG
		movwf		TempData
		movfw		POINT
		addwf		TempData,f
		movlw		high DSQL_MSG
		btfsc		STATUS,C
		incf		PCLATH,F
		movfw		TempData
		call		DSQL_MSG_J
		incf		POINT,F
		CALL		LCD_DATA_4
		decfsz		COUNT,f
		goto		DSQL_disp_50
		return

DSQL_MSG_J
		movwf	PCL
DSQL_MSG
		dt			"  OFF"
		dt			"DBEEP"
		dt			" DSQL"
		dt			"CBEEP"
		dt			" CSQL"


;-----------------
DCD_disp
		movlw		b'11010001'
		call		LCD_CMD_4
		movfw		datai
		call		DispHex2Dec
		return

;--------- EEPROM ----------------------------------
		org		0x2100
myCallSign		de		MyCallSign
				de		"  "
TxCallSign		
RPT2			de		RPT2_CallSign
RPT1			de		RPT1_CallSign
yourCallSign	de		YourCallSign
myCallSign2		de		MyCallSign2
;------------------------12345678901234567890
TxMessage		de		TxMessageDef
GpsMessage		de		GpsMessageDef
TxDelay			de		.20				;
MsgSndInterval	de		.30				; 30 sec.
EEPAdDefault	de		0x11			; DuplexOnOff | MSGSend_OnOff 
EEPAdDefault2	de		0x02			;  
GPS_Filter		de		0x00			; GPS off & filter No.
NoRetry			de		.3
DCDNumber		de		0x00			; DCD
DSQLNumber		de		0x00			; DSQL
M1H				de		0x00
M1L				de		0x00
M2H				de		0x00
M2L				de		0x00
M3H				de		0x00
M3L				de		0x00
;
Version			de		VersionInfo
Permission		de		"If you want to redistribute this file, do not modify all files without permission."
		END