/*
 * @(#)SAMLAuthorityProvider.java
 *
 * Copyright (C) 2007 Infocity Inc. All Rights Reserved.
 */
package info.dragonlady.sso.authority;

import info.dragonlady.sso.SSOConfig;
import info.dragonlady.sso.util.ResourceParseException;

import org.opensaml.SAMLAttributeQuery;
import org.opensaml.SAMLAuthenticationQuery;
import org.opensaml.SAMLAuthorizationDecisionQuery;
import org.opensaml.SAMLQuery;
import org.opensaml.SAMLRequest;

/**
 * SAMLI[\eB񋟃NXB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.0 $ $Date: 2007/04/24 21:04:17 $
 */
public class SAMLAuthorityProvider {

	/**
	 * SAMLvɏ]āASAMLI[\eBNXCX^X擾B
	 * 
	 * @param request SAMLv
	 * @return SAMLAuthority SAMLI[\eBNXCX^X
	 * @throws ResourceParseException
	 * @throws InstantiationException
	 * @throws IllegalAccessException
	 * @throws ClassNotFoundException
	 */
	public static final SAMLAuthority getAuthority(SAMLRequest request) throws ResourceParseException, InstantiationException, IllegalAccessException, ClassNotFoundException {
		SAMLAuthority authority = null;
		SAMLQuery query = request.getQuery();
		if(query instanceof SAMLAuthenticationQuery) {
			authority = getAuthenticationAuthority();
		} else if(query instanceof SAMLAttributeQuery) {
			authority = getAttributeAuthority();
		} else if(query instanceof SAMLAuthorizationDecisionQuery) {
			authority = getPolicyDecisionPoint();
		}
		return authority;
	}

	/**
	 * F؃I[\eBCX^X擾B
	 * 
	 * @return SAMLAuthority F؃I[\eBCX^X
	 * @throws ResourceParseException
	 * @throws InstantiationException
	 * @throws IllegalAccessException
	 * @throws ClassNotFoundException
	 */
	public static final SAMLAuthority getAuthenticationAuthority() throws ResourceParseException, InstantiationException, IllegalAccessException, ClassNotFoundException {
		return getAuthority(SSOConfig.getAuthenticationAuthorityClass());
	}

	/**
	 * I[\eBCX^X擾B
	 * 
	 * @return SAMLAuthority I[\eBCX^X
	 * @throws ResourceParseException
	 * @throws InstantiationException
	 * @throws IllegalAccessException
	 * @throws ClassNotFoundException
	 */
	public static final SAMLAuthority getAttributeAuthority() throws ResourceParseException, InstantiationException, IllegalAccessException, ClassNotFoundException {
		return getAuthority(SSOConfig.getAttributeAuthorityClass());
	}

	/**
	 * |V[_CX^X擾B
	 * 
	 * @return SAMLAuthority |V[_CX^X
	 * @throws ResourceParseException
	 * @throws InstantiationException
	 * @throws IllegalAccessException
	 * @throws ClassNotFoundException
	 */
	public static final SAMLAuthority getPolicyDecisionPoint() throws ResourceParseException, InstantiationException, IllegalAccessException, ClassNotFoundException {
		return getAuthority(SSOConfig.getPolicyDecisionPointClass());
	}

	/**
	 * w肳ꂽNXSAMLI[\eBCX^X擾B
	 * 
	 * @param className SAMLI[\eBNX
	 * @return SAMLAuthority SAMLI[\eBCX^X
	 * @throws InstantiationException
	 * @throws IllegalAccessException
	 * @throws ClassNotFoundException
	 */
	public static final SAMLAuthority getAuthority(String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
		return (SAMLAuthority)Class.forName(className).newInstance();
	}

}
