/*
 * @(#)ResourceUtils.java
 *
 * Copyright (C) 2005 Infocity Inc. All Rights Reserved.
 */
package info.dragonlady.sso.util;

import java.net.URL;

import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;

import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/**
 * \[XANZX[eBeBNX
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.1 $ $Date: 2005/11/11 14:08:42 $
 */
public class ResourceUtils {

	/**
	 * XML\[XXPathŎw肵擾
	 * 
	 * @param resourcePath XML\[X̃pX
	 * @param expression XPath
	 * @return String Y
	 * @throws ResourceParseException
	 */
	public static final String getString(String resourcePath, String expression) throws ResourceParseException {
		try {
			return (String)ResourceUtils.evaluate(resourcePath, expression, XPathConstants.STRING);
		} catch(ResourceParseException e) {
			throw e;
		} catch(Exception e) {
			throw new ResourceParseException(e);
		}
	}

	/**
	 * XML\[XXPathŎw肵m[hXg擾
	 * 
	 * @param resourcePath XML\[X̃pX
	 * @param expression XPath
	 * @return String Ym[hXg
	 * @throws ResourceParseException
	 */
	public static final NodeList getNodeSet(String resourcePath, String expression) throws ResourceParseException {
		try {
			return (NodeList)ResourceUtils.evaluate(resourcePath, expression, XPathConstants.NODESET);
		} catch(ResourceParseException e) {
			throw e;
		} catch(Exception e) {
			throw new ResourceParseException(e);
		}
	}

	/**
	 * XML\[XXPathQNameŎw肵IuWFNg擾
	 * 
	 * @param resourcePath XML\[X̃pX
	 * @param expression XPath
	 * @param returnType ړI̖߂ľ^
	 * @return Object YIuWFNg
	 * @throws ResourceParseException
	 */
	public static final Object evaluate(String resourcePath, String expression, QName returnType) throws ResourceParseException {
		try {
			URL url = ResourceUtils.class.getClassLoader().getResource(resourcePath);
			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			DocumentBuilder db = dbf.newDocumentBuilder();
			Document dom = db.parse(url.openStream());
			XPathFactory factory = XPathFactory.newInstance();
			XPath xpath = factory.newXPath();
			return xpath.evaluate(expression, dom, returnType);
		} catch(Exception e) {
			throw new ResourceParseException(e);
		}
	}

	/**
	 * oCgzBase64ŃGR[hɕϊ
	 * 
	 * @param src oCgz
	 * @return Base64ŃGR[hꂽ
	 */
	public static final String toBase64String(byte[] src) {
		return new String(Base64.encodeBase64(src));
	}

	/**
	 * oCgz16iŕ\ɕϊ
	 * 
	 * @param src oCgz
	 * @return 16iŕ\ꂽ
	 */
	public static final String toHexString(byte[] src) {
		return new String(Hex.encodeHex(src));
	}

	/**
	 * Base64ŃGR[hꂽoCgzɕϊ
	 * 
	 * @param src Base64ŃGR[hꂽ
	 * @return byte[] oCgz
	 */
	public static final byte[] toBase64ByteArray(String src) {
		return Base64.decodeBase64(src.getBytes());
	}

	/**
	 * 16i\oCgzɕϊ
	 * 
	 * @param src 16i\
	 * @return byte[] oCgz
	 * @throws DecoderException 
	 */
	public static final byte[] toHexByteArray(String src) throws DecoderException {
		return Hex.decodeHex(src.toCharArray());
	}

	/**
	 * XMLm[heLXg擾B
	 * 
	 * @param node m[h
	 * @return String eLXg
	 */
	public static final String getTextContent(Node node) {
		String content = null;
		NodeList list = node.getChildNodes();
		for(int i = 0; i < list.getLength(); i++) {
			Node child = (Node)list.item(i);
			if(child.getNodeType() == Node.TEXT_NODE) {
				content = ((Text)child).getData();
				break;
			}
		}
		return content;
	}

}
