/*
 * @(#)RequesterTest.java
 *
 * Copyright (C) 2005 Infocity Inc. All Rights Reserved.
 */
package test.info.dragonlady.sso;

import info.dragonlady.sso.AssertionManager;
import info.dragonlady.sso.Requester;
import info.dragonlady.sso.util.AssertionGenerator;

import org.apache.cactus.ServletTestCase;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLAuthenticationStatement;
import org.opensaml.SAMLException;
import org.opensaml.SAMLRequest;
import org.opensaml.SAMLResponse;
import org.opensaml.SAMLSubject;
import org.opensaml.artifact.Artifact;
import org.opensaml.artifact.SAMLArtifactType0001;

/**
 * RequesterNX̃eXgP[X
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.1 $ $Date: 2005/11/15 18:10:09 $
 */
public class RequesterTest extends ServletTestCase {
	private Artifact artifact = null;

	private String responder = "http://172.16.3.74:8080/sso_test/responder.html";

	/**
	 * Constructor for RequesterTest.
	 * @param arg0
	 */
	public RequesterTest(String arg0) {
		super(arg0);
	}

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
		// Assertion̍쐬
		SAMLAssertion assertion = AssertionGenerator.generateAuthenticationAssertion("dummyUserId", SAMLSubject.CONF_ARTIFACT, SAMLAuthenticationStatement.AuthenticationMethod_Unspecified);
		// Assertiono^
		byte[] handle = AssertionManager.getInstance().add(assertion);

		// Artifact̍쐬
	    artifact = AssertionGenerator.generateArtifact(handle);
	}

	/*
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	/*
	 * Test method for 'info.dragonlady.sso.Requester.Requester()'
	 */
	public final void testRequester() {
		try {
			new Requester(responder);
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * AT[V擾
	 * 
	 * Test method for 'info.dragonlady.sso.Requester.resolve(SAMLRequest)'
	 */
	public final void testResolve1() {
		try {
			Requester requester = new Requester(responder);
			SAMLRequest samlRequest = Requester.createAuthenticationRequest(artifact, null, null, SAMLSubject.CONF_ARTIFACT, null, null);
			SAMLResponse samlResponse = requester.resolve(samlRequest);
			assertTrue(samlResponse.getStatus().getCodes().next().equals(SAMLException.SUCCESS));
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * AT[V擾sisȃA[eBt@Ngj
	 * 
	 * Test method for 'info.dragonlady.sso.Requester.resolve(SAMLRequest)'
	 */
	public final void testResolve2() {
		try {
			Requester requester = new Requester(responder);
			SAMLRequest samlRequest = Requester.createAuthenticationRequest(new SAMLArtifactType0001(new byte[20]), null, null, SAMLSubject.CONF_ARTIFACT, null, null);
			requester.resolve(samlRequest);
			// OȂ΃G[
			assertTrue(false);
		} catch(SAMLException e) {
			assertTrue(true);
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * AT[V擾siAT[V݂Ȃj
	 * 
	 * Test method for 'info.dragonlady.sso.Requester.resolve(SAMLRequest)'
	 */
	public final void testResolve3() {
		try {
			// AT[V폜Ă
			AssertionManager.getInstance().remove(ArtifactManager.getInstance().getHandle(artifact.encode()));

			Requester requester = new Requester(responder);
			SAMLRequest samlRequest = Requester.createAuthenticationRequest(artifact, null, null, SAMLSubject.CONF_ARTIFACT, null, null);
			requester.resolve(samlRequest);
			// OȂ΃G[
			assertTrue(false);
		} catch(SAMLException e) {
			assertTrue(true);
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

}
