/*
 * @(#)SSOContextTest.java
 *
 * Copyright (C) 2007 Infocity Inc. All Rights Reserved.
 */
package test.info.dragonlady.sso;

import info.dragonlady.sso.SSOContext;

import org.apache.cactus.ServletTestCase;
import org.opensaml.ReplayCache;

/**
 * SSOContextNXeXgP[XB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.0 $ $Date: 2007/06/05 19:33:56 $
 */
public class SSOContextTest extends ServletTestCase {

	/**
	 * @param arg0
	 */
	public SSOContextTest(String arg0) {
		super(arg0);
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	/**
	 * {@link info.dragonlady.sso.SSOContext#getInstance()} ̂߂̃eXgE\bhB
	 */
	public final void testGetInstance() {
		try {
			assertTrue(SSOContext.getInstance() instanceof SSOContext);
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.SSOContext#getReplayCache()} ̂߂̃eXgE\bhB
	 */
	public final void testGetReplayCache() {
		try {
			assertTrue(SSOContext.getInstance().getReplayCache() instanceof ReplayCache);
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.SSOContext#getCurrentRequest()} ̂߂̃eXgE\bhB
	 */
	public final void testGetCurrentRequest() {
		try {
			SSOContext.getInstance().setCurrentRequest(request);
			assertEquals(SSOContext.getInstance().getCurrentRequest(), request);
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.SSOContext#setCurrentRequest(javax.servlet.http.HttpServletRequest)} ̂߂̃eXgE\bhB
	 */
	public final void testSetCurrentRequest() {
		try {
			SSOContext.getInstance().setCurrentRequest(request);
			assertEquals(SSOContext.getInstance().getCurrentRequest(), request);
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

}
