//
// LineTraceDriver.h
//

#ifndef LINETRACEDRIVER_H_
#define LINETRACEDRIVER_H_

#include "Vector.h"
#include "LightSensor.h"
using namespace ecrobot;

#include "Driver.h"


/**
 * @brief PID楯饹
 * PID̤򻻽Фޤ
 *
 * I̤λФϾάƤޤ
 *
 * @author teshima
 */
class PIDCtrl
{
public:

	/**
	 * 󥹥ȥ饯
	 * @param tgtVal ɸ
	 * @param kp P
	 * @param ki I
	 * @param kd D
	 */
	PIDCtrl(float tgtVal, float kp, float ki, float kd)
	 : TGT_VAL(tgtVal), KP(kp) , KI(ki) , KD(kd) ,m_prevDiff(0) {}
 
	~PIDCtrl() {}

	/**
	 * PID̻
	 * @param curVal 
	 * @retval S16 PID
	 */
	S16 calcVal(S16 curVal) {
		float diff = TGT_VAL - curVal;		//к
		return (S16)(calcPVal(diff) + calcIVal(diff) + calcDVal(diff));
	}
	void setSpeed(long value);

private:
	const float TGT_VAL;	//ɸ
	const float KP;			//P
	const float KI;			//I
	const float KD;			//D
	float m_prevDiff;		//к
	/**
	 * P̻
	 * @param diff 
	 * @retval float P
	 */
	float calcPVal(float diff) {
		return KP * diff;
	}

	/**
	 * I̻
	 * @brief ʤ
	 */
	float calcIVal(float diff) {
		return 0;
	}
	
	/**
	 * D̻
	 * @param diff 
	 * @retval float D
	 */
	float calcDVal(float diff) {
		float dValue = KD * (diff - m_prevDiff);
		m_prevDiff = diff;
		return dValue;
	}
};

/**
 * Line tracing driver class
 */
class LineTraceDriver: public Driver
{
public:
	/**
	 * Default light sensor value for white color
	 */
	static const S16 DEFAULT_BLACK = 700;

	/**
	 * Default light sensor value for black color
	 */
	static const S16 DEFAULT_WHITE = 520;
/*
	// ɸ
	const float DEFAULT_TARGET_VAL = 600;

	// PID 
	const float P_GAIN = 0.5;
	const float I_GAIN = 0.5;
	const float D_GAIN = 0.5;
*/
	/**
	 * Constructor.
	 */
	LineTraceDriver(LightSensor& light, S16 black=DEFAULT_BLACK, S16 white=DEFAULT_WHITE):
		mrLight(light), mBlack(black), mWhite(white) ,m_speed(50) ,m_bCurveSet(true)
	{	
		mDriverReq = Driver::DRIVE; 
//		m_pPIDCtrl = new PIDCtrl(DEFAULT_TARGET_VAL, P_GAIN, I_GAIN, D_GAIN);

//ե饤󥭡E
//		m_pPIDCtrl = new PIDCtrl(600, 2.0, 0.5, 1.3);
//UIS
//		m_pPIDCtrl = new PIDCtrl(600, 0.66, 0.5, 0.4);
//Ƥä
		m_pPIDCtrl = new PIDCtrl(590, 0.7, 0.5, 13.0);

	}

	/**
	 * Update driver status
	 */
	virtual void update(void);

	/**
	 * Set light sensor value for black and white color.
	 * @param black Light sensor value for black
	 * @param white Light sensor value for white
	 */
	void LineTraceDriver::setColorRef(S16 black, S16 white)
	{
		mBlack = black;
		mWhite = white;
	}
	
	S16 LineTraceDriver::getLightValue()
	{
		return mLightValue;
	}
	void setSpeed(S16 value);
	void setCurveSet(bool value);

private:
	LightSensor& mrLight;
	S16 mBlack;
	S16 mWhite;
	PIDCtrl*  m_pPIDCtrl;
	S16 mLightValue;
	S16 m_speed;
	bool m_bCurveSet;
};
inline void LineTraceDriver::setSpeed(S16 value) {
	m_speed = value;
}

inline void LineTraceDriver::setCurveSet(bool value) {
	m_bCurveSet = value;
}

#endif
