//
// t@C : Main.cpp
// Tv       : 2֓|UqCg[X{bgTOPPERS/ATK1(OSEK)pC++TvvO
//

//#include "math.h"

// ECRobot C++ API
#include "TouchSensor.h"
#include "SonarSensor.h"
#include "LightSensor.h"
#include "GyroSensor.h"
#include "Motor.h"
#include "Nxt.h"
#include "Clock.h"
#include "Lcd.h"
//using namespace ecrobot;

#include "UI.h"
#include "Driver.h"
#include "DriverMgr.h"
#include "TailControl.h"
#include "CourseMgr.h"
#include "Em_CourseKind.h"

//=============================================================================
// foCXIuWFNg̒`

GyroSensor gyro(PORT_1);
SonarSensor sonar(PORT_2);
LightSensor light(PORT_3);
TouchSensor touch(PORT_4);
Motor motorT(PORT_A);
Motor motorR(PORT_B);
Motor motorL(PORT_C);
Nxt nxt;
Lcd lcd;
Clock clock;

CourseMgr courseMgr;
TailControl tailControl(&motorT);
DriverMgr driverMgr(&light, &gyro, &sonar, &motorL, &motorR, &nxt, &lcd, &tailControl, &courseMgr);
UI ui(&light, &touch, &sonar, &nxt, &lcd, &driverMgr);

Em_CourseKind::eCourseKind eInOutFlag = Em_CourseKind::NONE;
bool bDifficultStageFlag;

extern "C"
{
//=============================================================================

// ^XN̋N[msec]
#define BACKGROUND_PERIOD (48)
#if defined(ENABLE_BT_LOG) || defined(ENABLE_BT_START)
// Bluetooth̃foCXi"ET" + 2011Nx FE[VO ̃`[ID "158"j
#define DEVICE_NAME     "ET158"
// Bluetooth̃pXL[iK̊֌WANXT̃ftHg "1234" ȊOݒ肷Kvj
#define PASS_KEY  "uis_robocon"
#endif

//=============================================================================
// ֐	: user_1ms_isr_type2
// 	: Ȃ
// ߂l	: Ȃ
// Tv	: 1msec荞݃tbN֐(OSEK ISR type2JeS)
//=============================================================================
void user_1ms_isr_type2(void)
{
#if defined(ENABLE_BT_LOG) || defined(ENABLE_BT_START)
	ecrobot_set_bt_device_name(DEVICE_NAME); //BluetoothfoCXݒ
#endif
	(void)SignalCounter(SysTimerCnt); // Alarmnh
	SleeperMonitor(); // NxtI2CfoCX̎gpɕKv
}

//=============================================================================
// ^XN@: TaskMain
// Tv	@: C^XN
//=============================================================================
TASK(TaskMain)
{
	
	SetRelAlarm(Alarm4msec, 1, DRIVE_PERIOD);
	
	ui.selectCource(eInOutFlag, bDifficultStageFlag);
	
	ui.printResult(eInOutFlag, bDifficultStageFlag);
	
	courseMgr.createCourse(eInOutFlag);

//	ui.printcalibration();

	ui.waitForTouchSenserOn();

	
}

//=============================================================================
// ^XN@: TaskDrive
// Tv	@: hCu^XN
//=============================================================================
TASK(TaskDrive)
{
	driverMgr.startDrive();
}
};


//=============================================================================
// ^XN@: ecrobot_device_initialize
// Tv	@: foCXptbN֐BnxtOSEKNɎsB
//=============================================================================
void ecrobot_device_initialize(void)
{
#if defined(ENABLE_BT_LOG) || defined(ENABLE_BT_START)
	ecrobot_init_bt_slave(PASS_KEY);
#endif

}

//=============================================================================
// ^XN@: ecrobot_device_terminate
// Tv	@: foCXIptbN֐BSTOP܂EXIT{^ꂽɎsB
//=============================================================================
void ecrobot_device_terminate(void)
{
#if defined(ENABLE_BT_LOG) || defined(ENABLE_BT_START)
	ecrobot_term_bt_connection();
#endif
	driverMgr.notifyTaskEnd();
	ui.notifyTaskEnd();
	clock.wait(100);
	
	lcd.clear();
	lcd.putf("sn", "Process End!!");
	lcd.disp();	
	
	clock.wait(1000);

}

