package com.yuji.ec.task;

import java.lang.ref.WeakReference;

import com.evernote.edam.notestore.NoteList;
import com.yuji.ec.NoteUpdatorActivity;
import com.yuji.ec.utility.AsyncTaskIF;
import com.yuji.ec.utility.EvernoteUtil;
import com.yuji.ec.utility.NoteUpdator;

public class NoteUpdateTask implements AsyncTaskIF {
	private EvernoteUtil util = EvernoteUtil.getInstance();
	private NoteList noteList;
	private WeakReference<NoteUpdatorActivity> activityRef;
	private EvernoteUtil.Error errorCode = null;
	private int noteItemType;
	private String guid;

	public NoteUpdateTask(NoteUpdatorActivity activity, int noteItemType, String guid) {
		activityRef = new WeakReference<NoteUpdatorActivity>(activity);
		this.noteItemType = noteItemType;
		this.guid = guid;
	}

	public void doExecute() {
		synchronized (util) {
			try {
				NoteUpdator updator = NoteUpdator.getInstance();
				updator.update(activityRef.get(), noteItemType, guid);
			} finally {
				errorCode = util.getErrorCode();
			}
		}
	}

	public void cancel() {

	}

	public void done(boolean isCancel) {
		NoteUpdatorActivity activity = activityRef.get();
		if (activity != null) {
			activity.done(errorCode);
			activityRef = null;
		}
	}

	public int getStatus() {
		return 0;
	}

	public NoteList getNoteList() {
		return noteList;
	}

	public EvernoteUtil.Error getErrorCode() {
		return errorCode;
	}
}
