/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.fess.ant.sax;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class XdocToTexHandler
extends DefaultHandler {
    private LinkedList<TagInfo> tagInfoList = new LinkedList();
    private Writer writer;
    private TableInfo tableInfo = null;

    public XdocToTexHandler(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) {
        TagInfo tagInfo = new TagInfo();
        tagInfo.setName(qName);
        int i = 0;
        while (i < attrs.getLength()) {
            tagInfo.add(attrs.getQName(i), attrs.getValue(i));
            ++i;
        }
        this.tagInfoList.add(tagInfo);
        if ("section".equalsIgnoreCase(qName)) {
            this.write("\\section{");
            this.write(tagInfo.getAttr("name").trim());
            this.write("}\n");
        } else if ("subsection".equalsIgnoreCase(qName)) {
            this.write("\\subsection{");
            this.write(tagInfo.getAttr("name").trim());
            this.write("}\n");
        } else if ("ul".equalsIgnoreCase(qName)) {
            this.write("\\begin{itemize}");
        } else if ("table".equalsIgnoreCase(qName)) {
            String widthInfo;
            this.tableInfo = new TableInfo();
            String columnInfo = tagInfo.getAttr("columninfo");
            if (columnInfo != null) {
                this.tableInfo.setColumnInfo(columnInfo);
            }
            if ((widthInfo = tagInfo.getAttr("widthinfo")) != null) {
                this.tableInfo.setWidthInfo(widthInfo);
            }
        } else if ("tr".equalsIgnoreCase(qName)) {
            this.tableInfo.newRow();
        } else if ("th".equalsIgnoreCase(qName)) {
            this.tableInfo.newBuffer();
        } else if ("td".equalsIgnoreCase(qName)) {
            this.tableInfo.newBuffer();
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) {
        TagInfo tagInfo = this.tagInfoList.removeLast();
        if (this.tableInfo != null) {
            if ("table".equalsIgnoreCase(qName)) {
                String lineInfo = tagInfo.getAttr("lineinfo");
                if (lineInfo == null) {
                    this.tableInfo.endTable("\\hline");
                } else {
                    this.tableInfo.endTable(lineInfo);
                }
                this.write(this.tableInfo.toTexString());
                this.tableInfo = null;
            } else if ("tr".equalsIgnoreCase(qName)) {
                String lineInfo = tagInfo.getAttr("lineinfo");
                if (lineInfo == null) {
                    this.tableInfo.endRow("\\hline");
                } else {
                    this.tableInfo.endRow(lineInfo);
                }
            } else if ("th".equalsIgnoreCase(qName)) {
                this.tableInfo.addCell();
            } else if ("td".equalsIgnoreCase(qName)) {
                this.tableInfo.addCell();
            } else if ("caption".equalsIgnoreCase(qName)) {
                this.tableInfo.setCaption(tagInfo.getBody());
            }
        } else if ("img".equalsIgnoreCase(qName)) {
            String sizeInfo;
            String src = tagInfo.getAttr("src");
            String srcName = src.replaceAll(".*/([^/]+)\\.[^/]+", "$1");
            String title = tagInfo.getAttr("alt");
            if (title == null) {
                title = tagInfo.getAttr("title");
            }
            if ((sizeInfo = tagInfo.getAttr("sizeinfo")) == null) {
                sizeInfo = "width=10cm";
            }
            this.write("\\begin{figure}[ht]\n");
            this.write("\\begin{center}\n");
            this.write("\\includegraphics[");
            this.write(sizeInfo);
            this.write("]{images/");
            this.write(srcName);
            this.write(".eps}\n");
            this.write("\\caption{");
            this.write(title);
            this.write("}\n");
            this.write("\\label{fig:");
            this.write(srcName);
            this.write("}\n");
            this.write("\\end{center}\n");
            this.write("\\end{figure}\n");
        } else if ("ul".equalsIgnoreCase(qName)) {
            this.write("\n\\end{itemize}\n");
        } else if ("p".equalsIgnoreCase(qName)) {
            this.write("\n");
        } else if ("source".equalsIgnoreCase(qName)) {
            this.write("\\begin{screen}\n");
            this.write("\\begin{small}\n");
            this.write("\\begin{verbatim}\n");
            this.write(tagInfo.getBody().trim());
            this.write("\n\\end{verbatim}\n");
            this.write("\n\\end{small}\n");
            this.write("\n\\end{screen}\n");
        }
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        TagInfo tagInfo = this.tagInfoList.getLast();
        String tagName = tagInfo.getName();
        if ("p".equalsIgnoreCase(tagName)) {
            String str = this.escape(new String(ch, start, length));
            this.write(str.trim());
            this.write("\n");
        } else if ("a".equalsIgnoreCase(tagName)) {
            String str = this.escape(new String(ch, start, length));
            this.write(str.trim());
        } else if ("code".equalsIgnoreCase(tagName)) {
            String str = this.escape(new String(ch, start, length));
            this.write("\u300c" + str.trim() + "\u300d");
        } else if ("b".equalsIgnoreCase(tagName)) {
            String str = this.escape(new String(ch, start, length));
            this.write("\\textbf{" + str.trim() + "}");
        } else if ("li".equalsIgnoreCase(tagName)) {
            String str = this.escape(new String(ch, start, length));
            this.write("\n\\item ");
            this.write(str.trim());
        } else if ("source".equalsIgnoreCase(tagName)) {
            String str = new String(ch, start, length);
            tagInfo.addBody(str);
        } else {
            String str = this.escape(new String(ch, start, length));
            if (this.tableInfo != null && this.tableInfo.hasBuffer()) {
                this.tableInfo.appendToBuf(str);
            } else {
                tagInfo.addBody(str);
            }
        }
    }

    private void write(String str) {
        if (this.tableInfo != null && this.tableInfo.hasBuffer()) {
            this.tableInfo.appendToBuf(str);
        } else {
            try {
                this.writer.write(str);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    String escape(String str) {
        if (str != null) {
            return str.replace("\\", "\\\\").replace("<", "\\<").replace(">", "\\>").replace("$", "\\$").replace("#", "\\#").replace("_", "\\_").replace("&", "\\&").replace("^", "\\^{}").replace("~", "\\~{}").replace("\uff5e", "$\\sim$");
        }
        return str;
    }

    private static class TableInfo {
        private List<List<String>> rowList = new ArrayList<List<String>>();
        private List<String> lineList = new ArrayList<String>();
        private String lineTop;
        private String caption = null;
        private String columnInfo = null;
        private StringBuilder buf;
        private String widthInfo;

        private TableInfo() {
        }

        public String toTexString() {
            StringBuilder contentBuf = new StringBuilder();
            contentBuf.append("\\begin{table}[htb]\n");
            contentBuf.append("\\begin{center}\n");
            if (this.caption != null) {
                contentBuf.append("\\caption{").append(this.caption).append("}\n");
            }
            if (this.widthInfo != null) {
                contentBuf.append("\\begin{tabular*}{").append(this.widthInfo).append("}{@{\u00a5extracolsep{\u00a5fill}}").append(this.getColumnInfo()).append('}');
            } else {
                contentBuf.append("\\begin{tabular}{").append(this.getColumnInfo()).append('}');
            }
            if (this.lineTop != null) {
                contentBuf.append(' ').append(this.lineTop);
            }
            contentBuf.append('\n');
            int rowSize = this.rowList.size();
            int i = 0;
            while (i < rowSize) {
                List<String> columnList = this.rowList.get(i);
                int columnSize = columnList.size();
                int j = 0;
                while (j < columnSize) {
                    contentBuf.append(columnList.get(j));
                    if (j == columnSize - 1) {
                        contentBuf.append(" \\\\");
                    } else {
                        contentBuf.append(" & ");
                    }
                    ++j;
                }
                String lineEnd = this.lineList.get(i);
                if (lineEnd != null) {
                    contentBuf.append(' ').append(lineEnd);
                }
                contentBuf.append('\n');
                ++i;
            }
            if (this.widthInfo != null) {
                contentBuf.append("\\end{tabular*}\n");
            } else {
                contentBuf.append("\\end{tabular}\n");
            }
            contentBuf.append("\\end{center}\n");
            contentBuf.append("\\end{table}\n");
            return contentBuf.toString();
        }

        public void setWidthInfo(String widthInfo) {
            this.widthInfo = widthInfo;
        }

        private String getColumnInfo() {
            if (this.columnInfo != null) {
                return this.columnInfo;
            }
            StringBuilder builder = new StringBuilder();
            int size = this.rowList.get(this.rowList.size() - 1).size();
            int i = 0;
            while (i < size) {
                builder.append('l');
                ++i;
            }
            return builder.toString();
        }

        public void newRow() {
            this.rowList.add(new ArrayList());
        }

        public void appendToBuf(String str) {
            this.buf.append(str);
        }

        public boolean hasBuffer() {
            return this.buf != null;
        }

        public void newBuffer() {
            this.buf = new StringBuilder();
        }

        public void endTable(String lineTopInfo) {
            this.lineTop = lineTopInfo;
        }

        public void endRow(String line) {
            this.lineList.add(line);
        }

        public void addCell() {
            this.rowList.get(this.rowList.size() - 1).add(this.buf.toString());
            this.buf = null;
        }

        public void setCaption(String caption) {
            this.caption = caption;
        }

        public void setColumnInfo(String info) {
            this.columnInfo = info;
        }
    }

    private static class TagInfo {
        private String name;
        private StringBuilder bodyBuf = new StringBuilder();
        private Map<String, String> attrMap = new HashMap<String, String>();

        private TagInfo() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getAttr(String key) {
            return this.attrMap.get(key);
        }

        public void add(String key, String value) {
            this.attrMap.put(key, value);
        }

        public void addBody(String str) {
            this.bodyBuf.append(str);
        }

        public String getBody() {
            return this.bodyBuf.toString();
        }
    }
}

