//
// Copyright 2009-2010 Fess Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

#import "SearchViewController.h"
#import "SearchResultDataSource.h"


@implementation SearchViewController

- (id) init {
	if (self = [super init]) {
		self.title = NSLocalizedString(@"SearchTitle",nil);
		self.variableHeightRows = YES;
		UIImage* image = [UIImage imageNamed:@"search.png"];
		self.tabBarItem = [[[UITabBarItem alloc] 
							initWithTitle:NSLocalizedString(@"SearchTabTitle",nil) 
							image:image tag:0] autorelease];
	}

	return self;
}

- (void)createModel {
  self.dataSource = [[[SearchResultDataSource alloc]
                      initWithSearchQuery:@""] autorelease];
}

- (void)loadView {
	[super loadView];
	
	UISearchBar *searchBar = [[[UISearchBar alloc] init] autorelease];
	searchBar.showsCancelButton = YES;
	[searchBar sizeToFit];
	searchBar.delegate = self;	
	searchBar.autocapitalizationType = UITextAutocapitalizationTypeNone;
	self.tableView.tableHeaderView = searchBar;
}

- (void)addToOverlayView:(UIView*)view {
	if (!_tableOverlayView) {
		CGRect frame = [self rectForOverlayView];
		UIView *searchBar = self.tableView.tableHeaderView;
		frame.origin.y += searchBar.frame.size.height;
		frame.size.height -= searchBar.frame.size.height;
		_tableOverlayView = [[UIView alloc] initWithFrame:frame];
		_tableOverlayView.autoresizesSubviews = YES;
		_tableOverlayView.autoresizingMask = UIViewAutoresizingFlexibleWidth
		| UIViewAutoresizingFlexibleBottomMargin;
		NSInteger tableIndex = [_tableView.superview.subviews indexOfObject:_tableView];
		if (tableIndex != NSNotFound) {
			[_tableView.superview addSubview:_tableOverlayView];
		}
	}
	
	view.frame = _tableOverlayView.bounds;
	view.autoresizingMask = UIViewAutoresizingFlexibleWidth | UIViewAutoresizingFlexibleHeight;
	[_tableOverlayView addSubview:view];
}

- (void)searchBarSearchButtonClicked:(UISearchBar *)searchBar {
	[searchBar resignFirstResponder];
	[self.dataSource search:searchBar.text];
}

- (void)searchBarCancelButtonClicked:(UISearchBar *)searchBar {
	[searchBar resignFirstResponder];
}

- (void)searchBarTextDidEndEditing:(UISearchBar *)searchBar {
	[searchBar resignFirstResponder];
}

@end

