package jp.sf.fess.helper;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import jp.sf.fess.FessSystemException;
import jp.sf.fess.db.exentity.CrawlingSession;
import jp.sf.fess.db.exentity.CrawlingSessionInfo;
import jp.sf.fess.service.CrawlingSessionService;

public class CrawlingSessionHelper implements Serializable {

    private static final long serialVersionUID = 1L;

    @Resource
    protected CrawlingSessionService crawlingSessionService;

    public String getCanonicalSessionId(String sessionId) {
        int idx = sessionId.indexOf('-');
        if (idx >= 0) {
            return sessionId.substring(0, idx);
        }
        return sessionId;
    }

    public void put(String sessionId, Map<String, String> infoMap) {
        CrawlingSession crawlingSession = crawlingSessionService.get(sessionId);
        if (crawlingSession == null) {
            throw new FessSystemException("No crawling session.");
        }

        List<CrawlingSessionInfo> crawlingSessionInfoList = new ArrayList<CrawlingSessionInfo>();
        for (Map.Entry<String, String> entry : infoMap.entrySet()) {
            CrawlingSessionInfo crawlingSessionInfo = new CrawlingSessionInfo();
            crawlingSessionInfo.setCrawlingSessionId(crawlingSession.getId());
            crawlingSessionInfo.setKey(entry.getKey());
            crawlingSessionInfo.setValue(entry.getValue());
            crawlingSessionInfoList.add(crawlingSessionInfo);
        }
        crawlingSessionService.storeInfo(crawlingSessionInfoList);
    }

    public Map<String, String> getInfoMap(String sessionId) {
        List<CrawlingSessionInfo> crawlingSessionInfoList = crawlingSessionService
                .getCrawlingSessionInfoList(sessionId);
        Map<String, String> infoMap = new HashMap<String, String>();
        for (CrawlingSessionInfo crawlingSessionInfo : crawlingSessionInfoList) {
            infoMap.put(crawlingSessionInfo.getKey(), crawlingSessionInfo
                    .getValue());
        }
        return infoMap;
    }

    public String generateId(Map<String, Object> dataMap) {
        String url = (String) dataMap.get("url");
        List<String> typeList = (List<String>) dataMap.get("type");

        StringBuilder buf = new StringBuilder(1000);
        buf.append(url);
        if (!typeList.isEmpty()) {
            buf.append(";type=");
            for (int i = 0; i < typeList.size(); i++) {
                if (i != 0) {
                    buf.append(',');
                }
                buf.append(typeList.get(i));
            }
        }

        return buf.toString();
    }
}
