/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.allcommon.DBCurrent;
import jp.sf.fess.db.allcommon.DBFluteConfig;
import jp.sf.fess.db.bsentity.dbmeta.CrawlingSessionDbm;
import jp.sf.fess.db.cbean.CrawlingSessionCB;
import jp.sf.fess.db.cbean.CrawlingSessionInfoCB;
import jp.sf.fess.db.exbhv.CrawlingSessionInfoBhv;
import jp.sf.fess.db.exentity.CrawlingSession;
import jp.sf.fess.db.exentity.CrawlingSessionInfo;

import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.ConditionBeanSetupper;
import org.seasar.dbflute.bhv.LoadReferrerOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingBean;
import org.seasar.dbflute.cbean.PagingHandler;
import org.seasar.dbflute.cbean.PagingInvoker;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.cbean.ResultBeanBuilder;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.jdbc.StatementConfig;

/**
 * The behavior of CRAWLING_SESSION that the type is TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, SESSION_ID, CREATED_TIME
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     
 * 
 * [foreign-table]
 *     
 * 
 * [referrer-table]
 *     CRAWLING_SESSION_INFO
 * 
 * [foreign-property]
 *     
 * 
 * [referrer-property]
 *     crawlingSessionInfoList
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsCrawlingSessionBhv extends
        org.seasar.dbflute.bhv.AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:BehaviorQueryPathBegin*/
    /*df:BehaviorQueryPathEnd*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "CRAWLING_SESSION";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return CrawlingSessionDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public CrawlingSessionDbm getMyDBMeta() {
        return CrawlingSessionDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    public Entity newEntity() {
        return newMyEntity();
    }

    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    public CrawlingSession newMyEntity() {
        return new CrawlingSession();
    }

    public CrawlingSessionCB newMyConditionBean() {
        return new CrawlingSessionCB();
    }

    // ===================================================================================
    //                                                                       Current DBDef
    //                                                                       =============
    @Override
    protected DBDef getCurrentDBDef() {
        return DBCurrent.getInstance().currentDBDef();
    }

    // ===================================================================================
    //                                                             Default StatementConfig
    //                                                             =======================
    @Override
    protected StatementConfig getDefaultStatementConfig() {
        return DBFluteConfig.getInstance().getDefaultStatementConfig();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count by the condition-bean. {IgnorePagingCondition}
     * @param cb The condition-bean of CrawlingSession. (NotNull)
     * @return The selected count.
     */
    public int selectCount(CrawlingSessionCB cb) {
        assertCBNotNull(cb);
        return delegateSelectCount(cb);
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean. <br />
     * Attention: It has a mapping cost from result set to entity.
     * @param cb The condition-bean of CrawlingSession. (NotNull)
     * @param entityRowHandler The handler of entity row of CrawlingSession. (NotNull)
     */
    public void selectCursor(CrawlingSessionCB cb,
            EntityRowHandler<CrawlingSession> entityRowHandler) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<CrawlingSession>",
                entityRowHandler);
        delegateSelectCursor(cb, entityRowHandler);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * @param cb The condition-bean of CrawlingSession. (NotNull)
     * @return The selected entity. (Nullalble)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public CrawlingSession selectEntity(final CrawlingSessionCB cb) {
        return helpSelectEntityInternally(
                cb,
                new InternalSelectEntityCallback<CrawlingSession, CrawlingSessionCB>() {
                    public List<CrawlingSession> callbackSelectList(
                            CrawlingSessionCB cb) {
                        return selectList(cb);
                    }
                });
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * @param cb The condition-bean of CrawlingSession. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public CrawlingSession selectEntityWithDeletedCheck(
            final CrawlingSessionCB cb) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<CrawlingSession, CrawlingSessionCB>() {
                    public List<CrawlingSession> callbackSelectList(
                            CrawlingSessionCB cb) {
                        return selectList(cb);
                    }
                });
    }

    /* (non-javadoc)
     * Select the entity with deleted check. {by primary-key value}
     * @param primaryKey The keys of primary.
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public CrawlingSession selectByPKValueWithDeletedCheck(Long id) {
        CrawlingSession entity = new CrawlingSession();
        entity.setId(id);
        final CrawlingSessionCB cb = newMyConditionBean();
        cb.acceptPrimaryKeyMapString(getDBMeta().extractPrimaryKeyMapString(
                entity));
        return selectEntityWithDeletedCheck(cb);
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * @param cb The condition-bean of CrawlingSession. (NotNull)
     * @return The result bean of selected list. (NotNull)
     */
    public ListResultBean<CrawlingSession> selectList(CrawlingSessionCB cb) {
        assertCBNotNull(cb);
        return new ResultBeanBuilder<CrawlingSession>(getTableDbName())
                .buildListResultBean(cb, delegateSelectList(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean.
     * @param cb The condition-bean of CrawlingSession. (NotNull)
     * @return The result bean of selected page. (NotNull)
     */
    public PagingResultBean<CrawlingSession> selectPage(
            final CrawlingSessionCB cb) {
        assertCBNotNull(cb);
        final PagingInvoker<CrawlingSession> invoker = new PagingInvoker<CrawlingSession>(
                getTableDbName());
        final PagingHandler<CrawlingSession> handler = new PagingHandler<CrawlingSession>() {
            public PagingBean getPagingBean() {
                return cb;
            }

            public int count() {
                return selectCount(cb);
            }

            public List<CrawlingSession> paging() {
                return selectList(cb);
            }
        };
        return invoker.invokePaging(handler);
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function. <br />
     * Call a function method after this method called like as follows:
     * <pre>
     * crawlingSessionBhv.scalarSelect(Date.class).max(new ScalarQuery(CrawlingSessionCB cb) {
     *     cb.specify().columnXxxDatetime(); // the required specification of target column
     *     cb.query().setXxxName_PrefixSearch("S"); // query as you like it
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (Nullable)
     */
    public <RESULT> SLFunction<CrawlingSessionCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        CrawlingSessionCB cb = newMyConditionBean();
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<CrawlingSessionCB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                       Load Referrer
    //                                                                       =============
    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param crawlingSession The entity of crawlingSession. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean setupper for registering referrer condition. (NotNull)
     */
    public void loadCrawlingSessionInfoList(CrawlingSession crawlingSession,
            ConditionBeanSetupper<CrawlingSessionInfoCB> conditionBeanSetupper) {
        xassLRArg(crawlingSession, conditionBeanSetupper);
        loadCrawlingSessionInfoList(xnewLRLs(crawlingSession),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of crawlingSessionInfoList with the setupper for condition-bean of referrer. <br />
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the setupper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setCrawlingSessionId_InScope(pkList);
     * cb.query().addOrderBy_CrawlingSessionId_Asc();
     * </pre>
     * @param crawlingSessionList The entity list of crawlingSession. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean setupper for registering referrer condition. (NotNull)
     */
    public void loadCrawlingSessionInfoList(
            List<CrawlingSession> crawlingSessionList,
            ConditionBeanSetupper<CrawlingSessionInfoCB> conditionBeanSetupper) {
        xassLRArg(crawlingSessionList, conditionBeanSetupper);
        loadCrawlingSessionInfoList(
                crawlingSessionList,
                new LoadReferrerOption<CrawlingSessionInfoCB, CrawlingSessionInfo>(
                        conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param crawlingSession The entity of crawlingSession. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadCrawlingSessionInfoList(
            CrawlingSession crawlingSession,
            LoadReferrerOption<CrawlingSessionInfoCB, CrawlingSessionInfo> loadReferrerOption) {
        xassLRArg(crawlingSession, loadReferrerOption);
        loadCrawlingSessionInfoList(xnewLRLs(crawlingSession),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param crawlingSessionList The entity list of crawlingSession. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadCrawlingSessionInfoList(
            List<CrawlingSession> crawlingSessionList,
            LoadReferrerOption<CrawlingSessionInfoCB, CrawlingSessionInfo> loadReferrerOption) {
        xassLRArg(crawlingSessionList, loadReferrerOption);
        if (crawlingSessionList.isEmpty()) {
            return;
        }
        final CrawlingSessionInfoBhv referrerBhv = xgetBSFLR().select(
                CrawlingSessionInfoBhv.class);
        helpLoadReferrerInternally(
                crawlingSessionList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<CrawlingSession, Long, CrawlingSessionInfoCB, CrawlingSessionInfo>() {
                    public Long callbackBase_getPrimaryKeyValue(
                            CrawlingSession entity) {
                        return entity.getId();
                    }

                    public void callbackBase_setReferrerList(
                            CrawlingSession entity,
                            List<CrawlingSessionInfo> referrerList) {
                        entity.setCrawlingSessionInfoList(referrerList);
                    }

                    public CrawlingSessionInfoCB callbackReferrer_newMyConditionBean() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void callbackReferrer_queryForeignKeyInScope(
                            CrawlingSessionInfoCB cb, List<Long> pkList) {
                        cb.query().setCrawlingSessionId_InScope(pkList);
                    }

                    public void callbackReferrer_queryAddOrderByForeignKeyAsc(
                            CrawlingSessionInfoCB cb) {
                        cb.query().addOrderBy_CrawlingSessionId_Asc();
                    }

                    public List<CrawlingSessionInfo> callbackReferrer_selectList(
                            CrawlingSessionInfoCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long callbackReferrer_getForeignKeyValue(
                            CrawlingSessionInfo entity) {
                        return entity.getCrawlingSessionId();
                    }

                    public void callbackReferrer_setForeignEntity(
                            CrawlingSessionInfo referrerEntity,
                            CrawlingSession baseEntity) {
                        referrerEntity.setCrawlingSession(baseEntity);
                    }
                });
    }

    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * @param crawlingSession The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(CrawlingSession crawlingSession) {
        assertEntityNotNull(crawlingSession);
        delegateInsert(crawlingSession);
    }

    @Override
    protected void doCreate(Entity crawlingSession) {
        insert((CrawlingSession) crawlingSession);
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ConcurrencyControl}
     * @param crawlingSession The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(final CrawlingSession crawlingSession) {
        helpUpdateInternally(crawlingSession,
                new InternalUpdateCallback<CrawlingSession>() {
                    public int callbackDelegateUpdate(CrawlingSession entity) {
                        return delegateUpdate(entity);
                    }
                });
    }

    @Override
    protected void doModify(Entity entity) {
        update((CrawlingSession) entity);
    }

    @Override
    protected void doModifyNonstrict(Entity entity) {
        update((CrawlingSession) entity);
    }

    /**
     * Insert or update the entity modified-only. {ConcurrencyControl(when update)}
     * @param crawlingSession The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(final CrawlingSession crawlingSession) {
        helpInsertOrUpdateInternally(
                crawlingSession,
                new InternalInsertOrUpdateCallback<CrawlingSession, CrawlingSessionCB>() {
                    public void callbackInsert(CrawlingSession entity) {
                        insert(entity);
                    }

                    public void callbackUpdate(CrawlingSession entity) {
                        update(entity);
                    }

                    public CrawlingSessionCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(CrawlingSessionCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdate(Entity crawlingSession) {
        insertOrUpdate((CrawlingSession) crawlingSession);
    }

    @Override
    protected void doCreateOrUpdateNonstrict(Entity entity) {
        insertOrUpdate((CrawlingSession) entity);
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ConcurrencyControl}
     * @param crawlingSession The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(CrawlingSession crawlingSession) {
        helpDeleteInternally(crawlingSession,
                new InternalDeleteCallback<CrawlingSession>() {
                    public int callbackDelegateDelete(CrawlingSession entity) {
                        return delegateDelete(entity);
                    }
                });
    }

    @Override
    protected void doRemove(Entity crawlingSession) {
        delete((CrawlingSession) crawlingSession);
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch insert the list. This method use 'Batch Update' of java.sql.PreparedStatement.
     * @param crawlingSessionList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(List<CrawlingSession> crawlingSessionList) {
        assertObjectNotNull("crawlingSessionList", crawlingSessionList);
        return delegateInsertList(crawlingSessionList);
    }

    /**
     * Batch update the list. All columns are update target. {NOT modified only} <br />
     * This method use 'Batch Update' of java.sql.PreparedStatement.
     * @param crawlingSessionList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdate(List<CrawlingSession> crawlingSessionList) {
        assertObjectNotNull("crawlingSessionList", crawlingSessionList);
        return delegateUpdateList(crawlingSessionList);
    }

    /**
     * Batch delete the list. <br />
     * This method use 'Batch Update' of java.sql.PreparedStatement.
     * @param crawlingSessionList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDelete(List<CrawlingSession> crawlingSessionList) {
        assertObjectNotNull("crawlingSessionList", crawlingSessionList);
        return delegateDeleteList(crawlingSessionList);
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Query update the several entities. {NoConcurrencyControl}
     * @param crawlingSession Entity. (NotNull) {PrimaryKeyNotRequired}
     * @param cb Condition-bean. (NotNull)
     * @return The updated count.
     */
    public int queryUpdate(CrawlingSession crawlingSession, CrawlingSessionCB cb) {
        assertObjectNotNull("crawlingSession", crawlingSession);
        assertCBNotNull(cb);
        setupCommonColumnOfUpdateIfNeeds(crawlingSession);
        filterEntityOfUpdate(crawlingSession);
        assertEntityOfUpdate(crawlingSession);
        return invoke(createQueryUpdateEntityCBCommand(crawlingSession, cb));
    }

    /**
     * Query delete the several entities. {NoConcurrencyControl}
     * @param cb Condition-bean. (NotNull)
     * @return The deleted count.
     */
    public int queryDelete(CrawlingSessionCB cb) {
        assertCBNotNull(cb);
        return invoke(createQueryDeleteCBCommand(cb));
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCount(CrawlingSessionCB cb) {
        return invoke(createSelectCountCBCommand(cb));
    }

    protected void delegateSelectCursor(CrawlingSessionCB cb,
            EntityRowHandler<CrawlingSession> entityRowHandler) {
        invoke(createSelectCursorCBCommand(cb, entityRowHandler,
                CrawlingSession.class));
    }

    protected int doCallReadCount(ConditionBean cb) {
        return delegateSelectCount((CrawlingSessionCB) cb);
    }

    protected List<CrawlingSession> delegateSelectList(CrawlingSessionCB cb) {
        return invoke(createSelectListCBCommand(cb, CrawlingSession.class));
    }

    @SuppressWarnings("unchecked")
    protected List<Entity> doCallReadList(ConditionBean cb) {
        return (List) delegateSelectList((CrawlingSessionCB) cb);
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(CrawlingSession e) {
        if (!processBeforeInsert(e)) {
            return 1;
        }
        return invoke(createInsertEntityCommand(e));
    }

    protected int doCallCreate(Entity entity) {
        return delegateInsert(downcast(entity));
    }

    protected int delegateUpdate(CrawlingSession e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateEntityCommand(e));
    }

    protected int doCallModify(Entity entity) {
        return delegateUpdate(downcast(entity));
    }

    protected int delegateDelete(CrawlingSession e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteEntityCommand(e));
    }

    protected int doCallRemove(Entity entity) {
        return delegateDelete(downcast(entity));
    }

    protected int[] delegateInsertList(List<CrawlingSession> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertEntityCommand(helpFilterBeforeInsertInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doCreateList(List<Entity> ls) {
        return delegateInsertList((List) ls);
    }

    protected int[] delegateUpdateList(List<CrawlingSession> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doModifyList(List<Entity> ls) {
        return delegateUpdateList((List) ls);
    }

    protected int[] delegateDeleteList(List<CrawlingSession> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doRemoveList(List<Entity> ls) {
        return delegateDeleteList((List) ls);
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return false;
    }

    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                              Helper
    //                                                                              ======
    protected CrawlingSession downcast(Entity entity) {
        return helpDowncastInternally(entity, CrawlingSession.class);
    }
}
