/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.cbean.bs;

import java.util.Map;

import jp.sf.fess.db.allcommon.DBFluteConfig;
import jp.sf.fess.db.allcommon.DBMetaInstanceHandler;
import jp.sf.fess.db.allcommon.ImplementedSqlClauseCreator;
import jp.sf.fess.db.cbean.DataConfigToBrowserTypeMappingCB;
import jp.sf.fess.db.cbean.DataConfigToLabelTypeMappingCB;
import jp.sf.fess.db.cbean.DataConfigToRoleTypeMappingCB;
import jp.sf.fess.db.cbean.DataCrawlingConfigCB;
import jp.sf.fess.db.cbean.cq.DataCrawlingConfigCQ;

import org.seasar.dbflute.cbean.AbstractConditionBean;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.SubQuery;
import org.seasar.dbflute.cbean.UnionQuery;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.dbmeta.DBMetaProvider;

/**
 * The base condition-bean of DATA_CRAWLING_CONFIG.
 * @author DBFlute(AutoGenerator)
 */
public class BsDataCrawlingConfigCB extends AbstractConditionBean {

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    private final DBMetaProvider _dbmetaProvider = new DBMetaInstanceHandler();

    protected DataCrawlingConfigCQ _conditionQuery;

    // ===================================================================================
    //                                                                           SqlClause
    //                                                                           =========
    @Override
    protected SqlClause createSqlClause() {
        return new ImplementedSqlClauseCreator().createSqlClause(this);
    }

    // ===================================================================================
    //                                                                     DBMeta Provider
    //                                                                     ===============
    @Override
    protected DBMetaProvider getDBMetaProvider() {
        return _dbmetaProvider;
    }

    // ===================================================================================
    //                                                                          Table Name
    //                                                                          ==========
    public String getTableDbName() {
        return "DATA_CRAWLING_CONFIG";
    }

    public String getTableSqlName() {
        return "DATA_CRAWLING_CONFIG";
    }

    // ===================================================================================
    //                                                                      PrimaryKey Map
    //                                                                      ==============
    public void acceptPrimaryKeyMap(Map<String, ? extends Object> primaryKeyMap) {
        assertPrimaryKeyMap(primaryKeyMap);
        {
            Object obj = primaryKeyMap.get("ID");
            if (obj instanceof Long) {
                query().setId_Equal((Long) obj);
            } else {
                query().setId_Equal(new Long((String) obj));
            }
        }

    }

    // ===================================================================================
    //                                                                     OrderBy Setting
    //                                                                     ===============
    public ConditionBean addOrderBy_PK_Asc() {
        query().addOrderBy_Id_Asc();
        return this;
    }

    public ConditionBean addOrderBy_PK_Desc() {
        query().addOrderBy_Id_Desc();
        return this;
    }

    // ===================================================================================
    //                                                                               Query
    //                                                                               =====
    public DataCrawlingConfigCQ query() {
        return getConditionQuery();
    }

    public DataCrawlingConfigCQ getConditionQuery() {
        if (_conditionQuery == null) {
            _conditionQuery = new DataCrawlingConfigCQ(null, getSqlClause(),
                    getSqlClause().getLocalTableAliasName(), 0);
        }
        return _conditionQuery;
    }

    /**
     * {@inheritDoc}
     */
    public ConditionQuery localCQ() {
        return getConditionQuery();
    }

    // ===================================================================================
    //                                                                               Union
    //                                                                               =====
    /**
     * Set up 'union'.
     * <pre>
     * cb.query().union(new UnionQuery&lt;DataCrawlingConfigCB&gt;() {
     *     public void query(DataCrawlingConfigCB unionCB) {
     *         unionCB.query().setXxx...
     *     }
     * });
     * </pre>
     * @param unionQuery The query of 'union'. (NotNull)
     */
    public void union(UnionQuery<DataCrawlingConfigCB> unionQuery) {
        final DataCrawlingConfigCB cb = new DataCrawlingConfigCB();
        cb.xsetupForUnion();
        unionQuery.query(cb);
        final DataCrawlingConfigCQ cq = cb.query();
        query().xsetUnionQuery(cq);
    }

    /**
     * Set up 'union all'.
     * <pre>
     * cb.query().unionAll(new UnionQuery&lt;DataCrawlingConfigCB&gt;() {
     *     public void query(DataCrawlingConfigCB unionCB) {
     *         unionCB.query().setXxx...
     *     }
     * });
     * </pre>
     * @param unionQuery The query of 'union'. (NotNull)
     */
    public void unionAll(UnionQuery<DataCrawlingConfigCB> unionQuery) {
        final DataCrawlingConfigCB cb = new DataCrawlingConfigCB();
        cb.xsetupForUnion();
        unionQuery.query(cb);
        final DataCrawlingConfigCQ cq = cb.query();
        query().xsetUnionAllQuery(cq);
    }

    public boolean hasUnionQueryOrUnionAllQuery() {
        return query().hasUnionQueryOrUnionAllQuery();
    }

    // ===================================================================================
    //                                                                        Setup Select
    //                                                                        ============

    // [DBFlute-0.7.4]
    // ===================================================================================
    //                                                                             Specify
    //                                                                             =======
    protected Specification _specification;

    public Specification specify() {
        if (_specification == null) {
            _specification = new Specification(this,
                    new SpQyCall<DataCrawlingConfigCQ>() {
                        public boolean has() {
                            return true;
                        }

                        public DataCrawlingConfigCQ qy() {
                            return query();
                        }
                    }, _forDerivedReferrer, _forScalarSelect,
                    _forScalarSubQuery, getDBMetaProvider());
        }
        return _specification;
    }

    public static class Specification extends
            AbstractSpecification<DataCrawlingConfigCQ> {
        protected SpQyCall<DataCrawlingConfigCQ> _myQyCall;

        public Specification(ConditionBean baseCB,
                SpQyCall<DataCrawlingConfigCQ> qyCall,
                boolean forDeriveReferrer, boolean forScalarSelect,
                boolean forScalarSubQuery, DBMetaProvider dbmetaProvider) {
            super(baseCB, qyCall, forDeriveReferrer, forScalarSelect,
                    forScalarSubQuery, dbmetaProvider);
            _myQyCall = qyCall;
        }

        public void columnId() {
            doColumn("ID");
        }

        public void columnName() {
            doColumn("NAME");
        }

        public void columnHandlerName() {
            doColumn("HANDLER_NAME");
        }

        public void columnHandlerParameter() {
            doColumn("HANDLER_PARAMETER");
        }

        public void columnHandlerScript() {
            doColumn("HANDLER_SCRIPT");
        }

        public void columnBoost() {
            doColumn("BOOST");
        }

        public void columnAvailable() {
            doColumn("AVAILABLE");
        }

        public void columnSortOrder() {
            doColumn("SORT_ORDER");
        }

        public void columnCreatedBy() {
            doColumn("CREATED_BY");
        }

        public void columnCreatedTime() {
            doColumn("CREATED_TIME");
        }

        public void columnUpdatedBy() {
            doColumn("UPDATED_BY");
        }

        public void columnUpdatedTime() {
            doColumn("UPDATED_TIME");
        }

        public void columnDeletedBy() {
            doColumn("DELETED_BY");
        }

        public void columnDeletedTime() {
            doColumn("DELETED_TIME");
        }

        public void columnVersionNo() {
            doColumn("VERSION_NO");
        }

        protected void doSpecifyRequiredColumn() {
            columnId(); // PK
        }

        protected String getTableDbName() {
            return "DATA_CRAWLING_CONFIG";
        }

        public RAFunction<DataConfigToBrowserTypeMappingCB, DataCrawlingConfigCQ> derivedDataConfigToBrowserTypeMappingList() {
            return new RAFunction<DataConfigToBrowserTypeMappingCB, DataCrawlingConfigCQ>(
                    _baseCB,
                    _myQyCall.qy(),
                    new RAQSetupper<DataConfigToBrowserTypeMappingCB, DataCrawlingConfigCQ>() {
                        public void setup(
                                String function,
                                SubQuery<DataConfigToBrowserTypeMappingCB> subQuery,
                                DataCrawlingConfigCQ cq, String aliasName) {
                            cq.xsderiveDataConfigToBrowserTypeMappingList(
                                    function, subQuery, aliasName);
                        }
                    }, _dbmetaProvider);
        }

        public RAFunction<DataConfigToLabelTypeMappingCB, DataCrawlingConfigCQ> derivedDataConfigToLabelTypeMappingList() {
            return new RAFunction<DataConfigToLabelTypeMappingCB, DataCrawlingConfigCQ>(
                    _baseCB,
                    _myQyCall.qy(),
                    new RAQSetupper<DataConfigToLabelTypeMappingCB, DataCrawlingConfigCQ>() {
                        public void setup(
                                String function,
                                SubQuery<DataConfigToLabelTypeMappingCB> subQuery,
                                DataCrawlingConfigCQ cq, String aliasName) {
                            cq.xsderiveDataConfigToLabelTypeMappingList(
                                    function, subQuery, aliasName);
                        }
                    }, _dbmetaProvider);
        }

        public RAFunction<DataConfigToRoleTypeMappingCB, DataCrawlingConfigCQ> derivedDataConfigToRoleTypeMappingList() {
            return new RAFunction<DataConfigToRoleTypeMappingCB, DataCrawlingConfigCQ>(
                    _baseCB,
                    _myQyCall.qy(),
                    new RAQSetupper<DataConfigToRoleTypeMappingCB, DataCrawlingConfigCQ>() {
                        public void setup(
                                String function,
                                SubQuery<DataConfigToRoleTypeMappingCB> subQuery,
                                DataCrawlingConfigCQ cq, String aliasName) {
                            cq.xsderiveDataConfigToRoleTypeMappingList(
                                    function, subQuery, aliasName);
                        }
                    }, _dbmetaProvider);
        }
    }

    // ===================================================================================
    //                                                                         Display SQL
    //                                                                         ===========
    @Override
    protected String getLogDateFormat() {
        return DBFluteConfig.getInstance().getLogDateFormat();
    }

    @Override
    protected String getLogTimestampFormat() {
        return DBFluteConfig.getInstance().getLogTimestampFormat();
    }

    // ===================================================================================
    //                                                                            Internal
    //                                                                            ========
    // Very Internal (for Suppressing Warn about 'Not Use Import')
    protected String getConditionBeanClassNameInternally() {
        return DataCrawlingConfigCB.class.getName();
    }

    protected String getConditionQueryClassNameInternally() {
        return DataCrawlingConfigCQ.class.getName();
    }

    protected String getSubQueryClassNameInternally() {
        return SubQuery.class.getName();
    }
}
