/*
 * Copyright 2009-2011 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.bsentity.dbmeta.DataCrawlingConfigDbm;
import jp.sf.fess.db.cbean.DataConfigToBrowserTypeMappingCB;
import jp.sf.fess.db.cbean.DataConfigToLabelTypeMappingCB;
import jp.sf.fess.db.cbean.DataConfigToRoleTypeMappingCB;
import jp.sf.fess.db.cbean.DataCrawlingConfigCB;
import jp.sf.fess.db.exbhv.DataConfigToBrowserTypeMappingBhv;
import jp.sf.fess.db.exbhv.DataConfigToLabelTypeMappingBhv;
import jp.sf.fess.db.exbhv.DataConfigToRoleTypeMappingBhv;
import jp.sf.fess.db.exbhv.DataCrawlingConfigBhv;
import jp.sf.fess.db.exentity.DataConfigToBrowserTypeMapping;
import jp.sf.fess.db.exentity.DataConfigToLabelTypeMapping;
import jp.sf.fess.db.exentity.DataConfigToRoleTypeMapping;
import jp.sf.fess.db.exentity.DataCrawlingConfig;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.AbstractBehaviorWritable;
import org.seasar.dbflute.bhv.ConditionBeanSetupper;
import org.seasar.dbflute.bhv.DeleteOption;
import org.seasar.dbflute.bhv.InsertOption;
import org.seasar.dbflute.bhv.LoadReferrerOption;
import org.seasar.dbflute.bhv.QueryInsertSetupper;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.cbean.SpecifyQuery;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.outsidesql.executor.OutsideSqlBasicExecutor;

/**
 * The behavior of DATA_CRAWLING_CONFIG as TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, NAME, HANDLER_NAME, HANDLER_PARAMETER, HANDLER_SCRIPT, BOOST, AVAILABLE, SORT_ORDER, CREATED_BY, CREATED_TIME, UPDATED_BY, UPDATED_TIME, DELETED_BY, DELETED_TIME, VERSION_NO
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     VERSION_NO
 * 
 * [foreign-table]
 *     
 * 
 * [referrer-table]
 *     DATA_CONFIG_TO_BROWSER_TYPE_MAPPING, DATA_CONFIG_TO_LABEL_TYPE_MAPPING, DATA_CONFIG_TO_ROLE_TYPE_MAPPING
 * 
 * [foreign-property]
 *     
 * 
 * [referrer-property]
 *     dataConfigToBrowserTypeMappingList, dataConfigToLabelTypeMappingList, dataConfigToRoleTypeMappingList
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsDataCrawlingConfigBhv extends AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:beginQueryPath*/
    /*df:endQueryPath*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "DATA_CRAWLING_CONFIG";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return DataCrawlingConfigDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public DataCrawlingConfigDbm getMyDBMeta() {
        return DataCrawlingConfigDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    /** {@inheritDoc} */
    public Entity newEntity() {
        return newMyEntity();
    }

    /** {@inheritDoc} */
    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    /** @return The instance of new entity as my table type. (NotNull) */
    public DataCrawlingConfig newMyEntity() {
        return new DataCrawlingConfig();
    }

    /** @return The instance of new condition-bean as my table type. (NotNull) */
    public DataCrawlingConfigCB newMyConditionBean() {
        return new DataCrawlingConfigCB();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count of uniquely-selected records by the condition-bean. {IgnorePagingCondition, IgnoreSpecifyColumn}<br />
     * SpecifyColumn is ignored but you can use it only to remove text type column for union's distinct.
     * <pre>
     * DataCrawlingConfigCB cb = new DataCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * int count = dataCrawlingConfigBhv.<span style="color: #FD4747">selectCount</span>(cb);
     * </pre>
     * @param cb The condition-bean of DataCrawlingConfig. (NotNull)
     * @return The selected count.
     */
    public int selectCount(DataCrawlingConfigCB cb) {
        return doSelectCountUniquely(cb);
    }

    protected int doSelectCountUniquely(DataCrawlingConfigCB cb) { // called by selectCount(cb) 
        assertCBNotNull(cb);
        return delegateSelectCountUniquely(cb);
    }

    protected int doSelectCountPlainly(DataCrawlingConfigCB cb) { // called by selectPage(cb)
        assertCBNotNull(cb);
        return delegateSelectCountPlainly(cb);
    }

    @Override
    protected int doReadCount(ConditionBean cb) {
        return selectCount(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean.
     * <pre>
     * DataCrawlingConfigCB cb = new DataCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * dataCrawlingConfigBhv.<span style="color: #FD4747">selectCursor</span>(cb, new EntityRowHandler&lt;DataCrawlingConfig&gt;() {
     *     public void handle(DataCrawlingConfig entity) {
     *         ... = entity.getFoo...();
     *     }
     * });
     * </pre>
     * @param cb The condition-bean of DataCrawlingConfig. (NotNull)
     * @param entityRowHandler The handler of entity row of DataCrawlingConfig. (NotNull)
     */
    public void selectCursor(DataCrawlingConfigCB cb,
            EntityRowHandler<DataCrawlingConfig> entityRowHandler) {
        doSelectCursor(cb, entityRowHandler, DataCrawlingConfig.class);
    }

    protected <ENTITY extends DataCrawlingConfig> void doSelectCursor(
            DataCrawlingConfigCB cb, EntityRowHandler<ENTITY> entityRowHandler,
            Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<DataCrawlingConfig>",
                entityRowHandler);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        delegateSelectCursor(cb, entityRowHandler, entityType);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * <pre>
     * DataCrawlingConfigCB cb = new DataCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * DataCrawlingConfig dataCrawlingConfig = dataCrawlingConfigBhv.<span style="color: #FD4747">selectEntity</span>(cb);
     * if (dataCrawlingConfig != null) {
     *     ... = dataCrawlingConfig.get...();
     * } else {
     *     ...
     * }
     * </pre>
     * @param cb The condition-bean of DataCrawlingConfig. (NotNull)
     * @return The selected entity. (NullAllowed: If the condition has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public DataCrawlingConfig selectEntity(DataCrawlingConfigCB cb) {
        return doSelectEntity(cb, DataCrawlingConfig.class);
    }

    protected <ENTITY extends DataCrawlingConfig> ENTITY doSelectEntity(
            final DataCrawlingConfigCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityInternally(
                cb,
                new InternalSelectEntityCallback<ENTITY, DataCrawlingConfigCB>() {
                    public List<ENTITY> callbackSelectList(
                            DataCrawlingConfigCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntity(ConditionBean cb) {
        return selectEntity(downcast(cb));
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * <pre>
     * DataCrawlingConfigCB cb = new DataCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * DataCrawlingConfig dataCrawlingConfig = dataCrawlingConfigBhv.<span style="color: #FD4747">selectEntityWithDeletedCheck</span>(cb);
     * ... = dataCrawlingConfig.get...(); <span style="color: #3F7E5E">// the entity always be not null</span>
     * </pre>
     * @param cb The condition-bean of DataCrawlingConfig. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public DataCrawlingConfig selectEntityWithDeletedCheck(
            DataCrawlingConfigCB cb) {
        return doSelectEntityWithDeletedCheck(cb, DataCrawlingConfig.class);
    }

    protected <ENTITY extends DataCrawlingConfig> ENTITY doSelectEntityWithDeletedCheck(
            final DataCrawlingConfigCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<ENTITY, DataCrawlingConfigCB>() {
                    public List<ENTITY> callbackSelectList(
                            DataCrawlingConfigCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntityWithDeletedCheck(ConditionBean cb) {
        return selectEntityWithDeletedCheck(downcast(cb));
    }

    /**
     * Select the entity by the primary-key value.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NullAllowed: If the primary-key value has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public DataCrawlingConfig selectByPKValue(Long id) {
        return doSelectByPKValue(id, DataCrawlingConfig.class);
    }

    protected <ENTITY extends DataCrawlingConfig> ENTITY doSelectByPKValue(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntity(buildPKCB(id), entityType);
    }

    /**
     * Select the entity by the primary-key value with deleted check.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public DataCrawlingConfig selectByPKValueWithDeletedCheck(Long id) {
        return doSelectByPKValueWithDeletedCheck(id, DataCrawlingConfig.class);
    }

    protected <ENTITY extends DataCrawlingConfig> ENTITY doSelectByPKValueWithDeletedCheck(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntityWithDeletedCheck(buildPKCB(id), entityType);
    }

    private DataCrawlingConfigCB buildPKCB(Long id) {
        assertObjectNotNull("id", id);
        DataCrawlingConfigCB cb = newMyConditionBean();
        cb.query().setId_Equal(id);
        return cb;
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * <pre>
     * DataCrawlingConfigCB cb = new DataCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * ListResultBean&lt;DataCrawlingConfig&gt; dataCrawlingConfigList = dataCrawlingConfigBhv.<span style="color: #FD4747">selectList</span>(cb);
     * for (DataCrawlingConfig dataCrawlingConfig : dataCrawlingConfigList) {
     *     ... = dataCrawlingConfig.get...();
     * }
     * </pre>
     * @param cb The condition-bean of DataCrawlingConfig. (NotNull)
     * @return The result bean of selected list. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public ListResultBean<DataCrawlingConfig> selectList(DataCrawlingConfigCB cb) {
        return doSelectList(cb, DataCrawlingConfig.class);
    }

    protected <ENTITY extends DataCrawlingConfig> ListResultBean<ENTITY> doSelectList(
            DataCrawlingConfigCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        return helpSelectListInternally(cb, entityType,
                new InternalSelectListCallback<ENTITY, DataCrawlingConfigCB>() {
                    public List<ENTITY> callbackSelectList(
                            DataCrawlingConfigCB cb, Class<ENTITY> entityType) {
                        return delegateSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected ListResultBean<? extends Entity> doReadList(ConditionBean cb) {
        return selectList(downcast(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean. <br />
     * (both count-select and paging-select are executed)
     * <pre>
     * DataCrawlingConfigCB cb = new DataCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * cb.<span style="color: #FD4747">paging</span>(20, 3); <span style="color: #3F7E5E">// 20 records per a page and current page number is 3</span>
     * PagingResultBean&lt;DataCrawlingConfig&gt; page = dataCrawlingConfigBhv.<span style="color: #FD4747">selectPage</span>(cb);
     * int allRecordCount = page.getAllRecordCount();
     * int allPageCount = page.getAllPageCount();
     * boolean isExistPrePage = page.isExistPrePage();
     * boolean isExistNextPage = page.isExistNextPage();
     * ...
     * for (DataCrawlingConfig dataCrawlingConfig : page) {
     *     ... = dataCrawlingConfig.get...();
     * }
     * </pre>
     * @param cb The condition-bean of DataCrawlingConfig. (NotNull)
     * @return The result bean of selected page. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public PagingResultBean<DataCrawlingConfig> selectPage(
            DataCrawlingConfigCB cb) {
        return doSelectPage(cb, DataCrawlingConfig.class);
    }

    protected <ENTITY extends DataCrawlingConfig> PagingResultBean<ENTITY> doSelectPage(
            DataCrawlingConfigCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        return helpSelectPageInternally(cb, entityType,
                new InternalSelectPageCallback<ENTITY, DataCrawlingConfigCB>() {
                    public int callbackSelectCount(DataCrawlingConfigCB cb) {
                        return doSelectCountPlainly(cb);
                    }

                    public List<ENTITY> callbackSelectList(
                            DataCrawlingConfigCB cb, Class<ENTITY> entityType) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected PagingResultBean<? extends Entity> doReadPage(ConditionBean cb) {
        return selectPage(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function from uniquely-selected records. <br />
     * You should call a function method after this method called like as follows:
     * <pre>
     * dataCrawlingConfigBhv.<span style="color: #FD4747">scalarSelect</span>(Date.class).max(new ScalarQuery() {
     *     public void query(DataCrawlingConfigCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooDatetime()</span>; <span style="color: #3F7E5E">// required for a function</span>
     *         cb.query().setBarName_PrefixSearch("S");
     *     }
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (NullAllowed)
     */
    public <RESULT> SLFunction<DataCrawlingConfigCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        return doScalarSelect(resultType, newMyConditionBean());
    }

    protected <RESULT, CB extends DataCrawlingConfigCB> SLFunction<CB, RESULT> doScalarSelect(
            Class<RESULT> resultType, CB cb) {
        assertObjectNotNull("resultType", resultType);
        assertCBNotNull(cb);
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<CB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                            Sequence
    //                                                                            ========
    @Override
    protected Number doReadNextVal() {
        String msg = "This table is NOT related to sequence: "
                + getTableDbName();
        throw new UnsupportedOperationException(msg);
    }

    // ===================================================================================
    //                                                                       Load Referrer
    //                                                                       =============
    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param dataCrawlingConfig The entity of dataCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadDataConfigToBrowserTypeMappingList(
            DataCrawlingConfig dataCrawlingConfig,
            ConditionBeanSetupper<DataConfigToBrowserTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(dataCrawlingConfig, conditionBeanSetupper);
        loadDataConfigToBrowserTypeMappingList(xnewLRLs(dataCrawlingConfig),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of dataConfigToBrowserTypeMappingList with the set-upper for condition-bean of referrer.
     * <pre>
     * dataCrawlingConfigBhv.<span style="color: #FD4747">loadDataConfigToBrowserTypeMappingList</span>(dataCrawlingConfigList, new ConditionBeanSetupper&lt;DataConfigToBrowserTypeMappingCB&gt;() {
     *     public void setup(DataConfigToBrowserTypeMappingCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (DataCrawlingConfig dataCrawlingConfig : dataCrawlingConfigList) {
     *     ... = dataCrawlingConfig.<span style="color: #FD4747">getDataConfigToBrowserTypeMappingList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setDataConfigId_InScope(pkList);
     * cb.query().addOrderBy_DataConfigId_Asc();
     * </pre>
     * @param dataCrawlingConfigList The entity list of dataCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadDataConfigToBrowserTypeMappingList(
            List<DataCrawlingConfig> dataCrawlingConfigList,
            ConditionBeanSetupper<DataConfigToBrowserTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(dataCrawlingConfigList, conditionBeanSetupper);
        loadDataConfigToBrowserTypeMappingList(
                dataCrawlingConfigList,
                new LoadReferrerOption<DataConfigToBrowserTypeMappingCB, DataConfigToBrowserTypeMapping>()
                        .xinit(conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param dataCrawlingConfig The entity of dataCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadDataConfigToBrowserTypeMappingList(
            DataCrawlingConfig dataCrawlingConfig,
            LoadReferrerOption<DataConfigToBrowserTypeMappingCB, DataConfigToBrowserTypeMapping> loadReferrerOption) {
        xassLRArg(dataCrawlingConfig, loadReferrerOption);
        loadDataConfigToBrowserTypeMappingList(xnewLRLs(dataCrawlingConfig),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param dataCrawlingConfigList The entity list of dataCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadDataConfigToBrowserTypeMappingList(
            List<DataCrawlingConfig> dataCrawlingConfigList,
            LoadReferrerOption<DataConfigToBrowserTypeMappingCB, DataConfigToBrowserTypeMapping> loadReferrerOption) {
        xassLRArg(dataCrawlingConfigList, loadReferrerOption);
        if (dataCrawlingConfigList.isEmpty()) {
            return;
        }
        final DataConfigToBrowserTypeMappingBhv referrerBhv = xgetBSFLR()
                .select(DataConfigToBrowserTypeMappingBhv.class);
        helpLoadReferrerInternally(
                dataCrawlingConfigList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<DataCrawlingConfig, Long, DataConfigToBrowserTypeMappingCB, DataConfigToBrowserTypeMapping>() {
                    public Long getPKVal(DataCrawlingConfig e) {
                        return e.getId();
                    }

                    public void setRfLs(DataCrawlingConfig e,
                            List<DataConfigToBrowserTypeMapping> ls) {
                        e.setDataConfigToBrowserTypeMappingList(ls);
                    }

                    public DataConfigToBrowserTypeMappingCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void qyFKIn(DataConfigToBrowserTypeMappingCB cb,
                            List<Long> ls) {
                        cb.query().setDataConfigId_InScope(ls);
                    }

                    public void qyOdFKAsc(DataConfigToBrowserTypeMappingCB cb) {
                        cb.query().addOrderBy_DataConfigId_Asc();
                    }

                    public void spFKCol(DataConfigToBrowserTypeMappingCB cb) {
                        cb.specify().columnDataConfigId();
                    }

                    public List<DataConfigToBrowserTypeMapping> selRfLs(
                            DataConfigToBrowserTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long getFKVal(DataConfigToBrowserTypeMapping e) {
                        return e.getDataConfigId();
                    }

                    public void setlcEt(DataConfigToBrowserTypeMapping re,
                            DataCrawlingConfig le) {
                        re.setDataCrawlingConfig(le);
                    }
                });
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param dataCrawlingConfig The entity of dataCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadDataConfigToLabelTypeMappingList(
            DataCrawlingConfig dataCrawlingConfig,
            ConditionBeanSetupper<DataConfigToLabelTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(dataCrawlingConfig, conditionBeanSetupper);
        loadDataConfigToLabelTypeMappingList(xnewLRLs(dataCrawlingConfig),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of dataConfigToLabelTypeMappingList with the set-upper for condition-bean of referrer.
     * <pre>
     * dataCrawlingConfigBhv.<span style="color: #FD4747">loadDataConfigToLabelTypeMappingList</span>(dataCrawlingConfigList, new ConditionBeanSetupper&lt;DataConfigToLabelTypeMappingCB&gt;() {
     *     public void setup(DataConfigToLabelTypeMappingCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (DataCrawlingConfig dataCrawlingConfig : dataCrawlingConfigList) {
     *     ... = dataCrawlingConfig.<span style="color: #FD4747">getDataConfigToLabelTypeMappingList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setDataConfigId_InScope(pkList);
     * cb.query().addOrderBy_DataConfigId_Asc();
     * </pre>
     * @param dataCrawlingConfigList The entity list of dataCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadDataConfigToLabelTypeMappingList(
            List<DataCrawlingConfig> dataCrawlingConfigList,
            ConditionBeanSetupper<DataConfigToLabelTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(dataCrawlingConfigList, conditionBeanSetupper);
        loadDataConfigToLabelTypeMappingList(
                dataCrawlingConfigList,
                new LoadReferrerOption<DataConfigToLabelTypeMappingCB, DataConfigToLabelTypeMapping>()
                        .xinit(conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param dataCrawlingConfig The entity of dataCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadDataConfigToLabelTypeMappingList(
            DataCrawlingConfig dataCrawlingConfig,
            LoadReferrerOption<DataConfigToLabelTypeMappingCB, DataConfigToLabelTypeMapping> loadReferrerOption) {
        xassLRArg(dataCrawlingConfig, loadReferrerOption);
        loadDataConfigToLabelTypeMappingList(xnewLRLs(dataCrawlingConfig),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param dataCrawlingConfigList The entity list of dataCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadDataConfigToLabelTypeMappingList(
            List<DataCrawlingConfig> dataCrawlingConfigList,
            LoadReferrerOption<DataConfigToLabelTypeMappingCB, DataConfigToLabelTypeMapping> loadReferrerOption) {
        xassLRArg(dataCrawlingConfigList, loadReferrerOption);
        if (dataCrawlingConfigList.isEmpty()) {
            return;
        }
        final DataConfigToLabelTypeMappingBhv referrerBhv = xgetBSFLR().select(
                DataConfigToLabelTypeMappingBhv.class);
        helpLoadReferrerInternally(
                dataCrawlingConfigList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<DataCrawlingConfig, Long, DataConfigToLabelTypeMappingCB, DataConfigToLabelTypeMapping>() {
                    public Long getPKVal(DataCrawlingConfig e) {
                        return e.getId();
                    }

                    public void setRfLs(DataCrawlingConfig e,
                            List<DataConfigToLabelTypeMapping> ls) {
                        e.setDataConfigToLabelTypeMappingList(ls);
                    }

                    public DataConfigToLabelTypeMappingCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void qyFKIn(DataConfigToLabelTypeMappingCB cb,
                            List<Long> ls) {
                        cb.query().setDataConfigId_InScope(ls);
                    }

                    public void qyOdFKAsc(DataConfigToLabelTypeMappingCB cb) {
                        cb.query().addOrderBy_DataConfigId_Asc();
                    }

                    public void spFKCol(DataConfigToLabelTypeMappingCB cb) {
                        cb.specify().columnDataConfigId();
                    }

                    public List<DataConfigToLabelTypeMapping> selRfLs(
                            DataConfigToLabelTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long getFKVal(DataConfigToLabelTypeMapping e) {
                        return e.getDataConfigId();
                    }

                    public void setlcEt(DataConfigToLabelTypeMapping re,
                            DataCrawlingConfig le) {
                        re.setDataCrawlingConfig(le);
                    }
                });
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param dataCrawlingConfig The entity of dataCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadDataConfigToRoleTypeMappingList(
            DataCrawlingConfig dataCrawlingConfig,
            ConditionBeanSetupper<DataConfigToRoleTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(dataCrawlingConfig, conditionBeanSetupper);
        loadDataConfigToRoleTypeMappingList(xnewLRLs(dataCrawlingConfig),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of dataConfigToRoleTypeMappingList with the set-upper for condition-bean of referrer.
     * <pre>
     * dataCrawlingConfigBhv.<span style="color: #FD4747">loadDataConfigToRoleTypeMappingList</span>(dataCrawlingConfigList, new ConditionBeanSetupper&lt;DataConfigToRoleTypeMappingCB&gt;() {
     *     public void setup(DataConfigToRoleTypeMappingCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (DataCrawlingConfig dataCrawlingConfig : dataCrawlingConfigList) {
     *     ... = dataCrawlingConfig.<span style="color: #FD4747">getDataConfigToRoleTypeMappingList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setDataConfigId_InScope(pkList);
     * cb.query().addOrderBy_DataConfigId_Asc();
     * </pre>
     * @param dataCrawlingConfigList The entity list of dataCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadDataConfigToRoleTypeMappingList(
            List<DataCrawlingConfig> dataCrawlingConfigList,
            ConditionBeanSetupper<DataConfigToRoleTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(dataCrawlingConfigList, conditionBeanSetupper);
        loadDataConfigToRoleTypeMappingList(
                dataCrawlingConfigList,
                new LoadReferrerOption<DataConfigToRoleTypeMappingCB, DataConfigToRoleTypeMapping>()
                        .xinit(conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param dataCrawlingConfig The entity of dataCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadDataConfigToRoleTypeMappingList(
            DataCrawlingConfig dataCrawlingConfig,
            LoadReferrerOption<DataConfigToRoleTypeMappingCB, DataConfigToRoleTypeMapping> loadReferrerOption) {
        xassLRArg(dataCrawlingConfig, loadReferrerOption);
        loadDataConfigToRoleTypeMappingList(xnewLRLs(dataCrawlingConfig),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param dataCrawlingConfigList The entity list of dataCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadDataConfigToRoleTypeMappingList(
            List<DataCrawlingConfig> dataCrawlingConfigList,
            LoadReferrerOption<DataConfigToRoleTypeMappingCB, DataConfigToRoleTypeMapping> loadReferrerOption) {
        xassLRArg(dataCrawlingConfigList, loadReferrerOption);
        if (dataCrawlingConfigList.isEmpty()) {
            return;
        }
        final DataConfigToRoleTypeMappingBhv referrerBhv = xgetBSFLR().select(
                DataConfigToRoleTypeMappingBhv.class);
        helpLoadReferrerInternally(
                dataCrawlingConfigList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<DataCrawlingConfig, Long, DataConfigToRoleTypeMappingCB, DataConfigToRoleTypeMapping>() {
                    public Long getPKVal(DataCrawlingConfig e) {
                        return e.getId();
                    }

                    public void setRfLs(DataCrawlingConfig e,
                            List<DataConfigToRoleTypeMapping> ls) {
                        e.setDataConfigToRoleTypeMappingList(ls);
                    }

                    public DataConfigToRoleTypeMappingCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void qyFKIn(DataConfigToRoleTypeMappingCB cb,
                            List<Long> ls) {
                        cb.query().setDataConfigId_InScope(ls);
                    }

                    public void qyOdFKAsc(DataConfigToRoleTypeMappingCB cb) {
                        cb.query().addOrderBy_DataConfigId_Asc();
                    }

                    public void spFKCol(DataConfigToRoleTypeMappingCB cb) {
                        cb.specify().columnDataConfigId();
                    }

                    public List<DataConfigToRoleTypeMapping> selRfLs(
                            DataConfigToRoleTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long getFKVal(DataConfigToRoleTypeMapping e) {
                        return e.getDataConfigId();
                    }

                    public void setlcEt(DataConfigToRoleTypeMapping re,
                            DataCrawlingConfig le) {
                        re.setDataCrawlingConfig(le);
                    }
                });
    }

    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * <pre>
     * DataCrawlingConfig dataCrawlingConfig = new DataCrawlingConfig();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * dataCrawlingConfig.setFoo...(value);
     * dataCrawlingConfig.setBar...(value);
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//dataCrawlingConfig.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//dataCrawlingConfig.set...;</span>
     * dataCrawlingConfigBhv.<span style="color: #FD4747">insert</span>(dataCrawlingConfig);
     * ... = dataCrawlingConfig.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param dataCrawlingConfig The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(DataCrawlingConfig dataCrawlingConfig) {
        doInsert(dataCrawlingConfig, null);
    }

    protected void doInsert(DataCrawlingConfig dataCrawlingConfig,
            InsertOption<DataCrawlingConfigCB> option) {
        assertObjectNotNull("dataCrawlingConfig", dataCrawlingConfig);
        prepareInsertOption(option);
        delegateInsert(dataCrawlingConfig, option);
    }

    protected void prepareInsertOption(InsertOption<DataCrawlingConfigCB> option) {
        if (option == null) {
            return;
        }
        assertInsertOptionStatus(option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doCreate(Entity entity,
            InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            insert(downcast(entity));
        } else {
            varyingInsert(downcast(entity), (InsertOption) option);
        }
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * DataCrawlingConfig dataCrawlingConfig = new DataCrawlingConfig();
     * dataCrawlingConfig.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * dataCrawlingConfig.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//dataCrawlingConfig.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//dataCrawlingConfig.set...;</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * dataCrawlingConfig.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     dataCrawlingConfigBhv.<span style="color: #FD4747">update</span>(dataCrawlingConfig);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param dataCrawlingConfig The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(final DataCrawlingConfig dataCrawlingConfig) {
        doUpdate(dataCrawlingConfig, null);
    }

    protected void doUpdate(DataCrawlingConfig dataCrawlingConfig,
            final UpdateOption<DataCrawlingConfigCB> option) {
        assertObjectNotNull("dataCrawlingConfig", dataCrawlingConfig);
        prepareUpdateOption(option);
        helpUpdateInternally(dataCrawlingConfig,
                new InternalUpdateCallback<DataCrawlingConfig>() {
                    public int callbackDelegateUpdate(DataCrawlingConfig entity) {
                        return delegateUpdate(entity, option);
                    }
                });
    }

    protected void prepareUpdateOption(UpdateOption<DataCrawlingConfigCB> option) {
        if (option == null) {
            return;
        }
        assertUpdateOptionStatus(option);
        if (option.hasSelfSpecification()) {
            option.resolveSelfSpecification(createCBForVaryingUpdate());
        }
        if (option.hasSpecifiedUpdateColumn()) {
            option.resolveUpdateColumnSpecification(createCBForSpecifiedUpdate());
        }
    }

    protected DataCrawlingConfigCB createCBForVaryingUpdate() {
        DataCrawlingConfigCB cb = newMyConditionBean();
        cb.xsetupForVaryingUpdate();
        return cb;
    }

    protected DataCrawlingConfigCB createCBForSpecifiedUpdate() {
        DataCrawlingConfigCB cb = newMyConditionBean();
        cb.xsetupForSpecifiedUpdate();
        return cb;
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doModify(Entity entity,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            update(downcast(entity));
        } else {
            varyingUpdate(downcast(entity), (UpdateOption) option);
        }
    }

    /**
     * Update the entity non-strictly modified-only. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * DataCrawlingConfig dataCrawlingConfig = new DataCrawlingConfig();
     * dataCrawlingConfig.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * dataCrawlingConfig.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//dataCrawlingConfig.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//dataCrawlingConfig.set...;</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//dataCrawlingConfig.setVersionNo(value);</span>
     * dataCrawlingConfigBhv.<span style="color: #FD4747">updateNonstrict</span>(dataCrawlingConfig);
     * </pre>
     * @param dataCrawlingConfig The entity of update target. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void updateNonstrict(final DataCrawlingConfig dataCrawlingConfig) {
        doUpdateNonstrict(dataCrawlingConfig, null);
    }

    protected void doUpdateNonstrict(DataCrawlingConfig dataCrawlingConfig,
            final UpdateOption<DataCrawlingConfigCB> option) {
        assertObjectNotNull("dataCrawlingConfig", dataCrawlingConfig);
        prepareUpdateOption(option);
        helpUpdateNonstrictInternally(dataCrawlingConfig,
                new InternalUpdateNonstrictCallback<DataCrawlingConfig>() {
                    public int callbackDelegateUpdateNonstrict(
                            DataCrawlingConfig entity) {
                        return delegateUpdateNonstrict(entity, option);
                    }
                });
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doModifyNonstrict(Entity entity,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            updateNonstrict(downcast(entity));
        } else {
            varyingUpdateNonstrict(downcast(entity), (UpdateOption) option);
        }
    }

    /**
     * Insert or update the entity modified-only. {ExclusiveControl(when update)}
     * @param dataCrawlingConfig The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(DataCrawlingConfig dataCrawlingConfig) {
        doInesrtOrUpdate(dataCrawlingConfig, null, null);
    }

    protected void doInesrtOrUpdate(DataCrawlingConfig dataCrawlingConfig,
            final InsertOption<DataCrawlingConfigCB> insertOption,
            final UpdateOption<DataCrawlingConfigCB> updateOption) {
        helpInsertOrUpdateInternally(
                dataCrawlingConfig,
                new InternalInsertOrUpdateCallback<DataCrawlingConfig, DataCrawlingConfigCB>() {
                    public void callbackInsert(DataCrawlingConfig entity) {
                        doInsert(entity, insertOption);
                    }

                    public void callbackUpdate(DataCrawlingConfig entity) {
                        doUpdate(entity, updateOption);
                    }

                    public DataCrawlingConfigCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(DataCrawlingConfigCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doCreateOrModify(Entity entity,
            InsertOption<? extends ConditionBean> insertOption,
            UpdateOption<? extends ConditionBean> updateOption) {
        if (insertOption == null && updateOption == null) {
            insertOrUpdate(downcast(entity));
        } else {
            insertOption = insertOption == null ? new InsertOption()
                    : insertOption;
            updateOption = updateOption == null ? new UpdateOption()
                    : updateOption;
            varyingInsertOrUpdate(downcast(entity),
                    (InsertOption) insertOption, (UpdateOption) updateOption);
        }
    }

    /**
     * Insert or update the entity non-strictly modified-only. {NonExclusiveControl(when update)}
     * @param dataCrawlingConfig The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdateNonstrict(DataCrawlingConfig dataCrawlingConfig) {
        doInesrtOrUpdateNonstrict(dataCrawlingConfig, null, null);
    }

    protected void doInesrtOrUpdateNonstrict(
            DataCrawlingConfig dataCrawlingConfig,
            final InsertOption<DataCrawlingConfigCB> insertOption,
            final UpdateOption<DataCrawlingConfigCB> updateOption) {
        helpInsertOrUpdateInternally(
                dataCrawlingConfig,
                new InternalInsertOrUpdateNonstrictCallback<DataCrawlingConfig>() {
                    public void callbackInsert(DataCrawlingConfig entity) {
                        doInsert(entity, insertOption);
                    }

                    public void callbackUpdateNonstrict(
                            DataCrawlingConfig entity) {
                        doUpdateNonstrict(entity, updateOption);
                    }
                });
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doCreateOrModifyNonstrict(Entity entity,
            InsertOption<? extends ConditionBean> insertOption,
            UpdateOption<? extends ConditionBean> updateOption) {
        if (insertOption == null && updateOption == null) {
            insertOrUpdateNonstrict(downcast(entity));
        } else {
            insertOption = insertOption == null ? new InsertOption()
                    : insertOption;
            updateOption = updateOption == null ? new UpdateOption()
                    : updateOption;
            varyingInsertOrUpdateNonstrict(downcast(entity),
                    (InsertOption) insertOption, (UpdateOption) updateOption);
        }
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * DataCrawlingConfig dataCrawlingConfig = new DataCrawlingConfig();
     * dataCrawlingConfig.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * dataCrawlingConfig.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     dataCrawlingConfigBhv.<span style="color: #FD4747">delete</span>(dataCrawlingConfig);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param dataCrawlingConfig The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(DataCrawlingConfig dataCrawlingConfig) {
        doDelete(dataCrawlingConfig, null);
    }

    protected void doDelete(DataCrawlingConfig dataCrawlingConfig,
            final DeleteOption<DataCrawlingConfigCB> option) {
        assertObjectNotNull("dataCrawlingConfig", dataCrawlingConfig);
        prepareDeleteOption(option);
        helpDeleteInternally(dataCrawlingConfig,
                new InternalDeleteCallback<DataCrawlingConfig>() {
                    public int callbackDelegateDelete(DataCrawlingConfig entity) {
                        return delegateDelete(entity, option);
                    }
                });
    }

    protected void prepareDeleteOption(DeleteOption<DataCrawlingConfigCB> option) {
        if (option == null) {
            return;
        }
        assertDeleteOptionStatus(option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doRemove(Entity entity,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            delete(downcast(entity));
        } else {
            varyingDelete(downcast(entity), (DeleteOption) option);
        }
    }

    /**
     * Delete the entity non-strictly. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * DataCrawlingConfig dataCrawlingConfig = new DataCrawlingConfig();
     * dataCrawlingConfig.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//dataCrawlingConfig.setVersionNo(value);</span>
     * dataCrawlingConfigBhv.<span style="color: #FD4747">deleteNonstrict</span>(dataCrawlingConfig);
     * </pre>
     * @param dataCrawlingConfig The entity of delete target. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrict(DataCrawlingConfig dataCrawlingConfig) {
        doDeleteNonstrict(dataCrawlingConfig, null);
    }

    protected void doDeleteNonstrict(DataCrawlingConfig dataCrawlingConfig,
            final DeleteOption<DataCrawlingConfigCB> option) {
        assertObjectNotNull("dataCrawlingConfig", dataCrawlingConfig);
        prepareDeleteOption(option);
        helpDeleteNonstrictInternally(dataCrawlingConfig,
                new InternalDeleteNonstrictCallback<DataCrawlingConfig>() {
                    public int callbackDelegateDeleteNonstrict(
                            DataCrawlingConfig entity) {
                        return delegateDeleteNonstrict(entity, option);
                    }
                });
    }

    /**
     * Delete the entity non-strictly ignoring deleted. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * DataCrawlingConfig dataCrawlingConfig = new DataCrawlingConfig();
     * dataCrawlingConfig.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//dataCrawlingConfig.setVersionNo(value);</span>
     * dataCrawlingConfigBhv.<span style="color: #FD4747">deleteNonstrictIgnoreDeleted</span>(dataCrawlingConfig);
     * <span style="color: #3F7E5E">// if the target entity doesn't exist, no exception</span>
     * </pre>
     * @param dataCrawlingConfig The entity of delete target. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrictIgnoreDeleted(
            DataCrawlingConfig dataCrawlingConfig) {
        doDeleteNonstrictIgnoreDeleted(dataCrawlingConfig, null);
    }

    protected void doDeleteNonstrictIgnoreDeleted(
            DataCrawlingConfig dataCrawlingConfig,
            final DeleteOption<DataCrawlingConfigCB> option) {
        assertObjectNotNull("dataCrawlingConfig", dataCrawlingConfig);
        prepareDeleteOption(option);
        helpDeleteNonstrictIgnoreDeletedInternally(
                dataCrawlingConfig,
                new InternalDeleteNonstrictIgnoreDeletedCallback<DataCrawlingConfig>() {
                    public int callbackDelegateDeleteNonstrict(
                            DataCrawlingConfig entity) {
                        return delegateDeleteNonstrict(entity, option);
                    }
                });
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doRemoveNonstrict(Entity entity,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            deleteNonstrict(downcast(entity));
        } else {
            varyingDeleteNonstrict(downcast(entity), (DeleteOption) option);
        }
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch-insert the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * All columns are insert target. (so default constraints are not available) <br />
     * And if the table has an identity, entities after the process do not have incremented values.
     * (When you use the (normal) insert(), an entity after the process has an incremented value)
     * @param dataCrawlingConfigList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(List<DataCrawlingConfig> dataCrawlingConfigList) {
        return doBatchInsert(dataCrawlingConfigList, null);
    }

    protected int[] doBatchInsert(
            List<DataCrawlingConfig> dataCrawlingConfigList,
            InsertOption<DataCrawlingConfigCB> option) {
        assertObjectNotNull("dataCrawlingConfigList", dataCrawlingConfigList);
        prepareInsertOption(option);
        return delegateBatchInsert(dataCrawlingConfigList, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpCreate(List<Entity> ls,
            InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchInsert((List) ls);
        } else {
            return varyingBatchInsert((List) ls, (InsertOption) option);
        }
    }

    /**
     * Batch-update the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * All columns are update target. {NOT modified only}
     * @param dataCrawlingConfigList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchUpdate(List<DataCrawlingConfig> dataCrawlingConfigList) {
        return doBatchUpdate(dataCrawlingConfigList, null);
    }

    protected int[] doBatchUpdate(
            List<DataCrawlingConfig> dataCrawlingConfigList,
            UpdateOption<DataCrawlingConfigCB> option) {
        assertObjectNotNull("dataCrawlingConfigList", dataCrawlingConfigList);
        prepareUpdateOption(option);
        return delegateBatchUpdate(dataCrawlingConfigList, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpModify(List<Entity> ls,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchUpdate((List) ls);
        } else {
            return varyingBatchUpdate((List) ls, (UpdateOption) option);
        }
    }

    /**
     * Batch-update the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * You can specify update columns used on set clause of update statement.
     * However you do not need to specify common columns for update
     * and an optimistick lock column because they are specified implicitly.
     * @param dataCrawlingConfigList The list of the entity. (NotNull)
     * @param updateColumnSpec The specification of update columns. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchUpdate(List<DataCrawlingConfig> dataCrawlingConfigList,
            SpecifyQuery<DataCrawlingConfigCB> updateColumnSpec) {
        return doBatchUpdate(dataCrawlingConfigList,
                createSpecifiedUpdateOption(updateColumnSpec));
    }

    /**
     * Batch-update the list non-strictly. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * All columns are update target. {NOT modified only}
     * @param dataCrawlingConfigList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdateNonstrict(
            List<DataCrawlingConfig> dataCrawlingConfigList) {
        return doBatchUpdateNonstrict(dataCrawlingConfigList, null);
    }

    protected int[] doBatchUpdateNonstrict(
            List<DataCrawlingConfig> dataCrawlingConfigList,
            UpdateOption<DataCrawlingConfigCB> option) {
        assertObjectNotNull("dataCrawlingConfigList", dataCrawlingConfigList);
        prepareUpdateOption(option);
        return delegateBatchUpdateNonstrict(dataCrawlingConfigList, option);
    }

    /**
     * Batch-update the list non-strictly. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * You can specify update columns used on set clause of update statement.
     * However you do not need to specify common columns for update
     * and an optimistick lock column because they are specified implicitly.
     * @param dataCrawlingConfigList The list of the entity. (NotNull)
     * @param updateColumnSpec The specification of update columns. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdateNonstrict(
            List<DataCrawlingConfig> dataCrawlingConfigList,
            SpecifyQuery<DataCrawlingConfigCB> updateColumnSpec) {
        return doBatchUpdateNonstrict(dataCrawlingConfigList,
                createSpecifiedUpdateOption(updateColumnSpec));
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpModifyNonstrict(List<Entity> ls,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchUpdateNonstrict((List) ls);
        } else {
            return varyingBatchUpdateNonstrict((List) ls, (UpdateOption) option);
        }
    }

    /**
     * Batch-delete the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param dataCrawlingConfigList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchDelete(List<DataCrawlingConfig> dataCrawlingConfigList) {
        return doBatchDelete(dataCrawlingConfigList, null);
    }

    protected int[] doBatchDelete(
            List<DataCrawlingConfig> dataCrawlingConfigList,
            DeleteOption<DataCrawlingConfigCB> option) {
        assertObjectNotNull("dataCrawlingConfigList", dataCrawlingConfigList);
        prepareDeleteOption(option);
        return delegateBatchDelete(dataCrawlingConfigList, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpRemove(List<Entity> ls,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchDelete((List) ls);
        } else {
            return varyingBatchDelete((List) ls, (DeleteOption) option);
        }
    }

    /**
     * Batch-delete the list non-strictly. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param dataCrawlingConfigList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDeleteNonstrict(
            List<DataCrawlingConfig> dataCrawlingConfigList) {
        return doBatchDeleteNonstrict(dataCrawlingConfigList, null);
    }

    protected int[] doBatchDeleteNonstrict(
            List<DataCrawlingConfig> dataCrawlingConfigList,
            DeleteOption<DataCrawlingConfigCB> option) {
        assertObjectNotNull("dataCrawlingConfigList", dataCrawlingConfigList);
        prepareDeleteOption(option);
        return delegateBatchDeleteNonstrict(dataCrawlingConfigList, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpRemoveNonstrict(List<Entity> ls,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchDeleteNonstrict((List) ls);
        } else {
            return varyingBatchDeleteNonstrict((List) ls, (DeleteOption) option);
        }
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Insert the several entities by query (modified-only for fixed value).
     * <pre>
     * dataCrawlingConfigBhv.<span style="color: #FD4747">queryInsert</span>(new QueryInsertSetupper&lt;dataCrawlingConfig, DataCrawlingConfigCB&gt;() {
     *     public ConditionBean setup(dataCrawlingConfig entity, DataCrawlingConfigCB intoCB) {
     *         FooCB cb = FooCB();
     *         cb.setupSelect_Bar();
     * 
     *         <span style="color: #3F7E5E">// mapping</span>
     *         intoCB.specify().columnMyName().mappedFrom(cb.specify().columnFooName());
     *         intoCB.specify().columnMyCount().mappedFrom(cb.specify().columnFooCount());
     *         intoCB.specify().columnMyDate().mappedFrom(cb.specify().specifyBar().columnBarDate());
     *         entity.setMyFixedValue("foo"); <span style="color: #3F7E5E">// fixed value</span>
     *         <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     *         <span style="color: #3F7E5E">//entity.setRegisterUser(value);</span>
     *         <span style="color: #3F7E5E">//entity.set...;</span>
     *         <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     *         <span style="color: #3F7E5E">//entity.setVersionNo(value);</span>
     * 
     *         return cb;
     *     }
     * });
     * </pre>
     * @param setupper The setup-per of query-insert. (NotNull)
     * @return The inserted count.
     */
    public int queryInsert(
            QueryInsertSetupper<DataCrawlingConfig, DataCrawlingConfigCB> setupper) {
        return doQueryInsert(setupper, null);
    }

    protected int doQueryInsert(
            QueryInsertSetupper<DataCrawlingConfig, DataCrawlingConfigCB> setupper,
            InsertOption<DataCrawlingConfigCB> option) {
        assertObjectNotNull("setupper", setupper);
        prepareInsertOption(option);
        DataCrawlingConfig entity = new DataCrawlingConfig();
        DataCrawlingConfigCB intoCB = createCBForQueryInsert();
        ConditionBean resourceCB = setupper.setup(entity, intoCB);
        return delegateQueryInsert(entity, intoCB, resourceCB, option);
    }

    protected DataCrawlingConfigCB createCBForQueryInsert() {
        DataCrawlingConfigCB cb = newMyConditionBean();
        cb.xsetupForQueryInsert();
        return cb;
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int doRangeCreate(
            QueryInsertSetupper<? extends Entity, ? extends ConditionBean> setupper,
            InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryInsert((QueryInsertSetupper) setupper);
        } else {
            return varyingQueryInsert((QueryInsertSetupper) setupper,
                    (InsertOption) option);
        }
    }

    /**
     * Update the several entities by query non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * DataCrawlingConfig dataCrawlingConfig = new DataCrawlingConfig();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//dataCrawlingConfig.setPK...(value);</span>
     * dataCrawlingConfig.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//dataCrawlingConfig.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//dataCrawlingConfig.set...;</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//dataCrawlingConfig.setVersionNo(value);</span>
     * DataCrawlingConfigCB cb = new DataCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * dataCrawlingConfigBhv.<span style="color: #FD4747">queryUpdate</span>(dataCrawlingConfig, cb);
     * </pre>
     * @param dataCrawlingConfig The entity that contains update values. (NotNull, PrimaryKeyNullAllowed)
     * @param cb The condition-bean of DataCrawlingConfig. (NotNull)
     * @return The updated count.
     * @exception org.seasar.dbflute.exception.NonQueryUpdateNotAllowedException When the query has no condition.
     */
    public int queryUpdate(DataCrawlingConfig dataCrawlingConfig,
            DataCrawlingConfigCB cb) {
        return doQueryUpdate(dataCrawlingConfig, cb, null);
    }

    protected int doQueryUpdate(DataCrawlingConfig dataCrawlingConfig,
            DataCrawlingConfigCB cb, UpdateOption<DataCrawlingConfigCB> option) {
        assertObjectNotNull("dataCrawlingConfig", dataCrawlingConfig);
        assertCBNotNull(cb);
        prepareUpdateOption(option);
        return delegateQueryUpdate(dataCrawlingConfig, cb, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int doRangeModify(Entity entity, ConditionBean cb,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryUpdate(downcast(entity), (DataCrawlingConfigCB) cb);
        } else {
            return varyingQueryUpdate(downcast(entity),
                    (DataCrawlingConfigCB) cb, (UpdateOption) option);
        }
    }

    /**
     * Delete the several entities by query. {NonExclusiveControl}
     * <pre>
     * DataCrawlingConfigCB cb = new DataCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * dataCrawlingConfigBhv.<span style="color: #FD4747">queryDelete</span>(dataCrawlingConfig, cb);
     * </pre>
     * @param cb The condition-bean of DataCrawlingConfig. (NotNull)
     * @return The deleted count.
     * @exception org.seasar.dbflute.exception.NonQueryDeleteNotAllowedException When the query has no condition.
     */
    public int queryDelete(DataCrawlingConfigCB cb) {
        return doQueryDelete(cb, null);
    }

    protected int doQueryDelete(DataCrawlingConfigCB cb,
            DeleteOption<DataCrawlingConfigCB> option) {
        assertCBNotNull(cb);
        prepareDeleteOption(option);
        return delegateQueryDelete(cb, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int doRangeRemove(ConditionBean cb,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryDelete((DataCrawlingConfigCB) cb);
        } else {
            return varyingQueryDelete((DataCrawlingConfigCB) cb,
                    (DeleteOption) option);
        }
    }

    // ===================================================================================
    //                                                                      Varying Update
    //                                                                      ==============
    // -----------------------------------------------------
    //                                         Entity Update
    //                                         -------------
    /**
     * Insert the entity with varying requests. <br />
     * For example, disableCommonColumnAutoSetup(), disablePrimaryKeyIdentity(). <br />
     * Other specifications are same as insert(entity).
     * <pre>
     * DataCrawlingConfig dataCrawlingConfig = new DataCrawlingConfig();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * dataCrawlingConfig.setFoo...(value);
     * dataCrawlingConfig.setBar...(value);
     * InsertOption<DataCrawlingConfigCB> option = new InsertOption<DataCrawlingConfigCB>();
     * <span style="color: #3F7E5E">// you can insert by your values for common columns</span>
     * option.disableCommonColumnAutoSetup();
     * dataCrawlingConfigBhv.<span style="color: #FD4747">varyingInsert</span>(dataCrawlingConfig, option);
     * ... = dataCrawlingConfig.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param dataCrawlingConfig The entity of insert target. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingInsert(DataCrawlingConfig dataCrawlingConfig,
            InsertOption<DataCrawlingConfigCB> option) {
        assertInsertOptionNotNull(option);
        doInsert(dataCrawlingConfig, option);
    }

    /**
     * Update the entity with varying requests modified-only. {UpdateCountZeroException, ExclusiveControl} <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification), disableCommonColumnAutoSetup(). <br />
     * Other specifications are same as update(entity).
     * <pre>
     * DataCrawlingConfig dataCrawlingConfig = new DataCrawlingConfig();
     * dataCrawlingConfig.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * dataCrawlingConfig.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * dataCrawlingConfig.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     <span style="color: #3F7E5E">// you can update by self calculation values</span>
     *     UpdateOption&lt;DataCrawlingConfigCB&gt; option = new UpdateOption&lt;DataCrawlingConfigCB&gt;();
     *     option.self(new SpecifyQuery&lt;DataCrawlingConfigCB&gt;() {
     *         public void specify(DataCrawlingConfigCB cb) {
     *             cb.specify().<span style="color: #FD4747">columnXxxCount()</span>;
     *         }
     *     }).plus(1); <span style="color: #3F7E5E">// XXX_COUNT = XXX_COUNT + 1</span>
     *     dataCrawlingConfigBhv.<span style="color: #FD4747">varyingUpdate</span>(dataCrawlingConfig, option);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * }
     * </pre>
     * @param dataCrawlingConfig The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdate(DataCrawlingConfig dataCrawlingConfig,
            UpdateOption<DataCrawlingConfigCB> option) {
        assertUpdateOptionNotNull(option);
        doUpdate(dataCrawlingConfig, option);
    }

    /**
     * Update the entity with varying requests non-strictly modified-only. {UpdateCountZeroException, NonExclusiveControl} <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification), disableCommonColumnAutoSetup(). <br />
     * Other specifications are same as updateNonstrict(entity).
     * <pre>
     * <span style="color: #3F7E5E">// ex) you can update by self calculation values</span>
     * DataCrawlingConfig dataCrawlingConfig = new DataCrawlingConfig();
     * dataCrawlingConfig.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * dataCrawlingConfig.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//dataCrawlingConfig.setVersionNo(value);</span>
     * UpdateOption&lt;DataCrawlingConfigCB&gt; option = new UpdateOption&lt;DataCrawlingConfigCB&gt;();
     * option.self(new SpecifyQuery&lt;DataCrawlingConfigCB&gt;() {
     *     public void specify(DataCrawlingConfigCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * dataCrawlingConfigBhv.<span style="color: #FD4747">varyingUpdateNonstrict</span>(dataCrawlingConfig, option);
     * </pre>
     * @param dataCrawlingConfig The entity of update target. (NotNull) {PrimaryKeyRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdateNonstrict(DataCrawlingConfig dataCrawlingConfig,
            UpdateOption<DataCrawlingConfigCB> option) {
        assertUpdateOptionNotNull(option);
        doUpdateNonstrict(dataCrawlingConfig, option);
    }

    /**
     * Insert or update the entity with varying requests. {ExclusiveControl(when update)}<br />
     * Other specifications are same as insertOrUpdate(entity).
     * @param dataCrawlingConfig The entity of insert or update target. (NotNull)
     * @param insertOption The option of insert for varying requests. (NotNull)
     * @param updateOption The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingInsertOrUpdate(DataCrawlingConfig dataCrawlingConfig,
            InsertOption<DataCrawlingConfigCB> insertOption,
            UpdateOption<DataCrawlingConfigCB> updateOption) {
        assertInsertOptionNotNull(insertOption);
        assertUpdateOptionNotNull(updateOption);
        doInesrtOrUpdate(dataCrawlingConfig, insertOption, updateOption);
    }

    /**
     * Insert or update the entity with varying requests non-strictly. {NonExclusiveControl(when update)}<br />
     * Other specifications are same as insertOrUpdateNonstrict(entity).
     * @param dataCrawlingConfig The entity of insert or update target. (NotNull)
     * @param insertOption The option of insert for varying requests. (NotNull)
     * @param updateOption The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingInsertOrUpdateNonstrict(
            DataCrawlingConfig dataCrawlingConfig,
            InsertOption<DataCrawlingConfigCB> insertOption,
            UpdateOption<DataCrawlingConfigCB> updateOption) {
        assertInsertOptionNotNull(insertOption);
        assertUpdateOptionNotNull(updateOption);
        doInesrtOrUpdateNonstrict(dataCrawlingConfig, insertOption,
                updateOption);
    }

    /**
     * Delete the entity with varying requests. {UpdateCountZeroException, ExclusiveControl} <br />
     * Now a valid option does not exist. <br />
     * Other specifications are same as delete(entity).
     * @param dataCrawlingConfig The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void varyingDelete(DataCrawlingConfig dataCrawlingConfig,
            DeleteOption<DataCrawlingConfigCB> option) {
        assertDeleteOptionNotNull(option);
        doDelete(dataCrawlingConfig, option);
    }

    /**
     * Delete the entity with varying requests non-strictly. {UpdateCountZeroException, NonExclusiveControl} <br />
     * Now a valid option does not exist. <br />
     * Other specifications are same as deleteNonstrict(entity).
     * @param dataCrawlingConfig The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void varyingDeleteNonstrict(DataCrawlingConfig dataCrawlingConfig,
            DeleteOption<DataCrawlingConfigCB> option) {
        assertDeleteOptionNotNull(option);
        doDeleteNonstrict(dataCrawlingConfig, option);
    }

    // -----------------------------------------------------
    //                                          Batch Update
    //                                          ------------
    /**
     * Batch-insert the list with varying requests. <br />
     * For example, disableCommonColumnAutoSetup()
     * , disablePrimaryKeyIdentity(), limitBatchInsertLogging(). <br />
     * Other specifications are same as batchInsert(entityList).
     * @param dataCrawlingConfigList The list of the entity. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @return The array of inserted count.
     */
    public int[] varyingBatchInsert(
            List<DataCrawlingConfig> dataCrawlingConfigList,
            InsertOption<DataCrawlingConfigCB> option) {
        assertInsertOptionNotNull(option);
        return doBatchInsert(dataCrawlingConfigList, option);
    }

    /**
     * Batch-update the list with varying requests. <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification)
     * , disableCommonColumnAutoSetup(), limitBatchUpdateLogging(). <br />
     * Other specifications are same as batchUpdate(entityList).
     * @param dataCrawlingConfigList The list of the entity. (NotNull)
     * @param option The option of update for varying requests. (NotNull)
     * @return The array of updated count.
     */
    public int[] varyingBatchUpdate(
            List<DataCrawlingConfig> dataCrawlingConfigList,
            UpdateOption<DataCrawlingConfigCB> option) {
        assertUpdateOptionNotNull(option);
        return doBatchUpdate(dataCrawlingConfigList, option);
    }

    /**
     * Batch-update the list with varying requests non-strictly. <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification)
     * , disableCommonColumnAutoSetup(), limitBatchUpdateLogging(). <br />
     * Other specifications are same as batchUpdateNonstrict(entityList).
     * @param dataCrawlingConfigList The list of the entity. (NotNull)
     * @param option The option of update for varying requests. (NotNull)
     * @return The array of updated count.
     */
    public int[] varyingBatchUpdateNonstrict(
            List<DataCrawlingConfig> dataCrawlingConfigList,
            UpdateOption<DataCrawlingConfigCB> option) {
        assertUpdateOptionNotNull(option);
        return doBatchUpdateNonstrict(dataCrawlingConfigList, option);
    }

    /**
     * Batch-delete the list with varying requests. <br />
     * For example, limitBatchDeleteLogging(). <br />
     * Other specifications are same as batchDelete(entityList).
     * @param dataCrawlingConfigList The list of the entity. (NotNull)
     * @param option The option of delete for varying requests. (NotNull)
     * @return The array of deleted count.
     */
    public int[] varyingBatchDelete(
            List<DataCrawlingConfig> dataCrawlingConfigList,
            DeleteOption<DataCrawlingConfigCB> option) {
        assertDeleteOptionNotNull(option);
        return doBatchDelete(dataCrawlingConfigList, option);
    }

    /**
     * Batch-delete the list with varying requests non-strictly. <br />
     * For example, limitBatchDeleteLogging(). <br />
     * Other specifications are same as batchDeleteNonstrict(entityList).
     * @param dataCrawlingConfigList The list of the entity. (NotNull)
     * @param option The option of delete for varying requests. (NotNull)
     * @return The array of deleted count.
     */
    public int[] varyingBatchDeleteNonstrict(
            List<DataCrawlingConfig> dataCrawlingConfigList,
            DeleteOption<DataCrawlingConfigCB> option) {
        assertDeleteOptionNotNull(option);
        return doBatchDeleteNonstrict(dataCrawlingConfigList, option);
    }

    // -----------------------------------------------------
    //                                          Query Update
    //                                          ------------
    /**
     * Insert the several entities by query with varying requests (modified-only for fixed value). <br />
     * For example, disableCommonColumnAutoSetup(), disablePrimaryKeyIdentity(). <br />
     * Other specifications are same as queryInsert(entity, setupper). 
     * @param setupper The setup-per of query-insert. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @return The inserted count.
     */
    public int varyingQueryInsert(
            QueryInsertSetupper<DataCrawlingConfig, DataCrawlingConfigCB> setupper,
            InsertOption<DataCrawlingConfigCB> option) {
        assertInsertOptionNotNull(option);
        return doQueryInsert(setupper, option);
    }

    /**
     * Update the several entities by query with varying requests non-strictly modified-only. {NonExclusiveControl} <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification)
     * , disableCommonColumnAutoSetup(), allowNonQueryUpdate(). <br />
     * Other specifications are same as queryUpdate(entity, cb). 
     * <pre>
     * <span style="color: #3F7E5E">// ex) you can update by self calculation values</span>
     * DataCrawlingConfig dataCrawlingConfig = new DataCrawlingConfig();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//dataCrawlingConfig.setPK...(value);</span>
     * dataCrawlingConfig.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//dataCrawlingConfig.setVersionNo(value);</span>
     * DataCrawlingConfigCB cb = new DataCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * UpdateOption&lt;DataCrawlingConfigCB&gt; option = new UpdateOption&lt;DataCrawlingConfigCB&gt;();
     * option.self(new SpecifyQuery&lt;DataCrawlingConfigCB&gt;() {
     *     public void specify(DataCrawlingConfigCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * dataCrawlingConfigBhv.<span style="color: #FD4747">varyingQueryUpdate</span>(dataCrawlingConfig, cb, option);
     * </pre>
     * @param dataCrawlingConfig The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of DataCrawlingConfig. (NotNull)
     * @param option The option of update for varying requests. (NotNull)
     * @return The updated count.
     * @exception org.seasar.dbflute.exception.NonQueryUpdateNotAllowedException When the query has no condition (if not allowed).
     */
    public int varyingQueryUpdate(DataCrawlingConfig dataCrawlingConfig,
            DataCrawlingConfigCB cb, UpdateOption<DataCrawlingConfigCB> option) {
        assertUpdateOptionNotNull(option);
        return doQueryUpdate(dataCrawlingConfig, cb, option);
    }

    /**
     * Delete the several entities by query with varying requests non-strictly. <br />
     * For example, allowNonQueryDelete(). <br />
     * Other specifications are same as batchUpdateNonstrict(entityList).
     * @param cb The condition-bean of DataCrawlingConfig. (NotNull)
     * @param option The option of delete for varying requests. (NotNull)
     * @return The deleted count.
     * @exception org.seasar.dbflute.exception.NonQueryDeleteNotAllowedException When the query has no condition (if not allowed).
     */
    public int varyingQueryDelete(DataCrawlingConfigCB cb,
            DeleteOption<DataCrawlingConfigCB> option) {
        assertDeleteOptionNotNull(option);
        return doQueryDelete(cb, option);
    }

    // ===================================================================================
    //                                                                          OutsideSql
    //                                                                          ==========
    /**
     * Prepare the basic executor of outside-SQL to execute it. <br />
     * The invoker of behavior command should be not null when you call this method.
     * <pre>
     * You can use the methods for outside-SQL are as follows:
     * {Basic}
     *   o selectList()
     *   o execute()
     *   o call()
     * 
     * {Entity}
     *   o entityHandling().selectEntity()
     *   o entityHandling().selectEntityWithDeletedCheck()
     * 
     * {Paging}
     *   o autoPaging().selectList()
     *   o autoPaging().selectPage()
     *   o manualPaging().selectList()
     *   o manualPaging().selectPage()
     * 
     * {Cursor}
     *   o cursorHandling().selectCursor()
     * 
     * {Option}
     *   o dynamicBinding().selectList()
     *   o removeBlockComment().selectList()
     *   o removeLineComment().selectList()
     *   o formatSql().selectList()
     * </pre>
     * @return The basic executor of outside-SQL. (NotNull) 
     */
    public OutsideSqlBasicExecutor<DataCrawlingConfigBhv> outsideSql() {
        return doOutsideSql();
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCountUniquely(DataCrawlingConfigCB cb) {
        return invoke(createSelectCountCBCommand(cb, true));
    }

    protected int delegateSelectCountPlainly(DataCrawlingConfigCB cb) {
        return invoke(createSelectCountCBCommand(cb, false));
    }

    protected <ENTITY extends DataCrawlingConfig> void delegateSelectCursor(
            DataCrawlingConfigCB cb, EntityRowHandler<ENTITY> erh,
            Class<ENTITY> et) {
        invoke(createSelectCursorCBCommand(cb, erh, et));
    }

    protected <ENTITY extends DataCrawlingConfig> List<ENTITY> delegateSelectList(
            DataCrawlingConfigCB cb, Class<ENTITY> et) {
        return invoke(createSelectListCBCommand(cb, et));
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(DataCrawlingConfig e,
            InsertOption<DataCrawlingConfigCB> op) {
        if (!processBeforeInsert(e, op)) {
            return 0;
        }
        return invoke(createInsertEntityCommand(e, op));
    }

    protected int delegateUpdate(DataCrawlingConfig e,
            UpdateOption<DataCrawlingConfigCB> op) {
        if (!processBeforeUpdate(e, op)) {
            return 0;
        }
        return invoke(createUpdateEntityCommand(e, op));
    }

    protected int delegateUpdateNonstrict(DataCrawlingConfig e,
            UpdateOption<DataCrawlingConfigCB> op) {
        if (!processBeforeUpdate(e, op)) {
            return 0;
        }
        return invoke(createUpdateNonstrictEntityCommand(e, op));
    }

    protected int delegateDelete(DataCrawlingConfig e,
            DeleteOption<DataCrawlingConfigCB> op) {
        if (!processBeforeDelete(e, op)) {
            return 0;
        }
        return invoke(createDeleteEntityCommand(e, op));
    }

    protected int delegateDeleteNonstrict(DataCrawlingConfig e,
            DeleteOption<DataCrawlingConfigCB> op) {
        if (!processBeforeDelete(e, op)) {
            return 0;
        }
        return invoke(createDeleteNonstrictEntityCommand(e, op));
    }

    protected int[] delegateBatchInsert(List<DataCrawlingConfig> ls,
            InsertOption<DataCrawlingConfigCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertCommand(processBatchInternally(ls, op),
                op));
    }

    protected int[] delegateBatchUpdate(List<DataCrawlingConfig> ls,
            UpdateOption<DataCrawlingConfigCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateCommand(
                processBatchInternally(ls, op, false), op));
    }

    protected int[] delegateBatchUpdateNonstrict(List<DataCrawlingConfig> ls,
            UpdateOption<DataCrawlingConfigCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateNonstrictCommand(
                processBatchInternally(ls, op, true), op));
    }

    protected int[] delegateBatchDelete(List<DataCrawlingConfig> ls,
            DeleteOption<DataCrawlingConfigCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteCommand(
                processBatchInternally(ls, op, false), op));
    }

    protected int[] delegateBatchDeleteNonstrict(List<DataCrawlingConfig> ls,
            DeleteOption<DataCrawlingConfigCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteNonstrictCommand(
                processBatchInternally(ls, op, true), op));
    }

    protected int delegateQueryInsert(DataCrawlingConfig e,
            DataCrawlingConfigCB inCB, ConditionBean resCB,
            InsertOption<DataCrawlingConfigCB> op) {
        if (!processBeforeQueryInsert(e, inCB, resCB, op)) {
            return 0;
        }
        return invoke(createQueryInsertCBCommand(e, inCB, resCB, op));
    }

    protected int delegateQueryUpdate(DataCrawlingConfig e,
            DataCrawlingConfigCB cb, UpdateOption<DataCrawlingConfigCB> op) {
        if (!processBeforeQueryUpdate(e, cb, op)) {
            return 0;
        }
        return invoke(createQueryUpdateCBCommand(e, cb, op));
    }

    protected int delegateQueryDelete(DataCrawlingConfigCB cb,
            DeleteOption<DataCrawlingConfigCB> op) {
        if (!processBeforeQueryDelete(cb, op)) {
            return 0;
        }
        return invoke(createQueryDeleteCBCommand(cb, op));
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return !(downcast(entity).getVersionNo() + "").equals("null");// For primitive type
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                     Downcast Helper
    //                                                                     ===============
    protected DataCrawlingConfig downcast(Entity entity) {
        return helpEntityDowncastInternally(entity, DataCrawlingConfig.class);
    }

    protected DataCrawlingConfigCB downcast(ConditionBean cb) {
        return helpConditionBeanDowncastInternally(cb,
                DataCrawlingConfigCB.class);
    }
}
