/*
 * Copyright 2009-2011 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.cbean.cq.ciq;

import jp.sf.fess.db.cbean.CrawlingSessionInfoCB;
import jp.sf.fess.db.cbean.cq.CrawlingSessionCQ;
import jp.sf.fess.db.cbean.cq.CrawlingSessionInfoCQ;
import jp.sf.fess.db.cbean.cq.bs.AbstractBsCrawlingSessionInfoCQ;
import jp.sf.fess.db.cbean.cq.bs.BsCrawlingSessionInfoCQ;

import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.ckey.ConditionKey;
import org.seasar.dbflute.cbean.coption.ConditionOption;
import org.seasar.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.exception.IllegalConditionBeanOperationException;

/**
 * The condition-query for in-line of CRAWLING_SESSION_INFO.
 * @author DBFlute(AutoGenerator)
 */
public class CrawlingSessionInfoCIQ extends AbstractBsCrawlingSessionInfoCQ {

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    protected BsCrawlingSessionInfoCQ _myCQ;

    // ===================================================================================
    //                                                                         Constructor
    //                                                                         ===========
    public CrawlingSessionInfoCIQ(ConditionQuery childQuery,
            SqlClause sqlClause, String aliasName, int nestLevel,
            BsCrawlingSessionInfoCQ myCQ) {
        super(childQuery, sqlClause, aliasName, nestLevel);
        _myCQ = myCQ;
        _foreignPropertyName = _myCQ.xgetForeignPropertyName(); // accept foreign property name
        _relationPath = _myCQ.xgetRelationPath(); // accept relation path
        _inline = true;
    }

    // ===================================================================================
    //                                                             Override about Register
    //                                                             =======================
    @Override
    protected void reflectRelationOnUnionQuery(ConditionQuery bq,
            ConditionQuery uq) {
        String msg = "InlineView must not need UNION method: " + bq + " : "
                + uq;
        throw new IllegalConditionBeanOperationException(msg);
    }

    @Override
    protected void setupConditionValueAndRegisterWhereClause(ConditionKey k,
            Object v, ConditionValue cv, String col) {
        regIQ(k, v, cv, col);
    }

    @Override
    protected void setupConditionValueAndRegisterWhereClause(ConditionKey k,
            Object v, ConditionValue cv, String col, ConditionOption op) {
        regIQ(k, v, cv, col, op);
    }

    @Override
    protected void registerWhereClause(String wc) {
        registerInlineWhereClause(wc);
    }

    @Override
    protected boolean isInScopeRelationSuppressLocalAliasName() {
        if (_onClause) {
            throw new IllegalConditionBeanOperationException(
                    "InScopeRelation on OnClause is unsupported.");
        }
        return true;
    }

    // ===================================================================================
    //                                                                Override about Query
    //                                                                ====================
    protected ConditionValue getCValueId() {
        return _myCQ.getId();
    }

    protected ConditionValue getCValueCrawlingSessionId() {
        return _myCQ.getCrawlingSessionId();
    }

    public String keepCrawlingSessionId_InScopeRelation_CrawlingSession(
            CrawlingSessionCQ sq) {
        return _myCQ.keepCrawlingSessionId_InScopeRelation_CrawlingSession(sq);
    }

    public String keepCrawlingSessionId_NotInScopeRelation_CrawlingSession(
            CrawlingSessionCQ sq) {
        return _myCQ
                .keepCrawlingSessionId_NotInScopeRelation_CrawlingSession(sq);
    }

    protected ConditionValue getCValueKey() {
        return _myCQ.getKey();
    }

    protected ConditionValue getCValueValue() {
        return _myCQ.getValue();
    }

    protected ConditionValue getCValueCreatedTime() {
        return _myCQ.getCreatedTime();
    }

    public String keepScalarCondition(CrawlingSessionInfoCQ subQuery) {
        throwIICBOE("ScalarCondition");
        return null;
    }

    public String keepMyselfInScopeRelation(CrawlingSessionInfoCQ subQuery) {
        throwIICBOE("MyselfInScopeRelation");
        return null;
    }

    protected void throwIICBOE(String name) { // throwInlineIllegalConditionBeanOperationException()
        throw new IllegalConditionBeanOperationException(name
                + " at InlineView is unsupported.");
    }

    // ===================================================================================
    //                                                                       Very Internal
    //                                                                       =============
    // very internal (for suppressing warn about 'Not Use Import')
    protected String xinCB() {
        return CrawlingSessionInfoCB.class.getName();
    }

    protected String xinCQ() {
        return CrawlingSessionInfoCQ.class.getName();
    }
}
