/*
 * Copyright 2009-2011 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.pager;

import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.List;

import org.seasar.framework.util.StringUtil;

import com.ibm.icu.text.SimpleDateFormat;

public class StatsPager implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final int DEFAULT_PAGE_SIZE = 20;

    public static final int DEFAULT_CURRENT_PAGE_NUMBER = 1;

    private int allRecordCount;

    private int allPageCount;

    private boolean existPrePage;

    private boolean existNextPage;

    private List<Integer> pageNumberList;

    private int pageSize;

    private int currentPageNumber;

    public String reportType;

    public String startDate;

    public String startHour;

    public String startMin;

    public String endDate;

    public String endHour;

    public String endMin;

    public void clear() {
        pageSize = getDefaultPageSize();
        currentPageNumber = getDefaultCurrentPageNumber();
        reportType = null;
        startDate = null;
        startHour = null;
        startMin = null;
        endDate = null;
        endHour = null;
        endMin = null;
    }

    public Date getFromRequestedTime() {
        if (StringUtil.isBlank(startDate)) {
            return null;
        }

        try {
            if (StringUtil.isBlank(startHour)) {
                startHour = null;
                startMin = null;
                return new SimpleDateFormat("yyyy-MM-dd").parse(startDate);
            } else {
                if (StringUtil.isBlank(startMin)) {
                    startMin = "0";
                }
                return new SimpleDateFormat("yyyy-MM-dd hh:mm").parse(startDate
                        + " " + startHour + ":" + startMin);
            }
        } catch (ParseException e) {
            startDate = null;
            startHour = null;
            startMin = null;
        }
        return null;
    }

    public Date getToRequestedTime() {
        if (StringUtil.isBlank(endDate)) {
            return null;
        }

        try {
            if (StringUtil.isBlank(endHour)) {
                endHour = null;
                endMin = null;
                return new SimpleDateFormat("yyyy-MM-dd").parse(endDate);
            } else {
                if (StringUtil.isBlank(endMin)) {
                    endMin = "0";
                }
                return new SimpleDateFormat("yyyy-MM-dd hh:mm").parse(endDate
                        + " " + endHour + ":" + endMin);
            }
        } catch (ParseException e) {
            endDate = null;
            endHour = null;
            endMin = null;
        }
        return null;
    }

    protected int getDefaultPageSize() {
        return DEFAULT_PAGE_SIZE;
    }

    protected int getDefaultCurrentPageNumber() {
        return DEFAULT_CURRENT_PAGE_NUMBER;
    }

    public int getAllRecordCount() {
        return allRecordCount;
    }

    public void setAllRecordCount(int allRecordCount) {
        this.allRecordCount = allRecordCount;
    }

    public int getAllPageCount() {
        return allPageCount;
    }

    public void setAllPageCount(int allPageCount) {
        this.allPageCount = allPageCount;
    }

    public boolean isExistPrePage() {
        return existPrePage;
    }

    public void setExistPrePage(boolean existPrePage) {
        this.existPrePage = existPrePage;
    }

    public boolean isExistNextPage() {
        return existNextPage;
    }

    public void setExistNextPage(boolean existNextPage) {
        this.existNextPage = existNextPage;
    }

    public int getPageSize() {
        if (pageSize <= 0) {
            pageSize = getDefaultPageSize();
        }
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getCurrentPageNumber() {
        if (currentPageNumber <= 0) {
            currentPageNumber = getDefaultCurrentPageNumber();
        }
        return currentPageNumber;
    }

    public void setCurrentPageNumber(int currentPageNumber) {
        this.currentPageNumber = currentPageNumber;
    }

    public List<Integer> getPageNumberList() {
        return pageNumberList;
    }

    public void setPageNumberList(List<Integer> pageNumberList) {
        this.pageNumberList = pageNumberList;
    }

}
